/*
 * Decompiled with CFR 0.152.
 */
package korolev.http.protocol;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import korolev.data.BytesLike;
import korolev.data.BytesLike$;
import korolev.data.BytesReader$;
import korolev.effect.Decoder;
import korolev.effect.Decoder$;
import korolev.effect.Effect;
import korolev.effect.Stream;
import korolev.effect.syntax$;
import korolev.http.protocol.WebSocketProtocol;
import korolev.http.protocol.WebSocketProtocol$;
import korolev.http.protocol.WebSocketProtocol$DecodingState$;
import korolev.http.protocol.WebSocketProtocol$DecodingState$Begin$;
import korolev.http.protocol.WebSocketProtocol$DecodingState$LongLength$;
import korolev.http.protocol.WebSocketProtocol$DecodingState$Payload$;
import korolev.http.protocol.WebSocketProtocol$DecodingState$ShortLength$;
import korolev.http.protocol.WebSocketProtocol$Frame$Binary$;
import korolev.http.protocol.WebSocketProtocol$Frame$ConnectionClose$;
import korolev.http.protocol.WebSocketProtocol$Frame$Continuation$;
import korolev.http.protocol.WebSocketProtocol$Frame$Ping$;
import korolev.http.protocol.WebSocketProtocol$Frame$Pong$;
import korolev.http.protocol.WebSocketProtocol$Frame$Text$;
import korolev.http.protocol.WebSocketProtocol$Frame$Unspecified$;
import korolev.http.protocol.WebSocketProtocol$Intention$;
import korolev.web.Headers$;
import korolev.web.Request;
import korolev.web.Response;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class WebSocketProtocol<B> {
    private final BytesLike<B> evidence$1;

    public static String GUID() {
        return WebSocketProtocol$.MODULE$.GUID();
    }

    public static int OpBinary() {
        return WebSocketProtocol$.MODULE$.OpBinary();
    }

    public static int OpConnectionClose() {
        return WebSocketProtocol$.MODULE$.OpConnectionClose();
    }

    public static int OpContinuation() {
        return WebSocketProtocol$.MODULE$.OpContinuation();
    }

    public static int OpPing() {
        return WebSocketProtocol$.MODULE$.OpPing();
    }

    public static int OpPong() {
        return WebSocketProtocol$.MODULE$.OpPong();
    }

    public static int OpText() {
        return WebSocketProtocol$.MODULE$.OpText();
    }

    public WebSocketProtocol(BytesLike<B> evidence$1) {
        this.evidence$1 = evidence$1;
    }

    public <F> Decoder<F, Frame<B>> decodeFrames(Decoder<F, B> decoder, Effect<F> evidence$2) {
        return decoder.decode(this::decodeFrames$$anonfun$1, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                throw new MatchError((Object)tuple22);
            }
            Object buffer = tuple2._1();
            DecodingState state = (DecodingState)tuple2._2();
            Object incoming = tuple22._2();
            return this.decodeFrames(buffer, state, incoming);
        });
    }

    public Tuple2<Tuple2<B, DecodingState>, Decoder.Action<B, Frame<B>>> decodeFrame(B data) {
        return this.decodeFrames(BytesLike$.MODULE$.apply(this.evidence$1).empty(), WebSocketProtocol$DecodingState$Begin$.MODULE$, data);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Tuple2<Tuple2<B, DecodingState>, Decoder.Action<B, Frame<B>>> decodeFrames(B buffer, DecodingState state, B incoming) {
        Tuple2 tuple2;
        DecodingState decodingState;
        Object bytes;
        WebSocketProtocol webSocketProtocol = this;
        B b = incoming;
        DecodingState decodingState2 = state;
        B b2 = buffer;
        while (true) {
            void var5_6;
            void var7_15;
            bytes = korolev.data.syntax$.MODULE$.BytesLikeOps((Object)var7_15, webSocketProtocol.evidence$1).$plus$plus((Object)var5_6);
            decodingState = decodingState2;
            if (WebSocketProtocol$DecodingState$Begin$.MODULE$.equals(decodingState) && korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, webSocketProtocol.evidence$1).length() >= 2L) {
                int firstByte = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, webSocketProtocol.evidence$1).apply(0) & 0xFF;
                int secondByte = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, webSocketProtocol.evidence$1).apply(1) & 0xFF;
                boolean fin = (firstByte & 0x80) != 0;
                int opcode = firstByte & 0xF;
                boolean mask = (secondByte & 0x80) != 0;
                Object restOfBytes = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, webSocketProtocol.evidence$1).slice(2L);
                int n = secondByte & 0x7F;
                if (126 == n) {
                    DecodingState.ShortLength nextState = WebSocketProtocol$DecodingState$ShortLength$.MODULE$.apply(fin, mask, opcode);
                    WebSocketProtocol webSocketProtocol2 = webSocketProtocol;
                    Object object = restOfBytes;
                    DecodingState.ShortLength shortLength = nextState;
                    Object object2 = BytesLike$.MODULE$.apply(webSocketProtocol.evidence$1).empty();
                    webSocketProtocol = webSocketProtocol2;
                    Object object3 = object;
                    decodingState2 = shortLength;
                    Object object4 = object2;
                    continue;
                }
                if (127 == n) {
                    DecodingState.LongLength nextState = WebSocketProtocol$DecodingState$LongLength$.MODULE$.apply(fin, mask, opcode);
                    WebSocketProtocol webSocketProtocol3 = webSocketProtocol;
                    Object object = restOfBytes;
                    DecodingState.LongLength longLength = nextState;
                    Object object5 = BytesLike$.MODULE$.apply(webSocketProtocol.evidence$1).empty();
                    webSocketProtocol = webSocketProtocol3;
                    Object object6 = object;
                    decodingState2 = longLength;
                    Object object7 = object5;
                    continue;
                }
                int length = n;
                DecodingState.Payload nextState = WebSocketProtocol$DecodingState$Payload$.MODULE$.apply(fin, mask, opcode, Int$.MODULE$.int2long(length));
                WebSocketProtocol webSocketProtocol4 = webSocketProtocol;
                Object object = restOfBytes;
                DecodingState.Payload payload = nextState;
                Object object8 = BytesLike$.MODULE$.apply(webSocketProtocol.evidence$1).empty();
                webSocketProtocol = webSocketProtocol4;
                Object object9 = object;
                decodingState2 = payload;
                Object object10 = object8;
                continue;
            }
            if (decodingState instanceof DecodingState.ShortLength) {
                DecodingState.ShortLength s = (DecodingState.ShortLength)decodingState;
                if (korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, webSocketProtocol.evidence$1).length() >= 2L) {
                    int length = BytesReader$.MODULE$.readShort(bytes, 0L, webSocketProtocol.evidence$1) & 0xFFFF;
                    DecodingState.Payload nextState = WebSocketProtocol$DecodingState$Payload$.MODULE$.apply(s.fin(), s.mask(), s.opcode(), Int$.MODULE$.int2long(length));
                    WebSocketProtocol webSocketProtocol5 = webSocketProtocol;
                    Object object = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, webSocketProtocol.evidence$1).slice(2L);
                    DecodingState.Payload payload = nextState;
                    Object object11 = BytesLike$.MODULE$.apply(webSocketProtocol.evidence$1).empty();
                    webSocketProtocol = webSocketProtocol5;
                    Object object12 = object;
                    decodingState2 = payload;
                    Object object13 = object11;
                    continue;
                }
            }
            if (!(decodingState instanceof DecodingState.LongLength)) break;
            DecodingState.LongLength s = (DecodingState.LongLength)decodingState;
            if (korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, webSocketProtocol.evidence$1).length() < 8L) break;
            long length = BytesReader$.MODULE$.readLong(bytes, 0L, webSocketProtocol.evidence$1);
            DecodingState.Payload nextState = WebSocketProtocol$DecodingState$Payload$.MODULE$.apply(s.fin(), s.mask(), s.opcode(), length);
            WebSocketProtocol webSocketProtocol6 = webSocketProtocol;
            Object object = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, webSocketProtocol.evidence$1).slice(8L);
            DecodingState.Payload payload = nextState;
            Object object14 = BytesLike$.MODULE$.apply(webSocketProtocol.evidence$1).empty();
            webSocketProtocol = webSocketProtocol6;
            Object object15 = object;
            decodingState2 = payload;
            Object object16 = object14;
        }
        if (decodingState instanceof DecodingState.Payload) {
            DecodingState.Payload s = (DecodingState.Payload)decodingState;
            if (korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, webSocketProtocol.evidence$1).length() >= s.fullLength()) {
                Object object;
                Frame<Nothing$> frame;
                Object payloadBytes = WebSocketProtocol.decodePayload$1(webSocketProtocol, bytes, s);
                int n = s.opcode();
                switch (n) {
                    case 0: {
                        frame = WebSocketProtocol$Frame$Continuation$.MODULE$.apply(payloadBytes, s.fin());
                        break;
                    }
                    case 2: {
                        frame = WebSocketProtocol$Frame$Binary$.MODULE$.apply(payloadBytes, s.fin(), webSocketProtocol.evidence$1);
                        break;
                    }
                    case 1: {
                        frame = WebSocketProtocol$Frame$Text$.MODULE$.apply(payloadBytes, s.fin(), webSocketProtocol.evidence$1);
                        break;
                    }
                    case 8: {
                        frame = WebSocketProtocol$Frame$ConnectionClose$.MODULE$;
                        break;
                    }
                    case 9: {
                        frame = WebSocketProtocol$Frame$Ping$.MODULE$;
                        break;
                    }
                    case 10: {
                        frame = WebSocketProtocol$Frame$Pong$.MODULE$;
                        break;
                    }
                    default: {
                        frame = WebSocketProtocol$Frame$Unspecified$.MODULE$.apply(s.fin(), s.opcode(), payloadBytes, webSocketProtocol.evidence$1);
                        break;
                    }
                }
                Frame frame2 = frame;
                Object restOfBytes = object = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, webSocketProtocol.evidence$1).slice(s.fullLength());
                if (korolev.data.syntax$.MODULE$.BytesLikeOps(restOfBytes, webSocketProtocol.evidence$1).isEmpty()) {
                    tuple2 = Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(BytesLike$.MODULE$.apply(webSocketProtocol.evidence$1).empty(), (Object)WebSocketProtocol$DecodingState$Begin$.MODULE$), (Object)Decoder.Action$.Push$.MODULE$.apply((Object)frame2));
                    return tuple2;
                }
                Object restOfBytes2 = object;
                tuple2 = Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(BytesLike$.MODULE$.apply(webSocketProtocol.evidence$1).empty(), (Object)WebSocketProtocol$DecodingState$Begin$.MODULE$), (Object)Decoder.Action$.Fork$.MODULE$.apply((Object)frame2, restOfBytes2));
                return tuple2;
            }
        }
        DecodingState state2 = decodingState;
        tuple2 = Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(bytes, (Object)state2), (Object)Decoder.Action$.TakeNext$.MODULE$);
        return tuple2;
    }

    public <F> Decoder<F, Frame.Merged<B>> mergeFrames(Decoder<F, Frame<B>> decoder, Effect<F> evidence$3) {
        return decoder.decode(WebSocketProtocol::mergeFrames$$anonfun$1, (Function2 & Serializable)(buffer, incoming) -> this.mergeFrames((Option<Frame.Merged<B>>)buffer, (Frame<B>)incoming));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Tuple2<Option<Frame.Merged<B>>, Decoder.Action<Frame<B>, Frame.Merged<B>>> mergeFrames(Option<Frame.Merged<B>> buffer, Frame<B> incoming) {
        Frame.Merged merged;
        Tuple2 tuple2;
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(buffer, incoming);
        if (tuple22 == null) throw new IllegalStateException("Fragmentation in WebSocket is invalid. Received " + incoming + " after " + buffer);
        Option option = (Option)tuple22._1();
        Frame frame = (Frame)tuple22._2();
        if (frame instanceof Frame.Control) {
            Frame.Control controlFrame = (Frame.Control)frame;
            tuple2 = Tuple2$.MODULE$.apply(buffer, (Object)Decoder.Action$.Push$.MODULE$.apply((Object)controlFrame));
            return tuple2;
        }
        if (None$.MODULE$.equals(option)) {
            Frame.Unspecified i;
            Frame.Binary i2;
            Frame.Text i3;
            Frame.Merged i4;
            if (frame instanceof Frame.Merged && (i4 = (Frame.Merged)frame).fin()) {
                tuple2 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)Decoder.Action$.Push$.MODULE$.apply((Object)i4));
                return tuple2;
            }
            if (frame instanceof Frame.Text && !(i3 = (Frame.Text)frame).fin()) {
                tuple2 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)i3), (Object)Decoder.Action$.TakeNext$.MODULE$);
                return tuple2;
            }
            if (frame instanceof Frame.Binary && !(i2 = (Frame.Binary)frame).fin()) {
                tuple2 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)i2), (Object)Decoder.Action$.TakeNext$.MODULE$);
                return tuple2;
            }
            if (frame instanceof Frame.Unspecified && !(i = (Frame.Unspecified)frame).fin()) {
                tuple2 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)i), (Object)Decoder.Action$.TakeNext$.MODULE$);
                return tuple2;
            }
        }
        if (!(option instanceof Some)) throw new IllegalStateException("Fragmentation in WebSocket is invalid. Received " + incoming + " after " + buffer);
        Frame.Merged buffer2 = merged = (Frame.Merged)((Some)option).value();
        if (!(frame instanceof Frame.Continuation)) throw new IllegalStateException("Fragmentation in WebSocket is invalid. Received " + incoming + " after " + buffer);
        Frame.Continuation continuation = (Frame.Continuation)frame;
        Frame.Continuation i = continuation;
        if (!i.fin()) {
            tuple2 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply(buffer2.append(i.payload(), false)), (Object)Decoder.Action$.TakeNext$.MODULE$);
            return tuple2;
        }
        Frame.Merged buffer3 = merged;
        Frame.Continuation i5 = continuation;
        if (!i5.fin()) throw new IllegalStateException("Fragmentation in WebSocket is invalid. Received " + incoming + " after " + buffer);
        tuple2 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)Decoder.Action$.Push$.MODULE$.apply(buffer3.append(i5.payload(), true)));
        return tuple2;
    }

    public B encodeFrame(Frame<B> frame, Option<Object> maybeMask) {
        Object object;
        Frame<B> frame2 = frame;
        if (WebSocketProtocol$Frame$Pong$.MODULE$.equals(frame2) || WebSocketProtocol$Frame$Ping$.MODULE$.equals(frame2) || WebSocketProtocol$Frame$ConnectionClose$.MODULE$.equals(frame2)) {
            object = this.encodeFrame(true, maybeMask, frame.opcode(), BytesLike$.MODULE$.apply(this.evidence$1).empty());
        } else if (frame2 instanceof Frame.Continuation) {
            Frame.Continuation continuation = WebSocketProtocol$Frame$Continuation$.MODULE$.unapply((Frame.Continuation)frame2);
            Object b = continuation._1();
            boolean bl = continuation._2();
            Object payload = b;
            boolean fin = bl;
            object = this.encodeFrame(fin, maybeMask, frame.opcode(), payload);
        } else if (frame2 instanceof Frame.Binary) {
            Frame.Binary binary = WebSocketProtocol$Frame$Binary$.MODULE$.unapply((Frame.Binary)frame2);
            Object b = binary._1();
            boolean bl = binary._2();
            Object payload = b;
            boolean fin = bl;
            object = this.encodeFrame(fin, maybeMask, frame.opcode(), payload);
        } else if (frame2 instanceof Frame.Text) {
            Frame.Text text = WebSocketProtocol$Frame$Text$.MODULE$.unapply((Frame.Text)frame2);
            Object b = text._1();
            boolean bl = text._2();
            Object payload = b;
            boolean fin = bl;
            object = this.encodeFrame(fin, maybeMask, frame.opcode(), payload);
        } else if (frame2 instanceof Frame.Unspecified) {
            Frame.Unspecified unspecified = WebSocketProtocol$Frame$Unspecified$.MODULE$.unapply((Frame.Unspecified)frame2);
            boolean bl = unspecified._1();
            int n = unspecified._2();
            Object b = unspecified._3();
            boolean fin = bl;
            int opcode = n;
            Object payload = b;
            object = this.encodeFrame(fin, maybeMask, opcode, payload);
        } else {
            throw new MatchError(frame2);
        }
        return (B)object;
    }

    public B encodeFrame(boolean fin, Option<Object> maybeMask, int opcode, B payload) {
        Object object;
        int maskSize = BoxesRunTime.unboxToInt((Object)maybeMask.fold(WebSocketProtocol::$anonfun$1, (Function1)(JFunction1.mcII.sp & Serializable)_$3 -> 4));
        ByteBuffer buffer = ByteBuffer.allocate(2 + BoxesRunTime.unboxToInt((Object)this.choseLength$1(payload, (Function1)(JFunction1.mcIJ.sp & Serializable)_$4 -> 8, (Function1)(JFunction1.mcIJ.sp & Serializable)_$5 -> 2, (Function1)(JFunction1.mcIJ.sp & Serializable)_$6 -> 0)) + maskSize);
        buffer.put((byte)((fin ? 128 : 0) | opcode));
        buffer.put((byte)((maybeMask.nonEmpty() ? 128 : 0) | BoxesRunTime.unboxToInt((Object)this.choseLength$1(payload, (Function1)(JFunction1.mcIJ.sp & Serializable)_$7 -> 127, (Function1)(JFunction1.mcIJ.sp & Serializable)_$8 -> 126, (Function1)(JFunction1.mcIJ.sp & Serializable)_$9 -> (int)_$9))));
        this.choseLength$1(payload, (Function1 & Serializable)x -> buffer.putLong(BoxesRunTime.unboxToLong((Object)x)), (Function1 & Serializable)x -> buffer.putShort((short)(BoxesRunTime.unboxToLong((Object)x) & 0xFFFFL)), (Function1 & Serializable)_$10 -> buffer);
        Option<Object> option = maybeMask;
        if (None$.MODULE$.equals(option)) {
            object = korolev.data.syntax$.MODULE$.BytesLikeOps(BytesLike$.MODULE$.apply(this.evidence$1).wrapArray(buffer.array()), this.evidence$1).$plus$plus(payload);
        } else if (option instanceof Some) {
            int mask = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            byte[] array = buffer.array();
            int o = array.length - 4;
            buffer.putInt(mask);
            object = korolev.data.syntax$.MODULE$.BytesLikeOps(BytesLike$.MODULE$.apply(this.evidence$1).wrapArray(array), this.evidence$1).$plus$plus(korolev.data.syntax$.MODULE$.BytesLikeOps(payload, this.evidence$1).mapI((Function2 & Serializable)(x, i) -> WebSocketProtocol.encodeFrame$$anonfun$7(array, o, BoxesRunTime.unboxToByte((Object)x), BoxesRunTime.unboxToLong((Object)i))));
        } else {
            throw new MatchError(option);
        }
        return (B)object;
    }

    public Option<Intention> findIntention(Request.Head request) {
        return request.header("Sec-WebSocket-Key").map((Function1 & Serializable)_$11 -> WebSocketProtocol$Intention$.MODULE$.apply((String)_$11));
    }

    public <T> Request<T> addIntention(Request<T> request, Intention intention) {
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Sec-WebSocket-Key");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)intention.key());
        objectArray[1] = Headers$.MODULE$.SecWebSocketVersion13();
        objectArray[2] = Headers$.MODULE$.ConnectionUpgrade();
        objectArray[3] = Headers$.MODULE$.UpgradeWebSocket();
        return request.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public <T> Response<T> handshake(Response<T> response, Intention intention) {
        String kg = "" + intention.key() + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        byte[] hash = sha1.digest(kg.getBytes(StandardCharsets.US_ASCII));
        String accept = Base64.getEncoder().encodeToString(hash);
        Response.Status status = Response.Status$.MODULE$.SwitchingProtocols();
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Sec-WebSocket-Accept");
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)accept);
        Tuple2 tuple22 = Headers$.MODULE$.ConnectionUpgrade();
        Tuple2 tuple23 = Headers$.MODULE$.UpgradeWebSocket();
        Seq seq = (Seq)((SeqOps)((SeqOps)response.headers().$plus$colon((Object)tuple23)).$plus$colon((Object)tuple22)).$plus$colon((Object)tuple2);
        Object object = response.copy$default$2();
        Option option = response.copy$default$4();
        return response.copy(status, object, seq, option);
    }

    public <F> Function1<Request<Stream<F, B>>, Object> upgrade(Intention intention, Function1<Request<Stream<F, Frame.Merged<B>>>, Object> f, Effect<F> evidence$4) {
        return f.compose((Function1 & Serializable)request -> {
            Decoder messages = Decoder$.MODULE$.apply((Stream)request.body(), evidence$4).decode(this::$anonfun$6, (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                    throw new MatchError((Object)tuple22);
                }
                Object buffer = tuple2._1();
                DecodingState state = (DecodingState)tuple2._2();
                Object incoming = tuple22._2();
                return this.decodeFrames(buffer, state, incoming);
            }).decode(WebSocketProtocol::$anonfun$8, (Function2 & Serializable)(buffer, incoming) -> this.mergeFrames((Option<Frame.Merged<B>>)buffer, (Frame<B>)incoming));
            return request.copy(request.copy$default$1(), request.copy$default$2(), request.copy$default$3(), request.copy$default$4(), (Object)messages, request.copy$default$6());
        }).andThen((Function1 & Serializable)responseF -> syntax$.MODULE$.EffectOps(responseF, evidence$4).map((Function1 & Serializable)response -> {
            Stream upgradedBody = ((Stream)response.body()).map((Function1 & Serializable)m -> this.encodeFrame((Frame<B>)m, (Option<Object>)None$.MODULE$));
            Response response2 = this.handshake((Response)response, intention);
            return response2.copy(response2.copy$default$1(), (Object)upgradedBody, response2.copy$default$3(), response2.copy$default$4());
        }));
    }

    private final Tuple2 decodeFrames$$anonfun$1() {
        return Tuple2$.MODULE$.apply(BytesLike$.MODULE$.apply(this.evidence$1).empty(), (Object)WebSocketProtocol$DecodingState$.MODULE$.begin());
    }

    private static final /* synthetic */ byte decodePayload$2$$anonfun$1(byte[] mask$1, byte x, long i) {
        return (byte)(x ^ korolev.data.syntax$.MODULE$.BytesLikeOps((Object)mask$1, (BytesLike)BytesLike.ArrayBytesLikeInstance$.MODULE$).apply(i % 4L));
    }

    private static final Object decodePayload$1(WebSocketProtocol $this$1, Object bytes, DecodingState.Payload state) {
        Object object;
        if (!state.containMask()) {
            object = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, $this$1.evidence$1).slice(0L, state.fullLength());
        } else {
            byte[] mask = korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, $this$1.evidence$1).slice(0L, 4L), $this$1.evidence$1).asArray();
            object = korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, $this$1.evidence$1).slice(4L, state.fullLength()), $this$1.evidence$1).mapI((Function2 & Serializable)(x, i) -> WebSocketProtocol.decodePayload$2$$anonfun$1(mask, BoxesRunTime.unboxToByte((Object)x), BoxesRunTime.unboxToLong((Object)i)));
        }
        return object;
    }

    private static final Option mergeFrames$$anonfun$1() {
        return Option$.MODULE$.empty();
    }

    private final Object choseLength$1(Object payload$4, Function1 l, Function1 s, Function1 t) {
        Object object;
        long l2 = korolev.data.syntax$.MODULE$.BytesLikeOps(payload$4, this.evidence$1).length();
        long x = l2;
        if (x > 65535L) {
            object = l.apply((Object)BoxesRunTime.boxToLong((long)x));
        } else {
            long x2 = l2;
            if (x2 > 125L) {
                object = s.apply((Object)BoxesRunTime.boxToLong((long)x2));
            } else {
                long x3 = l2;
                object = t.apply((Object)BoxesRunTime.boxToLong((long)x3));
            }
        }
        return object;
    }

    private static final int $anonfun$1() {
        return 0;
    }

    private static final /* synthetic */ byte encodeFrame$$anonfun$7(byte[] array$1, int o$1, byte x, long i) {
        return (byte)(x ^ array$1[o$1 + (int)i % 4]);
    }

    private final Tuple2 $anonfun$6() {
        return Tuple2$.MODULE$.apply(BytesLike$.MODULE$.apply(this.evidence$1).empty(), (Object)WebSocketProtocol$DecodingState$.MODULE$.begin());
    }

    private static final Option $anonfun$8() {
        return Option$.MODULE$.empty();
    }

    public static interface DecodingState {
    }

    public static interface Frame<B> {
        public int opcode();

        public boolean fin();
    }

    public static final class Intention
    implements Product,
    Serializable {
        private final String key;

        public static Intention apply(String string) {
            return WebSocketProtocol$Intention$.MODULE$.apply(string);
        }

        public static Intention fromProduct(Product product) {
            return WebSocketProtocol$Intention$.MODULE$.fromProduct(product);
        }

        public static <F> Object random(Effect<F> effect) {
            return WebSocketProtocol$Intention$.MODULE$.random(effect);
        }

        public static Intention unapply(Intention intention) {
            return WebSocketProtocol$Intention$.MODULE$.unapply(intention);
        }

        public Intention(String key) {
            this.key = key;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Intention)) return false;
            Intention intention = (Intention)object;
            String string = this.key();
            String string2 = intention.key();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Intention;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Intention";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "key";
        }

        public String key() {
            return this.key;
        }

        public Intention copy(String key) {
            return new Intention(key);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String _1() {
            return this.key();
        }
    }
}

