/*
 * Decompiled with CFR 0.152.
 */
package korolev.http;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import korolev.data.BytesLike;
import korolev.effect.AsyncResourcePool;
import korolev.effect.Decoder;
import korolev.effect.Decoder$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Reporter;
import korolev.effect.Scheduler;
import korolev.effect.Stream;
import korolev.effect.io.DataSocket;
import korolev.effect.io.DataSocket$;
import korolev.effect.io.RawDataSocket;
import korolev.effect.io.RawDataSocket$;
import korolev.effect.io.SecureDataSocket;
import korolev.effect.io.SecureDataSocket$;
import korolev.effect.syntax$;
import korolev.http.HttpClient$;
import korolev.http.protocol.Http11;
import korolev.http.protocol.WebSocketProtocol;
import korolev.http.protocol.WebSocketProtocol$Intention$;
import korolev.web.Headers$;
import korolev.web.PathAndQuery;
import korolev.web.PathAndQuery$;
import korolev.web.Request;
import korolev.web.Request$;
import korolev.web.Response;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class HttpClient<F, B> {
    private final String name;
    private final FiniteDuration maxIdleTime;
    private final int maxConnectionsPerAddress;
    private final Executor blockingExecutor;
    private final AsynchronousChannelGroup group;
    private final int bufferSize;
    private final SSLContext sslContext;
    private final Effect<F> evidence$1;
    private final BytesLike<B> evidence$2;
    private final ExecutionContext executor;
    private final Reporter reporter;
    private final Http11<B> http11;
    private final WebSocketProtocol<B> webSocketProtocol;
    private final TrieMap<InetSocketAddress, AsyncResourcePool<F, RawDataSocket<F, B>>> rawConnectionsPools;
    private final TrieMap<InetSocketAddress, AsyncResourcePool<F, SecureDataSocket<F, B>>> secureConnectionsPools;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(HttpClient$.class.getDeclaredField("defaultBlockingExecutor$lzy1"));

    public static <F, B> Object create(String string, FiniteDuration finiteDuration, int n, FiniteDuration finiteDuration2, Executor executor, AsynchronousChannelGroup asynchronousChannelGroup, int n2, SSLContext sSLContext, Effect<F> effect, Scheduler<F> scheduler, BytesLike<B> bytesLike, ExecutionContext executionContext, Reporter reporter) {
        return HttpClient$.MODULE$.create(string, finiteDuration, n, finiteDuration2, executor, asynchronousChannelGroup, n2, sSLContext, effect, scheduler, bytesLike, executionContext, reporter);
    }

    public static <F, B> String create$default$1() {
        return HttpClient$.MODULE$.create$default$1();
    }

    public static <F, B> FiniteDuration create$default$2() {
        return HttpClient$.MODULE$.create$default$2();
    }

    public static <F, B> int create$default$3() {
        return HttpClient$.MODULE$.create$default$3();
    }

    public static <F, B> FiniteDuration create$default$4() {
        return HttpClient$.MODULE$.create$default$4();
    }

    public static <F, B> Executor create$default$5() {
        return HttpClient$.MODULE$.create$default$5();
    }

    public static <F, B> AsynchronousChannelGroup create$default$6() {
        return HttpClient$.MODULE$.create$default$6();
    }

    public static <F, B> int create$default$7() {
        return HttpClient$.MODULE$.create$default$7();
    }

    public static <F, B> SSLContext create$default$8() {
        return HttpClient$.MODULE$.create$default$8();
    }

    public HttpClient(String name, FiniteDuration maxIdleTime, int maxConnectionsPerAddress, Executor blockingExecutor, AsynchronousChannelGroup group, int bufferSize, SSLContext sslContext, Stream<F, BoxedUnit> cleanupTicks, Effect<F> evidence$1, BytesLike<B> evidence$2, ExecutionContext executor, Reporter reporter) {
        this.name = name;
        this.maxIdleTime = maxIdleTime;
        this.maxConnectionsPerAddress = maxConnectionsPerAddress;
        this.blockingExecutor = blockingExecutor;
        this.group = group;
        this.bufferSize = bufferSize;
        this.sslContext = sslContext;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.executor = executor;
        this.reporter = reporter;
        syntax$.MODULE$.EffectOps(cleanupTicks.foreach((Function1 & Serializable)_$2 -> syntax$.MODULE$.EffectOps(syntax$.MODULE$.ListEffectOps(((IterableOnceOps)this.rawConnectionsPools.values().$plus$plus((IterableOnce)this.secureConnectionsPools.values())).toList().map((Function1 & Serializable)_$3 -> _$3.cleanup()), evidence$1).sequence(), evidence$1).map((Function1)(JProcedure1 & Serializable)results -> {
            int sum = BoxesRunTime.unboxToInt((Object)results.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            if (sum > 0) {
                reporter.debug("HttpClient(%s) closes %d idle connection after timeout", (Object)name, (Object)BoxesRunTime.boxToInteger((int)sum));
                return;
            }
        })), evidence$1).runAsyncForget(reporter);
        this.http11 = new Http11<B>(evidence$2);
        this.webSocketProtocol = new WebSocketProtocol<B>(evidence$2);
        this.rawConnectionsPools = TrieMap$.MODULE$.empty();
        this.secureConnectionsPools = TrieMap$.MODULE$.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public F apply(Request.Method method, URI uri, Seq<Tuple2<String, String>> headers, Option<Object> contentLength, Stream<F, B> body) {
        Seq seq;
        if (uri.getUserInfo() != null) {
            Tuple2 tuple2 = Headers$.MODULE$.basicAuthorization(uri.getUserInfo());
            seq = (Seq)headers.$plus$colon((Object)tuple2);
        } else {
            seq = headers;
        }
        Seq updatedHeaders = seq;
        Request request = Request$.MODULE$.apply(method, this.pqFromUri(uri), updatedHeaders, contentLength, body, Request$.MODULE$.$lessinit$greater$default$6());
        String string = uri.getScheme();
        if ("http".equals(string) && uri.getPort() == -1) {
            return this.http(new InetSocketAddress(uri.getHost(), 80), request);
        }
        if ("https".equals(string) && uri.getPort() == -1) {
            return this.https(new InetSocketAddress(uri.getHost(), 443), request);
        }
        switch (string == null ? 0 : string.hashCode()) {
            case 3804: {
                if ("ws".equals(string)) return (F)Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new IllegalArgumentException("Use HttpClient.webSocket() of HttpClient()"));
                break;
            }
            case 118039: {
                if ("wss".equals(string)) return (F)Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new IllegalArgumentException("Use HttpClient.webSocket() of HttpClient()"));
                break;
            }
            case 3213448: {
                if (!"http".equals(string)) break;
                return this.http(new InetSocketAddress(uri.getHost(), uri.getPort()), request);
            }
            case 99617003: {
                if (!"https".equals(string)) break;
                return this.https(new InetSocketAddress(uri.getHost(), uri.getPort()), request);
            }
        }
        String scheme = string;
        return (F)Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new IllegalArgumentException(new StringBuilder(17).append(scheme).append(" is not supported").toString()));
    }

    public F https(InetSocketAddress address, Request<Stream<F, B>> request) {
        return (F)syntax$.MODULE$.EffectOps(this.takeSecureConnection(address), this.evidence$1).flatMap((Function1 & Serializable)borrow -> syntax$.MODULE$.EffectOps(this.http((AsyncResourcePool.Borrow<F, DataSocket<F, B>>)borrow, address.getHostName(), request), this.evidence$1).map((Function1 & Serializable)response -> response));
    }

    public F http(InetSocketAddress address, Request<Stream<F, B>> request) {
        return (F)syntax$.MODULE$.EffectOps(this.takeRawConnection(address), this.evidence$1).flatMap((Function1 & Serializable)borrow -> syntax$.MODULE$.EffectOps(this.http((AsyncResourcePool.Borrow<F, DataSocket<F, B>>)borrow, address.getHostName(), request), this.evidence$1).map((Function1 & Serializable)response -> response));
    }

    private F http(AsyncResourcePool.Borrow<F, DataSocket<F, B>> borrow, String host, Request<Stream<F, B>> request) {
        return (F)syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(this.http11.renderRequest(request.withHeader("Host", host), this.evidence$1), this.evidence$1).map((Function1 & Serializable)requestStream -> {
            DataSocket socket = (DataSocket)borrow.value();
            return Tuple2$.MODULE$.apply(requestStream, (Object)socket);
        }), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Stream requestStream = (Stream)tuple2._1();
                DataSocket socket = (DataSocket)tuple2._2();
                return syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(requestStream.foreach((Function1 & Serializable)bytes -> socket.write(bytes)), this.evidence$1).start(this.executor), this.evidence$1).flatMap((Function1 & Serializable)writeBytesFiber -> syntax$.MODULE$.EffectOps(this.http11.decodeResponse(Decoder$.MODULE$.apply(socket.stream(), this.evidence$1), this.evidence$1).pull(), this.evidence$1).flatMap((Function1 & Serializable)maybeResponse -> {
                    Object object;
                    Option option = maybeResponse;
                    if (option instanceof Some) {
                        Response response2 = (Response)((Some)option).value();
                        Tuple2 tuple2 = ((Stream)response2.body()).handleConsumed();
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object consumed = tuple2._1();
                        Stream consumableBody = (Stream)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply(consumed, (Object)consumableBody);
                        Object consumed2 = tuple22._1();
                        Stream consumableBody2 = (Stream)tuple22._2();
                        object = syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(consumed2, this.evidence$1).after(() -> HttpClient.http$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1(writeBytesFiber)), this.evidence$1).after(() -> HttpClient.http$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$2(borrow)), this.evidence$1).start(this.executor), this.evidence$1).as((Object)response2.copy(response2.copy$default$1(), (Object)consumableBody2, response2.copy$default$3(), response2.copy$default$4()));
                    } else if (None$.MODULE$.equals(option)) {
                        object = Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new IllegalStateException("Peer has closed connection before sending response."));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return syntax$.MODULE$.EffectOps(object, this.evidence$1).map((Function1 & Serializable)response -> response);
                }));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public F secureWebSocket(InetSocketAddress address, PathAndQuery path, Stream<F, WebSocketProtocol.Frame<B>> outgoingFrames, Map<String, String> cookie, Map<String, String> headers) {
        return (F)syntax$.MODULE$.EffectOps(this.takeRawConnection(address), this.evidence$1).flatMap((Function1 & Serializable)borrow -> syntax$.MODULE$.EffectOps(this.webSocket((AsyncResourcePool.Borrow<F, DataSocket<F, B>>)borrow, address.getHostName(), path, outgoingFrames, cookie, headers), this.evidence$1).map((Function1 & Serializable)frames -> frames));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public F webSocket(URI uri, Stream<F, WebSocketProtocol.Frame<B>> outgoingFrames, Map<String, String> cookie, Map<String, String> headers) {
        PathAndQuery pq = this.pqFromUri(uri);
        Map updatedHeaders = uri.getUserInfo() != null ? (Map)headers.$plus(Headers$.MODULE$.basicAuthorization(uri.getUserInfo())) : headers;
        String string = uri.getScheme();
        if ("ws".equals(string) && uri.getPort() == -1) {
            return this.webSocket(new InetSocketAddress(uri.getHost(), 80), pq, outgoingFrames, cookie, (Map<String, String>)updatedHeaders);
        }
        if ("wss".equals(string) && uri.getPort() == -1) {
            return this.secureWebSocket(new InetSocketAddress(uri.getHost(), 443), pq, outgoingFrames, cookie, (Map<String, String>)updatedHeaders);
        }
        switch (string == null ? 0 : string.hashCode()) {
            case 3804: {
                if (!"ws".equals(string)) break;
                return this.webSocket(new InetSocketAddress(uri.getHost(), uri.getPort()), pq, outgoingFrames, cookie, (Map<String, String>)updatedHeaders);
            }
            case 118039: {
                if (!"wss".equals(string)) break;
                return this.secureWebSocket(new InetSocketAddress(uri.getHost(), uri.getPort()), pq, outgoingFrames, cookie, (Map<String, String>)updatedHeaders);
            }
            case 3213448: {
                if ("http".equals(string)) return (F)Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new IllegalArgumentException("Use HttpClient.http() of HttpClient.webSocket()"));
                break;
            }
            case 99617003: {
                if (!"https".equals(string)) break;
                return (F)Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new IllegalArgumentException("Use HttpClient.http() of HttpClient.webSocket()"));
            }
        }
        String scheme = string;
        return (F)Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new IllegalArgumentException(new StringBuilder(17).append(scheme).append(" is not supported").toString()));
    }

    public F webSocket(InetSocketAddress address, PathAndQuery path, Stream<F, WebSocketProtocol.Frame<B>> outgoingFrames, Map<String, String> cookie, Map<String, String> headers) {
        return (F)syntax$.MODULE$.EffectOps(this.takeRawConnection(address), this.evidence$1).flatMap((Function1 & Serializable)borrow -> syntax$.MODULE$.EffectOps(this.webSocket((AsyncResourcePool.Borrow<F, DataSocket<F, B>>)borrow, address.getHostName(), path, outgoingFrames, cookie, headers), this.evidence$1).map((Function1 & Serializable)frames -> frames));
    }

    private F webSocket(AsyncResourcePool.Borrow<F, DataSocket<F, B>> borrow, String host, PathAndQuery path, Stream<F, WebSocketProtocol.Frame<B>> outgoingFrames, Map<String, String> cookie, Map<String, String> headers) {
        return (F)syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(WebSocketProtocol$Intention$.MODULE$.random(this.evidence$1), this.evidence$1).map((Function1 & Serializable)intention -> {
            Stream encodedOutgoingFrames = outgoingFrames.map((Function1 & Serializable)frame -> this.webSocketProtocol.encodeFrame((WebSocketProtocol.Frame<B>)frame, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)123))));
            Request requestRaw = Request$.MODULE$.apply((Request.Method)Request.Method$.Get$.MODULE$, path, headers.toSeq(), (Option)None$.MODULE$, (Object)encodedOutgoingFrames, Request$.MODULE$.$lessinit$greater$default$6());
            Request requestWithCookie = (Request)cookie.foldLeft((Object)requestRaw, (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Request acc = (Request)tuple2._1();
                    if (tuple22 != null) {
                        String k = (String)tuple22._1();
                        String v = (String)tuple22._2();
                        return acc.withCookie(k, v);
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            Request requestWithIntention = this.webSocketProtocol.addIntention(requestWithCookie, (WebSocketProtocol.Intention)intention);
            return Tuple5$.MODULE$.apply(intention, (Object)encodedOutgoingFrames, (Object)requestRaw, (Object)requestWithCookie, requestWithIntention);
        }), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            Tuple5 tuple5 = x$12;
            if (tuple5 != null) {
                WebSocketProtocol.Intention intention = (WebSocketProtocol.Intention)tuple5._1();
                Stream encodedOutgoingFrames = (Stream)tuple5._2();
                Request requestRaw = (Request)tuple5._3();
                Request requestWithCookie = (Request)tuple5._4();
                Request requestWithIntention = (Request)tuple5._5();
                return syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(this.http(borrow, host, requestWithIntention), this.evidence$1).map((Function1 & Serializable)rawResponse -> {
                    Decoder frameDecoder = Decoder$.MODULE$.apply((Stream)rawResponse.body(), this.evidence$1);
                    Decoder<F, WebSocketProtocol.Frame.Merged<B>> frames = this.webSocketProtocol.mergeFrames(this.webSocketProtocol.decodeFrames(frameDecoder, this.evidence$1), this.evidence$1);
                    return Tuple3$.MODULE$.apply(rawResponse, (Object)frameDecoder, frames);
                }), this.evidence$1).map((Function1 & Serializable)x$1 -> {
                    Tuple3 tuple3 = x$1;
                    if (tuple3 != null) {
                        Response rawResponse = (Response)tuple3._1();
                        Decoder frameDecoder = (Decoder)tuple3._2();
                        Decoder frames = (Decoder)tuple3._3();
                        return rawResponse.copy(rawResponse.copy$default$1(), (Object)frames, rawResponse.copy$default$3(), rawResponse.copy$default$4());
                    }
                    throw new MatchError((Object)tuple3);
                });
            }
            throw new MatchError((Object)tuple5);
        });
    }

    private PathAndQuery pqFromUri(URI uri) {
        String path = uri.getPath() == null ? "" : uri.getPath();
        String query = uri.getQuery() == null ? "" : uri.getQuery();
        return PathAndQuery$.MODULE$.fromString(new StringBuilder(0).append(path).append(query).toString());
    }

    private F takeRawConnection(InetSocketAddress address) {
        AsyncResourcePool pool = (AsyncResourcePool)this.rawConnectionsPools.getOrElseUpdate((Object)address, () -> this.$anonfun$3(address));
        return (F)pool.borrow();
    }

    private F takeSecureConnection(InetSocketAddress address) {
        AsyncResourcePool pool = (AsyncResourcePool)this.secureConnectionsPools.getOrElseUpdate((Object)address, () -> this.$anonfun$4(address));
        return (F)pool.borrow();
    }

    private static final Object http$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1(Effect.Fiber writeBytesFiber$2) {
        return writeBytesFiber$2.join();
    }

    private static final Object http$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$2(AsyncResourcePool.Borrow borrow$5) {
        return borrow$5.give();
    }

    private final Object factory$1(InetSocketAddress address$5) {
        return RawDataSocket$.MODULE$.connect(address$5, ByteBuffer.allocate(this.bufferSize), ByteBuffer.allocate(this.bufferSize), this.group, this.evidence$1, this.evidence$2);
    }

    private final Object $anonfun$3$$anonfun$1(InetSocketAddress address$9) {
        return this.factory$1(address$9);
    }

    private static final long $anonfun$3$$anonfun$2$$anonfun$1() {
        return System.nanoTime();
    }

    private final AsyncResourcePool $anonfun$3(InetSocketAddress address$8) {
        return new AsyncResourcePool(new StringBuilder(16).append(this.name).append("-raw-socket-pool").toString(), () -> this.$anonfun$3$$anonfun$1(address$8), (Function0 & Serializable)() -> Effect$.MODULE$.apply(this.evidence$1).delay(HttpClient::$anonfun$3$$anonfun$2$$anonfun$1), this.maxConnectionsPerAddress, this.maxIdleTime, this.evidence$1, DataSocket$.MODULE$.dataSocketClose(this.evidence$1), this.reporter);
    }

    private final Object factory$2(InetSocketAddress address$6) {
        return syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(RawDataSocket$.MODULE$.connect(address$6, ByteBuffer.allocate(this.bufferSize), ByteBuffer.allocate(this.bufferSize), this.group, this.evidence$1, this.evidence$2), this.evidence$1).map((Function1 & Serializable)rawSocket -> {
            BoxedUnit boxedUnit;
            this.reporter.debug("%s - Connection established", (Object)this.name);
            BoxedUnit $1$ = boxedUnit = BoxedUnit.UNIT;
            BoxedUnit $1$2 = BoxedUnit.UNIT;
            SSLEngine engine = this.sslContext.createSSLEngine(address$6.getHostName(), address$6.getPort());
            return Tuple3$.MODULE$.apply(rawSocket, (Object)$1$2, (Object)engine);
        }), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            Tuple3 tuple3 = x$12;
            if (tuple3 != null) {
                RawDataSocket rawSocket = (RawDataSocket)tuple3._1();
                SSLEngine engine = (SSLEngine)tuple3._3();
                return syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(SecureDataSocket$.MODULE$.forClientMode(rawSocket, engine, this.blockingExecutor, this.evidence$1, this.evidence$2), this.evidence$1).map((Function1 & Serializable)socket -> {
                    BoxedUnit boxedUnit;
                    this.reporter.debug("%s - TLS handshake finished", (Object)this.name);
                    BoxedUnit $2$ = boxedUnit = BoxedUnit.UNIT;
                    BoxedUnit $2$2 = BoxedUnit.UNIT;
                    return Tuple2$.MODULE$.apply(socket, (Object)$2$2);
                }), this.evidence$1).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        SecureDataSocket socket = (SecureDataSocket)tuple2._1();
                        return socket;
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple3);
        });
    }

    private final Object $anonfun$4$$anonfun$1(InetSocketAddress address$11) {
        return this.factory$2(address$11);
    }

    private static final long $anonfun$4$$anonfun$2$$anonfun$1() {
        return System.nanoTime();
    }

    private final AsyncResourcePool $anonfun$4(InetSocketAddress address$10) {
        return new AsyncResourcePool(new StringBuilder(16).append(this.name).append("-tls-socket-pool").toString(), () -> this.$anonfun$4$$anonfun$1(address$10), (Function0 & Serializable)() -> Effect$.MODULE$.apply(this.evidence$1).delay(HttpClient::$anonfun$4$$anonfun$2$$anonfun$1), this.maxConnectionsPerAddress, this.maxIdleTime, this.evidence$1, DataSocket$.MODULE$.dataSocketClose(this.evidence$1), this.reporter);
    }
}

