/*
 * Decompiled with CFR 0.152.
 */
package korolev.http.protocol;

import java.io.Serializable;
import korolev.data.BytesLike;
import korolev.data.BytesLike$;
import korolev.effect.Decoder;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Stream;
import korolev.effect.Stream$;
import korolev.effect.syntax$;
import korolev.http.protocol.Http11$;
import korolev.http.protocol.Http11$StringBuilderOps$;
import korolev.web.PathAndQuery;
import korolev.web.PathAndQuery$;
import korolev.web.Request;
import korolev.web.Request$;
import korolev.web.Response;
import korolev.web.Response$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class Http11<B> {
    private final BytesLike<B> evidence$1;
    private final Stream.Template<B> LastChunk;
    private final B HeaderDelimiter;
    private final B CRLF;
    private final ThreadLocal<java.lang.StringBuilder> sb;

    public Http11(BytesLike<B> evidence$1) {
        this.evidence$1 = evidence$1;
        String NewLine = "\r\n";
        this.LastChunk = Stream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BytesLike$.MODULE$.apply(evidence$1).ascii("0\r\n\r\n")}));
        this.HeaderDelimiter = BytesLike$.MODULE$.apply(evidence$1).ascii("\r\n\r\n");
        this.CRLF = BytesLike$.MODULE$.apply(evidence$1).ascii("\r\n");
        this.sb = new ThreadLocal();
    }

    public <F> Stream<F, Request<Stream<F, B>>> decodeRequest(Decoder<F, B> decoder, Effect<F> evidence$2) {
        return decoder.decode(this::decodeRequest$$anonfun$1, (Function2 & Serializable)(buffer, incoming) -> this.decodeRequest(buffer, incoming)).map((Function1 & Serializable)request -> {
            Decoder decoder;
            Option option = request.contentLength();
            if (option instanceof Some) {
                long l = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                if (0L == l) {
                    decoder = Stream$.MODULE$.empty(evidence$2);
                } else {
                    long contentLength = l;
                    decoder = decoder.decode(Http11::$anonfun$1, (Function2 & Serializable)(_$2, _$3) -> this.$anonfun$2(evidence$2, contentLength, BoxesRunTime.unboxToLong((Object)_$2), _$3));
                }
            } else if (None$.MODULE$.equals(option)) {
                decoder = request.header("Transfer-Encoding").contains((Object)"chunked") ? decoder.decode(this::$anonfun$3, (Function2 & Serializable)(state, incoming) -> this.decodeChunkedBody((Tuple2<Option<Object>, B>)state, (B)incoming)) : decoder;
            } else {
                throw new MatchError((Object)option);
            }
            Decoder decoder2 = decoder;
            Request.Method method = request.copy$default$1();
            PathAndQuery pathAndQuery = request.copy$default$2();
            Seq seq = request.copy$default$3();
            Option option2 = request.copy$default$4();
            String string = request.copy$default$6();
            return request.copy(method, pathAndQuery, seq, option2, (Object)decoder2, string);
        });
    }

    public Tuple2<B, Decoder.Action<B, Request<BoxedUnit>>> decodeRequest(B buffer, B incoming) {
        Object allBytes = korolev.data.syntax$.MODULE$.BytesLikeOps(buffer, this.evidence$1).$plus$plus(incoming);
        long l = this.findLastHeaderEnd(allBytes);
        if (-1L == l) {
            return Tuple2$.MODULE$.apply(allBytes, (Object)Decoder.Action$.TakeNext$.MODULE$);
        }
        long lastByteOfHeader = l;
        Tuple2<Object, Request<BoxedUnit>> tuple2 = this.parseRequest(allBytes, lastByteOfHeader);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object bodyBytes = tuple2._1();
        Request request = (Request)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(bodyBytes, (Object)request);
        Object bodyBytes2 = tuple22._1();
        Request request2 = (Request)tuple22._2();
        return Tuple2$.MODULE$.apply(BytesLike$.MODULE$.apply(this.evidence$1).empty(), (Object)Decoder.Action$.Fork$.MODULE$.apply((Object)request2, bodyBytes2));
    }

    public <F> Stream<F, Response<Stream<F, B>>> decodeResponse(Decoder<F, B> decoder, Effect<F> evidence$3) {
        return decoder.decode(this::decodeResponse$$anonfun$1, (Function2 & Serializable)(buffer, incoming) -> this.decodeResponse(buffer, incoming)).map((Function1 & Serializable)response -> {
            Decoder decoder;
            Option option = response.contentLength();
            if (option instanceof Some) {
                long contentLength = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                decoder = decoder.decode(Http11::$anonfun$5, (Function2 & Serializable)(_$5, _$6) -> this.$anonfun$6(evidence$3, contentLength, BoxesRunTime.unboxToLong((Object)_$5), _$6));
            } else if (None$.MODULE$.equals(option)) {
                decoder = response.header("Transfer-Encoding").contains((Object)"chunked") ? decoder.decode(this::$anonfun$7, (Function2 & Serializable)(state, incoming) -> this.decodeChunkedBody((Tuple2<Option<Object>, B>)state, (B)incoming)) : decoder;
            } else {
                throw new MatchError((Object)option);
            }
            Decoder decoder2 = decoder;
            Response.Status status = response.copy$default$1();
            Seq seq = response.copy$default$3();
            Option option2 = response.copy$default$4();
            return response.copy(status, (Object)decoder2, seq, option2);
        });
    }

    public Tuple2<B, Decoder.Action<B, Response<BoxedUnit>>> decodeResponse(B buffer, B incoming) {
        Object allBytes = korolev.data.syntax$.MODULE$.BytesLikeOps(buffer, this.evidence$1).$plus$plus(incoming);
        long l = this.findLastHeaderEnd(allBytes);
        if (-1L == l) {
            return Tuple2$.MODULE$.apply(allBytes, (Object)Decoder.Action$.TakeNext$.MODULE$);
        }
        long lastByteOfHeader = l;
        Tuple2<Object, Response<BoxedUnit>> tuple2 = this.parseResponse(allBytes, lastByteOfHeader);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object bodyBytes = tuple2._1();
        Response response = (Response)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(bodyBytes, (Object)response);
        Object bodyBytes2 = tuple22._1();
        Response response2 = (Response)tuple22._2();
        return Tuple2$.MODULE$.apply(BytesLike$.MODULE$.apply(this.evidence$1).empty(), (Object)Decoder.Action$.Fork$.MODULE$.apply((Object)response2, bodyBytes2));
    }

    public <F> Tuple2<Object, Decoder.Action<B, B>> decodeLimitedBody(long prevBytesTotal, B incoming, long contentLength, Effect<F> evidence$4) {
        long l = prevBytesTotal + korolev.data.syntax$.MODULE$.BytesLikeOps(incoming, this.evidence$1).length();
        if (contentLength == l) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)contentLength), (Object)Decoder.Action$.PushFinish$.MODULE$.apply(incoming));
        }
        long total = l;
        if (total > contentLength) {
            long pos = contentLength - prevBytesTotal;
            Object value = korolev.data.syntax$.MODULE$.BytesLikeOps(incoming, this.evidence$1).slice(0L, pos);
            Object takeBack = korolev.data.syntax$.MODULE$.BytesLikeOps(incoming, this.evidence$1).slice(pos);
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)total), (Object)Decoder.Action$.ForkFinish$.MODULE$.apply(value, takeBack));
        }
        long total2 = l;
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)total2), (Object)Decoder.Action$.Push$.MODULE$.apply(incoming));
    }

    public Tuple2<Tuple2<Option<Object>, B>, Decoder.Action<B, B>> decodeChunkedBody(Tuple2<Option<Object>, B> state, B incoming) {
        Tuple2<Option<Object>, B> tuple2 = state;
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Object object = tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                long chunkSize = BoxesRunTime.unboxToLong((Object)some.value());
                Some maybeChunkSize = some;
                Object buffer = object;
                Object allBytes = korolev.data.syntax$.MODULE$.BytesLikeOps(buffer, this.evidence$1).$plus$plus(incoming);
                long expectedLength = chunkSize + korolev.data.syntax$.MODULE$.BytesLikeOps(this.CRLF, this.evidence$1).length();
                if (korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).length() >= expectedLength) {
                    if (chunkSize > 0L) {
                        Object chunk = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).slice(0L, chunkSize);
                        Object rest = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).slice(expectedLength);
                        return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)None$.MODULE$, BytesLike$.MODULE$.apply(this.evidence$1).empty()), (Object)Decoder.Action$.Fork$.MODULE$.apply(chunk, rest));
                    }
                    Object rest = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).slice(expectedLength);
                    return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)None$.MODULE$, BytesLike$.MODULE$.apply(this.evidence$1).empty()), (Object)Decoder.Action$.TakeBackFinish$.MODULE$.apply(rest));
                }
                return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)maybeChunkSize, allBytes), (Object)Decoder.Action$.TakeNext$.MODULE$);
            }
            if (None$.MODULE$.equals(option)) {
                Object buffer = object;
                Object allBytes = korolev.data.syntax$.MODULE$.BytesLikeOps(buffer, this.evidence$1).$plus$plus(incoming);
                long index = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).indexOfSlice(this.CRLF);
                if (index < 0L) {
                    return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)None$.MODULE$, allBytes), (Object)Decoder.Action$.TakeNext$.MODULE$);
                }
                String chunkSizeHex = korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).slice(0L, index), this.evidence$1).asAsciiString();
                long chunkSize = Long.parseLong(chunkSizeHex, 16);
                Object restBytes = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).slice(index + korolev.data.syntax$.MODULE$.BytesLikeOps(this.CRLF, this.evidence$1).length());
                return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)chunkSize)), BytesLike$.MODULE$.apply(this.evidence$1).empty()), (Object)Decoder.Action$.TakeBack$.MODULE$.apply(restBytes));
            }
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<B, Request<BoxedUnit>> parseRequest(B allBytes, long lastByteOfHeader) {
        long methodEnd = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).indexOf((byte)32);
        long paramsStart = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).indexOf((byte)63, methodEnd + 1L);
        long pathEnd = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).indexOf((byte)32, methodEnd + 1L);
        long protocolVersionEnd = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).indexOf((byte)13);
        boolean hasParams = paramsStart > -1L && paramsStart < protocolVersionEnd;
        String method = korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).slice(0L, methodEnd), this.evidence$1).asAsciiString();
        String path = korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).slice(methodEnd + 1L, hasParams ? paramsStart : pathEnd), this.evidence$1).asAsciiString();
        String params = hasParams ? korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).slice(paramsStart + 1L, pathEnd), this.evidence$1).asAsciiString() : null;
        Buffer headers = (Buffer)Buffer$.MODULE$.empty();
        long headerStart = protocolVersionEnd + 2L;
        String cookie = null;
        String contentLength = null;
        while (headerStart < lastByteOfHeader) {
            BoxedUnit boxedUnit;
            long nameEnd = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).indexOf((byte)58, headerStart);
            long valueEnd = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).indexOf((byte)13, nameEnd);
            String name = korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).slice(headerStart, nameEnd), this.evidence$1).asAsciiString();
            String value = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).apply(nameEnd + 1L) == 32 ? korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).slice(nameEnd + 2L, valueEnd), this.evidence$1).asAsciiString() : korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).slice(nameEnd + 1L, valueEnd), this.evidence$1).asAsciiString();
            String string = name;
            if (name.equalsIgnoreCase("Cookie")) {
                cookie = value;
                boxedUnit = BoxedUnit.UNIT;
            } else if (name.equalsIgnoreCase("Content-Length")) {
                contentLength = value;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = headers.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)name, (Object)value));
            }
            headerStart = valueEnd + 2L;
        }
        Request.Method method2 = Request.Method$.MODULE$.fromString(method);
        PathAndQuery pathAndQuery = PathAndQuery$.MODULE$.fromString(path).withParams(Option$.MODULE$.apply((Object)params));
        String string = cookie;
        Vector vector = headers.toVector();
        None$ none$ = contentLength == null ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(contentLength))));
        Request request = Request$.MODULE$.apply(method2, pathAndQuery, (Seq)vector, (Option)none$, (Object)BoxedUnit.UNIT, string);
        Object bodyBytes = korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).slice(lastByteOfHeader + 4L, korolev.data.syntax$.MODULE$.BytesLikeOps(allBytes, this.evidence$1).length());
        return Tuple2$.MODULE$.apply(bodyBytes, (Object)request);
    }

    public long findLastHeaderEnd(B bytes) {
        return korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).indexOfSlice(this.HeaderDelimiter);
    }

    public Tuple2<B, Response<BoxedUnit>> parseResponse(B bytes, long lastHeaderEnd) {
        long protocolVersionEnd = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).indexOf((byte)32);
        long statusCodeStart = protocolVersionEnd + 1L;
        long statusCodeEnd = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).indexOf((byte)32, statusCodeStart);
        long statusPhraseStart = statusCodeEnd + 1L;
        long statusPhraseEnd = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).indexOf((byte)13, statusPhraseStart);
        Object statusCode = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).slice(statusCodeStart, statusCodeEnd);
        Object statusPhrase = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).slice(statusPhraseStart, statusPhraseEnd);
        long headerStart = statusPhraseEnd + 2L;
        Buffer headers = (Buffer)Buffer$.MODULE$.empty();
        String cookie = null;
        String contentLength = null;
        while (headerStart < lastHeaderEnd) {
            BoxedUnit boxedUnit;
            long nameEnd = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).indexOf((byte)58, headerStart);
            long valueEnd = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).indexOf((byte)13, nameEnd);
            String name = korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).slice(headerStart, nameEnd), this.evidence$1).asAsciiString();
            String value = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).apply(nameEnd + 1L) == 32 ? korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).slice(nameEnd + 2L, valueEnd), this.evidence$1).asAsciiString() : korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).slice(nameEnd + 1L, valueEnd), this.evidence$1).asAsciiString();
            String string = name;
            if (name.equalsIgnoreCase("Cookie")) {
                cookie = value;
                boxedUnit = headers.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)name, (Object)value));
            } else if (name.equalsIgnoreCase("Content-Length")) {
                contentLength = value;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = headers.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)name, (Object)value));
            }
            headerStart = valueEnd + 2L;
        }
        Response.Status status = Response.Status$.MODULE$.apply(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(korolev.data.syntax$.MODULE$.BytesLikeOps(statusCode, this.evidence$1).asAsciiString())), korolev.data.syntax$.MODULE$.BytesLikeOps(statusPhrase, this.evidence$1).asAsciiString());
        Vector vector = headers.toVector();
        None$ none$ = contentLength == null ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(contentLength))));
        Response response = Response$.MODULE$.apply(status, (Object)BoxedUnit.UNIT, (Seq)vector, (Option)none$);
        Object bodyBytes = korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).slice(lastHeaderEnd + 4L, korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$1).length());
        return Tuple2$.MODULE$.apply(bodyBytes, (Object)response);
    }

    public String renderResponseHeader(Response.Status status, Seq<Tuple2<String, String>> headers) {
        java.lang.StringBuilder stringBuilder;
        java.lang.StringBuilder b = this.sb.get();
        if (b == null) {
            java.lang.StringBuilder nb = new java.lang.StringBuilder();
            this.sb.set(nb);
            stringBuilder = nb;
        } else {
            b.setLength(0);
            stringBuilder = b;
        }
        java.lang.StringBuilder builder = stringBuilder;
        builder.append("HTTP/1.1 ").append(status.codeAsString()).append(' ').append(status.phrase()).append("\r\n");
        headers.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                return Http11.putHeader$1(builder, name, value);
            }
            throw new MatchError((Object)tuple2);
        });
        return builder.append("\r\n").toString();
    }

    public <T> String renderRequestHead(Request<T> request) {
        BoxedUnit boxedUnit;
        Option option;
        StringBuilder sb = new StringBuilder().appendAll(request.method().value()).append(' ');
        request.pq().mkString(sb);
        Http11$StringBuilderOps$.MODULE$.newLine$extension(Http11$.MODULE$.korolev$http$protocol$Http11$$$StringBuilderOps(sb.append(' ').appendAll("HTTP/1.1")));
        if (request.renderedCookie() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(request.renderedCookie()))) {
            Http11$StringBuilderOps$.MODULE$.newLine$extension(Http11$.MODULE$.korolev$http$protocol$Http11$$$StringBuilderOps(sb.appendAll("Cookie").appendAll(": ").appendAll(request.renderedCookie())));
        }
        if (None$.MODULE$.equals(option = request.contentLength())) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            long contentLength = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            boxedUnit = Http11$StringBuilderOps$.MODULE$.newLine$extension(Http11$.MODULE$.korolev$http$protocol$Http11$$$StringBuilderOps(sb.appendAll("Content-Length").appendAll(": ").append(contentLength)));
        } else {
            throw new MatchError((Object)option);
        }
        request.headers().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Http11$StringBuilderOps$.MODULE$.newLine$extension(Http11$.MODULE$.korolev$http$protocol$Http11$$$StringBuilderOps(sb.appendAll(k).appendAll(": ").appendAll(v)));
            }
            throw new MatchError((Object)tuple2);
        });
        return Http11$StringBuilderOps$.MODULE$.newLine$extension(Http11$.MODULE$.korolev$http$protocol$Http11$$$StringBuilderOps(sb)).mkString();
    }

    public <F> Object renderRequest(Request<Stream<F, B>> request, Effect<F> evidence$5) {
        String head = this.renderRequestHead(request);
        return syntax$.MODULE$.EffectOps(Stream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BytesLike$.MODULE$.apply(this.evidence$1).ascii(head)})).mat(evidence$5), evidence$5).map((Function1 & Serializable)_$9 -> _$9.$plus$plus((Stream)request.body()));
    }

    public <F> Object renderResponse(Response<Stream<F, B>> response, Effect<F> evidence$6) {
        Option option = response.contentLength();
        if (option instanceof Some) {
            long s = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Content-Length");
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToLong((long)s).toString());
            return this.go$1(response, evidence$6, (Seq)response.headers().$plus$colon((Object)tuple2), (Stream)response.body());
        }
        if (None$.MODULE$.equals(option)) {
            Response.Status status = response.status();
            Response.Status status2 = Response.Status$.MODULE$.SwitchingProtocols();
            if (!(status != null ? !status.equals(status2) : status2 != null)) {
                return this.go$1(response, evidence$6, response.headers(), (Stream)response.body());
            }
            if (response.header("Transfer-Encoding").contains((Object)"chunked")) {
                Stream chunkedBody = ((Stream)response.body()).map((Function1 & Serializable)chunk -> korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(korolev.data.syntax$.MODULE$.BytesLikeOps(BytesLike$.MODULE$.apply(this.evidence$1).ascii(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(korolev.data.syntax$.MODULE$.BytesLikeOps(chunk, this.evidence$1).length()))), this.evidence$1).$plus$plus(this.CRLF), this.evidence$1).$plus$plus(chunk), this.evidence$1).$plus$plus(this.CRLF));
                return syntax$.MODULE$.EffectOps(this.LastChunk.mat(evidence$6), evidence$6).flatMap((Function1 & Serializable)lastChunk -> this.go$1(response, evidence$6, response.headers(), chunkedBody.$plus$plus(lastChunk)));
            }
            Predef$.MODULE$.println((Object)"NOT CHUNKED BUT NONE");
            response.headers().foreach((Function1)(JProcedure1 & Serializable)x -> Predef$.MODULE$.println(x));
            return Effect$.MODULE$.apply(evidence$6).pure((Object)Stream$.MODULE$.empty(evidence$6));
        }
        throw new MatchError((Object)option);
    }

    private final Object decodeRequest$$anonfun$1() {
        return BytesLike$.MODULE$.apply(this.evidence$1).empty();
    }

    private static final long $anonfun$1() {
        return 0L;
    }

    private final /* synthetic */ Tuple2 $anonfun$2(Effect evidence$2$2, long contentLength$5, long _$2, Object _$3) {
        return this.decodeLimitedBody(_$2, _$3, contentLength$5, evidence$2$2);
    }

    private final Tuple2 $anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)Option$.MODULE$.empty(), BytesLike$.MODULE$.apply(this.evidence$1).empty());
    }

    private final Object decodeResponse$$anonfun$1() {
        return BytesLike$.MODULE$.apply(this.evidence$1).empty();
    }

    private static final long $anonfun$5() {
        return 0L;
    }

    private final /* synthetic */ Tuple2 $anonfun$6(Effect evidence$3$2, long contentLength$6, long _$5, Object _$6) {
        return this.decodeLimitedBody(_$5, _$6, contentLength$6, evidence$3$2);
    }

    private final Tuple2 $anonfun$7() {
        return Tuple2$.MODULE$.apply((Object)Option$.MODULE$.empty(), BytesLike$.MODULE$.apply(this.evidence$1).empty());
    }

    private static final java.lang.StringBuilder putHeader$1(java.lang.StringBuilder builder$1, String name, String value) {
        return builder$1.append(name).append(':').append(' ').append(value).append("\r\n");
    }

    private final Object go$1(Response response$1, Effect evidence$6$1, Seq readers, Stream body) {
        String fullHeaderString = this.renderResponseHeader(response$1.status(), (Seq<Tuple2<String, String>>)readers);
        Object fullHeaderBytes = BytesLike$.MODULE$.apply(this.evidence$1).ascii(fullHeaderString);
        return syntax$.MODULE$.EffectOps(Stream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{fullHeaderBytes})).mat(evidence$6$1), evidence$6$1).map((Function1 & Serializable)_$11 -> _$11.$plus$plus(body));
    }

    public static final class StringBuilderOps {
        private final StringBuilder builder;

        public static boolean equals$extension(StringBuilder stringBuilder, Object object) {
            return Http11$StringBuilderOps$.MODULE$.equals$extension(stringBuilder, object);
        }

        public static int hashCode$extension(StringBuilder stringBuilder) {
            return Http11$StringBuilderOps$.MODULE$.hashCode$extension(stringBuilder);
        }

        public static StringBuilder newLine$extension(StringBuilder stringBuilder) {
            return Http11$StringBuilderOps$.MODULE$.newLine$extension(stringBuilder);
        }

        public StringBuilderOps(StringBuilder builder) {
            this.builder = builder;
        }

        public int hashCode() {
            return Http11$StringBuilderOps$.MODULE$.hashCode$extension(this.builder());
        }

        public boolean equals(Object x$0) {
            return Http11$StringBuilderOps$.MODULE$.equals$extension(this.builder(), x$0);
        }

        public StringBuilder builder() {
            return this.builder;
        }

        public StringBuilder newLine() {
            return Http11$StringBuilderOps$.MODULE$.newLine$extension(this.builder());
        }
    }
}

