/*
 * Decompiled with CFR 0.152.
 */
package korolev.web.dsl;

import java.io.Serializable;
import korolev.data.BytesLike;
import korolev.data.BytesLike$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Stream;
import korolev.effect.Stream$;
import korolev.effect.syntax$;
import korolev.web.Headers$;
import korolev.web.dsl.BodyFactory$;
import korolev.web.dsl.BodyFactory$Body$;
import korolev.web.dsl.EmptyBodyFactory;
import korolev.web.dsl.JsonCodec;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface BodyFactory<F, A, B> {
    public static <F, J, B> BodyFactory<F, J, B> jsonBodyFactory(Effect<F> effect, JsonCodec<J> jsonCodec, BodyFactory<F, String, B> bodyFactory) {
        return BodyFactory$.MODULE$.jsonBodyFactory(effect, jsonCodec, bodyFactory);
    }

    public static <F, A, B> BodyFactory<F, A, Stream<F, B>> streamedBodyFactory(Effect<F> effect, BodyFactory<F, A, B> bodyFactory) {
        return BodyFactory$.MODULE$.streamedBodyFactory(effect, bodyFactory);
    }

    public static <F, A> EmptyBodyFactory<Stream<F, A>> streamedEmptyBodyFactory(Effect<F> effect) {
        return BodyFactory$.MODULE$.streamedEmptyBodyFactory(effect);
    }

    public static <F, B> BodyFactory<F, String, B> stringBytesLikeBodyFactory(Effect<F> effect, BytesLike<B> bytesLike) {
        return BodyFactory$.MODULE$.stringBytesLikeBodyFactory(effect, bytesLike);
    }

    public F mkBody(A var1);

    public static final class Body<B>
    implements Product,
    Serializable {
        private final Object content;
        private final Map headers;
        private final Option contentLength;

        public static <B> Body<B> apply(B b, Map<String, String> map, Option<Object> option) {
            return BodyFactory$Body$.MODULE$.apply(b, map, option);
        }

        public static Body<?> fromProduct(Product product) {
            return BodyFactory$Body$.MODULE$.fromProduct(product);
        }

        public static <B> Body<B> unapply(Body<B> body) {
            return BodyFactory$Body$.MODULE$.unapply(body);
        }

        public Body(B content, Map<String, String> headers, Option<Object> contentLength) {
            this.content = content;
            this.headers = headers;
            this.contentLength = contentLength;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Body)) return false;
            Body body = (Body)object;
            if (!BoxesRunTime.equals(this.content(), body.content())) return false;
            Map<String, String> map = this.headers();
            Map<String, String> map2 = body.headers();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Option<Object> option = this.contentLength();
            Option<Object> option2 = body.contentLength();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Body;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Body";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "content";
                    break;
                }
                case 1: {
                    string = "headers";
                    break;
                }
                case 2: {
                    string = "contentLength";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public B content() {
            return (B)this.content;
        }

        public Map<String, String> headers() {
            return this.headers;
        }

        public Option<Object> contentLength() {
            return this.contentLength;
        }

        public <B> Body<B> copy(B content, Map<String, String> headers, Option<Object> contentLength) {
            return new Body<B>(content, headers, contentLength);
        }

        public <B> B copy$default$1() {
            return this.content();
        }

        public <B> Map<String, String> copy$default$2() {
            return this.headers();
        }

        public <B> Option<Object> copy$default$3() {
            return this.contentLength();
        }

        public B _1() {
            return this.content();
        }

        public Map<String, String> _2() {
            return this.headers();
        }

        public Option<Object> _3() {
            return this.contentLength();
        }
    }

    private static final class JsonBodyFactory<F, J, B>
    implements BodyFactory<F, J, B> {
        private final Effect<F> evidence$3;
        private final JsonCodec<J> evidence$4;
        private final BodyFactory<F, String, B> bf;

        public JsonBodyFactory(Effect<F> evidence$3, JsonCodec<J> evidence$4, BodyFactory<F, String, B> bf) {
            this.evidence$3 = evidence$3;
            this.evidence$4 = evidence$4;
            this.bf = bf;
        }

        @Override
        public F mkBody(J source) {
            return (F)syntax$.MODULE$.EffectOps(this.bf.mkBody(((JsonCodec)Predef$.MODULE$.implicitly(this.evidence$4)).encode(source)), this.evidence$3).map((Function1 & Serializable)body -> {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Content-Type");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"application/json; charset=utf-8");
                Map map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                Object b = body.copy$default$1();
                Option<Object> option = body.copy$default$3();
                return body.copy(b, (Map<String, String>)map, option);
            });
        }
    }

    private static final class StreamedBodyFactory<F, A, B>
    implements BodyFactory<F, A, Stream<F, B>> {
        private final Effect<F> evidence$5;
        private final BodyFactory<F, A, B> bf;

        public StreamedBodyFactory(Effect<F> evidence$5, BodyFactory<F, A, B> bf) {
            this.evidence$5 = evidence$5;
            this.bf = bf;
        }

        @Override
        public F mkBody(A source) {
            return (F)syntax$.MODULE$.EffectOps(this.bf.mkBody(source), this.evidence$5).flatMap((Function1 & Serializable)body -> syntax$.MODULE$.EffectOps(Stream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{body.content()})).mat(this.evidence$5), this.evidence$5).map((Function1 & Serializable)stream -> BodyFactory$Body$.MODULE$.apply(stream, body.headers(), body.contentLength())));
        }
    }

    private static final class StringBytesLikeBodyFactory<F, B>
    implements BodyFactory<F, String, B> {
        private final Effect<F> evidence$1;
        private final BytesLike<B> evidence$2;

        public StringBytesLikeBodyFactory(Effect<F> evidence$1, BytesLike<B> evidence$2) {
            this.evidence$1 = evidence$1;
            this.evidence$2 = evidence$2;
        }

        @Override
        public F mkBody(String source) {
            Object bytes = BytesLike$.MODULE$.apply(this.evidence$2).utf8(source);
            return (F)Effect$.MODULE$.apply(this.evidence$1).pure(BodyFactory$Body$.MODULE$.apply(bytes, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Headers$.MODULE$.ContentTypeTextUtf8()}))), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)korolev.data.syntax$.MODULE$.BytesLikeOps(bytes, this.evidence$2).length()))));
        }
    }
}

