/*
 * Decompiled with CFR 0.152.
 */
package korolev.zio.http;

import java.io.Serializable;
import korolev.data.Bytes;
import korolev.data.Bytes$;
import korolev.data.BytesLike;
import korolev.effect.Effect;
import korolev.effect.Queue;
import korolev.effect.Queue$;
import korolev.effect.Stream;
import korolev.effect.Stream$;
import korolev.server.KorolevService;
import korolev.server.KorolevServiceConfig;
import korolev.state.StateDeserializer;
import korolev.state.StateSerializer;
import korolev.web.PathAndQuery;
import korolev.web.PathAndQuery$;
import korolev.web.Request;
import korolev.web.Request$;
import korolev.web.Response;
import korolev.web.Response$;
import korolev.zio.ZioEffect;
import korolev.zio.http.HttpStatusConverter$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArraySeq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import zhttp.http.Header;
import zhttp.http.Header$;
import zhttp.http.Http;
import zhttp.http.HttpApp$;
import zhttp.http.HttpData;
import zhttp.http.HttpData$;
import zhttp.http.Method;
import zhttp.http.PathModule;
import zhttp.http.Request;
import zhttp.http.Response;
import zhttp.socket.Socket;
import zhttp.socket.Socket$;
import zhttp.socket.SocketApp;
import zhttp.socket.SocketApp$;
import zhttp.socket.SocketDecoder$;
import zhttp.socket.WebSocketFrame;
import zio.Chunk;
import zio.Task$;
import zio.ZIO;
import zio.ZIO$;
import zio.package;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public class ZioHttpKorolev<R> {
    public <S, M> Http<R, Throwable, Request, Response<R, Throwable>> service(KorolevServiceConfig<package.RIO, S, M> config, StateSerializer<S> evidence$1, StateDeserializer<S> evidence$2, ZioEffect<R, Throwable> eff) {
        KorolevService korolevServer = korolev.server.package$.MODULE$.korolevService(config, eff, evidence$1, evidence$2);
        PathModule.Path rootPath = zhttp.http.package$.MODULE$.Path().apply(config.rootPath().mkString());
        return HttpApp$.MODULE$.collectM((PartialFunction)new Serializable(evidence$1, evidence$2, eff, korolevServer, rootPath, this){
            private final StateSerializer evidence$1$2;
            private final StateDeserializer evidence$2$2;
            private final ZioEffect eff$2;
            private final KorolevService korolevServer$2;
            private final PathModule.Path rootPath$2;
            private final ZioHttpKorolev $outer;
            {
                this.evidence$1$2 = evidence$1$3;
                this.evidence$2$2 = evidence$2$3;
                this.eff$2 = eff$4;
                this.korolevServer$2 = korolevServer$4;
                this.rootPath$2 = rootPath$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Request x) {
                Request request = x;
                Request req = request;
                return this.$outer.korolev$zio$http$ZioHttpKorolev$$matchPrefix(this.rootPath$2, req.url().path());
            }

            public final Object applyOrElse(Request x, Function1 function1) {
                Request request = x;
                Request req = request;
                return this.$outer.korolev$zio$http$ZioHttpKorolev$$matchPrefix(this.rootPath$2, req.url().path()) ? this.$outer.korolev$zio$http$ZioHttpKorolev$$_$app$2(this.evidence$1$2, this.evidence$2$2, this.eff$2, this.korolevServer$2, this.rootPath$2, req) : function1.apply((Object)x);
            }
        });
    }

    private boolean matchWebSocket(Request req) {
        Method method = req.method();
        Method.GET$ gET$ = Method.GET$.MODULE$;
        return !(method != null ? !method.equals(gET$) : gET$ != null) && this.containsUpgradeHeader(req);
    }

    private ZIO<R, Throwable, Response<R, Throwable>> routeHttpRequest(PathModule.Path rootPath, Request req, KorolevService<package.RIO> korolevServer, ZioEffect<R, Throwable> eff) {
        ZIO<R, Throwable, Response<R, Throwable>> zIO;
        Request request;
        int prefLength = rootPath.toList().length();
        Request req2 = request = req;
        Method method = req2.method();
        Method.GET$ gET$ = Method.GET$.MODULE$;
        if (!(method != null ? !method.equals(gET$) : gET$ != null)) {
            Stream body = Stream$.MODULE$.empty(eff);
            korolev.web.Request<Stream> korolevRequest = this.mkKorolevRequest(req2, this.subPath(req2.url().path(), prefLength), body);
            zIO = this.handleHttpResponse(korolevServer, korolevRequest);
        } else {
            Request req3 = request;
            zIO = this.toKorolevBody(req3.content(), eff).map((Function1 & Serializable)stream -> {
                korolev.web.Request<Stream> korolevRequest = this.mkKorolevRequest(req3, this.subPath(req3.url().path(), prefLength), stream);
                return Tuple2$.MODULE$.apply(stream, korolevRequest);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Stream stream = (Stream)tuple2._1();
                korolev.web.Request korolevRequest = (korolev.web.Request)tuple2._2();
                return this.handleHttpResponse(korolevServer, (korolev.web.Request<Stream<package.RIO, Bytes>>)korolevRequest).map((Function1 & Serializable)response -> response);
            });
        }
        return zIO;
    }

    public boolean korolev$zio$http$ZioHttpKorolev$$matchPrefix(PathModule.Path prefix, PathModule.Path url) {
        List list = url.toList().take(prefix.toList().length());
        List list2 = prefix.toList();
        return !(list != null ? !list.equals(list2) : list2 != null);
    }

    private String subPath(PathModule.Path path, int prefLength) {
        return zhttp.http.package$.MODULE$.Path().apply((List)path.toList().drop(prefLength)).toString();
    }

    private boolean containsUpgradeHeader(Request req) {
        List headers = req.headers();
        Option found = headers.find((Function1 & Serializable)h -> {
            String string = String.valueOf(h.name()).toLowerCase();
            String string2 = "connection";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = String.valueOf(h.value()).toLowerCase();
            String string4 = "upgrade";
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }).flatMap((Function1 & Serializable)x$12 -> {
            Header header = x$12;
            return headers.find((Function1 & Serializable)h -> {
                String string = String.valueOf(h.name()).toLowerCase();
                String string2 = "upgrade";
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = String.valueOf(h.value()).toLowerCase();
                String string4 = "websocket";
                if (string3 == null) {
                    if (string4 == null) return true;
                    return false;
                } else {
                    if (!string3.equals(string4)) return false;
                    return true;
                }
            }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                Header header = x$1;
            });
        });
        return found.isDefined();
    }

    private <S, M> ZIO<R, Throwable, Response<R, Throwable>> routeWsRequest(Request req, String fullPath, KorolevService<package.RIO> korolevServer, StateSerializer<S> evidence$3, StateDeserializer<S> evidence$4, ZioEffect<R, Throwable> eff) {
        Queue fromClientKQueue = Queue$.MODULE$.apply(Queue$.MODULE$.apply$default$1(), eff);
        korolev.web.Request<Stream> korolevRequest = this.mkKorolevRequest(req, fullPath, fromClientKQueue.stream());
        return ((ZIO)korolevServer.ws(korolevRequest)).map((Function1 & Serializable)response -> {
            korolev.web.Response response2 = response;
            if (response2 == null) {
                if (response2 == null) {
                    throw new RuntimeException();
                }
                throw new MatchError((Object)response2);
            }
            korolev.web.Response response3 = Response$.MODULE$.unapply(response2);
            Response.Status status = response3._1();
            Stream stream = (Stream)response3._2();
            Seq seq = response3._3();
            Option option = response3._4();
            Stream outStream = stream;
            ZStream toClient = korolev.zio.streams.package$.MODULE$.KorolevSreamOps(outStream.map((Function1 & Serializable)out -> WebSocketFrame.Text$.MODULE$.apply(out))).toZStream();
            return Tuple2$.MODULE$.apply(response, (Object)toClient);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            korolev.web.Response response = (korolev.web.Response)tuple2._1();
            ZStream toClient = (ZStream)tuple2._2();
            return this.buildSocket(toClient, (Queue<package.RIO, String>)fromClientKQueue).map((Function1 & Serializable)route -> route);
        });
    }

    private ZIO<R, Throwable, Response<R, Throwable>> buildSocket(ZStream<R, Throwable, WebSocketFrame> toClientStream, Queue<package.RIO, String> fromClientKQueue) {
        BoxedUnit boxedUnit = Socket$.MODULE$.fromFunction();
        Socket onMessage = Socket.MkFromFunction$.MODULE$.apply$extension(boxedUnit, (Function1 & Serializable)_$8 -> ZStream$.MODULE$.empty()).contramapM((Function1 & Serializable)x$1 -> {
            ZIO zIO;
            WebSocketFrame webSocketFrame = x$1;
            if (webSocketFrame instanceof WebSocketFrame.Text) {
                String string;
                WebSocketFrame.Text text = (WebSocketFrame.Text)webSocketFrame;
                WebSocketFrame.Text text2 = WebSocketFrame.Text$.MODULE$.unapply(text);
                String t = string = text2._1();
                WebSocketFrame.Text f = text;
                zIO = ((ZIO)fromClientKQueue.offer((Object)t)).as(() -> ZioHttpKorolev.$anonfun$5$$anonfun$1(f));
            } else if (webSocketFrame instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close f = (WebSocketFrame.Close)webSocketFrame;
                zIO = ((ZIO)fromClientKQueue.close()).as(() -> ZioHttpKorolev.$anonfun$5$$anonfun$2(f));
            } else {
                WebSocketFrame frame = webSocketFrame;
                zIO = ZIO$.MODULE$.fail(() -> ZioHttpKorolev.$anonfun$5$$anonfun$3(frame));
            }
            return zIO;
        });
        BoxedUnit boxedUnit2 = Socket$.MODULE$.fromFunction();
        SocketApp app = SocketApp$.MODULE$.open(Socket.MkFromFunction$.MODULE$.apply$extension(boxedUnit2, (Function1 & Serializable)_$9 -> toClientStream)).$plus$plus(SocketApp$.MODULE$.message(onMessage)).$plus$plus(SocketApp$.MODULE$.close((Function1 & Serializable)_$10 -> (ZIO)fromClientKQueue.close())).$plus$plus(SocketApp$.MODULE$.decoder(SocketDecoder$.MODULE$.allowExtensions()));
        return ZIO$.MODULE$.apply(() -> ZioHttpKorolev.buildSocket$$anonfun$1(app));
    }

    private <Body> korolev.web.Request<Body> mkKorolevRequest(Request request, String path, Body body) {
        Option<String> cookies = this.findCookieHeader((List<Header>)request.headers());
        Map params = (Map)request.url().queryParams().collect((PartialFunction)new Serializable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 == null) return false;
                String k = (String)tuple2._1();
                List v = (List)tuple2._2();
                if (!v.nonEmpty()) return false;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Object object;
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    List v = (List)tuple2._2();
                    if (v.nonEmpty()) {
                        object = Tuple2$.MODULE$.apply((Object)k, v.head());
                        return object;
                    }
                }
                object = function1.apply((Object)x);
                return object;
            }
        });
        PathAndQuery pathAndQuery = PathAndQuery$.MODULE$.fromString(path).withParams(params);
        Request.Method method = Request.Method$.MODULE$.fromString(request.method().toString());
        String string = (String)cookies.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option option = this.findHeaderValue((List<Header>)request.headers(), "content-length").map((Function1 & Serializable)_$11 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$11)));
        Option contentType = request.getContentType();
        Seq contentTypeHeaders = (Seq)contentType.map((Function1 & Serializable)ct -> {
            Seq seq;
            if (ct.contains("multipart")) {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"content-type");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)contentType.toString());
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            } else {
                seq = (Seq)package$.MODULE$.Seq().empty();
            }
            return seq;
        }).getOrElse(ZioHttpKorolev::$anonfun$10);
        List list = (List)request.headers().map((Function1 & Serializable)h -> Tuple2$.MODULE$.apply((Object)String.valueOf(h.name()), (Object)String.valueOf(h.value()))).$plus$plus((IterableOnce)contentTypeHeaders);
        return Request$.MODULE$.apply(method, pathAndQuery, (Seq)list, option, body, string);
    }

    private ZIO<R, Throwable, Response<R, Throwable>> handleHttpResponse(KorolevService<package.RIO> korolevServer, korolev.web.Request<Stream<package.RIO, Bytes>> korolevRequest) {
        return ((ZIO)korolevServer.http(korolevRequest)).map((Function1 & Serializable)x$1 -> {
            korolev.web.Response response = x$1;
            if (response == null) {
                throw new MatchError((Object)response);
            }
            korolev.web.Response response2 = Response$.MODULE$.unapply(response);
            Response.Status status = response2._1();
            Stream stream = (Stream)response2._2();
            Seq seq = response2._3();
            Option option = response2._4();
            Response.Status status2 = status;
            Stream stream2 = stream;
            Seq responseHeaders = seq;
            List<Header> headers = this.korolevToZioHttpHeaders((Seq<Tuple2<String, String>>)responseHeaders);
            ZStream body = korolev.zio.streams.package$.MODULE$.KorolevSreamOps(stream2).toZStream().flatMap((Function1 & Serializable)bytes -> ZStream$.MODULE$.fromIterable(() -> ZioHttpKorolev.$anonfun$12$$anonfun$1(bytes)));
            return zhttp.http.Response$.MODULE$.http(HttpStatusConverter$.MODULE$.fromKorolevStatus(status2), headers, HttpData$.MODULE$.fromStream(body));
        });
    }

    private ZIO<R, Throwable, Stream<package.RIO, Bytes>> toKorolevBody(HttpData<R, Throwable> data, ZioEffect<R, Throwable> eff) {
        ZIO zIO;
        HttpData<R, Throwable> httpData = data;
        if (HttpData.Empty$.MODULE$.equals(httpData)) {
            zIO = Task$.MODULE$.apply(() -> ZioHttpKorolev.toKorolevBody$$anonfun$1(eff));
        } else if (httpData instanceof HttpData.CompleteData) {
            Chunk chunk;
            HttpData.CompleteData completeData = HttpData.CompleteData$.MODULE$.unapply((HttpData.CompleteData)httpData);
            Chunk chunk2 = chunk = completeData._1();
            zIO = (ZIO)Stream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bytes[]{Bytes$.MODULE$.wrap(chunk2.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), (BytesLike)BytesLike.ArrayBytesLikeInstance$.MODULE$)})).mat(eff);
        } else if (httpData instanceof HttpData.StreamData) {
            ZStream zStream;
            HttpData.StreamData streamData = HttpData.StreamData$.MODULE$.unapply((HttpData.StreamData)httpData);
            ZStream zStream2 = zStream = streamData._1();
            zIO = korolev.zio.streams.package$.MODULE$.ZStreamOps(zStream2).toKorolev(eff).map((Function1 & Serializable)kStream -> kStream.map((Function1 & Serializable)bytes -> Bytes$.MODULE$.wrap(bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)), (BytesLike)BytesLike.ArrayBytesLikeInstance$.MODULE$))).useNow();
        } else {
            throw new MatchError(httpData);
        }
        return zIO;
    }

    private List<Header> korolevToZioHttpHeaders(Seq<Tuple2<String, String>> responseHeaders) {
        return responseHeaders.toList().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            String value = (String)tuple2._2();
            return Header$.MODULE$.custom(name, (CharSequence)value);
        });
    }

    private Option<String> findCookieHeader(List<Header> headers) {
        return this.findHeaderValue(headers, "cookie");
    }

    private Option<String> findHeaderValue(List<Header> headers, String name) {
        return headers.find((Function1 & Serializable)h -> {
            String string = String.valueOf(h.name()).toLowerCase();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)h -> String.valueOf(h.value()));
    }

    public final ZIO korolev$zio$http$ZioHttpKorolev$$_$app$2(StateSerializer evidence$1$1, StateDeserializer evidence$2$1, ZioEffect eff$1, KorolevService korolevServer$1, PathModule.Path rootPath$1, Request req) {
        ZIO<R, Throwable, Response<R, Throwable>> zIO;
        Request request = req;
        Request req2 = request;
        if (this.matchWebSocket(req2)) {
            zIO = this.routeWsRequest(req2, this.subPath(req2.url().path(), rootPath$1.toList().length()), (KorolevService<package.RIO>)korolevServer$1, evidence$1$1, evidence$2$1, eff$1);
        } else {
            Request req3 = request;
            zIO = this.routeHttpRequest(rootPath$1, req3, (KorolevService<package.RIO>)korolevServer$1, eff$1);
        }
        return zIO;
    }

    private static final WebSocketFrame.Text $anonfun$5$$anonfun$1(WebSocketFrame.Text f$1) {
        return f$1;
    }

    private static final WebSocketFrame.Close $anonfun$5$$anonfun$2(WebSocketFrame.Close f$2) {
        return f$2;
    }

    private static final Exception $anonfun$5$$anonfun$3(WebSocketFrame frame$1) {
        return new Exception(new StringBuilder(19).append("Invalid frame type ").append(frame$1.getClass().getName()).toString());
    }

    private static final Response buildSocket$$anonfun$1(SocketApp app$1) {
        return zhttp.http.Response$.MODULE$.socket(app$1);
    }

    private static final Seq $anonfun$10() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private static final ArraySeq.ofByte $anonfun$12$$anonfun$1(Bytes bytes$1) {
        return Predef$.MODULE$.wrapByteArray((byte[])bytes$1.as((BytesLike)BytesLike.ArrayBytesLikeInstance$.MODULE$));
    }

    private static final Stream toKorolevBody$$anonfun$1(ZioEffect eff$3) {
        return Stream$.MODULE$.empty((Effect)eff$3);
    }
}

