/*
 * Decompiled with CFR 0.152.
 */
package korolev.server.internal.services;

import java.io.Serializable;
import java.nio.ByteBuffer;
import korolev.Qsid;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Reporter;
import korolev.effect.Stream;
import korolev.effect.io.LazyBytes;
import korolev.effect.syntax$;
import korolev.internal.ApplicationInstance;
import korolev.server.internal.FormDataCodec;
import korolev.server.internal.services.CommonService;
import korolev.server.internal.services.SessionsService;
import korolev.web.FormData;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec!\u0002\u0007\u000e\u0005M)\u0002\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"A\u0001\n\u0001B\u0002B\u0003-\u0011\n\u0003\u0005M\u0001\t\u0005\t\u0015a\u0003N\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!a\u0010\u0001\t\u0003\t\t\u0005C\u0004\u0002L\u0001!I!!\u0014\u0003\u0017A{7\u000f^*feZL7-\u001a\u0006\u0003\u001d=\t\u0001b]3sm&\u001cWm\u001d\u0006\u0003!E\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003%M\taa]3sm\u0016\u0014(\"\u0001\u000b\u0002\u000f-|'o\u001c7fmV\u0011a#L\n\u0003\u0001]\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0017\u0001\u0003:fa>\u0014H/\u001a:\u0004\u0001A\u0011\u0001eI\u0007\u0002C)\u0011!eE\u0001\u0007K\u001a4Wm\u0019;\n\u0005\u0011\n#\u0001\u0003*fa>\u0014H/\u001a:\u0002\u001fM,7o]5p]N\u001cVM\u001d<jG\u0016\u00044a\n\u001e>!\u0015A\u0013fK\u001d=\u001b\u0005i\u0011B\u0001\u0016\u000e\u0005=\u0019Vm]:j_:\u001c8+\u001a:wS\u000e,\u0007C\u0001\u0017.\u0019\u0001!QA\f\u0001C\u0002=\u0012\u0011AR\u000b\u0003a]\n\"!\r\u001b\u0011\u0005a\u0011\u0014BA\u001a\u001a\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001G\u001b\n\u0005YJ\"aA!os\u0012)\u0001(\fb\u0001a\t\tq\f\u0005\u0002-u\u0011I1HAA\u0001\u0002\u0003\u0015\t\u0001\r\u0002\u0004?\u0012\n\u0004C\u0001\u0017>\t%q$!!A\u0001\u0002\u000b\u0005\u0001GA\u0002`II\nQbY8n[>t7+\u001a:wS\u000e,\u0007c\u0001\u0015BW%\u0011!)\u0004\u0002\u000e\u0007>lWn\u001c8TKJ4\u0018nY3\u0002\u001b\u0019|'/\u001c#bi\u0006\u001cu\u000eZ3d!\t)e)D\u0001\u0010\u0013\t9uBA\u0007G_JlG)\u0019;b\u0007>$WmY\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u0001\u0011KW%\u00111*\t\u0002\u0007\u000b\u001a4Wm\u0019;\u0002\u0005\u0015\u001c\u0007C\u0001(R\u001b\u0005y%B\u0001)\u001a\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003%>\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0015)\u0016LW1c)\r1v\u000b\u0017\t\u0004Q\u0001Y\u0003\"\u0002%\b\u0001\bI\u0005\"\u0002'\b\u0001\bi\u0005\"B\u000f\b\u0001\u0004y\u0002\"B\u0013\b\u0001\u0004Y\u0006g\u0001/_AB)\u0001&K\u0016^?B\u0011AF\u0018\u0003\nwi\u000b\t\u0011!A\u0003\u0002A\u0002\"\u0001\f1\u0005\u0013yR\u0016\u0011!A\u0001\u0006\u0003\u0001\u0004\"B \b\u0001\u0004\u0001\u0005\"B\"\b\u0001\u0004!\u0015\u0001\u00034pe6$\u0015\r^1\u0015\u000f\u0015$(0!\u0003\u0002$A\u0019A&\f4\u0011\u0007\u001d\f8F\u0004\u0002i_:\u0011\u0011N\u001c\b\u0003U6l\u0011a\u001b\u0006\u0003Yz\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000b\n\u0005I\u0019\u0012B\u00019\u0012\u0003\u001d\u0001\u0018mY6bO\u0016L!A]:\u0003\u0019!#H\u000f\u001d*fgB|gn]3\u000b\u0005A\f\u0002\"B;\t\u0001\u00041\u0018\u0001B9tS\u0012\u0004\"a\u001e=\u000e\u0003MI!!_\n\u0003\tE\u001b\u0018\u000e\u001a\u0005\u0006w\"\u0001\r\u0001`\u0001\u000bI\u0016\u001c8M]5qi>\u0014\bcA?\u0002\u00049\u0011ap \t\u0003UfI1!!\u0001\u001a\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA\u0004\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011A\r\t\u000f\u0005-\u0001\u00021\u0001\u0002\u000e\u00059\u0001.Z1eKJ\u001c\bCBA\b\u0003/\tiB\u0004\u0003\u0002\u0012\u0005Uab\u00016\u0002\u0014%\t!$\u0003\u0002q3%!\u0011\u0011DA\u000e\u0005\r\u0019V-\u001d\u0006\u0003af\u0001R\u0001GA\u0010yrL1!!\t\u001a\u0005\u0019!V\u000f\u001d7fe!9\u0011Q\u0005\u0005A\u0002\u0005\u001d\u0012\u0001\u00023bi\u0006\u0004R!!\u000b\u00020-j!!a\u000b\u000b\u0007\u00055\u0012%\u0001\u0002j_&!\u0011\u0011GA\u0016\u0005%a\u0015M_=CsR,7/A\u0005gS2,7/\u00138g_R9Q-a\u000e\u0002:\u0005m\u0002\"B;\n\u0001\u00041\b\"B>\n\u0001\u0004a\bbBA\u001f\u0013\u0001\u0007\u0011qE\u0001\u0005E>$\u00170\u0001\u0003gS2,G#C3\u0002D\u0005\u0015\u0013qIA%\u0011\u0015)(\u00021\u0001w\u0011\u0015Y(\u00021\u0001}\u0011\u001d\tYA\u0003a\u0001\u0003\u001bAq!!\u0010\u000b\u0001\u0004\t9#\u0001\u000bFeJ|'oU3tg&|gNT8u\r>,h\u000e\u001a\u000b\u0004y\u0006=\u0003\"B;\f\u0001\u00041\b")
public final class PostService<F> {
    private final SessionsService<F, ?, ?> sessionsService;
    private final CommonService<F> commonService;
    private final FormDataCodec formDataCodec;
    private final Effect<F> evidence$1;
    private final ExecutionContext ec;

    public F formData(Qsid qsid, String descriptor, Seq<Tuple2<String, String>> headers, LazyBytes<F> data) {
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                ApplicationInstance app = (ApplicationInstance)some.value();
                object = syntax$.MODULE$.EffectOps(data.toStrict(), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)formBytes -> syntax$.MODULE$.EffectOps(this.extractBoundary$1(headers), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)boundary -> syntax$.MODULE$.EffectOps(this.parseFormData$1((byte[])formBytes, (String)boundary), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)errorOrFormData -> syntax$.MODULE$.EffectOps(app.frontend().resolveFormData(descriptor, (Either<Throwable, FormData>)errorOrFormData), $this.evidence$1).map((Function1 & Serializable & scala.Serializable)_ -> $this.commonService.simpleOkResponse()))));
            } else if (None$.MODULE$.equals(option)) {
                object = $this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    public F filesInfo(Qsid qsid, String descriptor, LazyBytes<F> body) {
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                ApplicationInstance app = (ApplicationInstance)some.value();
                object = syntax$.MODULE$.EffectOps(body.toStrictUtf8(), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)message -> {
                    List sizes = message.isEmpty() ? List$.MODULE$.empty() : PostService.parseFilesInfo$1(message);
                    return syntax$.MODULE$.EffectOps(app.frontend().resolveFileNames(descriptor, (List<Tuple2<String, Object>>)sizes), $this.evidence$1).map((Function1 & Serializable & scala.Serializable)_ -> $this.commonService.simpleOkResponse());
                });
            } else if (None$.MODULE$.equals(option)) {
                object = $this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    public F file(Qsid qsid, String descriptor, Seq<Tuple2<String, String>> headers, LazyBytes<F> body) {
        Tuple2 tuple2 = body.chunks().handleConsumed();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object consumed = tuple2._1();
        Stream chunks = (Stream)tuple2._2();
        Tuple2 tuple22 = new Tuple2(consumed, (Object)chunks);
        Tuple2 tuple23 = tuple22;
        Object consumed2 = tuple23._1();
        Stream chunks2 = (Stream)tuple23._2();
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                ApplicationInstance app = (ApplicationInstance)some.value();
                object = syntax$.MODULE$.EffectOps(app.frontend().resolveFile(descriptor, new LazyBytes(chunks2, body.bytesLength(), $this.evidence$1)), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)_2 -> syntax$.MODULE$.EffectOps(consumed2, $this.evidence$1).map((Function1 & Serializable & scala.Serializable)_ -> $this.commonService.simpleOkResponse()));
            } else if (None$.MODULE$.equals(option)) {
                object = $this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    private String ErrorSessionNotFound(Qsid qsid) {
        return new StringBuilder(36).append("There is no app instance matched to ").append(qsid).toString();
    }

    public static final /* synthetic */ boolean $anonfun$formData$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).contains((Object)BoxesRunTime.boxToCharacter((char)'='));
    }

    private final Object extractBoundary$1(Seq headers$1) {
        Effect effect = Effect$.MODULE$.apply(this.evidence$1);
        return headers$1.collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String k = (String)A1._1();
                    String v = (String)A1._2();
                    String string = k.toLowerCase();
                    String string2 = "content-type";
                    if (!(string != null ? !string.equals(string2) : string2 != null) && v.contains("multipart/form-data")) {
                        object = v;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                Tuple2<String, String> tuple2 = x1;
                if (tuple2 == null) return false;
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                String string = k.toLowerCase();
                String string2 = "content-type";
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (!v.contains("multipart/form-data")) return false;
                return true;
            }
        }).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)((List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$1)).split(';'))).toList().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PostService.$anonfun$formData$2(x$2)))).map((Function1 & Serializable & scala.Serializable)x$3 -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$3)).split('='))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), List$.MODULE$.canBuildFrom())).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends String[], B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                Option option = Array$.MODULE$.unapplySeq(A1);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    String string = (String)((SeqLike)option.get()).apply(0);
                    String s = (String)((SeqLike)option.get()).apply(1);
                    if ("boundary".equals(string)) {
                        object = s;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(String[] x2) {
                String string;
                String[] stringArray = x2;
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                boolean bl = !option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0 && "boundary".equals(string = (String)((SeqLike)option.get()).apply(0));
                return bl;
            }
        })).fold((Function0 & Serializable & scala.Serializable)() -> Effect$.MODULE$.apply($this.evidence$1).fail((Throwable)new Exception("Content-Type should be `multipart/form-data`")), (Function1 & Serializable & scala.Serializable)value -> effect.pure(value));
    }

    private final Object parseFormData$1(byte[] formBytes, String boundary) {
        return Effect$.MODULE$.apply(this.evidence$1).fork((Function0 & Serializable & scala.Serializable)() -> Effect$.MODULE$.apply($this.evidence$1).delay((Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            try {
                left = package$.MODULE$.Right().apply((Object)$this.formDataCodec.decode(ByteBuffer.wrap(formBytes), boundary));
            }
            catch (Throwable error) {
                left = package$.MODULE$.Left().apply((Object)error);
            }
            return left;
        }), this.ec);
    }

    private static final List parseFilesInfo$1(String message) {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])message.split("\n"))).toList().map((Function1 & Serializable & scala.Serializable)entry -> {
            int slash = entry.lastIndexOf(47);
            return new Tuple2((Object)entry.substring(0, slash), (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(entry.substring(slash + 1))).toLong()));
        }, List$.MODULE$.canBuildFrom());
    }

    public PostService(Reporter reporter, SessionsService<F, ?, ?> sessionsService, CommonService<F> commonService, FormDataCodec formDataCodec, Effect<F> evidence$1, ExecutionContext ec) {
        this.sessionsService = sessionsService;
        this.commonService = commonService;
        this.formDataCodec = formDataCodec;
        this.evidence$1 = evidence$1;
        this.ec = ec;
    }
}

