/*
 * Decompiled with CFR 0.152.
 */
package korolev.server.internal.services;

import java.io.Serializable;
import korolev.Qsid;
import korolev.data.Bytes;
import korolev.data.Bytes$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Reporter;
import korolev.effect.Stream;
import korolev.effect.syntax$;
import korolev.internal.ApplicationInstance;
import korolev.internal.Frontend;
import korolev.server.internal.FormDataCodec;
import korolev.server.internal.services.CommonService;
import korolev.server.internal.services.SessionsService;
import korolev.web.FormData;
import korolev.web.Response;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;

@ScalaSignature(bytes="\u0006\u0001\u0005}c!B\u0007\u000f\u0005Q1\u0002\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001dB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A\u0011\n\u0001B\u0002B\u0003-!\n\u0003\u0005N\u0001\t\u0005\t\u0015a\u0003O\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\\\tY\u0001k\\:u'\u0016\u0014h/[2f\u0015\ty\u0001#\u0001\u0005tKJ4\u0018nY3t\u0015\t\t\"#\u0001\u0005j]R,'O\\1m\u0015\t\u0019B#\u0001\u0004tKJ4XM\u001d\u0006\u0002+\u000591n\u001c:pY\u00164XCA\f/'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\te\u0016\u0004xN\u001d;fe\u000e\u0001\u0001CA\u0011%\u001b\u0005\u0011#BA\u0012\u0015\u0003\u0019)gMZ3di&\u0011QE\t\u0002\t%\u0016\u0004xN\u001d;fe\u0006y1/Z:tS>t7oU3sm&\u001cW\rM\u0002)wy\u0002R!\u000b\u0016-uuj\u0011AD\u0005\u0003W9\u0011qbU3tg&|gn]*feZL7-\u001a\t\u0003[9b\u0001\u0001B\u00030\u0001\t\u0007\u0001GA\u0001G+\t\t\u0004(\u0005\u00023kA\u0011\u0011dM\u0005\u0003ii\u0011qAT8uQ&tw\r\u0005\u0002\u001am%\u0011qG\u0007\u0002\u0004\u0003:LH!B\u001d/\u0005\u0004\t$!A0\u0011\u00055ZD!\u0003\u001f\u0003\u0003\u0003\u0005\tQ!\u00012\u0005\ryF%\r\t\u0003[y\"\u0011b\u0010\u0002\u0002\u0002\u0003\u0005)\u0011A\u0019\u0003\u0007}##'A\u0007d_6lwN\\*feZL7-\u001a\t\u0004S\tc\u0013BA\"\u000f\u00055\u0019u.\\7p]N+'O^5dK\u0006iam\u001c:n\t\u0006$\u0018mQ8eK\u000e\u0004\"AR$\u000e\u0003AI!\u0001\u0013\t\u0003\u001b\u0019{'/\u001c#bi\u0006\u001cu\u000eZ3d\u0003))g/\u001b3f]\u000e,G%\r\t\u0004C-c\u0013B\u0001'#\u0005\u0019)eMZ3di\u0006\u0011Qm\u0019\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#j\t!bY8oGV\u0014(/\u001a8u\u0013\t\u0019\u0006K\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"RA\u0016.\\E\u000e$2a\u0016-Z!\rI\u0003\u0001\f\u0005\u0006\u0013\u001e\u0001\u001dA\u0013\u0005\u0006\u001b\u001e\u0001\u001dA\u0014\u0005\u0006=\u001d\u0001\r\u0001\t\u0005\u0006M\u001d\u0001\r\u0001\u0018\u0019\u0004;~\u000b\u0007#B\u0015+Yy\u0003\u0007CA\u0017`\t%a4,!A\u0001\u0002\u000b\u0005\u0011\u0007\u0005\u0002.C\u0012IqhWA\u0001\u0002\u0003\u0015\t!\r\u0005\u0006\u0001\u001e\u0001\r!\u0011\u0005\u0006\t\u001e\u0001\r!R\u0001\tM>\u0014X\u000eR1uCR9a-^>\u0002\f\u0005\u0015\u0002cA\u0017/OB\u0019\u0001N\u001d\u0017\u000f\u0005%\u0004hB\u00016p\u001d\tYg.D\u0001m\u0015\tiw$\u0001\u0004=e>|GOP\u0005\u0002+%\u00111\u0003F\u0005\u0003cJ\tq\u0001]1dW\u0006<W-\u0003\u0002ti\na\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK*\u0011\u0011O\u0005\u0005\u0006m\"\u0001\ra^\u0001\u0005cNLG\r\u0005\u0002ys6\tA#\u0003\u0002{)\t!\u0011k]5e\u0011\u0015a\b\u00021\u0001~\u0003)!Wm]2sSB$xN\u001d\t\u0004}\u0006\u0015abA@\u0002\u0002A\u00111NG\u0005\u0004\u0003\u0007Q\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\b\u0005%!AB*ue&twMC\u0002\u0002\u0004iAq!!\u0004\t\u0001\u0004\ty!A\u0004iK\u0006$WM]:\u0011\r\u0005E\u0011\u0011DA\u0010\u001d\u0011\t\u0019\"a\u0006\u000f\u0007-\f)\"C\u0001\u001c\u0013\t\t($\u0003\u0003\u0002\u001c\u0005u!aA*fc*\u0011\u0011O\u0007\t\u00063\u0005\u0005R0`\u0005\u0004\u0003GQ\"A\u0002+va2,'\u0007C\u0004\u0002(!\u0001\r!!\u000b\u0002\t\u0011\fG/\u0019\t\u0007C\u0005-B&a\f\n\u0007\u00055\"E\u0001\u0004TiJ,\u0017-\u001c\t\u0005\u0003c\t)$\u0004\u0002\u00024)\u0019\u0011q\u0005\u000b\n\t\u0005]\u00121\u0007\u0002\u0006\u0005f$Xm]\u0001\nM&dWm]%oM>$rAZA\u001f\u0003\u007f\t\t\u0005C\u0003w\u0013\u0001\u0007q\u000fC\u0003}\u0013\u0001\u0007Q\u0010C\u0004\u0002D%\u0001\r!!\u000b\u0002\t\t|G-_\u0001\rI><h\u000e\\8bI\u001aKG.\u001a\u000b\u0006M\u0006%\u00131\n\u0005\u0006m*\u0001\ra\u001e\u0005\u0006y*\u0001\r!`\u0001\u000bkBdw.\u00193GS2,G#\u00034\u0002R\u0005M\u0013QKA,\u0011\u001518\u00021\u0001x\u0011\u0015a8\u00021\u0001~\u0011\u001d\tia\u0003a\u0001\u0003\u001fAq!a\u0011\f\u0001\u0004\tI#\u0001\u000bFeJ|'oU3tg&|gNT8u\r>,h\u000e\u001a\u000b\u0004{\u0006u\u0003\"\u0002<\r\u0001\u00049\b")
public final class PostService<F> {
    private final SessionsService<F, ?, ?> sessionsService;
    private final CommonService<F> commonService;
    private final FormDataCodec formDataCodec;
    private final Effect<F> evidence$1;
    private final ExecutionContext ec;

    public F formData(Qsid qsid, String descriptor, Seq<Tuple2<String, String>> headers, Stream<F, Bytes> data) {
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                ApplicationInstance app = (ApplicationInstance)some.value();
                object = syntax$.MODULE$.EffectOps(data.fold((Object)Bytes$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> x$5.$plus$plus(x$6)), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)formBytes -> syntax$.MODULE$.EffectOps(this.extractBoundary$1(headers), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)boundary -> syntax$.MODULE$.EffectOps(this.parseFormData$1((Bytes)formBytes, (String)boundary), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)errorOrFormData -> syntax$.MODULE$.EffectOps(app.frontend().resolveFormData(descriptor, (Either<Throwable, FormData>)errorOrFormData), $this.evidence$1).map((Function1 & Serializable & scala.Serializable)_ -> $this.commonService.simpleOkResponse()))));
            } else if (None$.MODULE$.equals(option)) {
                object = $this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    public F filesInfo(Qsid qsid, String descriptor, Stream<F, Bytes> body) {
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                ApplicationInstance app = (ApplicationInstance)some.value();
                object = syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(body.fold((Object)Bytes$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> x$7.$plus$plus(x$8)), $this.evidence$1).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.asUtf8String()), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)message -> {
                    List sizes = message.isEmpty() ? List$.MODULE$.empty() : PostService.parseFilesInfo$1(message);
                    return syntax$.MODULE$.EffectOps(app.frontend().resolveFileNames(descriptor, (List<Tuple2<String, Object>>)sizes), $this.evidence$1).map((Function1 & Serializable & scala.Serializable)_ -> $this.commonService.simpleOkResponse());
                });
            } else if (None$.MODULE$.equals(option)) {
                object = $this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    public F downloadFile(Qsid qsid, String descriptor) {
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                ApplicationInstance app = (ApplicationInstance)some.value();
                object = syntax$.MODULE$.EffectOps(app.frontend().resolveFileDownload(descriptor), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Object object;
                    Some some;
                    Frontend.DownloadFileMeta downloadFileMeta;
                    Option option = x0$2;
                    if (option instanceof Some && (downloadFileMeta = (Frontend.DownloadFileMeta)(some = (Some)option).value()) != null) {
                        Stream stream = downloadFileMeta.stream();
                        Option<Object> maybeLength = downloadFileMeta.size();
                        String mimeType = downloadFileMeta.mimeType();
                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Content-Type"), (Object)mimeType);
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Accept-Ranges"), (Object)"none");
                        List headers = Nil$.MODULE$.$colon$colon((Object)tuple22).$colon$colon((Object)tuple2);
                        Response response = new Response(Response.Status$.MODULE$.Ok(), stream, (Seq)headers, maybeLength);
                        object = Effect$.MODULE$.apply($this.evidence$1).pure((Object)response);
                    } else if (None$.MODULE$.equals(option)) {
                        object = $this.commonService.notFoundResponseF();
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return object;
                });
            } else if (None$.MODULE$.equals(option)) {
                object = $this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    public F uploadFile(Qsid qsid, String descriptor, Seq<Tuple2<String, String>> headers, Stream<F, Bytes> body) {
        Tuple2 tuple2 = body.handleConsumed();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object consumed = tuple2._1();
        Stream chunks = (Stream)tuple2._2();
        Tuple2 tuple22 = new Tuple2(consumed, (Object)chunks);
        Tuple2 tuple23 = tuple22;
        Object consumed2 = tuple23._1();
        Stream chunks2 = (Stream)tuple23._2();
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                ApplicationInstance app = (ApplicationInstance)some.value();
                object = syntax$.MODULE$.EffectOps(app.frontend().resolveFile(descriptor, chunks2), $this.evidence$1).flatMap((Function1 & Serializable & scala.Serializable)_2 -> syntax$.MODULE$.EffectOps(consumed2, $this.evidence$1).map((Function1 & Serializable & scala.Serializable)_ -> $this.commonService.simpleOkResponse()));
            } else if (None$.MODULE$.equals(option)) {
                object = $this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    private String ErrorSessionNotFound(Qsid qsid) {
        return new StringBuilder(36).append("There is no app instance matched to ").append(qsid).toString();
    }

    public static final /* synthetic */ boolean $anonfun$formData$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).contains((Object)BoxesRunTime.boxToCharacter((char)'='));
    }

    private final Object extractBoundary$1(Seq headers$1) {
        Effect effect = Effect$.MODULE$.apply(this.evidence$1);
        return headers$1.collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String k = (String)A1._1();
                    String v = (String)A1._2();
                    String string = k.toLowerCase();
                    String string2 = "content-type";
                    if (!(string != null ? !string.equals(string2) : string2 != null) && v.contains("multipart/form-data")) {
                        object = v;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                Tuple2<String, String> tuple2 = x1;
                if (tuple2 == null) return false;
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                String string = k.toLowerCase();
                String string2 = "content-type";
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (!v.contains("multipart/form-data")) return false;
                return true;
            }
        }).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)((List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$1)).split(';'))).toList().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PostService.$anonfun$formData$2(x$2)))).map((Function1 & Serializable & scala.Serializable)x$3 -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$3)).split('='))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), List$.MODULE$.canBuildFrom())).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends String[], B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                Option option = Array$.MODULE$.unapplySeq(A1);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    String string = (String)((SeqLike)option.get()).apply(0);
                    String s = (String)((SeqLike)option.get()).apply(1);
                    if ("boundary".equals(string)) {
                        object = s;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(String[] x2) {
                String string;
                String[] stringArray = x2;
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                boolean bl = !option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0 && "boundary".equals(string = (String)((SeqLike)option.get()).apply(0));
                return bl;
            }
        })).fold((Function0 & Serializable & scala.Serializable)() -> Effect$.MODULE$.apply($this.evidence$1).fail((Throwable)new Exception("Content-Type should be `multipart/form-data`")), (Function1 & Serializable & scala.Serializable)value -> effect.pure(value));
    }

    private final Object parseFormData$1(Bytes formBytes, String boundary) {
        return Effect$.MODULE$.apply(this.evidence$1).fork((Function0 & Serializable & scala.Serializable)() -> Effect$.MODULE$.apply($this.evidence$1).delay((Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            try {
                left = package$.MODULE$.Right().apply((Object)$this.formDataCodec.decode(formBytes.asBuffer(), boundary));
            }
            catch (Throwable error) {
                left = package$.MODULE$.Left().apply((Object)error);
            }
            return left;
        }), this.ec);
    }

    private static final List parseFilesInfo$1(String message) {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])message.split("\n"))).toList().map((Function1 & Serializable & scala.Serializable)entry -> {
            int slash = entry.lastIndexOf(47);
            return new Tuple2((Object)entry.substring(0, slash), (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(entry.substring(slash + 1))).toLong()));
        }, List$.MODULE$.canBuildFrom());
    }

    public PostService(Reporter reporter, SessionsService<F, ?, ?> sessionsService, CommonService<F> commonService, FormDataCodec formDataCodec, Effect<F> evidence$1, ExecutionContext ec) {
        this.sessionsService = sessionsService;
        this.commonService = commonService;
        this.formDataCodec = formDataCodec;
        this.evidence$1 = evidence$1;
        this.ec = ec;
    }
}

