/*
 * Decompiled with CFR 0.152.
 */
package korolev.server.internal.services;

import java.io.Serializable;
import korolev.Qsid;
import korolev.data.Bytes;
import korolev.data.Bytes$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Reporter;
import korolev.effect.Stream;
import korolev.effect.syntax$;
import korolev.internal.ApplicationInstance;
import korolev.server.internal.FormDataCodec;
import korolev.server.internal.services.CommonService;
import korolev.server.internal.services.SessionsService;
import korolev.web.FormData;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;

public final class PostService<F> {
    private final SessionsService<F, ?, ?> sessionsService;
    private final CommonService<F> commonService;
    private final FormDataCodec formDataCodec;
    private final Effect<F> evidence$1;
    private final ExecutionContext ec;

    public <F> PostService(Reporter reporter, SessionsService<F, ?, ?> sessionsService, CommonService<F> commonService, FormDataCodec formDataCodec, Effect<F> evidence$1, ExecutionContext ec) {
        this.sessionsService = sessionsService;
        this.commonService = commonService;
        this.formDataCodec = formDataCodec;
        this.evidence$1 = evidence$1;
        this.ec = ec;
    }

    public F formData(Qsid qsid, String descriptor, Seq<Tuple2<String, String>> headers, Stream<F, Bytes> data) {
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Option option = x$1;
            if (option instanceof Some) {
                ApplicationInstance app = (ApplicationInstance)((Some)option).value();
                object = syntax$.MODULE$.EffectOps(data.fold((Object)Bytes$.MODULE$.empty(), (Function2 & Serializable)(_$6, _$7) -> _$6.$plus$plus(_$7)), this.evidence$1).flatMap((Function1 & Serializable)formBytes -> syntax$.MODULE$.EffectOps(this.extractBoundary$7(headers), this.evidence$1).flatMap((Function1 & Serializable)boundary -> syntax$.MODULE$.EffectOps(this.parseFormData$3((Bytes)formBytes, (String)boundary), this.evidence$1).flatMap((Function1 & Serializable)errorOrFormData -> syntax$.MODULE$.EffectOps(app.frontend().resolveFormData(descriptor, (Either<Throwable, FormData>)errorOrFormData), this.evidence$1).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                    return this.commonService.simpleOkResponse();
                }))));
            } else if (None$.MODULE$.equals(option)) {
                object = this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    public F filesInfo(Qsid qsid, String descriptor, Stream<F, Bytes> body) {
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Option option = x$1;
            if (option instanceof Some) {
                ApplicationInstance app = (ApplicationInstance)((Some)option).value();
                object = syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(body.fold((Object)Bytes$.MODULE$.empty(), (Function2 & Serializable)(_$8, _$9) -> _$8.$plus$plus(_$9)), this.evidence$1).map((Function1 & Serializable)_$10 -> _$10.asUtf8String()), this.evidence$1).map((Function1 & Serializable)message -> {
                    List sizes = message.isEmpty() ? package$.MODULE$.List().empty() : PostService.parseFilesInfo$2(message);
                    return Tuple2$.MODULE$.apply(message, (Object)sizes);
                }), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                    Tuple2 tuple2 = x$12;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String message = (String)tuple2._1();
                    List sizes = (List)tuple2._2();
                    return syntax$.MODULE$.EffectOps(app.frontend().resolveFileNames(descriptor, (List<Tuple2<String, Object>>)sizes), this.evidence$1).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = x$1;
                        return this.commonService.simpleOkResponse();
                    });
                });
            } else if (None$.MODULE$.equals(option)) {
                object = this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    public F file(Qsid qsid, String descriptor, Seq<Tuple2<String, String>> headers, Stream<F, Bytes> body) {
        Tuple2 tuple2 = body.handleConsumed();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object consumed = tuple2._1();
        Stream chunks = (Stream)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(consumed, (Object)chunks);
        Object consumed2 = tuple22._1();
        Stream chunks2 = (Stream)tuple22._2();
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Option option = x$1;
            if (option instanceof Some) {
                ApplicationInstance app = (ApplicationInstance)((Some)option).value();
                object = syntax$.MODULE$.EffectOps(app.frontend().resolveFile(descriptor, chunks2), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = x$12;
                    return syntax$.MODULE$.EffectOps(consumed2, this.evidence$1).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = x$1;
                        return this.commonService.simpleOkResponse();
                    });
                });
            } else if (None$.MODULE$.equals(option)) {
                object = this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    private String ErrorSessionNotFound(Qsid qsid) {
        return "There is no app instance matched to " + qsid;
    }

    private final Object extractBoundary$5$$anonfun$5() {
        return Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new Exception("Content-Type should be `multipart/form-data`"));
    }

    private final Object extractBoundary$7(Seq headers$1) {
        Effect effect = Effect$.MODULE$.apply(this.evidence$1);
        return headers$1.collectFirst((PartialFunction)new Serializable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 == null) return false;
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                String string = k.toLowerCase();
                String string2 = "content-type";
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (!v.contains("multipart/form-data")) return false;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Object object;
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = k.toLowerCase();
                    String string2 = "content-type";
                    if (!(string != null ? !string.equals(string2) : string2 != null) && v.contains("multipart/form-data")) {
                        object = v;
                        return object;
                    }
                }
                object = function1.apply((Object)x);
                return object;
            }
        }).flatMap((Function1 & Serializable)_$2 -> Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(_$2), ';')).toList().filter((Function1 & Serializable)_$3 -> StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(_$3), '=')).map((Function1 & Serializable)_$4 -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(_$4), '='));
            return (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$5 -> _$5.trim(), ClassTag$.MODULE$.apply(String.class));
        }).collectFirst((PartialFunction)new Serializable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(String[] x) {
                String[] stringArray = x;
                if (stringArray == null) return false;
                Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) != 0) return false;
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                if (!"boundary".equals(string)) return false;
                String s = string2;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(String[] x, Function1 function1) {
                Object object;
                Object object2;
                String[] stringArray = x;
                if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
                    String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 0);
                    String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 1);
                    if ("boundary".equals(string)) {
                        String s = string2;
                        object = s;
                        return object;
                    }
                }
                object = function1.apply((Object)x);
                return object;
            }
        })).fold(this::extractBoundary$5$$anonfun$5, (Function1 & Serializable)value -> effect.pure(value));
    }

    private final Either liftedTree1$1(Bytes formBytes$3, String boundary$3) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)this.formDataCodec.decode(formBytes$3.asBuffer(), boundary$3));
        }
        catch (Throwable error) {
            left = package$.MODULE$.Left().apply((Object)error);
        }
        return left;
    }

    private final Either parseFormData$1$$anonfun$1$$anonfun$1(Bytes formBytes$2, String boundary$2) {
        return this.liftedTree1$1(formBytes$2, boundary$2);
    }

    private final Object parseFormData$2$$anonfun$2(Bytes formBytes$1, String boundary$1) {
        return Effect$.MODULE$.apply(this.evidence$1).delay(() -> this.parseFormData$1$$anonfun$1$$anonfun$1(formBytes$1, boundary$1));
    }

    private final Object parseFormData$3(Bytes formBytes, String boundary) {
        return Effect$.MODULE$.apply(this.evidence$1).fork(() -> this.parseFormData$2$$anonfun$2(formBytes, boundary), this.ec);
    }

    private static final List parseFilesInfo$2(String message) {
        return Predef$.MODULE$.wrapRefArray((Object[])message.split("\n")).toList().map((Function1 & Serializable)entry -> {
            int slash = entry.lastIndexOf(47);
            return Tuple2$.MODULE$.apply((Object)entry.substring(0, slash), (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(entry.substring(slash + 1)))));
        });
    }
}

