/*
 * Decompiled with CFR 0.152.
 */
package korolev.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import korolev.Component;
import korolev.Context;
import korolev.Qsid;
import korolev.Router;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Hub;
import korolev.effect.Hub$;
import korolev.effect.Queue;
import korolev.effect.Queue$;
import korolev.effect.Reporter;
import korolev.effect.Scheduler;
import korolev.effect.Stream;
import korolev.effect.syntax$;
import korolev.internal.ComponentInstance;
import korolev.internal.DevMode;
import korolev.internal.EventRegistry;
import korolev.internal.Frontend;
import korolev.state.StateDeserializer;
import korolev.state.StateManager;
import korolev.state.StateSerializer;
import korolev.web.Path;
import korolev.web.PathAndQuery;
import levsha.Document;
import levsha.Id;
import levsha.Id$;
import levsha.StatefulRenderContext;
import levsha.XmlNs$;
import levsha.events;
import levsha.events$;
import levsha.impl.DiffRenderContext;
import levsha.impl.DiffRenderContext$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

public final class ApplicationInstance<F, S, M> {
    private final Frontend frontend;
    private final StateManager<F> stateManager;
    private final S initialState;
    public final Function1<S, Document.Node<Context.Binding<F, S, M>>> korolev$internal$ApplicationInstance$$render;
    private final Path rootPath;
    private final Router<F, S> router;
    public final Reporter korolev$internal$ApplicationInstance$$reporter;
    public final PartialFunction<Throwable, Function1<S, S>> korolev$internal$ApplicationInstance$$recovery;
    private final Effect<F> evidence$1;
    private final StateSerializer<S> evidence$2;
    private final StateDeserializer<S> evidence$3;
    private final DevMode.ForRenderContext devMode;
    private final AtomicInteger currentRenderNum;
    private final Queue<F, Tuple3<Id, Object, Option<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>> stateQueue;
    private final Queue<F, M> messagesQueue;
    private final DiffRenderContext<Context.Binding<F, S, M>> renderContext;
    private final ComponentInstance topLevelComponentInstance;
    private final Stream<F, Tuple3<Id, Object, Option<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>> internalStateStream;
    private final Object stateStream;
    private final Stream messagesStream;

    public ApplicationInstance(Qsid sessionId, Frontend<F> frontend, StateManager<F> stateManager, S initialState, Function1<S, Document.Node<Context.Binding<F, S, M>>> render, Path rootPath, Router<F, S> router, Function2<StatefulRenderContext<Context.Binding<F, S, M>>, Function2<StatefulRenderContext<Context.Binding<F, S, M>>, Context.Binding<F, S, M>, BoxedUnit>, StatefulRenderContext<Context.Binding<F, S, M>>> createMiscProxy, Scheduler<F> scheduler, Reporter reporter, PartialFunction<Throwable, Function1<S, S>> recovery, Effect<F> evidence$1, StateSerializer<S> evidence$2, StateDeserializer<S> evidence$3) {
        this.frontend = frontend;
        this.stateManager = stateManager;
        this.initialState = initialState;
        this.korolev$internal$ApplicationInstance$$render = render;
        this.rootPath = rootPath;
        this.router = router;
        this.korolev$internal$ApplicationInstance$$reporter = reporter;
        this.korolev$internal$ApplicationInstance$$recovery = recovery;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.evidence$3 = evidence$3;
        this.devMode = new DevMode.ForRenderContext(sessionId.toString());
        this.currentRenderNum = new AtomicInteger(0);
        this.stateQueue = Queue$.MODULE$.apply(Queue$.MODULE$.apply$default$1(), evidence$1);
        Hub stateHub = Hub$.MODULE$.apply(this.stateQueue.stream(), Hub$.MODULE$.apply$default$2(), evidence$1);
        this.messagesQueue = Queue$.MODULE$.apply(Queue$.MODULE$.apply$default$1(), evidence$1);
        Option<ByteBuffer> option = this.devMode.loadRenderContext();
        Function2 function2 = DiffRenderContext$.MODULE$.apply$default$1();
        int n = DiffRenderContext$.MODULE$.apply$default$2();
        this.renderContext = DiffRenderContext$.MODULE$.apply(function2, n, option);
        EventRegistry<F> eventRegistry = new EventRegistry<F>(frontend, evidence$1, reporter.Implicit());
        Component component = new Component<F, S, Object, M>(initialState, this){
            private final ApplicationInstance $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(ApplicationInstance.korolev$internal$ApplicationInstance$$_$_$$anon$superArg$1$1(initialState$2), "top-level");
            }

            public Document.Node render(Object parameters, Object state) {
                Document.Node node;
                try {
                    node = (Document.Node)this.$outer.korolev$internal$ApplicationInstance$$render.apply(state);
                }
                catch (MatchError e) {
                    node = Document.Node$.MODULE$.apply((Function1)(JProcedure1 & Serializable)rc -> {
                        this.$outer.korolev$internal$ApplicationInstance$$reporter.error(new StringBuilder(26).append("Render is not defined for ").append(state).toString());
                        rc.openNode(XmlNs$.MODULE$.html(), "html");
                        rc.openNode(XmlNs$.MODULE$.html(), "body");
                        rc.addTextNode("Render is not defined for the state. ");
                        rc.addTextNode(e.getMessage());
                        rc.closeNode("body");
                        rc.closeNode("html");
                    });
                }
                return node;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{render$$anonfun$1(java.lang.Object scala.MatchError levsha.RenderContext )}, serializedLambda);
            }
        };
        ComponentInstance componentInstance = new ComponentInstance(Id$.MODULE$.TopLevel(), sessionId, frontend, eventRegistry, stateManager, (Function0<Object>)(Function0 & Serializable)() -> this.currentRenderNum.get(), component, this.stateQueue, createMiscProxy, scheduler, reporter, (PartialFunction<Throwable, Object>)new Serializable(this){
            private final ApplicationInstance $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                boolean bl;
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Object object;
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    object = this.$outer.topLevelComponentInstance().browserAccess().transition((Function1)this.$outer.korolev$internal$ApplicationInstance$$recovery.apply((Object)ex));
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        }, evidence$1, evidence$2, evidence$3, evidence$2, evidence$3);
        componentInstance.setEventsSubscription((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)this.messagesQueue.offerUnsafe(item)));
        this.topLevelComponentInstance = componentInstance;
        this.internalStateStream = stateHub.newStreamUnsafe();
        this.stateStream = syntax$.MODULE$.EffectOps(stateHub.newStream(), evidence$1).map((Function1 & Serializable)stream -> stream.map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Id id = (Id)tuple3._1();
            Object state = tuple3._2();
            return Tuple2$.MODULE$.apply((Object)id, state);
        }));
        this.messagesStream = this.messagesQueue.stream();
    }

    public Frontend<F> frontend() {
        return this.frontend;
    }

    public ComponentInstance<F, S, M, S, Object, M> topLevelComponentInstance() {
        return this.topLevelComponentInstance;
    }

    private F saveRenderContextIfNecessary() {
        return (F)(this.devMode.isActive() ? Effect$.MODULE$.apply(this.evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)this::saveRenderContextIfNecessary$$anonfun$1)) : Effect$.MODULE$.apply(this.evidence$1).unit());
    }

    private F nextRenderNum() {
        return (F)Effect$.MODULE$.apply(this.evidence$1).delay(this::nextRenderNum$$anonfun$1);
    }

    private F onState(Option<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> maybeRenderCallback) {
        return (F)syntax$.MODULE$.EffectOps(this.stateManager.snapshot(), this.evidence$1).flatMap((Function1 & Serializable)snapshot -> syntax$.MODULE$.EffectOps(((Option)this.router.fromState().lift().apply(snapshot.apply(Id$.MODULE$.TopLevel(), this.evidence$3).getOrElse(this::onState$$anonfun$1$$anonfun$1))).fold(this::onState$$anonfun$1$$anonfun$2, (Function1 & Serializable)uri -> this.frontend().changePageUrl(this.rootPath.$plus$plus(uri))), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.onState$$anonfun$1$$anonfun$4$$anonfun$1(snapshot))), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return syntax$.MODULE$.EffectOps(this.frontend().performDomChanges((Function1<DiffRenderContext.ChangesPerformer, BoxedUnit>)(JProcedure1 & Serializable)performer -> this.renderContext.diff(performer)), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = x$12;
                    return syntax$.MODULE$.EffectOps(this.saveRenderContextIfNecessary(), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = x$1;
                        return syntax$.MODULE$.EffectOps(this.nextRenderNum(), this.evidence$1).flatMap((Function1 & Serializable)renderNum -> this.onState$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(maybeRenderCallback, BoxesRunTime.unboxToInt((Object)renderNum)));
                    });
                });
            });
        }));
    }

    private F onHistory(PathAndQuery pq) {
        return (F)syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(this.stateManager.read(Id$.MODULE$.TopLevel(), this.evidence$3), this.evidence$1).flatMap((Function1 & Serializable)maybeTopLevelState -> ((Option)this.router.toState().lift().apply((Object)pq)).fold(this::onHistory$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$3 -> syntax$.MODULE$.EffectOps(_$3.apply(maybeTopLevelState.getOrElse(this::onHistory$$anonfun$1$$anonfun$2$$anonfun$1)), this.evidence$1).map((Function1 & Serializable)_$4 -> Some$.MODULE$.apply(_$4)))), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Option option = x$1;
            if (option instanceof Some) {
                Object newState = ((Some)option).value();
                object = syntax$.MODULE$.EffectOps(this.stateManager.write(Id$.MODULE$.TopLevel(), newState, this.evidence$2), this.evidence$1).after(() -> this.onHistory$$anonfun$2$$anonfun$1(newState));
            } else if (None$.MODULE$.equals(option)) {
                object = Effect$.MODULE$.apply(this.evidence$1).unit();
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    private F onEvent(Frontend.DomEventMessage dem) {
        return (F)Effect$.MODULE$.apply(this.evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.onEvent$$anonfun$1(dem)));
    }

    public F stateStream() {
        return (F)this.stateStream;
    }

    public Stream<F, M> messagesStream() {
        return this.messagesStream;
    }

    public F destroy() {
        return (F)syntax$.MODULE$.EffectOps(this.stateQueue.close(), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return syntax$.MODULE$.EffectOps(this.messagesQueue.close(), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = x$12;
                return syntax$.MODULE$.EffectOps(this.topLevelComponentInstance().destroy(), this.evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                });
            });
        });
    }

    public F initialize(ExecutionContext ec) {
        return (F)(this.devMode.saved() ? syntax$.MODULE$.EffectOps(this.frontend().setRenderNum(0), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return syntax$.MODULE$.EffectOps(this.reloadCssIfNecessary$1(), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = x$12;
                return syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)this::initialize$$anonfun$1$$anonfun$1$$anonfun$1)), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                    return syntax$.MODULE$.EffectOps(this.render$1((Function1 & Serializable)f -> this.frontend().performDomChanges((Function1<DiffRenderContext.ChangesPerformer, BoxedUnit>)f)), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = x$12;
                        return syntax$.MODULE$.EffectOps(this.topLevelComponentInstance().initialize(ec), this.evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            Effect.Fiber fiber = x$1;
                        });
                    });
                });
            });
        }) : syntax$.MODULE$.EffectOps(this.frontend().setRenderNum(0), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return syntax$.MODULE$.EffectOps(this.reloadCssIfNecessary$1(), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return syntax$.MODULE$.EffectOps(this.render$1((Function1 & Serializable)f -> Effect$.MODULE$.apply(this.evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> ApplicationInstance.initialize$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(f)))), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = x$12;
                    return syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(this.frontend().browserHistoryMessages().foreach((Function1 & Serializable)pq -> this.onHistory((PathAndQuery)pq)), this.evidence$1).start(ec), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                        Effect.Fiber fiber = x$1;
                        return syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(this.frontend().domEventMessages().foreach((Function1 & Serializable)dem -> this.onEvent((Frontend.DomEventMessage)dem)), this.evidence$1).start(ec), this.evidence$1).flatMap((Function1 & Serializable)x$13 -> {
                            Effect.Fiber fiber = x$13;
                            return syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(this.internalStateStream.foreach((Function1 & Serializable)x$1 -> {
                                Tuple3 tuple3 = x$1;
                                if (tuple3 == null) {
                                    throw new MatchError((Object)tuple3);
                                }
                                Option cb = (Option)tuple3._3();
                                return this.onState((Option<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>)cb);
                            }), this.evidence$1).start(ec), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                                Effect.Fiber fiber = x$12;
                                return syntax$.MODULE$.EffectOps(this.topLevelComponentInstance().initialize(ec), this.evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                    Effect.Fiber fiber = x$1;
                                });
                            });
                        });
                    });
                });
            });
        }));
    }

    public static final Object korolev$internal$ApplicationInstance$$_$_$$anon$superArg$1$1(Object initialState$1) {
        return initialState$1;
    }

    private final void saveRenderContextIfNecessary$$anonfun$1() {
        this.devMode.saveRenderContext(this.renderContext);
    }

    private final int nextRenderNum$$anonfun$1() {
        return this.currentRenderNum.incrementAndGet();
    }

    private final Object onState$$anonfun$1$$anonfun$1() {
        return this.initialState;
    }

    private final Object onState$$anonfun$1$$anonfun$2() {
        return Effect$.MODULE$.apply(this.evidence$1).unit();
    }

    private final void onState$$anonfun$1$$anonfun$4$$anonfun$1(StateManager.Snapshot snapshot$2) {
        this.renderContext.swap();
        this.topLevelComponentInstance().applyRenderContext(BoxedUnit.UNIT, (StatefulRenderContext<Context.Binding<F, S, M>>)this.renderContext, snapshot$2);
    }

    private final void onState$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1() {
        this.topLevelComponentInstance().dropObsoleteMisc();
    }

    private final /* synthetic */ Object onState$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(Option maybeRenderCallback$7, int renderNum) {
        return syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)this::onState$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1)), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(this.frontend().setRenderNum(renderNum), this.evidence$1).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                BoxedUnit $1$ = boxedUnit2 = x$1;
                maybeRenderCallback$7.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.apply((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)));
                BoxedUnit $2$ = boxedUnit = BoxedUnit.UNIT;
                BoxedUnit $2$2 = BoxedUnit.UNIT;
                return Tuple2$.MODULE$.apply((Object)$1$, (Object)$2$2);
            }), this.evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
            });
        });
    }

    private static final Option onHistory$$anonfun$1$$anonfun$1$$anonfun$1() {
        return Option$.MODULE$.empty();
    }

    private final Object onHistory$$anonfun$1$$anonfun$1() {
        return Effect$.MODULE$.apply(this.evidence$1).delay(ApplicationInstance::onHistory$$anonfun$1$$anonfun$1$$anonfun$1);
    }

    private final Object onHistory$$anonfun$1$$anonfun$2$$anonfun$1() {
        return this.initialState;
    }

    private final Object onHistory$$anonfun$2$$anonfun$1(Object newState$1) {
        return this.stateQueue.enqueue((Object)Tuple3$.MODULE$.apply((Object)Id$.MODULE$.TopLevel(), newState$1, (Object)None$.MODULE$));
    }

    private final void onEvent$$anonfun$1(Frontend.DomEventMessage dem$1) {
        if (this.currentRenderNum.get() == dem$1.renderNum()) {
            events$.MODULE$.calculateEventPropagation(dem$1.target(), dem$1.eventType()).forall((Function1 & Serializable)eventId -> this.topLevelComponentInstance().applyEvent((events.EventId)eventId));
        }
    }

    private final Object reloadCssIfNecessary$1() {
        return this.devMode.isActive() ? this.frontend().reloadCss() : Effect$.MODULE$.apply(this.evidence$1).unit();
    }

    private final void render$1$$anonfun$1$$anonfun$1(StateManager.Snapshot snapshot$3) {
        this.topLevelComponentInstance().applyRenderContext(BoxedUnit.UNIT, (StatefulRenderContext<Context.Binding<F, S, M>>)this.renderContext, snapshot$3);
    }

    private final Object render$1(Function1 performDiff) {
        return syntax$.MODULE$.EffectOps(this.stateManager.snapshot(), this.evidence$1).flatMap((Function1 & Serializable)snapshot -> syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.render$1$$anonfun$1$$anonfun$1(snapshot))), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return syntax$.MODULE$.EffectOps(performDiff.apply((JProcedure1 & Serializable)performer -> this.renderContext.diff(performer)), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = x$12;
                return syntax$.MODULE$.EffectOps(this.saveRenderContextIfNecessary(), this.evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                });
            });
        }));
    }

    private final void initialize$$anonfun$1$$anonfun$1$$anonfun$1() {
        this.renderContext.swap();
    }

    private static final void initialize$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Function1 f$1) {
        f$1.apply((Object)DiffRenderContext.DummyChangesPerformer$.MODULE$);
    }
}

