/*
 * Decompiled with CFR 0.152.
 */
package korolev.server.internal.services;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import korolev.Context;
import korolev.Qsid;
import korolev.Qsid$;
import korolev.effect.AsyncTable;
import korolev.effect.AsyncTable$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Scheduler;
import korolev.effect.Stream;
import korolev.effect.syntax$;
import korolev.internal.ApplicationInstance;
import korolev.internal.ComponentInstance$browserAccess$;
import korolev.internal.Frontend;
import korolev.server.KorolevServiceConfig;
import korolev.server.internal.BadRequestException$;
import korolev.server.internal.Cookies$;
import korolev.server.internal.services.PageService;
import korolev.state.StateDeserializer;
import korolev.state.StateManager;
import korolev.state.StateSerializer;
import korolev.state.StateStorage;
import korolev.state.StateStorage$;
import korolev.web.Request;
import levsha.Id;
import levsha.Id$;
import levsha.StatefulRenderContext;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public final class SessionsService<F, S, M> {
    private final KorolevServiceConfig<F, S, M> config;
    private final PageService<F, S, M> pageService;
    private final Effect<F> evidence$1;
    private final StateSerializer<S> evidence$2;
    private final StateDeserializer<S> evidence$3;
    private final AsyncTable<F, Qsid, ApplicationInstance<F, S, M>> apps;
    private final StateStorage<F, S> stateStorage;
    private final Scheduler<F> scheduler;

    public SessionsService(KorolevServiceConfig<F, S, M> config, PageService<F, S, M> pageService, Effect<F> evidence$1, StateSerializer<S> evidence$2, StateDeserializer<S> evidence$3) {
        this.config = config;
        this.pageService = pageService;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.evidence$3 = evidence$3;
        this.apps = AsyncTable$.MODULE$.unsafeCreateEmpty(evidence$1);
        this.stateStorage = config.stateStorage() == null ? StateStorage$.MODULE$.apply(StateStorage$.MODULE$.apply$default$1(), evidence$1, evidence$2) : config.stateStorage();
        this.scheduler = new Scheduler(evidence$1);
    }

    public F initSession(Request.Head rh) {
        Object object;
        Option option = rh.cookie(Cookies$.MODULE$.DeviceId());
        if (option instanceof Some) {
            String d = (String)((Some)option).value();
            object = Effect$.MODULE$.apply(this.evidence$1).pure((Object)d);
        } else if (None$.MODULE$.equals(option)) {
            object = this.config.idGenerator().generateDeviceId(this.evidence$1);
        } else {
            throw new MatchError((Object)option);
        }
        return (F)syntax$.MODULE$.EffectOps(object, this.evidence$1).flatMap((Function1 & Serializable)deviceId -> syntax$.MODULE$.EffectOps(this.config.idGenerator().generateSessionId(this.evidence$1), this.evidence$1).map((Function1 & Serializable)sessionId -> Qsid$.MODULE$.apply((String)deviceId, (String)sessionId)));
    }

    public F initAppState(Qsid qsid, Request.Head rh) {
        return (F)syntax$.MODULE$.EffectOps(this.config.stateLoader().apply((Object)qsid.deviceId(), (Object)rh), this.evidence$1).flatMap((Function1 & Serializable)defaultState -> syntax$.MODULE$.EffectOps(((Option)this.config.router().toState().lift().apply((Object)rh.pq())).fold(() -> this.initAppState$$anonfun$2$$anonfun$1(defaultState), (Function1 & Serializable)f -> f.apply(defaultState)), this.evidence$1).flatMap((Function1 & Serializable)state -> syntax$.MODULE$.EffectOps(this.stateStorage.create(qsid.deviceId(), qsid.sessionId(), state), this.evidence$1).map((Function1 & Serializable)x$1 -> {
            StateManager stateManager = x$1;
            return state;
        })));
    }

    public F getApp(Qsid qsid) {
        return (F)this.apps.getImmediately((Object)qsid);
    }

    public F createAppIfNeeded(Qsid qsid, Request.Head rh, Stream<F, String> incomingStream) {
        Tuple2 tuple2 = incomingStream.handleConsumed();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object incomingConsumed = tuple2._1();
        Stream incoming = (Stream)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(incomingConsumed, (Object)incoming);
        Object incomingConsumed2 = tuple22._1();
        Stream incoming2 = (Stream)tuple22._2();
        return (F)syntax$.MODULE$.EffectOps(this.stateStorage.exists(qsid.deviceId(), qsid.sessionId()), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> this.createAppIfNeeded$$anonfun$2(qsid, incomingConsumed2, incoming2, BoxesRunTime.unboxToBoolean((Object)x$1)));
    }

    private final Object initAppState$$anonfun$2$$anonfun$1(Object defaultState$1) {
        return Effect$.MODULE$.apply(this.evidence$1).pure(defaultState$1);
    }

    private final void handleAppOrWsOutgoingClose$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(Qsid qsid$8) {
        this.stateStorage.remove(qsid$8.deviceId(), qsid$8.sessionId());
    }

    private final Object handleAppOrWsOutgoingClose$9(Qsid qsid$3, Object incomingConsumed$2, Frontend frontend, ApplicationInstance app, List ehs) {
        Object consumed = Effect$.MODULE$.apply(this.evidence$1).promise((Function1)(JProcedure1 & Serializable)cb -> {
            AtomicBoolean invoked = new AtomicBoolean(false);
            JProcedure1 & Serializable invokeOnce = (JProcedure1 & Serializable)x -> {
                if (invoked.compareAndSet(false, true)) {
                    cb.apply(x);
                }
            };
            syntax$.MODULE$.EffectOps(frontend.outgoingConsumed(), this.evidence$1).runAsync((Function1)invokeOnce);
            syntax$.MODULE$.EffectOps(incomingConsumed$2, this.evidence$1).runAsync((Function1)invokeOnce);
        });
        return syntax$.MODULE$.EffectOps(consumed, this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return syntax$.MODULE$.EffectOps(frontend.outgoingMessages().cancel(), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return syntax$.MODULE$.EffectOps(app.topLevelComponentInstance().destroy(), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = x$12;
                    return syntax$.MODULE$.EffectOps(syntax$.MODULE$.ListEffectOps(ehs.map((Function1 & Serializable)_$2 -> _$2.onDestroy()), this.evidence$1).sequence(), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                        List list = x$1;
                        return syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.handleAppOrWsOutgoingClose$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(qsid$3))), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = x$12;
                            return syntax$.MODULE$.EffectOps(this.apps.remove((Object)qsid$3), this.evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = x$1;
                            });
                        });
                    });
                });
            });
        });
    }

    private final Object handleStateChange$3(ApplicationInstance app, List ehs) {
        return app.stateStream().foreach((Function1 & Serializable)x$1 -> {
            Id id;
            Id id2;
            Object state;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Id id3 = (Id)tuple2._1();
                state = tuple2._2();
                id2 = id3;
                id = Id$.MODULE$.TopLevel();
            } else {
                throw new MatchError((Object)tuple2);
            }
            return (id2 == null ? id != null : !id2.equals(id)) ? Effect$.MODULE$.apply(this.evidence$1).unit() : syntax$.MODULE$.EffectOps(syntax$.MODULE$.ListEffectOps(ehs.map((Function1 & Serializable)_$3 -> _$3.onState(state)), this.evidence$1).sequence(), this.evidence$1).unit();
        });
    }

    private final Object handleMessages$3(ApplicationInstance app, List ehs) {
        return app.messagesStream().foreach((Function1 & Serializable)m -> syntax$.MODULE$.EffectOps(syntax$.MODULE$.ListEffectOps(ehs.map((Function1 & Serializable)_$4 -> _$4.onMessage(m)), this.evidence$1).sequence(), this.evidence$1).unit());
    }

    private final Object create$1$$anonfun$1$$anonfun$1$$anonfun$1(Qsid qsid$13) {
        return Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)BadRequestException$.MODULE$.apply("Top level state should exists. Snapshot for " + qsid$13 + " is corrupted"));
    }

    private final Object create$5$$anonfun$5$$anonfun$5$$anonfun$5$$anonfun$2$$anonfun$1(ApplicationInstance app$4, List ehs$6) {
        return this.handleStateChange$3(app$4, ehs$6);
    }

    private final Object create$6$$anonfun$6$$anonfun$6$$anonfun$6$$anonfun$3$$anonfun$2$$anonfun$1(ApplicationInstance app$6, List ehs$8) {
        return this.handleMessages$3(app$6, ehs$8);
    }

    private final Object create$7$$anonfun$7$$anonfun$7$$anonfun$7$$anonfun$4$$anonfun$3$$anonfun$2$$anonfun$1(Qsid qsid$19, Object incomingConsumed$9, Frontend frontend$6, ApplicationInstance app$8, List ehs$10) {
        return this.handleAppOrWsOutgoingClose$9(qsid$19, incomingConsumed$9, frontend$6, app$8, ehs$10);
    }

    private final Object create$17(Qsid qsid$10, Object incomingConsumed$3, Stream incoming$1) {
        return syntax$.MODULE$.EffectOps(this.stateStorage.get(qsid$10.deviceId(), qsid$10.sessionId()), this.evidence$1).flatMap((Function1 & Serializable)stateManager -> syntax$.MODULE$.EffectOps(stateManager.read(Id$.MODULE$.TopLevel(), this.evidence$3), this.evidence$1).flatMap((Function1 & Serializable)maybeInitialState -> syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(maybeInitialState.fold(() -> this.create$1$$anonfun$1$$anonfun$1$$anonfun$1(qsid$10), (Function1 & Serializable)_$5 -> Effect$.MODULE$.apply(this.evidence$1).pure(_$5)), this.evidence$1).map((Function1 & Serializable)initialState -> {
            Frontend<F> frontend = new Frontend<F>(incoming$1, this.evidence$1, this.config.reporter().Implicit());
            ApplicationInstance<F, Object, M> app = new ApplicationInstance<F, Object, M>(qsid$10, frontend, stateManager, initialState, this.config.document(), this.config.router(), (Function2 & Serializable)(rc, k) -> this.pageService.setupStatefulProxy((StatefulRenderContext<Context.Binding<F, S, M>>)rc, qsid$10, (Function2<StatefulRenderContext<Context.Binding<F, S, M>>, Context.Binding<F, S, M>, BoxedUnit>)k), this.scheduler, this.config.reporter(), this.evidence$1, (StateSerializer<Object>)this.evidence$2, (StateDeserializer<Object>)this.evidence$3);
            ComponentInstance$browserAccess$ browserAccess = app.topLevelComponentInstance().browserAccess();
            return Tuple4$.MODULE$.apply(initialState, frontend, app, (Object)browserAccess);
        }), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Object initialState = tuple4._1();
            Frontend frontend = (Frontend)tuple4._2();
            ApplicationInstance app = (ApplicationInstance)tuple4._3();
            ComponentInstance$browserAccess$ browserAccess = (ComponentInstance$browserAccess$)tuple4._4();
            return syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(syntax$.MODULE$.ListEffectOps(this.config.extensions().map((Function1 & Serializable)_$6 -> _$6.setup(browserAccess)), this.evidence$1).sequence(), this.evidence$1).flatMap((Function1 & Serializable)ehs -> syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).start(() -> this.create$5$$anonfun$5$$anonfun$5$$anonfun$5$$anonfun$2$$anonfun$1(app, ehs), this.config.executionContext()), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                Effect.Fiber fiber = x$1;
                return syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).start(() -> this.create$6$$anonfun$6$$anonfun$6$$anonfun$6$$anonfun$3$$anonfun$2$$anonfun$1(app, ehs), this.config.executionContext()), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                    Effect.Fiber fiber = x$12;
                    return syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).start(() -> this.create$7$$anonfun$7$$anonfun$7$$anonfun$7$$anonfun$4$$anonfun$3$$anonfun$2$$anonfun$1(qsid$10, incomingConsumed$3, frontend, app, ehs), this.config.executionContext()), this.evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Effect.Fiber fiber = x$1;
                    });
                });
            })), this.evidence$1).start(this.config.executionContext()), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
                Effect.Fiber fiber = x$12;
                return syntax$.MODULE$.EffectOps(app.initialize(this.config.executionContext()), this.evidence$1).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                    return app;
                });
            });
        })));
    }

    private final Object createAppIfNeeded$$anonfun$1$$anonfun$1(Qsid qsid$22, Object incomingConsumed$12, Stream incoming$6) {
        return this.create$17(qsid$22, incomingConsumed$12, incoming$6);
    }

    private final /* synthetic */ Object createAppIfNeeded$$anonfun$2(Qsid qsid$20, Object incomingConsumed$10, Stream incoming$5, boolean x$1) {
        Object object;
        boolean bl = x$1;
        if (bl) {
            object = syntax$.MODULE$.EffectOps(this.apps.getFill((Object)qsid$20, () -> this.createAppIfNeeded$$anonfun$1$$anonfun$1(qsid$20, incomingConsumed$10, incoming$5)), this.evidence$1).unit();
        } else if (!bl) {
            object = this.apps.remove((Object)qsid$20);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return object;
    }
}

