/*
 * Decompiled with CFR 0.152.
 */
package korolev.server.internal;

import java.io.Serializable;
import korolev.Qsid$;
import korolev.data.Bytes;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Stream;
import korolev.server.KorolevService;
import korolev.server.internal.BadRequestException;
import korolev.server.internal.BadRequestException$;
import korolev.server.internal.services.CommonService;
import korolev.server.internal.services.FilesService;
import korolev.server.internal.services.MessagingService;
import korolev.server.internal.services.PostService;
import korolev.server.internal.services.ServerSideRenderingService;
import korolev.web.Path;
import korolev.web.PathAndQuery;
import korolev.web.PathAndQuery$$div$;
import korolev.web.PathAndQuery$Root$;
import korolev.web.Request;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public final class KorolevServiceImpl<F>
implements KorolevService<F> {
    private final PartialFunction<Request<Stream<F, Bytes>>, F> http;
    private final CommonService<F> commonService;
    private final FilesService<F> filesService;
    private final MessagingService<F> messagingService;
    private final PostService<F> postService;
    private final ServerSideRenderingService<F, ?, ?> ssrService;
    private final F webSocketBadRequestF;

    public KorolevServiceImpl(PartialFunction<Request<Stream<F, Bytes>>, Object> http, CommonService<F> commonService, FilesService<F> filesService, MessagingService<F> messagingService, PostService<F> postService, ServerSideRenderingService<F, ?, ?> ssrService, Effect<F> evidence$1) {
        this.http = http;
        this.commonService = commonService;
        this.filesService = filesService;
        this.messagingService = messagingService;
        this.postService = postService;
        this.ssrService = ssrService;
        BadRequestException error = BadRequestException$.MODULE$.apply("Wrong path. Should be '/bridge/web-socket/<device>/<session>'.");
        this.webSocketBadRequestF = Effect$.MODULE$.apply(evidence$1).fail((Throwable)error);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public F http(Request<Stream<F, Bytes>> request) {
        PathAndQuery path;
        Option option;
        Object object;
        Tuple2 tuple2;
        Option option2;
        PathAndQuery pathAndQuery = request.pq();
        if (pathAndQuery != null && !(option2 = PathAndQuery$$div$.MODULE$.unapply(pathAndQuery)).isEmpty() && PathAndQuery$Root$.MODULE$.equals((tuple2 = (Tuple2)option2.get())._1()) && "static".equals(tuple2._2())) {
            object = this.commonService.notFoundResponseF();
            return object;
        }
        PathAndQuery path2 = pathAndQuery;
        if (path2.startsWith("static")) {
            object = this.filesService.resourceFromClasspath(path2);
            return object;
        }
        if (pathAndQuery != null && !(option = PathAndQuery$$div$.MODULE$.unapply(pathAndQuery)).isEmpty()) {
            Option option3;
            Tuple2 tuple22 = (Tuple2)option.get();
            Path path3 = (Path)tuple22._1();
            String string = (String)tuple22._2();
            if (path3 != null && !(option3 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path3)).isEmpty()) {
                Option option4;
                Tuple2 tuple23 = (Tuple2)option3.get();
                Path path4 = (Path)tuple23._1();
                String string2 = (String)tuple23._2();
                if (path4 != null && !(option4 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path4)).isEmpty()) {
                    Option option5;
                    Tuple2 tuple24 = (Tuple2)option4.get();
                    Path path5 = (Path)tuple24._1();
                    String string3 = (String)tuple24._2();
                    if (path5 != null && !(option5 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path5)).isEmpty()) {
                        Option option6;
                        Tuple2 tuple25 = (Tuple2)option5.get();
                        Path path6 = (Path)tuple25._1();
                        String string4 = (String)tuple25._2();
                        if (path6 != null && !(option6 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path6)).isEmpty()) {
                            Tuple2 tuple26;
                            Option option7;
                            Tuple2 tuple27 = (Tuple2)option6.get();
                            Path path7 = (Path)tuple27._1();
                            String string5 = (String)tuple27._2();
                            if (PathAndQuery$Root$.MODULE$.equals(path7) && "bridge".equals(string5)) {
                                if ("long-polling".equals(string4)) {
                                    String deviceId = string3;
                                    String sessionId = string2;
                                    if ("publish".equals(string)) {
                                        object = this.messagingService.longPollingPublish(Qsid$.MODULE$.apply(deviceId, sessionId), (Stream)request.body());
                                        return object;
                                    }
                                    String deviceId2 = string3;
                                    String sessionId2 = string2;
                                    if ("subscribe".equals(string)) {
                                        object = this.messagingService.longPollingSubscribe(Qsid$.MODULE$.apply(deviceId2, sessionId2), (Request.Head)request);
                                        return object;
                                    }
                                }
                                String deviceId = string4;
                                String sessionId = string3;
                                if ("form-data".equals(string2)) {
                                    String descriptor = string;
                                    object = this.postService.formData(Qsid$.MODULE$.apply(deviceId, sessionId), descriptor, (Seq<Tuple2<String, String>>)request.headers(), (Stream)request.body());
                                    return object;
                                }
                            }
                            if (path7 != null && !(option7 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path7)).isEmpty() && PathAndQuery$Root$.MODULE$.equals((tuple26 = (Tuple2)option7.get())._1()) && "bridge".equals(tuple26._2())) {
                                String deviceId = string5;
                                String sessionId = string4;
                                if ("file".equals(string3)) {
                                    String descriptor = string2;
                                    if ("info".equals(string)) {
                                        object = this.postService.filesInfo(Qsid$.MODULE$.apply(deviceId, sessionId), descriptor, (Stream)request.body());
                                        return object;
                                    }
                                    String deviceId3 = string5;
                                    String sessionId3 = string4;
                                    String descriptor2 = string2;
                                    object = this.postService.downloadFile(Qsid$.MODULE$.apply(deviceId3, sessionId3), descriptor2);
                                    return object;
                                }
                            }
                            if (PathAndQuery$Root$.MODULE$.equals(path7) && "bridge".equals(string5)) {
                                String deviceId = string4;
                                String sessionId = string3;
                                if ("file".equals(string2)) {
                                    String descriptor = string;
                                    object = this.postService.uploadFile(Qsid$.MODULE$.apply(deviceId, sessionId), descriptor, (Seq<Tuple2<String, String>>)request.headers(), (Stream)request.body());
                                    return object;
                                }
                            }
                        }
                    }
                }
            }
        }
        PathAndQuery pathAndQuery2 = path = pathAndQuery;
        PathAndQuery$Root$ pathAndQuery$Root$ = PathAndQuery$Root$.MODULE$;
        if ((pathAndQuery2 == null ? pathAndQuery$Root$ != null : !pathAndQuery2.equals(pathAndQuery$Root$)) && !this.ssrService.canBeRendered(request.pq())) {
            object = this.http.applyOrElse(request, (Function1 & Serializable)_$2 -> this.commonService.notFoundResponseF());
            return object;
        }
        object = this.ssrService.serverSideRenderedPage(request);
        return object;
    }

    @Override
    public F ws(Request<Stream<F, String>> request) {
        F f;
        Tuple2 tuple2;
        Option option;
        Tuple2 tuple22;
        Path path;
        Option option2;
        Tuple2 tuple23;
        Path path2;
        Option option3;
        Tuple2 tuple24;
        Path path3;
        Option option4;
        PathAndQuery pathAndQuery = request.pq();
        if (pathAndQuery != null && !(option4 = PathAndQuery$$div$.MODULE$.unapply(pathAndQuery)).isEmpty() && (path3 = (Path)(tuple24 = (Tuple2)option4.get())._1()) != null && !(option3 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path3)).isEmpty() && (path2 = (Path)(tuple23 = (Tuple2)option3.get())._1()) != null && !(option2 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path2)).isEmpty() && (path = (Path)(tuple22 = (Tuple2)option2.get())._1()) != null && !(option = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path)).isEmpty() && PathAndQuery$Root$.MODULE$.equals((tuple2 = (Tuple2)option.get())._1()) && "bridge".equals(tuple2._2()) && "web-socket".equals(tuple22._2())) {
            String deviceId = (String)tuple23._2();
            String sessionId = (String)tuple24._2();
            f = this.messagingService.webSocketMessaging(Qsid$.MODULE$.apply(deviceId, sessionId), (Request.Head)request, (Stream<F, String>)((Stream)request.body()));
        } else {
            f = this.webSocketBadRequestF;
        }
        return f;
    }
}

