/*
 * Decompiled with CFR 0.152.
 */
package korolev.server.internal;

import java.io.Serializable;
import korolev.Qsid$;
import korolev.data.Bytes;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Stream;
import korolev.server.KorolevService;
import korolev.server.internal.BadRequestException;
import korolev.server.internal.BadRequestException$;
import korolev.server.internal.Cookies$;
import korolev.server.internal.services.CommonService;
import korolev.server.internal.services.FilesService;
import korolev.server.internal.services.MessagingService;
import korolev.server.internal.services.PostService;
import korolev.server.internal.services.ServerSideRenderingService;
import korolev.web.Path;
import korolev.web.PathAndQuery;
import korolev.web.PathAndQuery$$div$;
import korolev.web.PathAndQuery$Root$;
import korolev.web.Request;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;

public final class KorolevServiceImpl<F>
implements KorolevService<F> {
    private final PartialFunction<Request<Stream<F, Bytes>>, F> http;
    private final CommonService<F> commonService;
    private final FilesService<F> filesService;
    private final MessagingService<F> messagingService;
    private final PostService<F> postService;
    private final ServerSideRenderingService<F, ?, ?> ssrService;
    private final F webSocketBadRequestF;

    public KorolevServiceImpl(PartialFunction<Request<Stream<F, Bytes>>, Object> http, CommonService<F> commonService, FilesService<F> filesService, MessagingService<F> messagingService, PostService<F> postService, ServerSideRenderingService<F, ?, ?> ssrService, Effect<F> evidence$1) {
        this.http = http;
        this.commonService = commonService;
        this.filesService = filesService;
        this.messagingService = messagingService;
        this.postService = postService;
        this.ssrService = ssrService;
        BadRequestException error = BadRequestException$.MODULE$.apply("Malformed request. Headers MUST contain deviceId cookie. Path MUST be '/bridge/web-socket/<session>'.");
        this.webSocketBadRequestF = Effect$.MODULE$.apply(evidence$1).fail((Throwable)error);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public F http(Request<Stream<F, Bytes>> request) {
        Object object;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)request.cookie(Cookies$.MODULE$.DeviceId()), (Object)request.pq());
        if (tuple2 != null) {
            PathAndQuery path;
            Tuple2 tuple22;
            Option option;
            Option option2 = (Option)tuple2._1();
            PathAndQuery pathAndQuery = (PathAndQuery)tuple2._2();
            if (pathAndQuery != null && !(option = PathAndQuery$$div$.MODULE$.unapply(pathAndQuery)).isEmpty() && PathAndQuery$Root$.MODULE$.equals((tuple22 = (Tuple2)option.get())._1()) && "static".equals(tuple22._2())) {
                object = this.commonService.notFoundResponseF();
                return (F)object;
            }
            PathAndQuery path2 = pathAndQuery;
            if (path2.startsWith("static")) {
                object = this.filesService.resourceFromClasspath(path2);
                return (F)object;
            }
            if (option2 instanceof Some) {
                Option option3;
                String string;
                String deviceId = string = (String)((Some)option2).value();
                if (pathAndQuery != null && !(option3 = PathAndQuery$$div$.MODULE$.unapply(pathAndQuery)).isEmpty()) {
                    Option option4;
                    Tuple2 tuple23 = (Tuple2)option3.get();
                    Path path3 = (Path)tuple23._1();
                    String string2 = (String)tuple23._2();
                    if (path3 != null && !(option4 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path3)).isEmpty()) {
                        Option option5;
                        Tuple2 tuple24 = (Tuple2)option4.get();
                        Path path4 = (Path)tuple24._1();
                        String string3 = (String)tuple24._2();
                        if (path4 != null && !(option5 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path4)).isEmpty()) {
                            Option option6;
                            Tuple2 tuple25 = (Tuple2)option5.get();
                            Path path5 = (Path)tuple25._1();
                            String string4 = (String)tuple25._2();
                            if (path5 != null && !(option6 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path5)).isEmpty()) {
                                Tuple2 tuple26;
                                Option option7;
                                Tuple2 tuple27;
                                Option option8;
                                Tuple2 tuple28 = (Tuple2)option6.get();
                                Path path6 = (Path)tuple28._1();
                                String string5 = (String)tuple28._2();
                                if (PathAndQuery$Root$.MODULE$.equals(path6) && "bridge".equals(string5) && "long-polling".equals(string4)) {
                                    String sessionId = string3;
                                    if ("publish".equals(string2)) {
                                        object = this.messagingService.longPollingPublish(Qsid$.MODULE$.apply(deviceId, sessionId), (Stream)request.body());
                                        return (F)object;
                                    }
                                }
                                String deviceId2 = string;
                                if (PathAndQuery$Root$.MODULE$.equals(path6) && "bridge".equals(string5) && "long-polling".equals(string4)) {
                                    String sessionId = string3;
                                    if ("subscribe".equals(string2)) {
                                        object = this.messagingService.longPollingSubscribe(Qsid$.MODULE$.apply(deviceId2, sessionId), (Request.Head)request);
                                        return (F)object;
                                    }
                                }
                                String deviceId3 = string;
                                if (PathAndQuery$Root$.MODULE$.equals(path6) && "bridge".equals(string5)) {
                                    String sessionId = string4;
                                    if ("form-data".equals(string3)) {
                                        String descriptor = string2;
                                        object = this.postService.formData(Qsid$.MODULE$.apply(deviceId3, sessionId), descriptor, (Seq<Tuple2<String, String>>)request.headers(), (Stream)request.body());
                                        return (F)object;
                                    }
                                }
                                String deviceId4 = string;
                                if (path6 != null && !(option8 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path6)).isEmpty() && PathAndQuery$Root$.MODULE$.equals((tuple27 = (Tuple2)option8.get())._1()) && "bridge".equals(tuple27._2())) {
                                    String sessionId = string5;
                                    if ("file".equals(string4)) {
                                        String descriptor = string3;
                                        if ("info".equals(string2)) {
                                            object = this.postService.filesInfo(Qsid$.MODULE$.apply(deviceId4, sessionId), descriptor, (Stream)request.body());
                                            return (F)object;
                                        }
                                    }
                                }
                                String deviceId5 = string;
                                if (path6 != null && !(option7 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path6)).isEmpty() && PathAndQuery$Root$.MODULE$.equals((tuple26 = (Tuple2)option7.get())._1()) && "bridge".equals(tuple26._2())) {
                                    String sessionId = string5;
                                    if ("file".equals(string4)) {
                                        String descriptor = string3;
                                        object = this.postService.downloadFile(Qsid$.MODULE$.apply(deviceId5, sessionId), descriptor);
                                        return (F)object;
                                    }
                                }
                                String deviceId6 = string;
                                if (PathAndQuery$Root$.MODULE$.equals(path6) && "bridge".equals(string5)) {
                                    String sessionId = string4;
                                    if ("file".equals(string3)) {
                                        String descriptor = string2;
                                        object = this.postService.uploadFile(Qsid$.MODULE$.apply(deviceId6, sessionId), descriptor, (Seq<Tuple2<String, String>>)request.headers(), (Stream)request.body());
                                        return (F)object;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            PathAndQuery pathAndQuery2 = path = pathAndQuery;
            PathAndQuery$Root$ pathAndQuery$Root$ = PathAndQuery$Root$.MODULE$;
            if (!(pathAndQuery2 == null ? pathAndQuery$Root$ != null : !pathAndQuery2.equals(pathAndQuery$Root$)) || this.ssrService.canBeRendered(request.pq())) {
                object = this.ssrService.serverSideRenderedPage(request);
                return (F)object;
            }
        }
        object = this.http.applyOrElse(request, (Function1 & Serializable)_$2 -> this.commonService.notFoundResponseF());
        return (F)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public F ws(Request<Stream<F, String>> request) {
        F f;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)request.cookie(Cookies$.MODULE$.DeviceId()), (Object)request.pq());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            PathAndQuery pathAndQuery = (PathAndQuery)tuple2._2();
            if (option instanceof Some) {
                Tuple2 tuple22;
                Option option2;
                Tuple2 tuple23;
                Path path;
                Option option3;
                Tuple2 tuple24;
                Path path2;
                Option option4;
                String deviceId = (String)((Some)option).value();
                if (pathAndQuery != null && !(option4 = PathAndQuery$$div$.MODULE$.unapply(pathAndQuery)).isEmpty() && (path2 = (Path)(tuple24 = (Tuple2)option4.get())._1()) != null && !(option3 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path2)).isEmpty() && (path = (Path)(tuple23 = (Tuple2)option3.get())._1()) != null && !(option2 = PathAndQuery$$div$.MODULE$.unapply((PathAndQuery)path)).isEmpty() && PathAndQuery$Root$.MODULE$.equals((tuple22 = (Tuple2)option2.get())._1()) && "bridge".equals(tuple22._2()) && "web-socket".equals(tuple23._2())) {
                    String sessionId = (String)tuple24._2();
                    f = this.messagingService.webSocketMessaging(Qsid$.MODULE$.apply(deviceId, sessionId), (Request.Head)request, (Stream<F, String>)((Stream)request.body()));
                    return f;
                }
            }
        }
        f = this.webSocketBadRequestF;
        return f;
    }
}

