/*
 * Decompiled with CFR 0.152.
 */
package korolev.server.internal.services;

import java.io.Serializable;
import korolev.Qsid;
import korolev.data.Bytes;
import korolev.data.Bytes$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Queue;
import korolev.effect.Queue$;
import korolev.effect.Reporter;
import korolev.effect.Stream;
import korolev.effect.Stream$;
import korolev.effect.syntax$;
import korolev.internal.ApplicationInstance;
import korolev.internal.Frontend$;
import korolev.server.internal.package$;
import korolev.server.internal.services.CommonService;
import korolev.server.internal.services.MessagingService$;
import korolev.server.internal.services.SessionsService;
import korolev.web.Request;
import korolev.web.Response;
import korolev.web.Response$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class MessagingService<F> {
    private final SessionsService<F, ?, ?> sessionsService;
    private final Effect<F> evidence$1;
    private final TrieMap<Qsid, Queue<F, String>> longPollingTopics;
    private final Seq<Tuple2<String, String>> commonResponseHeaders;
    private final Response<Stream<F, Bytes>> commonOkResponse;
    private final Response<Stream<F, Bytes>> commonGoneResponse;

    public static <F> Object SomeReloadMessageF(Effect<F> effect) {
        return MessagingService$.MODULE$.SomeReloadMessageF(effect);
    }

    public MessagingService(Reporter reporter, CommonService<F> commonService, SessionsService<F, ?, ?> sessionsService, Effect<F> evidence$1) {
        this.sessionsService = sessionsService;
        this.evidence$1 = evidence$1;
        this.longPollingTopics = TrieMap$.MODULE$.empty();
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"cache-control");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"no-cache");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"content-type");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"application/json");
        this.commonResponseHeaders = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.commonOkResponse = Response$.MODULE$.apply(Response.Status$.MODULE$.Ok(), (Object)Stream$.MODULE$.empty(evidence$1), this.commonResponseHeaders, (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)));
        this.commonGoneResponse = Response$.MODULE$.apply(Response.Status$.MODULE$.Gone(), (Object)Stream$.MODULE$.empty(evidence$1), this.commonResponseHeaders, (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)));
    }

    public F longPollingSubscribe(Qsid qsid, Request.Head rh) {
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.createAppIfNeeded(qsid, rh, this.createTopic(qsid)), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable)maybeApp -> syntax$.MODULE$.EffectOps(maybeApp.fold(this::longPollingSubscribe$$anonfun$1$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$2 -> _$2.frontend().outgoingMessages().pull()), this.evidence$1).flatMap((Function1 & Serializable)maybeMessage -> {
                Object object;
                Option option = maybeMessage;
                if (None$.MODULE$.equals(option)) {
                    object = Effect$.MODULE$.apply(this.evidence$1).pure(this.commonGoneResponse);
                } else if (option instanceof Some) {
                    String message = (String)((Some)option).value();
                    object = package$.MODULE$.HttpResponse(Response.Status$.MODULE$.Ok(), message, this.commonResponseHeaders, this.evidence$1);
                } else {
                    throw new MatchError((Object)option);
                }
                return syntax$.MODULE$.EffectOps(object, this.evidence$1).map((Function1 & Serializable)response -> response);
            }));
        });
    }

    public F longPollingPublish(Qsid qsid, Stream<F, Bytes> data) {
        return (F)syntax$.MODULE$.EffectOps(this.takeTopic(qsid), this.evidence$1).flatMap((Function1 & Serializable)topic -> syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(data.fold((Object)Bytes$.MODULE$.empty(), (Function2 & Serializable)(_$3, _$4) -> _$3.$plus$plus(_$4)), this.evidence$1).map((Function1 & Serializable)_$5 -> _$5.asUtf8String()), this.evidence$1).flatMap((Function1 & Serializable)message -> syntax$.MODULE$.EffectOps(topic.enqueue(message), this.evidence$1).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return this.commonOkResponse;
        })));
    }

    public F webSocketMessaging(Qsid qsid, Request.Head rh, Stream<F, String> incomingMessages) {
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.createAppIfNeeded(qsid, rh, incomingMessages), this.evidence$1).flatMap((Function1 & Serializable)_$6 -> syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Object object;
            Option option = x$1;
            if (option instanceof Some) {
                ApplicationInstance app = (ApplicationInstance)((Some)option).value();
                object = Effect$.MODULE$.apply(this.evidence$1).pure((Object)Response$.MODULE$.apply(Response.Status$.MODULE$.Ok(), app.frontend().outgoingMessages(), (Seq)scala.package$.MODULE$.Nil(), (Option)None$.MODULE$));
            } else if (None$.MODULE$.equals(option)) {
                object = syntax$.MODULE$.EffectOps(Stream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Frontend$.MODULE$.ReloadMessage()})).mat(this.evidence$1), this.evidence$1).map((Function1 & Serializable)messages -> Response$.MODULE$.apply(Response.Status$.MODULE$.Ok(), messages, (Seq)scala.package$.MODULE$.Nil(), (Option)None$.MODULE$));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        }));
    }

    private F takeTopic(Qsid qsid) {
        return (F)Effect$.MODULE$.apply(this.evidence$1).delay(() -> this.takeTopic$$anonfun$1(qsid));
    }

    private Stream<F, String> createTopic(Qsid qsid) {
        Queue topic = Queue$.MODULE$.apply(Queue$.MODULE$.apply$default$1(), this.evidence$1);
        this.longPollingTopics.putIfAbsent((Object)qsid, (Object)topic);
        return topic.stream();
    }

    private final Object longPollingSubscribe$$anonfun$1$$anonfun$1$$anonfun$1() {
        return MessagingService$.MODULE$.SomeReloadMessageF(this.evidence$1);
    }

    private final Queue takeTopic$$anonfun$1(Qsid qsid$3) {
        if (!this.longPollingTopics.contains((Object)qsid$3)) {
            throw new Exception(new StringBuilder(40).append("There is no long-polling topic matching ").append(qsid$3).toString());
        }
        return (Queue)this.longPollingTopics.apply((Object)qsid$3);
    }
}

