/*
 * Decompiled with CFR 0.152.
 */
package korolev.internal;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import korolev.Context;
import korolev.Metrics$;
import korolev.data.Bytes;
import korolev.effect.AsyncTable;
import korolev.effect.AsyncTable$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Queue;
import korolev.effect.Queue$;
import korolev.effect.Reporter;
import korolev.effect.Stream;
import korolev.effect.syntax$;
import korolev.internal.Frontend$;
import korolev.internal.Frontend$CallbackType$;
import korolev.internal.Frontend$CallbackType$CustomCallback$;
import korolev.internal.Frontend$CallbackType$DomEvent$;
import korolev.internal.Frontend$CallbackType$EvalJsResponse$;
import korolev.internal.Frontend$CallbackType$ExtractEventDataResponse$;
import korolev.internal.Frontend$CallbackType$ExtractPropertyResponse$;
import korolev.internal.Frontend$CallbackType$Heartbeat$;
import korolev.internal.Frontend$CallbackType$History$;
import korolev.internal.Frontend$DomEventMessage$;
import korolev.internal.Frontend$DownloadFileMeta$;
import korolev.internal.Frontend$EvalJsStatus$;
import korolev.internal.Frontend$EvalJsStatus$Failure$;
import korolev.internal.Frontend$EvalJsStatus$Success$;
import korolev.internal.Frontend$ModifyDomProcedure$;
import korolev.internal.Frontend$ModifyDomProcedure$SetAttr$;
import korolev.internal.Frontend$Procedure$;
import korolev.internal.Frontend$Procedure$ChangePageUrl$;
import korolev.internal.Frontend$Procedure$DownloadFile$;
import korolev.internal.Frontend$Procedure$EvalJs$;
import korolev.internal.Frontend$Procedure$ExtractEventData$;
import korolev.internal.Frontend$Procedure$ExtractProperty$;
import korolev.internal.Frontend$Procedure$Focus$;
import korolev.internal.Frontend$Procedure$ListFiles$;
import korolev.internal.Frontend$Procedure$ListenEvent$;
import korolev.internal.Frontend$Procedure$ModifyDom$;
import korolev.internal.Frontend$Procedure$Reload$;
import korolev.internal.Frontend$Procedure$ReloadCss$;
import korolev.internal.Frontend$Procedure$RestForm$;
import korolev.internal.Frontend$Procedure$SetRenderNum$;
import korolev.internal.Frontend$Procedure$UploadFile$;
import korolev.internal.Frontend$Procedure$UploadForm$;
import korolev.internal.Frontend$PropertyType$;
import korolev.internal.Frontend$PropertyType$Error$;
import korolev.internal.RemoteDomChangesPerformer;
import korolev.internal.package$;
import korolev.web.FormData;
import korolev.web.PathAndQuery;
import korolev.web.PathAndQuery$;
import levsha.Id;
import levsha.Id$;
import levsha.impl.DiffRenderContext;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

public final class Frontend<F> {
    private final Effect<F> evidence$1;
    private final ExecutionContext ec;
    private final AtomicInteger lastDescriptor;
    private final AtomicLong avgDiffTime;
    private final RemoteDomChangesPerformer remoteDomChangesPerformer;
    private final Map<String, Function1<String, F>> customCallbacks;
    private final Map<String, DownloadFileMeta<F>> downloadFiles;
    private final AsyncTable<F, String, String> stringPromises;
    private final AsyncTable<F, String, FormData> formDataPromises;
    private final AsyncTable<F, String, Stream<F, Bytes>> filesPromises;
    private final AsyncTable<F, String, List<Tuple2<String, Object>>> fileNamePromises;
    private final Queue<F, String> outgoingQueue;
    private final Stream outgoingMessages;
    private final Stream domEventMessages;
    private final Stream browserHistoryMessages;

    public static long HeavyRenderThresholdNanos() {
        return Frontend$.MODULE$.HeavyRenderThresholdNanos();
    }

    public static String ReloadMessage() {
        return Frontend$.MODULE$.ReloadMessage();
    }

    public Frontend(Stream<F, String> incomingMessages, Effect<F> evidence$1, Reporter reporter, ExecutionContext ec) {
        SeqOps seqOps;
        this.evidence$1 = evidence$1;
        this.ec = ec;
        this.lastDescriptor = new AtomicInteger(0);
        this.avgDiffTime = new AtomicLong(0L);
        this.remoteDomChangesPerformer = new RemoteDomChangesPerformer();
        this.customCallbacks = (Map)Map$.MODULE$.empty();
        this.downloadFiles = (Map)Map$.MODULE$.empty();
        this.stringPromises = AsyncTable$.MODULE$.unsafeCreateEmpty(evidence$1);
        this.formDataPromises = AsyncTable$.MODULE$.unsafeCreateEmpty(evidence$1);
        this.filesPromises = AsyncTable$.MODULE$.unsafeCreateEmpty(evidence$1);
        this.fileNamePromises = AsyncTable$.MODULE$.unsafeCreateEmpty(evidence$1);
        this.outgoingQueue = Queue$.MODULE$.apply(Queue$.MODULE$.apply$default$1(), evidence$1);
        List list = incomingMessages.map((Function1 & Serializable)json -> this.parseMessage((String)json)).sort(3, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) return 2;
            int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
            if (Frontend$CallbackType$DomEvent$.MODULE$.code() == n) {
                return 0;
            }
            if (Frontend$CallbackType$History$.MODULE$.code() != n) return 2;
            return 1;
        });
        if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.List().unapplySeq((SeqOps)list), 3) != 0) {
            throw new MatchError((Object)list);
        }
        Stream stream = (Stream)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
        Stream stream2 = (Stream)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
        Stream stream3 = (Stream)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 2);
        Stream rawDomEvents = stream;
        Stream rawBrowserHistoryChanges = stream2;
        Stream rawClientMessages = stream3;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)rawDomEvents, (Object)rawBrowserHistoryChanges, (Object)rawClientMessages);
        Stream rawDomEvents2 = (Stream)tuple3._1();
        Stream rawBrowserHistoryChanges2 = (Stream)tuple3._2();
        Stream rawClientMessages2 = (Stream)tuple3._3();
        this.outgoingMessages = this.outgoingQueue.stream();
        this.domEventMessages = rawDomEvents2.map((Function1 & Serializable)x$1 -> {
            String tpe;
            String target;
            String renderNum;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object object;
                String args = (String)tuple2._2();
                String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(args), ':');
                if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 3) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2);
                renderNum = string;
                target = string2;
                tpe = string3;
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)renderNum, (Object)target, (Object)tpe);
            String renderNum2 = (String)tuple3._1();
            String target2 = (String)tuple3._2();
            String tpe2 = (String)tuple3._3();
            return Frontend$DomEventMessage$.MODULE$.apply(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(renderNum2)), Id$.MODULE$.apply(target2, Id$.MODULE$.apply$default$2()), tpe2);
        });
        this.browserHistoryMessages = rawBrowserHistoryChanges2.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String args = (String)tuple2._2();
            return PathAndQuery$.MODULE$.fromString(args);
        });
        syntax$.MODULE$.EffectOps(rawClientMessages2.foreach((Function1 & Serializable)x$1 -> {
            Object object;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
            String string = (String)tuple2._2();
            if (Frontend$CallbackType$Heartbeat$.MODULE$.code() == n) {
                object = Effect$.MODULE$.apply(evidence$1).unit();
                return object;
            } else if (Frontend$CallbackType$ExtractPropertyResponse$.MODULE$.code() == n) {
                Object object2;
                String args = string;
                String[] stringArray = args.split(":", 3);
                if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray), 3) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 0);
                String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 1);
                String string4 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 2);
                String descriptor = string2;
                String propertyType = string3;
                String value = string4;
                Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)descriptor, (Object)propertyType, (Object)value);
                String descriptor2 = (String)tuple3._1();
                String propertyType2 = (String)tuple3._2();
                String value2 = (String)tuple3._3();
                int n2 = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(propertyType2));
                object = Frontend$PropertyType$Error$.MODULE$.code() == n2 ? syntax$.MODULE$.EffectOps(this.stringPromises.fail((Object)descriptor2, (Throwable)new ClientSideException(value2)), evidence$1).after(() -> this.$init$$$anonfun$5$$anonfun$1(descriptor2)) : syntax$.MODULE$.EffectOps(this.stringPromises.put((Object)descriptor2, (Object)value2), evidence$1).after(() -> this.$init$$$anonfun$5$$anonfun$2(descriptor2));
                return object;
            } else if (Frontend$CallbackType$ExtractEventDataResponse$.MODULE$.code() == n) {
                Object object3;
                String args = string;
                String[] stringArray = args.split(":", 2);
                if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object3 = Array$.MODULE$.unapplySeq((Object)stringArray), 2) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String string5 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object3, 0);
                String string6 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object3, 1);
                String descriptor = string5;
                String value = string6;
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)descriptor, (Object)value);
                String descriptor3 = (String)tuple22._1();
                String value3 = (String)tuple22._2();
                object = syntax$.MODULE$.EffectOps(this.stringPromises.put((Object)descriptor3, (Object)value3), evidence$1).after(() -> this.$init$$$anonfun$5$$anonfun$3(descriptor3));
                return object;
            } else if (Frontend$CallbackType$EvalJsResponse$.MODULE$.code() == n) {
                Object object4;
                String args = string;
                String[] stringArray = args.split(":", 3);
                if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object4 = Array$.MODULE$.unapplySeq((Object)stringArray), 3) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String string7 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object4, 0);
                String string8 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object4, 1);
                String string9 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object4, 2);
                String descriptor = string7;
                String status = string8;
                String json = string9;
                Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)descriptor, (Object)status, (Object)json);
                String descriptor4 = (String)tuple3._1();
                String status2 = (String)tuple3._2();
                String json2 = (String)tuple3._3();
                int n3 = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(status2));
                if (Frontend$EvalJsStatus$Success$.MODULE$.code() == n3) {
                    object = syntax$.MODULE$.EffectOps(this.stringPromises.put((Object)descriptor4, (Object)json2), evidence$1).after(() -> this.$init$$$anonfun$5$$anonfun$4(descriptor4));
                    return object;
                } else {
                    if (Frontend$EvalJsStatus$Failure$.MODULE$.code() != n3) throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n3));
                    object = syntax$.MODULE$.EffectOps(this.stringPromises.fail((Object)descriptor4, (Throwable)new ClientSideException(json2)), evidence$1).after(() -> this.$init$$$anonfun$5$$anonfun$5(descriptor4));
                }
                return object;
            } else if (Frontend$CallbackType$CustomCallback$.MODULE$.code() == n) {
                Object object5;
                String args = string;
                String[] stringArray = args.split(":", 2);
                if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object5 = Array$.MODULE$.unapplySeq((Object)stringArray), 2) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String string10 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object5, 0);
                String string11 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object5, 1);
                String name = string10;
                String arg = string11;
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)name, (Object)arg);
                String name2 = (String)tuple23._1();
                String arg2 = (String)tuple23._2();
                Option option = this.customCallbacks.get((Object)name2);
                if (option instanceof Some) {
                    Function1 f = (Function1)((Some)option).value();
                    object = f.apply((Object)arg2);
                    return object;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    object = Effect$.MODULE$.apply(evidence$1).unit();
                }
                return object;
            } else {
                int callbackType = n;
                String args = string;
                object = Effect$.MODULE$.apply(evidence$1).fail((Throwable)new UnknownCallbackException(callbackType, args));
            }
            return object;
        }), evidence$1).runAsyncForget(reporter);
    }

    public Stream<F, String> outgoingMessages() {
        return this.outgoingMessages;
    }

    public Stream<F, DomEventMessage> domEventMessages() {
        return this.domEventMessages;
    }

    public Stream<F, PathAndQuery> browserHistoryMessages() {
        return this.browserHistoryMessages;
    }

    private F sendRaw(String str) {
        return (F)this.outgoingQueue.enqueue((Object)str);
    }

    private F send(Seq<Object> args) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        args.foreach((Function1 & Serializable)x$1 -> {
            StringBuilder stringBuilder;
            Object object = x$1;
            if (object instanceof String) {
                String s = (String)object;
                sb.append('\"');
                package$.MODULE$.jsonEscape(sb, s, true);
                sb.append('\"');
                stringBuilder = sb.append(',');
            } else {
                Object x = object;
                sb.append(x.toString());
                stringBuilder = sb.append(',');
            }
            return stringBuilder;
        });
        sb.update(sb.length() - 1, ' ');
        sb.append(']');
        return this.sendRaw(sb.result());
    }

    public F listenEvent(String name, boolean preventDefault) {
        return this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$ListenEvent$.MODULE$.code()), name, BoxesRunTime.boxToBoolean((boolean)preventDefault)}));
    }

    public F uploadForm(Id id) {
        return (F)syntax$.MODULE$.EffectOps(this.nextDescriptor(), this.evidence$1).flatMap((Function1 & Serializable)descriptor -> syntax$.MODULE$.EffectOps(this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$UploadForm$.MODULE$.code()), id.mkString(), descriptor})), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return syntax$.MODULE$.EffectOps(this.formDataPromises.get(descriptor), this.evidence$1).map((Function1 & Serializable)result -> result);
        }));
    }

    public F listFiles(Id id) {
        return (F)syntax$.MODULE$.EffectOps(this.nextDescriptor(), this.evidence$1).flatMap((Function1 & Serializable)descriptor -> syntax$.MODULE$.EffectOps(this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$ListFiles$.MODULE$.code()), id.mkString(), descriptor})), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return syntax$.MODULE$.EffectOps(this.fileNamePromises.get(descriptor), this.evidence$1).map((Function1 & Serializable)files -> files);
        }));
    }

    public F uploadFile(Id id, Context.FileHandler handler) {
        return (F)syntax$.MODULE$.EffectOps(this.nextDescriptor(), this.evidence$1).flatMap((Function1 & Serializable)descriptor -> syntax$.MODULE$.EffectOps(this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$UploadFile$.MODULE$.code()), id.mkString(), descriptor, handler.fileName()})), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return syntax$.MODULE$.EffectOps(this.filesPromises.get(descriptor), this.evidence$1).map((Function1 & Serializable)file -> file);
        }));
    }

    public F downloadFile(String name, Stream<F, Bytes> stream, Option<Object> size, String mimeType) {
        Tuple2 tuple2 = stream.handleConsumed();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object consumed = tuple2._1();
        Stream updatedStream = (Stream)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(consumed, (Object)updatedStream);
        Object consumed2 = tuple22._1();
        Stream updatedStream2 = (Stream)tuple22._2();
        String id = BoxesRunTime.boxToInteger((int)this.lastDescriptor.getAndIncrement()).toString();
        syntax$.MODULE$.EffectOps(consumed2, this.evidence$1).runAsync((Function1)(JProcedure1 & Serializable)_$2 -> this.downloadFiles.remove((Object)name));
        this.downloadFiles.put((Object)id, Frontend$DownloadFileMeta$.MODULE$.apply(updatedStream2, size, mimeType, this.evidence$1));
        return this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$DownloadFile$.MODULE$.code()), id, name}));
    }

    public F resolveFileDownload(String descriptor) {
        return (F)Effect$.MODULE$.apply(this.evidence$1).delay(() -> this.resolveFileDownload$$anonfun$1(descriptor));
    }

    public F focus(Id id) {
        return this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$Focus$.MODULE$.code()), id.mkString()}));
    }

    private F nextDescriptor() {
        return (F)Effect$.MODULE$.apply(this.evidence$1).delay(this::nextDescriptor$$anonfun$1);
    }

    public F extractProperty(Id id, String name) {
        return (F)syntax$.MODULE$.EffectOps(this.nextDescriptor(), this.evidence$1).flatMap((Function1 & Serializable)descriptor -> syntax$.MODULE$.EffectOps(this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$ExtractProperty$.MODULE$.code()), descriptor, id.mkString(), name})), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return syntax$.MODULE$.EffectOps(this.stringPromises.get(descriptor), this.evidence$1).map((Function1 & Serializable)result -> result);
        }));
    }

    public F setProperty(Id id, String name, Object value) {
        return this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$ModifyDom$.MODULE$.code()), BoxesRunTime.boxToInteger((int)Frontend$ModifyDomProcedure$SetAttr$.MODULE$.code()), id.mkString(), BoxesRunTime.boxToInteger((int)0), name, value, BoxesRunTime.boxToBoolean((boolean)true)}));
    }

    public F evalJs(String code) {
        return (F)syntax$.MODULE$.EffectOps(this.nextDescriptor(), this.evidence$1).flatMap((Function1 & Serializable)descriptor -> syntax$.MODULE$.EffectOps(this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$EvalJs$.MODULE$.code()), descriptor, code})), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return syntax$.MODULE$.EffectOps(this.stringPromises.get(descriptor), this.evidence$1).map((Function1 & Serializable)result -> result);
        }));
    }

    public F resetForm(Id id) {
        return this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$RestForm$.MODULE$.code()), id.mkString()}));
    }

    public F changePageUrl(PathAndQuery pq) {
        return this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$ChangePageUrl$.MODULE$.code()), pq.mkString()}));
    }

    public F setRenderNum(int i) {
        return this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$SetRenderNum$.MODULE$.code()), BoxesRunTime.boxToInteger((int)i)}));
    }

    public F reload() {
        return this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$Reload$.MODULE$.code())}));
    }

    public F reloadCss() {
        return this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$ReloadCss$.MODULE$.code())}));
    }

    public F extractEventData(int renderNum) {
        return (F)syntax$.MODULE$.EffectOps(this.nextDescriptor(), this.evidence$1).flatMap((Function1 & Serializable)descriptor -> syntax$.MODULE$.EffectOps(this.send((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Frontend$Procedure$ExtractEventData$.MODULE$.code()), descriptor, BoxesRunTime.boxToInteger((int)renderNum)})), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return syntax$.MODULE$.EffectOps(this.stringPromises.get(descriptor), this.evidence$1).map((Function1 & Serializable)result -> result);
        }));
    }

    public F performDomChanges(Function1<DiffRenderContext.FastChangesPerformer, BoxedUnit> f) {
        return (F)syntax$.MODULE$.EffectOps(this.avgDiffTime.get() > 50000000L ? Effect$.MODULE$.apply(this.evidence$1).blocking(() -> this.performDomChanges$$anonfun$1(f), this.ec) : Effect$.MODULE$.apply(this.evidence$1).delay(() -> this.performDomChanges$$anonfun$2(f)), this.evidence$1).flatMap((Function1 & Serializable)result -> syntax$.MODULE$.EffectOps(this.sendRaw((String)result), this.evidence$1).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)this::performDomChanges$$anonfun$3$$anonfun$1$$anonfun$1)), this.evidence$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
            });
        }));
    }

    public F resolveFile(String descriptor, Stream<F, Bytes> file) {
        return (F)syntax$.MODULE$.EffectOps(this.filesPromises.put((Object)descriptor, file), this.evidence$1).after(() -> this.resolveFile$$anonfun$1(descriptor));
    }

    public F resolveFileNames(String descriptor, List<Tuple2<String, Object>> handler) {
        return (F)syntax$.MODULE$.EffectOps(this.fileNamePromises.put((Object)descriptor, handler), this.evidence$1).after(() -> this.resolveFileNames$$anonfun$1(descriptor));
    }

    public F resolveFormData(String descriptor, Either<Throwable, FormData> formData) {
        return (F)syntax$.MODULE$.EffectOps(this.formDataPromises.putEither((Object)descriptor, formData, this.formDataPromises.putEither$default$3()), this.evidence$1).after(() -> this.resolveFormData$$anonfun$1(descriptor));
    }

    public F registerCustomCallback(String name, Function1<String, F> f) {
        return (F)Effect$.MODULE$.apply(this.evidence$1).delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.registerCustomCallback$$anonfun$1(name, f)));
    }

    private String unescapeJsonString(String s) {
        int charsConsumed;
        StringBuilder sb = new StringBuilder();
        int len = s.length() - 1;
        block10: for (int i = 1; i < len; i += charsConsumed) {
            StringBuilder stringBuilder;
            char c = s.charAt(i);
            charsConsumed = 0;
            if (c != '\\') {
                charsConsumed = 1;
                stringBuilder = sb.append(c);
                continue;
            }
            charsConsumed = 2;
            char c2 = s.charAt(i + 1);
            switch (c2) {
                case '\\': {
                    stringBuilder = sb.append('\\');
                    continue block10;
                }
                case '\"': {
                    stringBuilder = sb.append('\"');
                    continue block10;
                }
                case 'b': {
                    stringBuilder = sb.append('\b');
                    continue block10;
                }
                case 'f': {
                    stringBuilder = sb.append('\f');
                    continue block10;
                }
                case 'n': {
                    stringBuilder = sb.append('\n');
                    continue block10;
                }
                case 'r': {
                    stringBuilder = sb.append('\r');
                    continue block10;
                }
                case 't': {
                    stringBuilder = sb.append('\t');
                    continue block10;
                }
                case 'u': {
                    String code = s.substring(i + 2, i + 6);
                    charsConsumed = 6;
                    stringBuilder = sb.append((char)Integer.parseInt(code, 16));
                    continue block10;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c2));
                }
            }
        }
        return sb.result();
    }

    private Tuple2<Object, String> parseMessage(String json) {
        String[] tokens = json.substring(1, json.length() - 1).split(",", 2);
        String callbackType = tokens[0];
        String args = tokens.length > 1 ? this.unescapeJsonString(tokens[1]) : "";
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(callbackType))), (Object)args);
    }

    private final Object $init$$$anonfun$5$$anonfun$1(String descriptor$1) {
        return this.stringPromises.remove((Object)descriptor$1);
    }

    private final Object $init$$$anonfun$5$$anonfun$2(String descriptor$2) {
        return this.stringPromises.remove((Object)descriptor$2);
    }

    private final Object $init$$$anonfun$5$$anonfun$3(String descriptor$3) {
        return this.stringPromises.remove((Object)descriptor$3);
    }

    private final Object $init$$$anonfun$5$$anonfun$4(String descriptor$4) {
        return this.stringPromises.remove((Object)descriptor$4);
    }

    private final Object $init$$$anonfun$5$$anonfun$5(String descriptor$5) {
        return this.stringPromises.remove((Object)descriptor$5);
    }

    private final Option resolveFileDownload$$anonfun$1(String descriptor$9) {
        return this.downloadFiles.get((Object)descriptor$9);
    }

    private final String nextDescriptor$$anonfun$1() {
        return BoxesRunTime.boxToInteger((int)this.lastDescriptor.getAndIncrement()).toString();
    }

    private final String diff$1(Function1 f$1) {
        long timeStart = System.nanoTime();
        StringBuilder sb = this.remoteDomChangesPerformer.buffer();
        sb.append('[');
        sb.append(Frontend$Procedure$ModifyDom$.MODULE$.codeString());
        sb.append(',');
        try {
            f$1.apply((Object)this.remoteDomChangesPerformer);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        sb.update(sb.length() - 1, ' ');
        sb.append(']');
        String result = this.remoteDomChangesPerformer.buffer().result();
        long timeEnd = System.nanoTime();
        long timeTotal = timeEnd - timeStart;
        Metrics$.MODULE$.MaxDiffNanos().update((Function1<Object, Object>)(JFunction1.mcJJ.sp & Serializable)prev -> Math.max(prev, timeTotal));
        Metrics$.MODULE$.MinDiffNanos().update((Function1<Object, Object>)(JFunction1.mcJJ.sp & Serializable)prev -> prev == 0L ? timeTotal : Math.min(prev, timeTotal));
        this.avgDiffTime.set((this.avgDiffTime.get() + timeTotal) / 2L);
        return result;
    }

    private final String performDomChanges$$anonfun$1(Function1 f$3) {
        return this.diff$1(f$3);
    }

    private final String performDomChanges$$anonfun$2(Function1 f$4) {
        return this.diff$1(f$4);
    }

    private final void performDomChanges$$anonfun$3$$anonfun$1$$anonfun$1() {
        this.remoteDomChangesPerformer.buffer().clear();
    }

    private final Object resolveFile$$anonfun$1(String descriptor$13) {
        return this.filesPromises.remove((Object)descriptor$13);
    }

    private final Object resolveFileNames$$anonfun$1(String descriptor$14) {
        return this.fileNamePromises.remove((Object)descriptor$14);
    }

    private final Object resolveFormData$$anonfun$1(String descriptor$15) {
        return this.formDataPromises.remove((Object)descriptor$15);
    }

    private final void registerCustomCallback$$anonfun$1(String name$3, Function1 f$2) {
        this.customCallbacks.put((Object)name$3, (Object)f$2);
    }

    public static abstract class CallbackType {
        private final int code;

        public static Set<CallbackType> All() {
            return Frontend$CallbackType$.MODULE$.All();
        }

        public static Option<CallbackType> apply(int n) {
            return Frontend$CallbackType$.MODULE$.apply(n);
        }

        public static int ordinal(CallbackType callbackType) {
            return Frontend$CallbackType$.MODULE$.ordinal(callbackType);
        }

        public CallbackType(int code) {
            this.code = code;
        }

        public final int code() {
            return this.code;
        }
    }

    public static class ClientSideException
    extends Exception {
        public ClientSideException(String message) {
            super(message);
        }
    }

    public static final class DomEventMessage
    implements Product,
    Serializable {
        private final int renderNum;
        private final Id target;
        private final String eventType;

        public static DomEventMessage apply(int n, Id id, String string) {
            return Frontend$DomEventMessage$.MODULE$.apply(n, id, string);
        }

        public static DomEventMessage fromProduct(Product product) {
            return Frontend$DomEventMessage$.MODULE$.fromProduct(product);
        }

        public static DomEventMessage unapply(DomEventMessage domEventMessage) {
            return Frontend$DomEventMessage$.MODULE$.unapply(domEventMessage);
        }

        public DomEventMessage(int renderNum, Id target, String eventType) {
            this.renderNum = renderNum;
            this.target = target;
            this.eventType = eventType;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.renderNum());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.target()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.eventType()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DomEventMessage)) return false;
            DomEventMessage domEventMessage = (DomEventMessage)object;
            if (this.renderNum() != domEventMessage.renderNum()) return false;
            Id id = this.target();
            Id id2 = domEventMessage.target();
            if (id == null) {
                if (id2 != null) {
                    return false;
                }
            } else if (!id.equals(id2)) return false;
            String string = this.eventType();
            String string2 = domEventMessage.eventType();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DomEventMessage;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "DomEventMessage";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "renderNum";
                    break;
                }
                case 1: {
                    string = "target";
                    break;
                }
                case 2: {
                    string = "eventType";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public int renderNum() {
            return this.renderNum;
        }

        public Id target() {
            return this.target;
        }

        public String eventType() {
            return this.eventType;
        }

        public DomEventMessage copy(int renderNum, Id target, String eventType) {
            return new DomEventMessage(renderNum, target, eventType);
        }

        public int copy$default$1() {
            return this.renderNum();
        }

        public Id copy$default$2() {
            return this.target();
        }

        public String copy$default$3() {
            return this.eventType();
        }

        public int _1() {
            return this.renderNum();
        }

        public Id _2() {
            return this.target();
        }

        public String _3() {
            return this.eventType();
        }
    }

    public static final class DownloadFileMeta<F>
    implements Product,
    Serializable {
        private final Stream stream;
        private final Option size;
        private final String mimeType;

        public static <F> DownloadFileMeta<F> apply(Stream<F, Bytes> stream, Option<Object> option, String string, Effect<F> effect) {
            return Frontend$DownloadFileMeta$.MODULE$.apply(stream, option, string, effect);
        }

        public static <F> DownloadFileMeta<F> unapply(DownloadFileMeta<F> downloadFileMeta) {
            return Frontend$DownloadFileMeta$.MODULE$.unapply(downloadFileMeta);
        }

        public DownloadFileMeta(Stream<F, Bytes> stream, Option<Object> size, String mimeType, Effect<F> evidence$2) {
            this.stream = stream;
            this.size = size;
            this.mimeType = mimeType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DownloadFileMeta)) return false;
            DownloadFileMeta downloadFileMeta = (DownloadFileMeta)object;
            Stream<F, Bytes> stream = this.stream();
            Stream<F, Bytes> stream2 = downloadFileMeta.stream();
            if (stream == null) {
                if (stream2 != null) {
                    return false;
                }
            } else if (!stream.equals(stream2)) return false;
            Option<Object> option = this.size();
            Option<Object> option2 = downloadFileMeta.size();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            String string = this.mimeType();
            String string2 = downloadFileMeta.mimeType();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DownloadFileMeta;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "DownloadFileMeta";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "stream";
                    break;
                }
                case 1: {
                    string = "size";
                    break;
                }
                case 2: {
                    string = "mimeType";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Stream<F, Bytes> stream() {
            return this.stream;
        }

        public Option<Object> size() {
            return this.size;
        }

        public String mimeType() {
            return this.mimeType;
        }

        public <F> DownloadFileMeta<F> copy(Stream<F, Bytes> stream, Option<Object> size, String mimeType, Effect<F> evidence$2) {
            return new DownloadFileMeta<F>(stream, size, mimeType, evidence$2);
        }

        public <F> Stream<F, Bytes> copy$default$1() {
            return this.stream();
        }

        public <F> Option<Object> copy$default$2() {
            return this.size();
        }

        public <F> String copy$default$3() {
            return this.mimeType();
        }

        public Stream<F, Bytes> _1() {
            return this.stream();
        }

        public Option<Object> _2() {
            return this.size();
        }

        public String _3() {
            return this.mimeType();
        }
    }

    public static abstract class EvalJsStatus {
        private final int code;

        public static int ordinal(EvalJsStatus evalJsStatus) {
            return Frontend$EvalJsStatus$.MODULE$.ordinal(evalJsStatus);
        }

        public EvalJsStatus(int code) {
            this.code = code;
        }

        public final int code() {
            return this.code;
        }
    }

    public static abstract class ModifyDomProcedure {
        private final int code;
        private final String codeString;

        public static int ordinal(ModifyDomProcedure modifyDomProcedure) {
            return Frontend$ModifyDomProcedure$.MODULE$.ordinal(modifyDomProcedure);
        }

        public ModifyDomProcedure(int code) {
            this.code = code;
            this.codeString = BoxesRunTime.boxToInteger((int)code).toString();
        }

        public final int code() {
            return this.code;
        }

        public final String codeString() {
            return this.codeString;
        }
    }

    public static abstract class Procedure {
        private final int code;
        private final String codeString;

        public static Set<Procedure> All() {
            return Frontend$Procedure$.MODULE$.All();
        }

        public static Option<Procedure> apply(int n) {
            return Frontend$Procedure$.MODULE$.apply(n);
        }

        public static int ordinal(Procedure procedure) {
            return Frontend$Procedure$.MODULE$.ordinal(procedure);
        }

        public Procedure(int code) {
            this.code = code;
            this.codeString = BoxesRunTime.boxToInteger((int)code).toString();
        }

        public final int code() {
            return this.code;
        }

        public final String codeString() {
            return this.codeString;
        }
    }

    public static abstract class PropertyType {
        private final int code;

        public static int ordinal(PropertyType propertyType) {
            return Frontend$PropertyType$.MODULE$.ordinal(propertyType);
        }

        public PropertyType(int code) {
            this.code = code;
        }

        public final int code() {
            return this.code;
        }
    }

    public static class UnknownCallbackException
    extends Exception {
        public UnknownCallbackException(int callbackType, String args) {
            super(new java.lang.StringBuilder(39).append("Unknown callback ").append(callbackType).append(" with args '").append(args).append("' received").toString());
        }
    }
}

