/*
 * Decompiled with CFR 0.152.
 */
package korolev.server.internal.services;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import korolev.Qsid;
import korolev.data.Bytes;
import korolev.data.Bytes$;
import korolev.data.BytesLike;
import korolev.data.BytesLike$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Queue;
import korolev.effect.Queue$;
import korolev.effect.Reporter;
import korolev.effect.Stream;
import korolev.effect.Stream$;
import korolev.effect.syntax$;
import korolev.internal.ApplicationInstance;
import korolev.internal.Frontend$;
import korolev.server.internal.package$;
import korolev.server.internal.services.CommonService;
import korolev.server.internal.services.MessagingService$;
import korolev.server.internal.services.SessionsService;
import korolev.server.package$WebSocketResponse$;
import korolev.web.Request;
import korolev.web.Response;
import korolev.web.Response$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MessagingService<F> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MessagingService.class.getDeclaredField("0bitmap$1"));
    public long 0bitmap$1;
    private final Reporter reporter;
    private final SessionsService<F, ?, ?> sessionsService;
    private final Effect<F> evidence$1;
    private ThreadLocal inflaters$lzy1;
    private ThreadLocal deflaters$lzy1;
    private ThreadLocal compressionInputBuffers$lzy1;
    private ThreadLocal compressionOutputBuffers$lzy1;
    private final Function1<Bytes, String> wsJsonDeflateDecoder;
    private final Function1<String, Bytes> wsJsonDeflateEncoder;
    private final Function1<Bytes, String> wsJsonDecoder;
    private final Function1<String, Bytes> wsJsonEncoder;
    private final TrieMap<Qsid, Queue<F, String>> longPollingTopics;
    private final Seq<Tuple2<String, String>> commonResponseHeaders;
    private final Response<Stream<F, Bytes>> commonOkResponse;
    private final Response<Stream<F, Bytes>> commonGoneResponse;

    public static <F> Object SomeReloadMessageF(Effect<F> effect) {
        return MessagingService$.MODULE$.SomeReloadMessageF(effect);
    }

    public MessagingService(Reporter reporter, CommonService<F> commonService, SessionsService<F, ?, ?> sessionsService, Effect<F> evidence$1) {
        this.reporter = reporter;
        this.sessionsService = sessionsService;
        this.evidence$1 = evidence$1;
        this.wsJsonDeflateDecoder = (Function1 & Serializable)bytes -> {
            ByteBuffer inputBuffer = this.compressionInputBuffers().get();
            ByteBuffer outputBuffer = this.compressionOutputBuffers().get();
            Inflater inflater = this.inflaters().get();
            inputBuffer.clear();
            outputBuffer.clear();
            inflater.reset();
            bytes.copyToBuffer(inputBuffer);
            inputBuffer.flip();
            inflater.setInput(inputBuffer);
            inflater.inflate(outputBuffer);
            outputBuffer.flip();
            return StandardCharsets.UTF_8.decode(outputBuffer).toString();
        };
        this.wsJsonDeflateEncoder = (Function1 & Serializable)message -> {
            CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
            ByteBuffer inputBuffer = this.compressionInputBuffers().get();
            ByteBuffer outputBuffer = this.compressionOutputBuffers().get();
            Deflater deflatter = this.deflaters().get();
            inputBuffer.clear();
            outputBuffer.clear();
            deflatter.reset();
            CharBuffer chars = CharBuffer.wrap(message);
            encoder.encode(chars, inputBuffer, true);
            inputBuffer.flip();
            deflatter.setInput(inputBuffer);
            deflatter.finish();
            deflatter.deflate(outputBuffer, 2);
            outputBuffer.flip();
            byte[] array = new byte[outputBuffer.remaining()];
            outputBuffer.get(array);
            return Bytes$.MODULE$.wrap((Object)array, (BytesLike)BytesLike.ArrayBytesLikeInstance$.MODULE$);
        };
        this.wsJsonDecoder = (Function1 & Serializable)bytes -> bytes.asUtf8String();
        this.wsJsonEncoder = (Function1 & Serializable)message -> (Bytes)BytesLike$.MODULE$.apply((BytesLike)Bytes.BytesBytesLikeInstance$.MODULE$).utf8(message);
        this.longPollingTopics = TrieMap$.MODULE$.empty();
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"cache-control");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"no-cache");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"content-type");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"application/json");
        this.commonResponseHeaders = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.commonOkResponse = Response$.MODULE$.apply(Response.Status$.MODULE$.Ok(), (Object)Stream$.MODULE$.empty(evidence$1), this.commonResponseHeaders, (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)));
        this.commonGoneResponse = Response$.MODULE$.apply(Response.Status$.MODULE$.Gone(), (Object)Stream$.MODULE$.empty(evidence$1), this.commonResponseHeaders, (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L)));
    }

    public F longPollingSubscribe(Qsid qsid, Request.Head rh) {
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.createAppIfNeeded(qsid, rh, this.createTopic(qsid)), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable)maybeApp -> syntax$.MODULE$.EffectOps(maybeApp.fold(this::longPollingSubscribe$$anonfun$1$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$2 -> _$2.frontend().outgoingMessages().pull()), this.evidence$1).flatMap((Function1 & Serializable)maybeMessage -> {
                Object object;
                Option option = maybeMessage;
                if (None$.MODULE$.equals(option)) {
                    object = Effect$.MODULE$.apply(this.evidence$1).pure(this.commonGoneResponse);
                } else if (option instanceof Some) {
                    String message = (String)((Some)option).value();
                    object = package$.MODULE$.HttpResponse(Response.Status$.MODULE$.Ok(), message, this.commonResponseHeaders, this.evidence$1);
                } else {
                    throw new MatchError((Object)option);
                }
                return syntax$.MODULE$.EffectOps(object, this.evidence$1).map((Function1 & Serializable)response -> response);
            }));
        });
    }

    public F longPollingPublish(Qsid qsid, Stream<F, Bytes> data) {
        return (F)syntax$.MODULE$.EffectOps(this.takeTopic(qsid), this.evidence$1).flatMap((Function1 & Serializable)topic -> syntax$.MODULE$.EffectOps(syntax$.MODULE$.EffectOps(data.fold((Object)Bytes$.MODULE$.empty(), (Function2 & Serializable)(_$3, _$4) -> _$3.$plus$plus(_$4)), this.evidence$1).map((Function1 & Serializable)_$5 -> _$5.asUtf8String()), this.evidence$1).flatMap((Function1 & Serializable)message -> syntax$.MODULE$.EffectOps(topic.enqueue(message), this.evidence$1).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.commonOkResponse;
        })));
    }

    private ThreadLocal<Inflater> inflaters() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    ThreadLocal<Inflater> threadLocal;
                    this.inflaters$lzy1 = threadLocal = ThreadLocal.withInitial(() -> new Inflater(true));
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return threadLocal;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.inflaters$lzy1;
    }

    private ThreadLocal<Deflater> deflaters() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                try {
                    ThreadLocal<Deflater> threadLocal;
                    this.deflaters$lzy1 = threadLocal = ThreadLocal.withInitial(() -> new Deflater(-1, true));
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                    return threadLocal;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
        }
        return this.deflaters$lzy1;
    }

    private ThreadLocal<ByteBuffer> compressionInputBuffers() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 2)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 2)) continue;
                try {
                    ThreadLocal<ByteBuffer> threadLocal;
                    this.compressionInputBuffers$lzy1 = threadLocal = ThreadLocal.withInitial(() -> ByteBuffer.allocate(0xA00000));
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 2);
                    return threadLocal;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 2);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 2);
        }
        return this.compressionInputBuffers$lzy1;
    }

    private ThreadLocal<ByteBuffer> compressionOutputBuffers() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 3)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 3)) continue;
                try {
                    ThreadLocal<ByteBuffer> threadLocal;
                    this.compressionOutputBuffers$lzy1 = threadLocal = ThreadLocal.withInitial(() -> ByteBuffer.allocate(0xA00000));
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 3);
                    return threadLocal;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 3);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 3);
        }
        return this.compressionOutputBuffers$lzy1;
    }

    public F webSocketMessaging(Qsid qsid, Request.Head rh, Stream<F, Bytes> incomingMessages, Seq<String> protocols) {
        Tuple3 tuple3 = protocols.contains((Object)MessagingService$.korolev$server$internal$services$MessagingService$$$ProtocolJsonDeflate) ? Tuple3$.MODULE$.apply((Object)MessagingService$.korolev$server$internal$services$MessagingService$$$ProtocolJsonDeflate, this.wsJsonDeflateDecoder, this.wsJsonDeflateEncoder) : Tuple3$.MODULE$.apply((Object)MessagingService$.korolev$server$internal$services$MessagingService$$$ProtocolJson, this.wsJsonDecoder, this.wsJsonEncoder);
        String selectedProtocol = (String)tuple3._1();
        Function1 decoder = (Function1)tuple3._2();
        Function1 encoder = (Function1)tuple3._3();
        return (F)syntax$.MODULE$.EffectOps(this.sessionsService.createAppIfNeeded(qsid, rh, incomingMessages.map(decoder)), this.evidence$1).flatMap((Function1 & Serializable)_$6 -> syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ApplicationInstance app = (ApplicationInstance)((Some)option).value();
                Response httpResponse = Response$.MODULE$.apply(Response.Status$.MODULE$.Ok(), (Object)app.frontend().outgoingMessages().map(encoder), (Seq)scala.package$.MODULE$.Nil(), (Option)None$.MODULE$);
                return Effect$.MODULE$.apply(this.evidence$1).pure(package$WebSocketResponse$.MODULE$.apply(httpResponse, selectedProtocol));
            }
            if (None$.MODULE$.equals(option)) {
                return syntax$.MODULE$.EffectOps(Stream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Frontend$.MODULE$.ReloadMessage()})).mat(this.evidence$1), this.evidence$1).map((Function1 & Serializable)messages -> {
                    Response httpResponse = Response$.MODULE$.apply(Response.Status$.MODULE$.Ok(), (Object)messages.map(encoder), (Seq)scala.package$.MODULE$.Nil(), (Option)None$.MODULE$);
                    return package$WebSocketResponse$.MODULE$.apply(httpResponse, selectedProtocol);
                });
            }
            throw new MatchError((Object)option);
        }));
    }

    private F takeTopic(Qsid qsid) {
        return (F)Effect$.MODULE$.apply(this.evidence$1).delay(() -> this.takeTopic$$anonfun$1(qsid));
    }

    private Stream<F, String> createTopic(Qsid qsid) {
        this.reporter.debug(new StringBuilder(30).append("Create long-polling topic for ").append(qsid).toString());
        Queue topic = Queue$.MODULE$.apply(Queue$.MODULE$.apply$default$1(), this.evidence$1);
        syntax$.MODULE$.EffectOps(topic.cancelSignal(), this.evidence$1).runAsync((Function1)(JProcedure1 & Serializable)_$7 -> this.longPollingTopics.remove((Object)qsid));
        this.longPollingTopics.putIfAbsent((Object)qsid, (Object)topic);
        return topic.stream();
    }

    private final Object longPollingSubscribe$$anonfun$1$$anonfun$1$$anonfun$1() {
        return MessagingService$.MODULE$.SomeReloadMessageF(this.evidence$1);
    }

    private final Queue takeTopic$$anonfun$1(Qsid qsid$3) {
        if (this.longPollingTopics.contains((Object)qsid$3)) {
            return (Queue)this.longPollingTopics.apply((Object)qsid$3);
        }
        throw new Exception(new StringBuilder(40).append("There is no long-polling topic matching ").append(qsid$3).toString());
    }
}

