/*
 * Decompiled with CFR 0.152.
 */
package korolev.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.internal.DevMode$;
import korolev.state.StateDeserializer;
import korolev.state.StateManager;
import korolev.state.StateSerializer;
import korolev.state.StateStorage$;
import levsha.Id;
import levsha.Id$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

public abstract class StateStorage<F, S> {
    public static <F, S> StateStorage<F, S> apply(int n, Effect<F> effect, StateSerializer<S> stateSerializer) {
        return StateStorage$.MODULE$.apply(n, effect, stateSerializer);
    }

    public static <F, S> int apply$default$1() {
        return StateStorage$.MODULE$.apply$default$1();
    }

    public StateStorage(Effect<F> evidence$1) {
    }

    public abstract F exists(String var1, String var2);

    public abstract F create(String var1, String var2, S var3);

    public abstract F get(String var1, String var2);

    public abstract void remove(String var1, String var2);

    public static final class DefaultStateStorage<F, S>
    extends StateStorage<F, S> {
        public final int korolev$state$StateStorage$DefaultStateStorage$$forDeletionCacheCapacity;
        private final Effect<F> evidence$2;
        private final StateSerializer<S> evidence$3;
        private final TrieMap<String, StateManager<F>> cache;
        private final LinkedHashMap<String, StateManager<F>> forDeletionCache;

        public DefaultStateStorage(int forDeletionCacheCapacity, Effect<F> evidence$2, StateSerializer<S> evidence$3) {
            this.korolev$state$StateStorage$DefaultStateStorage$$forDeletionCacheCapacity = forDeletionCacheCapacity;
            this.evidence$2 = evidence$2;
            this.evidence$3 = evidence$3;
            super(evidence$2);
            this.cache = TrieMap$.MODULE$.empty();
            this.forDeletionCache = new LinkedHashMap<String, StateManager<F>>(this){
                private final /* synthetic */ DefaultStateStorage $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.korolev$state$StateStorage$DefaultStateStorage$$forDeletionCacheCapacity, 0.7f, true);
                }

                public boolean removeEldestEntry(Map.Entry entry) {
                    return this.size() > this.$outer.korolev$state$StateStorage$DefaultStateStorage$$forDeletionCacheCapacity;
                }
            };
        }

        public String mkKey(String deviceId, String sessionId) {
            return new StringBuilder(1).append(deviceId).append("-").append(sessionId).toString();
        }

        @Override
        public F exists(String deviceId, String sessionId) {
            String key = this.mkKey(deviceId, sessionId);
            if (DevMode$.MODULE$.isActive()) {
                File file = new File(DevMode$.MODULE$.sessionsDirectory(), key);
                boolean result = this.cache.contains((Object)key) || this.forDeletionCache.containsKey(key) || file.exists();
                return (F)Effect$.MODULE$.apply(this.evidence$2).delay(() -> this.exists$$anonfun$1(result));
            }
            boolean result = this.cache.contains((Object)key) || this.forDeletionCache.containsKey(key);
            return (F)Effect$.MODULE$.apply(this.evidence$2).delay(() -> this.exists$$anonfun$2(result));
        }

        @Override
        public F get(String deviceId, String sessionId) {
            String key = this.mkKey(deviceId, sessionId);
            Option option = this.cache.get((Object)key);
            if (None$.MODULE$.equals(option)) {
                StateManager stateManager;
                LinkedHashMap<String, StateManager<F>> linkedHashMap = this.forDeletionCache;
                synchronized (linkedHashMap) {
                    stateManager = (StateManager)this.forDeletionCache.remove(key);
                }
                Option option2 = Option$.MODULE$.apply((Object)stateManager);
                if (option2 instanceof Some) {
                    StateManager sm = (StateManager)((Some)option2).value();
                    return (F)Effect$.MODULE$.apply(this.evidence$2).delay(() -> this.get$$anonfun$1(key, sm));
                }
                if (None$.MODULE$.equals(option2)) {
                    if (DevMode$.MODULE$.isActive()) {
                        File directory = new File(DevMode$.MODULE$.sessionsDirectory(), key);
                        if (directory.exists()) {
                            DevModeStateManager<F> sm = new DevModeStateManager<F>(directory, this.evidence$2);
                            this.cache.put((Object)key, sm);
                            return (F)Effect$.MODULE$.apply(this.evidence$2).delay(() -> this.get$$anonfun$2(sm));
                        }
                        return (F)this.errored$1(deviceId, sessionId);
                    }
                    return (F)this.errored$1(deviceId, sessionId);
                }
                throw new MatchError((Object)option2);
            }
            if (option instanceof Some) {
                StateManager sm = (StateManager)((Some)option).value();
                return (F)Effect$.MODULE$.apply(this.evidence$2).delay(() -> this.get$$anonfun$3(sm));
            }
            throw new MatchError((Object)option);
        }

        @Override
        public F create(String deviceId, String sessionId, S state) {
            String key = this.mkKey(deviceId, sessionId);
            if (DevMode$.MODULE$.isActive()) {
                File directory = new File(DevMode$.MODULE$.sessionsDirectory(), key);
                DevModeStateManager<F> sm = new DevModeStateManager<F>(directory, this.evidence$2);
                this.cache.put((Object)key, sm);
                if (directory.exists()) {
                    return (F)Effect$.MODULE$.apply(this.evidence$2).delay(() -> this.create$$anonfun$1(sm));
                }
                return (F)Effect$.MODULE$.apply(this.evidence$2).map(sm.write(Id$.MODULE$.TopLevel(), state, this.evidence$3), (Function1 & Serializable)_$3 -> sm);
            }
            SimpleInMemoryStateManager<F> sm = new SimpleInMemoryStateManager<F>(this.evidence$2);
            this.cache.put((Object)key, sm);
            return (F)Effect$.MODULE$.apply(this.evidence$2).map(sm.write(Id$.MODULE$.TopLevel(), state, this.evidence$3), (Function1 & Serializable)_$4 -> sm);
        }

        @Override
        public void remove(String deviceId, String sessionId) {
            String key = this.mkKey(deviceId, sessionId);
            this.cache.remove((Object)key).foreach((Function1 & Serializable)sm -> {
                StateManager stateManager;
                LinkedHashMap<String, StateManager<F>> linkedHashMap = this.forDeletionCache;
                synchronized (linkedHashMap) {
                    stateManager = this.forDeletionCache.put(key, (StateManager<F>)sm);
                }
                return stateManager;
            });
        }

        private final boolean exists$$anonfun$1(boolean result$1) {
            return result$1;
        }

        private final boolean exists$$anonfun$2(boolean result$2) {
            return result$2;
        }

        private final Object errored$1(String deviceId$1, String sessionId$1) {
            return Effect$.MODULE$.apply(this.evidence$2).fail((Throwable)new NoSuchElementException(new StringBuilder(23).append("There is no state for ").append(deviceId$1).append("/").append(sessionId$1).toString()));
        }

        private final StateManager get$$anonfun$1(String key$1, StateManager sm$1) {
            this.cache.put((Object)key$1, (Object)sm$1);
            return sm$1;
        }

        private final StateManager get$$anonfun$2(DevModeStateManager sm$2) {
            return sm$2;
        }

        private final StateManager get$$anonfun$3(StateManager sm$3) {
            return sm$3;
        }

        private final StateManager create$$anonfun$1(DevModeStateManager sm$4) {
            return sm$4;
        }
    }

    public static final class DevModeStateManager<F>
    extends StateManager<F> {
        public final File korolev$state$StateStorage$DevModeStateManager$$directory;
        private final Effect<F> evidence$4;

        public DevModeStateManager(File directory, Effect<F> evidence$4) {
            this.korolev$state$StateStorage$DevModeStateManager$$directory = directory;
            this.evidence$4 = evidence$4;
            super(evidence$4);
        }

        public File getStateFile(Id node) {
            return new File(this.korolev$state$StateStorage$DevModeStateManager$$directory, node.mkString());
        }

        public Option<File> getStateFileOpt(Id node) {
            File file = this.getStateFile(node);
            if (file.exists()) {
                return Some$.MODULE$.apply((Object)file);
            }
            return None$.MODULE$;
        }

        @Override
        public F snapshot() {
            return (F)Effect$.MODULE$.apply(this.evidence$4).delay(this::snapshot$$anonfun$1);
        }

        @Override
        public <T> F read(Id nodeId, StateDeserializer<T> evidence$8) {
            return (F)Effect$.MODULE$.apply(this.evidence$4).delay(() -> this.read$$anonfun$1(nodeId, evidence$8));
        }

        @Override
        public F delete(Id nodeId) {
            return (F)Effect$.MODULE$.apply(this.evidence$4).delay((Function0 & Serializable)() -> {
                this.delete$$anonfun$1(nodeId);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public <T> F write(Id nodeId, T value, StateSerializer<T> evidence$9) {
            return (F)Effect$.MODULE$.apply(this.evidence$4).delay((Function0 & Serializable)() -> {
                this.write$$anonfun$1(nodeId, value, evidence$9);
                return BoxedUnit.UNIT;
            });
        }

        public byte[] readFile(File file) {
            FileInputStream stream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            stream.read(data);
            return data;
        }

        private final StateManager.Snapshot snapshot$$anonfun$1() {
            return new StateManager.Snapshot(this){
                private final Map cache;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    if (!$outer.korolev$state$StateStorage$DevModeStateManager$$directory.exists()) {
                        $outer.korolev$state$StateStorage$DevModeStateManager$$directory.mkdirs();
                    }
                    Object object = Predef$.MODULE$.refArrayOps((Object[])$outer.korolev$state$StateStorage$DevModeStateManager$$directory.listFiles());
                    this.cache = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, arg_0 -> StateStorage$.korolev$state$StateStorage$DevModeStateManager$$anon$2$$_$$lessinit$greater$$anonfun$1($outer, arg_0), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                }

                public Map cache() {
                    return this.cache;
                }

                public Option apply(Id nodeId, StateDeserializer evidence$12) {
                    return this.cache().get((Object)nodeId).flatMap(arg_0 -> StateStorage$.korolev$state$StateStorage$DevModeStateManager$$anon$2$$_$apply$$anonfun$1(evidence$12, arg_0));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{korolev$state$StateStorage$DevModeStateManager$$anon$2$$_$$lessinit$greater$$anonfun$1(korolev.state.StateStorage$DevModeStateManager java.io.File ), korolev$state$StateStorage$DevModeStateManager$$anon$2$$_$apply$$anonfun$1(korolev.state.StateDeserializer byte[] )}, serializedLambda);
                }
            };
        }

        private final Option read$$anonfun$1(Id nodeId$1, StateDeserializer evidence$8$1) {
            return this.getStateFileOpt(nodeId$1).flatMap((Function1 & Serializable)file -> {
                byte[] data = this.readFile((File)file);
                return ((StateDeserializer)Predef$.MODULE$.implicitly((Object)evidence$8$1)).deserialize(data);
            });
        }

        private final void delete$$anonfun$1(Id nodeId$2) {
            File file = this.getStateFile(nodeId$2);
            file.delete();
        }

        private final void write$$anonfun$1(Id nodeId$3, Object value$1, StateSerializer evidence$9$1) {
            File file = this.getStateFile(nodeId$3);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileOutputStream outputStream = new FileOutputStream(file);
            byte[] data = ((StateSerializer)Predef$.MODULE$.implicitly((Object)evidence$9$1)).serialize(value$1);
            outputStream.write(data);
        }
    }

    public static final class SimpleInMemoryStateManager<F>
    extends StateManager<F> {
        private final Effect<F> evidence$5;
        private final TrieMap cache;
        private final Object snapshot;

        public SimpleInMemoryStateManager(Effect<F> evidence$5) {
            this.evidence$5 = evidence$5;
            super(evidence$5);
            this.cache = TrieMap$.MODULE$.empty();
            this.snapshot = Effect$.MODULE$.apply(evidence$5).pure((Object)new StateManager.Snapshot(this){
                private final /* synthetic */ SimpleInMemoryStateManager $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Option apply(Id nodeId, StateDeserializer evidence$13) {
                    None$ none$;
                    try {
                        none$ = this.$outer.cache().get((Object)nodeId);
                    }
                    catch (ClassCastException classCastException) {
                        none$ = None$.MODULE$;
                    }
                    return none$;
                }
            });
        }

        public TrieMap<Id, Object> cache() {
            return this.cache;
        }

        @Override
        public F snapshot() {
            return (F)this.snapshot;
        }

        @Override
        public <T> F read(Id nodeId, StateDeserializer<T> evidence$10) {
            return (F)Effect$.MODULE$.apply(this.evidence$5).map(this.snapshot(), (Function1 & Serializable)_$7 -> _$7.apply(nodeId, evidence$10));
        }

        @Override
        public F delete(Id nodeId) {
            return (F)Effect$.MODULE$.apply(this.evidence$5).delay((Function0 & Serializable)() -> {
                this.delete$$anonfun$2(nodeId);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public <T> F write(Id nodeId, T value, StateSerializer<T> evidence$11) {
            return (F)Effect$.MODULE$.apply(this.evidence$5).delay((Function0 & Serializable)() -> {
                this.write$$anonfun$2(nodeId, value);
                return BoxedUnit.UNIT;
            });
        }

        private final void delete$$anonfun$2(Id nodeId$5) {
            this.cache().remove((Object)nodeId$5);
        }

        private final void write$$anonfun$2(Id nodeId$6, Object value$2) {
            this.cache().put((Object)nodeId$6, value$2);
        }
    }
}

