/*
 * Decompiled with CFR 0.152.
 */
package korolev.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import korolev.Component;
import korolev.Context;
import korolev.Qsid;
import korolev.Router;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Hub;
import korolev.effect.Hub$;
import korolev.effect.Queue;
import korolev.effect.Queue$;
import korolev.effect.Reporter;
import korolev.effect.Scheduler;
import korolev.effect.Scheduler$;
import korolev.effect.Stream;
import korolev.effect.syntax;
import korolev.effect.syntax$;
import korolev.internal.ComponentInstance;
import korolev.internal.DevMode;
import korolev.internal.EventRegistry;
import korolev.internal.Frontend;
import korolev.state.StateDeserializer;
import korolev.state.StateManager;
import korolev.state.StateSerializer;
import korolev.web.Path;
import korolev.web.PathAndQuery;
import levsha.Document;
import levsha.Id;
import levsha.Id$;
import levsha.StatefulRenderContext;
import levsha.XmlNs$;
import levsha.events$;
import levsha.impl.DiffRenderContext;
import levsha.impl.DiffRenderContext$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.MapView;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public final class ApplicationInstance<F, S, M> {
    private final Frontend frontend;
    private final StateManager<F> stateManager;
    public final S korolev$internal$ApplicationInstance$$initialState;
    public final Function1<S, Document.Node<Context.Binding<F, S, M>>> korolev$internal$ApplicationInstance$$render;
    private final Path rootPath;
    private final Router<F, S> router;
    public final Reporter korolev$internal$ApplicationInstance$$reporter;
    public final PartialFunction<Throwable, Function1<S, S>> korolev$internal$ApplicationInstance$$recovery;
    private final FiniteDuration delayedRender;
    private final Effect<F> evidence$1;
    private final StateSerializer<S> evidence$2;
    private final StateDeserializer<S> evidence$3;
    private final ExecutionContext ec;
    private final DevMode.ForRenderContext devMode;
    private final TrieMap<Tuple2<Id, String>, Object> eventCounters;
    private final Queue<F, Tuple3<Id, Object, Option<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>> stateQueue;
    private final Queue<F, M> messagesQueue;
    private final DiffRenderContext<Context.Binding<F, S, M>> renderContext;
    private final ComponentInstance topLevelComponentInstance;
    private final Stream<F, Tuple3<Id, Object, Option<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>> internalStateStream;
    private final Object stateStream;
    private final Stream messagesStream;

    public ApplicationInstance(Qsid sessionId, Frontend<F> frontend, StateManager<F> stateManager, S initialState, Function1<S, Document.Node<Context.Binding<F, S, M>>> render, Path rootPath, Router<F, S> router, Function2<StatefulRenderContext<Context.Binding<F, S, M>>, Function2<StatefulRenderContext<Context.Binding<F, S, M>>, Context.Binding<F, S, M>, BoxedUnit>, StatefulRenderContext<Context.Binding<F, S, M>>> createMiscProxy, Scheduler<F> scheduler, Reporter reporter, PartialFunction<Throwable, Function1<S, S>> recovery, FiniteDuration delayedRender, Effect<F> evidence$1, StateSerializer<S> evidence$2, StateDeserializer<S> evidence$3, ExecutionContext ec) {
        this.frontend = frontend;
        this.stateManager = stateManager;
        this.korolev$internal$ApplicationInstance$$initialState = initialState;
        this.korolev$internal$ApplicationInstance$$render = render;
        this.rootPath = rootPath;
        this.router = router;
        this.korolev$internal$ApplicationInstance$$reporter = reporter;
        this.korolev$internal$ApplicationInstance$$recovery = recovery;
        this.delayedRender = delayedRender;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.evidence$3 = evidence$3;
        this.ec = ec;
        this.devMode = new DevMode.ForRenderContext(sessionId.toString());
        this.eventCounters = new TrieMap();
        this.stateQueue = Queue$.MODULE$.apply(Queue$.MODULE$.apply$default$1(), evidence$1);
        Hub stateHub = Hub$.MODULE$.apply(this.stateQueue.stream(), Hub$.MODULE$.apply$default$2(), evidence$1);
        this.messagesQueue = Queue$.MODULE$.apply(Queue$.MODULE$.apply$default$1(), evidence$1);
        Option<ByteBuffer> option = this.devMode.loadRenderContext();
        Function2 function2 = DiffRenderContext$.MODULE$.apply$default$1();
        int n = DiffRenderContext$.MODULE$.apply$default$2();
        this.renderContext = DiffRenderContext$.MODULE$.apply(function2, n, option);
        EventRegistry<F> eventRegistry = new EventRegistry<F>(frontend, evidence$1, reporter.Implicit());
        Component component = new Component<F, S, Object, M>(this){
            private final /* synthetic */ ApplicationInstance $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.korolev$internal$ApplicationInstance$$initialState, "top-level");
            }

            public Document.Node render(Object parameters, Object state) {
                Document.Node node;
                try {
                    node = (Document.Node)this.$outer.korolev$internal$ApplicationInstance$$render.apply(state);
                }
                catch (MatchError e) {
                    node = Document.Node$.MODULE$.apply((Function1)(JProcedure1 & Serializable)rc -> {
                        this.$outer.korolev$internal$ApplicationInstance$$reporter.error(new StringBuilder(26).append("Render is not defined for ").append(state).toString());
                        rc.openNode(XmlNs$.MODULE$.html(), "html");
                        rc.openNode(XmlNs$.MODULE$.html(), "body");
                        rc.addTextNode("Render is not defined for the state. ");
                        rc.addTextNode(e.getMessage());
                        rc.closeNode("body");
                        rc.closeNode("html");
                    });
                }
                return node;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{render$$anonfun$1(java.lang.Object scala.MatchError levsha.RenderContext )}, serializedLambda);
            }
        };
        ComponentInstance componentInstance = new ComponentInstance(Id$.MODULE$.TopLevel(), sessionId, frontend, eventRegistry, stateManager, component, this.stateQueue, createMiscProxy, scheduler, reporter, (PartialFunction<Throwable, Object>)new Serializable(this){
            private final /* synthetic */ ApplicationInstance $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable != null) {
                    Throwable ex = throwable;
                    return this.$outer.topLevelComponentInstance().browserAccess().transition((Function1)this.$outer.korolev$internal$ApplicationInstance$$recovery.apply((Object)ex));
                }
                return function1.apply((Object)x);
            }
        }, evidence$1, evidence$2, evidence$3, evidence$2, evidence$3);
        componentInstance.setEventsSubscription((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)this.messagesQueue.offerUnsafe(item)));
        this.topLevelComponentInstance = componentInstance;
        this.internalStateStream = stateHub.newStreamUnsafe();
        Object object = syntax$.MODULE$.EffectOps(stateHub.newStream());
        this.stateStream = syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)stream -> stream.map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                Id id = (Id)tuple3._1();
                Object state = tuple3._2();
                return Tuple2$.MODULE$.apply((Object)id, state);
            }
            throw new MatchError((Object)tuple3);
        }), evidence$1);
        this.messagesStream = this.messagesQueue.stream();
    }

    public Frontend<F> frontend() {
        return this.frontend;
    }

    public ComponentInstance<F, S, M, S, Object, M> topLevelComponentInstance() {
        return this.topLevelComponentInstance;
    }

    private F saveRenderContextIfNecessary() {
        if (this.devMode.isActive()) {
            return (F)Effect$.MODULE$.apply(this.evidence$1).delay((Function0 & Serializable)() -> {
                this.saveRenderContextIfNecessary$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }
        return (F)Effect$.MODULE$.apply(this.evidence$1).unit();
    }

    private F onState(Seq<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> maybeRenderCallback) {
        Object object = syntax$.MODULE$.EffectOps(this.stateManager.snapshot());
        return (F)syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)snapshot -> {
            Object object = syntax$.MODULE$.EffectOps(((Option)this.router.fromState().lift().apply(snapshot.apply(Id$.MODULE$.TopLevel(), this.evidence$3).getOrElse(this::onState$$anonfun$1$$anonfun$1))).fold(this::onState$$anonfun$1$$anonfun$2, (Function1 & Serializable)uri -> this.frontend().changePageUrl(this.rootPath.$plus$plus(uri))));
            return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay((Function0 & Serializable)() -> {
                    this.onState$$anonfun$1$$anonfun$4$$anonfun$1((StateManager.Snapshot)snapshot);
                    return BoxedUnit.UNIT;
                }));
                return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = syntax$.MODULE$.EffectOps(this.frontend().performDomChanges((Function1<DiffRenderContext.ChangesPerformer, BoxedUnit>)(JProcedure1 & Serializable)performer -> this.renderContext.diff(performer)));
                    return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        Object object = syntax$.MODULE$.EffectOps(this.saveRenderContextIfNecessary());
                        return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            Object object = syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay((Function0 & Serializable)() -> {
                                this.onState$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1();
                                return BoxedUnit.UNIT;
                            }));
                            Object object2 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit;
                                BoxedUnit boxedUnit2;
                                BoxedUnit $1$ = boxedUnit2 = BoxedUnit.UNIT;
                                maybeRenderCallback.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.apply((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)));
                                BoxedUnit $2$ = boxedUnit = BoxedUnit.UNIT;
                                BoxedUnit $2$2 = BoxedUnit.UNIT;
                                return Tuple2$.MODULE$.apply((Object)$1$, (Object)$2$2);
                            }, this.evidence$1));
                            return syntax.EffectOps$.MODULE$.map$extension(object2, (Function1)(JProcedure1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    return;
                                }
                                throw new MatchError((Object)tuple2);
                            }, this.evidence$1);
                        }, this.evidence$1);
                    }, this.evidence$1);
                }, this.evidence$1);
            }, this.evidence$1);
        }, this.evidence$1);
    }

    private F onHistory(PathAndQuery pq) {
        Object object = syntax$.MODULE$.EffectOps(this.stateManager.read(Id$.MODULE$.TopLevel(), this.evidence$3));
        Object object2 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)maybeTopLevelState -> ((Option)this.router.toState().lift().apply((Object)pq)).fold(this::onHistory$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$3 -> {
            Object object = syntax$.MODULE$.EffectOps(_$3.apply(maybeTopLevelState.getOrElse(this::onHistory$$anonfun$1$$anonfun$2$$anonfun$1)));
            return syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$4 -> Some$.MODULE$.apply(_$4), this.evidence$1);
        }), this.evidence$1));
        return (F)syntax.EffectOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Object newState = ((Some)option).value();
                Object object = syntax$.MODULE$.EffectOps(this.stateManager.write(Id$.MODULE$.TopLevel(), newState, this.evidence$2));
                return syntax.EffectOps$.MODULE$.after$extension(object, () -> this.onHistory$$anonfun$2$$anonfun$1(newState), this.evidence$1);
            }
            if (None$.MODULE$.equals(option)) {
                return Effect$.MODULE$.apply(this.evidence$1).unit();
            }
            throw new MatchError((Object)option);
        }, this.evidence$1);
    }

    private F onEvent(Frontend.DomEventMessage dem) {
        Tuple2 k = Tuple2$.MODULE$.apply((Object)dem.target(), (Object)dem.eventType());
        Object object = syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay(() -> this.onEvent$$anonfun$1(k)));
        Object object2 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)eventCounter -> this.onEvent$$anonfun$2(dem, k, BoxesRunTime.unboxToInt((Object)eventCounter)), this.evidence$1));
        Object object3 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.recover$extension(object2, (PartialFunction)new Serializable(dem, this){
            private final Frontend.DomEventMessage dem$7;
            private final /* synthetic */ ApplicationInstance $outer;
            {
                this.dem$7 = dem$10;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable error = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable error = throwable = x;
                this.$outer.korolev$internal$ApplicationInstance$$reporter.error(new StringBuilder(24).append("Unable to process event ").append(this.dem$7).toString(), error);
                return BoxedUnit.UNIT;
            }
        }, this.evidence$1));
        Object object4 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.start$extension(object3, this.ec, this.evidence$1));
        return (F)syntax.EffectOps$.MODULE$.unit$extension(object4, this.evidence$1);
    }

    public F stateStream() {
        return (F)this.stateStream;
    }

    public Stream<F, M> messagesStream() {
        return this.messagesStream;
    }

    public F destroy() {
        Object object = syntax$.MODULE$.EffectOps(this.stateQueue.close());
        return (F)syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object object = syntax$.MODULE$.EffectOps(this.messagesQueue.close());
            return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = syntax$.MODULE$.EffectOps(this.topLevelComponentInstance().destroy());
                return syntax.EffectOps$.MODULE$.map$extension(object, (Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }, this.evidence$1);
            }, this.evidence$1);
        }, this.evidence$1);
    }

    public F initialize(ExecutionContext ec) {
        if (this.devMode.saved()) {
            Object object = syntax$.MODULE$.EffectOps(this.frontend().resetEventCounters());
            return (F)syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = syntax$.MODULE$.EffectOps(this.reloadCssIfNecessary$1());
                return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay((Function0 & Serializable)() -> {
                        this.initialize$$anonfun$1$$anonfun$1$$anonfun$1();
                        return BoxedUnit.UNIT;
                    }));
                    return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        Object object = syntax$.MODULE$.EffectOps(this.render$1((Function1 & Serializable)f -> this.frontend().performDomChanges((Function1<DiffRenderContext.ChangesPerformer, BoxedUnit>)f)));
                        return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            Object object = syntax$.MODULE$.EffectOps(this.topLevelComponentInstance().initialize(ec));
                            return syntax.EffectOps$.MODULE$.map$extension(object, (Function1)(JProcedure1 & Serializable)x$1 -> {
                                Effect.Fiber fiber = x$1;
                            }, this.evidence$1);
                        }, this.evidence$1);
                    }, this.evidence$1);
                }, this.evidence$1);
            }, this.evidence$1);
        }
        Object object = syntax$.MODULE$.EffectOps(this.frontend().resetEventCounters());
        return (F)syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object object = syntax$.MODULE$.EffectOps(this.reloadCssIfNecessary$1());
            return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = syntax$.MODULE$.EffectOps(this.render$1((Function1 & Serializable)f -> Effect$.MODULE$.apply(this.evidence$1).delay((Function0 & Serializable)() -> {
                    ApplicationInstance.initialize$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(f);
                    return BoxedUnit.UNIT;
                })));
                return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = syntax$.MODULE$.EffectOps(this.frontend().browserHistoryMessages().foreach((Function1 & Serializable)pq -> this.onHistory((PathAndQuery)pq)));
                    Object object2 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.start$extension(object, ec, this.evidence$1));
                    return syntax.EffectOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)x$12 -> {
                        Effect.Fiber fiber = x$12;
                        Object object = syntax$.MODULE$.EffectOps(this.frontend().domEventMessages().foreach((Function1 & Serializable)dem -> this.onEvent((Frontend.DomEventMessage)dem)));
                        Object object2 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.start$extension(object, ec, this.evidence$1));
                        return syntax.EffectOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)x$1 -> {
                            Object object;
                            Effect.Fiber fiber = x$1;
                            if (this.delayedRender.toMillis() > 0L) {
                                Object object2 = syntax$.MODULE$.EffectOps(this.internalStateStream.buffer(this.delayedRender, this.internalStateStream.buffer$default$2(), Scheduler$.MODULE$.schedulerF(this.evidence$1), ec, this.korolev$internal$ApplicationInstance$$reporter.Implicit()).foreach((Function1 & Serializable)xs -> this.onState((Seq<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>)((Seq)xs.flatMap((Function1 & Serializable)_$5 -> (IterableOnce)_$5._3())))));
                                object = syntax.EffectOps$.MODULE$.start$extension(object2, ec, this.evidence$1);
                            } else {
                                Object object3 = syntax$.MODULE$.EffectOps(this.internalStateStream.foreach((Function1 & Serializable)x -> this.onState((Seq<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>)Option$.MODULE$.option2Iterable((Option)x._3()).toSeq())));
                                object = syntax.EffectOps$.MODULE$.start$extension(object3, ec, this.evidence$1);
                            }
                            Object object4 = syntax$.MODULE$.EffectOps(object);
                            return syntax.EffectOps$.MODULE$.flatMap$extension(object4, (Function1 & Serializable)x$12 -> {
                                Effect.Fiber fiber = x$12;
                                Object object = syntax$.MODULE$.EffectOps(this.topLevelComponentInstance().initialize(ec));
                                return syntax.EffectOps$.MODULE$.map$extension(object, (Function1)(JProcedure1 & Serializable)x$1 -> {
                                    Effect.Fiber fiber = x$1;
                                }, this.evidence$1);
                            }, this.evidence$1);
                        }, this.evidence$1);
                    }, this.evidence$1);
                }, this.evidence$1);
            }, this.evidence$1);
        }, this.evidence$1);
    }

    private final void saveRenderContextIfNecessary$$anonfun$1() {
        this.devMode.saveRenderContext(this.renderContext);
    }

    private final Object onState$$anonfun$1$$anonfun$1() {
        return this.korolev$internal$ApplicationInstance$$initialState;
    }

    private final Object onState$$anonfun$1$$anonfun$2() {
        return Effect$.MODULE$.apply(this.evidence$1).unit();
    }

    private final void onState$$anonfun$1$$anonfun$4$$anonfun$1(StateManager.Snapshot snapshot$2) {
        this.renderContext.swap();
        this.topLevelComponentInstance().applyRenderContext(BoxedUnit.UNIT, (StatefulRenderContext<Context.Binding<F, S, M>>)this.renderContext, snapshot$2);
    }

    private final void onState$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1() {
        this.topLevelComponentInstance().dropObsoleteMisc();
    }

    private static final Option onHistory$$anonfun$1$$anonfun$1$$anonfun$1() {
        return Option$.MODULE$.empty();
    }

    private final Object onHistory$$anonfun$1$$anonfun$1() {
        return Effect$.MODULE$.apply(this.evidence$1).delay(ApplicationInstance::onHistory$$anonfun$1$$anonfun$1$$anonfun$1);
    }

    private final Object onHistory$$anonfun$1$$anonfun$2$$anonfun$1() {
        return this.korolev$internal$ApplicationInstance$$initialState;
    }

    private final Object onHistory$$anonfun$2$$anonfun$1(Object newState$1) {
        return this.stateQueue.enqueue((Object)Tuple3$.MODULE$.apply((Object)Id$.MODULE$.TopLevel(), newState$1, (Object)None$.MODULE$));
    }

    private final /* synthetic */ Object aux$1$$anonfun$1(Frontend.DomEventMessage dem$2, List xs$1, boolean stopPropagation) {
        if (stopPropagation) {
            return Effect$.MODULE$.apply(this.evidence$1).unit();
        }
        return this.aux$1(dem$2, xs$1);
    }

    private final Object aux$1(Frontend.DomEventMessage dem$1, List effects) {
        List list = effects;
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Effect$.MODULE$.apply(this.evidence$1).unit();
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            Function1 effect = (Function1)colon2.head();
            List xs = list3;
            Object object = syntax$.MODULE$.EffectOps(effect.apply((Object)dem$1));
            return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)stopPropagation -> this.aux$1$$anonfun$1(dem$1, xs, BoxesRunTime.unboxToBoolean((Object)stopPropagation)), this.evidence$1);
        }
        throw new MatchError((Object)list);
    }

    private static final int onEvent$$anonfun$1$$anonfun$1() {
        return 0;
    }

    private final int onEvent$$anonfun$1(Tuple2 k$1) {
        return BoxesRunTime.unboxToInt((Object)this.eventCounters.getOrElse((Object)k$1, ApplicationInstance::onEvent$$anonfun$1$$anonfun$1));
    }

    private static final Vector $anonfun$2$$anonfun$1() {
        return package$.MODULE$.Vector().empty();
    }

    private final Option onEvent$$anonfun$2$$anonfun$2$$anonfun$1(Tuple2 k$4, int newEventConter$1) {
        return this.eventCounters.put((Object)k$4, (Object)BoxesRunTime.boxToInteger((int)newEventConter$1));
    }

    private final /* synthetic */ Object onEvent$$anonfun$2(Frontend.DomEventMessage dem$3, Tuple2 k$2, int eventCounter) {
        Predef$.MODULE$.println((Object)new StringBuilder(45).append("processing ").append(dem$3).append(". eventCounter=").append(eventCounter).append(", dem.eventCounter=").append(dem$3.eventCounter()).toString());
        if (eventCounter == dem$3.eventCounter()) {
            Seq propagation = events$.MODULE$.calculateEventPropagation(dem$3.target(), dem$3.eventType());
            MapView allHandlers = this.topLevelComponentInstance().allEventHandlers();
            List allEffects = propagation.toList().flatMap((Function1 & Serializable)eventId -> (IterableOnce)allHandlers.getOrElse(eventId, ApplicationInstance::$anonfun$2$$anonfun$1));
            Predef$.MODULE$.println((Object)new StringBuilder(16).append("handlers found: ").append(allEffects).toString());
            if (allEffects.nonEmpty()) {
                Object object = syntax$.MODULE$.EffectOps(this.aux$1(dem$3, allEffects));
                Object object2 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit;
                    BoxedUnit $3$ = boxedUnit = BoxedUnit.UNIT;
                    int newEventConter = dem$3.eventCounter() + 1;
                    return Tuple2$.MODULE$.apply((Object)$3$, (Object)BoxesRunTime.boxToInteger((int)newEventConter));
                }, this.evidence$1));
                return syntax.EffectOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        int newEventConter = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        Object object = syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay(() -> this.onEvent$$anonfun$2$$anonfun$2$$anonfun$1(k$2, newEventConter)));
                        return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                            Option option = x$12;
                            Object object = syntax$.MODULE$.EffectOps(this.frontend().setEventCounter(dem$3.target(), dem$3.eventType(), newEventConter));
                            return syntax.EffectOps$.MODULE$.map$extension(object, (Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }, this.evidence$1);
                        }, this.evidence$1);
                    }
                    throw new MatchError((Object)tuple2);
                }, this.evidence$1);
            }
            return Effect$.MODULE$.apply(this.evidence$1).unit();
        }
        return Effect$.MODULE$.apply(this.evidence$1).unit();
    }

    private final Object reloadCssIfNecessary$1() {
        if (this.devMode.isActive()) {
            return this.frontend().reloadCss();
        }
        return Effect$.MODULE$.apply(this.evidence$1).unit();
    }

    private final void render$1$$anonfun$1$$anonfun$1(StateManager.Snapshot snapshot$3) {
        this.topLevelComponentInstance().applyRenderContext(BoxedUnit.UNIT, (StatefulRenderContext<Context.Binding<F, S, M>>)this.renderContext, snapshot$3);
    }

    private final Object render$1(Function1 performDiff) {
        Object object = syntax$.MODULE$.EffectOps(this.stateManager.snapshot());
        return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)snapshot -> {
            Object object = syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay((Function0 & Serializable)() -> {
                this.render$1$$anonfun$1$$anonfun$1((StateManager.Snapshot)snapshot);
                return BoxedUnit.UNIT;
            }));
            return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = syntax$.MODULE$.EffectOps(performDiff.apply((JProcedure1 & Serializable)performer -> this.renderContext.diff(performer)));
                return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = syntax$.MODULE$.EffectOps(this.saveRenderContextIfNecessary());
                    return syntax.EffectOps$.MODULE$.map$extension(object, (Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }, this.evidence$1);
                }, this.evidence$1);
            }, this.evidence$1);
        }, this.evidence$1);
    }

    private final void initialize$$anonfun$1$$anonfun$1$$anonfun$1() {
        this.renderContext.swap();
    }

    private static final void initialize$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Function1 f$1) {
        f$1.apply((Object)DiffRenderContext.DummyChangesPerformer$.MODULE$);
    }
}

