/*
 * Decompiled with CFR 0.152.
 */
package korolev.server.internal.services;

import java.io.Serializable;
import korolev.Qsid;
import korolev.data.Bytes;
import korolev.data.Bytes$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Reporter;
import korolev.effect.Stream;
import korolev.effect.syntax;
import korolev.effect.syntax$;
import korolev.internal.ApplicationInstance;
import korolev.internal.Frontend;
import korolev.internal.Frontend$DownloadFileMeta$;
import korolev.server.internal.FormDataCodec;
import korolev.server.internal.services.CommonService;
import korolev.server.internal.services.SessionsService;
import korolev.web.FormData;
import korolev.web.Response;
import korolev.web.Response$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;

public final class PostService<F> {
    private final SessionsService<F, ?, ?> sessionsService;
    private final CommonService<F> commonService;
    private final FormDataCodec formDataCodec;
    private final Effect<F> evidence$1;
    private final ExecutionContext ec;

    public PostService(Reporter reporter, SessionsService<F, ?, ?> sessionsService, CommonService<F> commonService, FormDataCodec formDataCodec, Effect<F> evidence$1, ExecutionContext ec) {
        this.sessionsService = sessionsService;
        this.commonService = commonService;
        this.formDataCodec = formDataCodec;
        this.evidence$1 = evidence$1;
        this.ec = ec;
    }

    public F formData(Qsid qsid, String descriptor, Seq<Tuple2<String, String>> headers, Stream<F, Bytes> data) {
        Object object = syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid));
        return (F)syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ApplicationInstance app = (ApplicationInstance)((Some)option).value();
                Object object = syntax$.MODULE$.EffectOps(data.fold((Object)Bytes$.MODULE$.empty(), (Function2 & Serializable)(_$6, _$7) -> _$6.$plus$plus(_$7)));
                return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)formBytes -> {
                    Object object = syntax$.MODULE$.EffectOps(this.extractBoundary$1(headers));
                    return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)boundary -> {
                        Object object = syntax$.MODULE$.EffectOps(this.parseFormData$1((Bytes)formBytes, (String)boundary));
                        return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)errorOrFormData -> {
                            Object object = syntax$.MODULE$.EffectOps(app.frontend().resolveFormData(descriptor, (Either<Throwable, FormData>)errorOrFormData));
                            return syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return this.commonService.simpleOkResponse();
                            }, this.evidence$1);
                        }, this.evidence$1);
                    }, this.evidence$1);
                }, this.evidence$1);
            }
            if (None$.MODULE$.equals(option)) {
                return this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            }
            throw new MatchError((Object)option);
        }, this.evidence$1);
    }

    public F filesInfo(Qsid qsid, String descriptor, Stream<F, Bytes> body) {
        Object object = syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid));
        return (F)syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ApplicationInstance app = (ApplicationInstance)((Some)option).value();
                Object object = syntax$.MODULE$.EffectOps(body.fold((Object)Bytes$.MODULE$.empty(), (Function2 & Serializable)(_$8, _$9) -> _$8.$plus$plus(_$9)));
                Object object2 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$10 -> _$10.asUtf8String(), this.evidence$1));
                Object object3 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.map$extension(object2, (Function1 & Serializable)message -> {
                    List sizes = message.isEmpty() ? package$.MODULE$.List().empty() : PostService.parseFilesInfo$1(message);
                    return Tuple2$.MODULE$.apply(message, (Object)sizes);
                }, this.evidence$1));
                return syntax.EffectOps$.MODULE$.flatMap$extension(object3, (Function1 & Serializable)x$12 -> {
                    Tuple2 tuple2 = x$12;
                    if (tuple2 != null) {
                        String message = (String)tuple2._1();
                        List sizes = (List)tuple2._2();
                        Object object = syntax$.MODULE$.EffectOps(app.frontend().resolveFileNames(descriptor, (List<Tuple2<String, Object>>)sizes));
                        return syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return this.commonService.simpleOkResponse();
                        }, this.evidence$1);
                    }
                    throw new MatchError((Object)tuple2);
                }, this.evidence$1);
            }
            if (None$.MODULE$.equals(option)) {
                return this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            }
            throw new MatchError((Object)option);
        }, this.evidence$1);
    }

    public F downloadFile(Qsid qsid, String descriptor) {
        Object object = syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid));
        return (F)syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
            Option option = x$12;
            if (option instanceof Some) {
                ApplicationInstance app = (ApplicationInstance)((Some)option).value();
                Object object = syntax$.MODULE$.EffectOps(app.frontend().resolveFileDownload(descriptor));
                return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                    Frontend.DownloadFileMeta downloadFileMeta;
                    Option option = x$1;
                    if (option instanceof Some && (downloadFileMeta = (Frontend.DownloadFileMeta)((Some)option).value()) != null) {
                        Frontend.DownloadFileMeta downloadFileMeta2 = Frontend$DownloadFileMeta$.MODULE$.unapply(downloadFileMeta);
                        Stream stream = downloadFileMeta2._1();
                        Option<Object> option2 = downloadFileMeta2._2();
                        String string = downloadFileMeta2._3();
                        Stream stream2 = stream;
                        Option<Object> maybeLength = option2;
                        String mimeType = string;
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Content-Type");
                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)mimeType);
                        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Accept-Ranges");
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"none");
                        List headers = package$.MODULE$.Nil().$colon$colon((Object)tuple22).$colon$colon((Object)tuple2);
                        Response response = Response$.MODULE$.apply(Response.Status$.MODULE$.Ok(), stream2, (Seq)headers, maybeLength);
                        return Effect$.MODULE$.apply(this.evidence$1).pure((Object)response);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return this.commonService.notFoundResponseF();
                    }
                    throw new MatchError((Object)option);
                }, this.evidence$1);
            }
            if (None$.MODULE$.equals(option)) {
                return this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            }
            throw new MatchError((Object)option);
        }, this.evidence$1);
    }

    public F uploadFile(Qsid qsid, String descriptor, Seq<Tuple2<String, String>> headers, Stream<F, Bytes> body) {
        Tuple2 tuple2 = body.handleConsumed();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object consumed = tuple2._1();
        Stream chunks = (Stream)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(consumed, (Object)chunks);
        Object consumed2 = tuple22._1();
        Stream chunks2 = (Stream)tuple22._2();
        Object object = syntax$.MODULE$.EffectOps(this.sessionsService.getApp(qsid));
        return (F)syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ApplicationInstance app = (ApplicationInstance)((Some)option).value();
                Object object = syntax$.MODULE$.EffectOps(app.frontend().resolveFile(descriptor, chunks2));
                return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = syntax$.MODULE$.EffectOps(consumed2);
                    return syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.commonService.simpleOkResponse();
                    }, this.evidence$1);
                }, this.evidence$1);
            }
            if (None$.MODULE$.equals(option)) {
                return this.commonService.badRequest(this.ErrorSessionNotFound(qsid));
            }
            throw new MatchError((Object)option);
        }, this.evidence$1);
    }

    private String ErrorSessionNotFound(Qsid qsid) {
        return new StringBuilder(36).append("There is no app instance matched to ").append(qsid).toString();
    }

    private final Object extractBoundary$1$$anonfun$2() {
        return Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)new Exception("Content-Type should be `multipart/form-data`"));
    }

    private final Object extractBoundary$1(Seq headers$1) {
        Effect effect = Effect$.MODULE$.apply(this.evidence$1);
        return headers$1.collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = k.toLowerCase();
                    String string2 = "content-type";
                    if (!(string != null ? !string.equals(string2) : string2 != null) && v.contains("multipart/form-data")) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = k.toLowerCase();
                    String string2 = "content-type";
                    if (!(string != null ? !string.equals(string2) : string2 != null) && v.contains("multipart/form-data")) {
                        return v;
                    }
                }
                return function1.apply((Object)x);
            }
        }).flatMap((Function1 & Serializable)_$2 -> Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(_$2), ';')).toList().filter((Function1 & Serializable)_$3 -> StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(_$3), '=')).map((Function1 & Serializable)_$4 -> Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(_$4), '=')).toList().map((Function1 & Serializable)_$5 -> _$5.trim())).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(List x) {
                List list = x;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list2 = colon2.next$access$1();
                    if ("boundary".equals(colon2.head()) && list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        List list3 = colon3.next$access$1();
                        String s = (String)colon3.head();
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list4 = list3;
                        if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                            return true;
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(List x, Function1 function1) {
                List list = x;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list2 = colon2.next$access$1();
                    if ("boundary".equals(colon2.head()) && list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        List list3 = colon3.next$access$1();
                        String s = (String)colon3.head();
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list4 = list3;
                        if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                            return s;
                        }
                    }
                }
                return function1.apply((Object)x);
            }
        })).fold(this::extractBoundary$1$$anonfun$2, (Function1 & Serializable)value -> effect.pure(value));
    }

    private final Either parseFormData$1$$anonfun$1$$anonfun$1(Bytes formBytes$2, String boundary$2) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)this.formDataCodec.decode(formBytes$2.asBuffer(), boundary$2));
        }
        catch (Throwable error) {
            left = package$.MODULE$.Left().apply((Object)error);
        }
        return left;
    }

    private final Object parseFormData$1$$anonfun$1(Bytes formBytes$1, String boundary$1) {
        return Effect$.MODULE$.apply(this.evidence$1).delay(() -> this.parseFormData$1$$anonfun$1$$anonfun$1(formBytes$1, boundary$1));
    }

    private final Object parseFormData$1(Bytes formBytes, String boundary) {
        return Effect$.MODULE$.apply(this.evidence$1).fork(() -> this.parseFormData$1$$anonfun$1(formBytes, boundary), this.ec);
    }

    private static final List parseFilesInfo$1(String message) {
        return Predef$.MODULE$.wrapRefArray((Object[])message.split("\n")).toList().map((Function1 & Serializable)entry -> {
            int slash = entry.lastIndexOf(47);
            return Tuple2$.MODULE$.apply((Object)entry.substring(0, slash), (Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(entry.substring(slash + 1)))));
        });
    }
}

