/*
 * Decompiled with CFR 0.152.
 */
package korolev.server.internal.services;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import korolev.Context;
import korolev.Qsid;
import korolev.Qsid$;
import korolev.effect.AsyncTable;
import korolev.effect.AsyncTable$;
import korolev.effect.Effect;
import korolev.effect.Effect$;
import korolev.effect.Hub;
import korolev.effect.Hub$;
import korolev.effect.Scheduler;
import korolev.effect.Stream;
import korolev.effect.Var;
import korolev.effect.Var$;
import korolev.effect.syntax;
import korolev.effect.syntax$;
import korolev.internal.ApplicationInstance;
import korolev.internal.ComponentInstance;
import korolev.internal.Frontend;
import korolev.server.KorolevServiceConfig;
import korolev.server.internal.BadRequestException$;
import korolev.server.internal.Cookies$;
import korolev.server.internal.services.PageService;
import korolev.state.StateDeserializer;
import korolev.state.StateManager;
import korolev.state.StateSerializer;
import korolev.state.StateStorage;
import korolev.state.StateStorage$;
import korolev.web.Request;
import levsha.Id;
import levsha.Id$;
import levsha.StatefulRenderContext;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public final class SessionsService<F, S, M> {
    private final KorolevServiceConfig<F, S, M> config;
    private final PageService<F, S, M> pageService;
    private final Effect<F> evidence$1;
    private final StateSerializer<S> evidence$2;
    private final StateDeserializer<S> evidence$3;
    private final AsyncTable<F, Qsid, ApplicationInstance<F, S, M>> apps;
    private final StateStorage<F, S> stateStorage;
    private final Scheduler<F> scheduler;

    public SessionsService(KorolevServiceConfig<F, S, M> config, PageService<F, S, M> pageService, Effect<F> evidence$1, StateSerializer<S> evidence$2, StateDeserializer<S> evidence$3) {
        this.config = config;
        this.pageService = pageService;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.evidence$3 = evidence$3;
        this.apps = AsyncTable$.MODULE$.unsafeCreateEmpty(evidence$1);
        this.stateStorage = config.stateStorage() == null ? StateStorage$.MODULE$.apply(StateStorage$.MODULE$.apply$default$1(), evidence$1, evidence$2) : config.stateStorage();
        this.scheduler = new Scheduler(evidence$1);
    }

    public F initSession(Request.Head rh) {
        Object object;
        Option option = rh.cookie(Cookies$.MODULE$.DeviceId());
        if (option instanceof Some) {
            String d = (String)((Some)option).value();
            object = Effect$.MODULE$.apply(this.evidence$1).pure((Object)d);
        } else if (None$.MODULE$.equals(option)) {
            object = this.config.idGenerator().generateDeviceId(this.evidence$1);
        } else {
            throw new MatchError((Object)option);
        }
        Object object2 = syntax$.MODULE$.EffectOps(object);
        return (F)syntax.EffectOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)deviceId -> {
            Object object = syntax$.MODULE$.EffectOps(this.config.idGenerator().generateSessionId(this.evidence$1));
            return syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)sessionId -> Qsid$.MODULE$.apply((String)deviceId, (String)sessionId), this.evidence$1);
        }, this.evidence$1);
    }

    public F initAppState(Qsid qsid, Request.Head rh) {
        Object object = syntax$.MODULE$.EffectOps(this.config.stateLoader().apply((Object)qsid.deviceId(), (Object)rh));
        return (F)syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)defaultState -> {
            Object object = syntax$.MODULE$.EffectOps(((Option)this.config.router().toState().lift().apply((Object)rh.pq())).fold(() -> this.initAppState$$anonfun$1$$anonfun$1(defaultState), (Function1 & Serializable)f -> f.apply(defaultState)));
            return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)state -> {
                Object object = syntax$.MODULE$.EffectOps(this.stateStorage.create(qsid.deviceId(), qsid.sessionId(), state));
                return syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                    StateManager stateManager = x$1;
                    return state;
                }, this.evidence$1);
            }, this.evidence$1);
        }, this.evidence$1);
    }

    public F getApp(Qsid qsid) {
        return (F)this.apps.getImmediately((Object)qsid);
    }

    public F createAppIfNeeded(Qsid qsid, Request.Head rh, Stream<F, String> incomingStream) {
        Tuple2 tuple2 = incomingStream.handleConsumed();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object incomingConsumed = tuple2._1();
        Stream managedIncomingStream = (Stream)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(incomingConsumed, (Object)managedIncomingStream);
        Object incomingConsumed2 = tuple22._1();
        Stream managedIncomingStream2 = (Stream)tuple22._2();
        Hub incomingHub = Hub$.MODULE$.apply(managedIncomingStream2, Hub$.MODULE$.apply$default$2(), this.evidence$1);
        Object object = syntax$.MODULE$.EffectOps(this.stateStorage.exists(qsid.deviceId(), qsid.sessionId()));
        return (F)syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> this.createAppIfNeeded$$anonfun$1(qsid, incomingStream, incomingConsumed2, incomingHub, BoxesRunTime.unboxToBoolean((Object)x$1)), this.evidence$1);
    }

    private final Object initAppState$$anonfun$1$$anonfun$1(Object defaultState$1) {
        return Effect$.MODULE$.apply(this.evidence$1).pure(defaultState$1);
    }

    private final Function1 invokeOnce$1(Qsid qsid$3, Function1 cb$1, AtomicBoolean invoked$1, String reason) {
        return (JProcedure1 & Serializable)x -> {
            if (invoked$1.compareAndSet(false, true)) {
                this.config.reporter().debug(new StringBuilder(20).append("Session ").append(qsid$3).append(" closed due ").append(reason).toString());
                cb$1.apply(x);
                return;
            }
        };
    }

    private final Object createTimeout$1$$anonfun$1(Qsid qsid$7, Function1 cb$3, AtomicBoolean invoked$3, Stream stream$1) {
        this.invokeOnce$1(qsid$7, cb$3, invoked$3, "session idle timeout").apply((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        return stream$1.cancel();
    }

    private final Object createTimeout$1(Qsid qsid$34, Function1 cb$10, AtomicBoolean invoked$10, Stream stream) {
        return this.scheduler.scheduleOnce(this.config.sessionIdleTimeout(), () -> this.createTimeout$1$$anonfun$1(qsid$34, cb$10, invoked$10, stream));
    }

    private final Object handleCommunicationTimeout$1(Qsid qsid$8, Hub incomingHub$3, Function1 cb$4, AtomicBoolean invoked$4) {
        Object object = syntax$.MODULE$.EffectOps(incomingHub$3.newStream());
        return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)in -> {
            Object object = syntax$.MODULE$.EffectOps(this.createTimeout$1(qsid$8, cb$4, invoked$4, (Stream)in));
            Object object2 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)initialTimeout -> {
                BoxedUnit boxedUnit;
                this.config.reporter().debug(new StringBuilder(24).append("Create idle timeout for ").append(qsid$8).toString());
                BoxedUnit $2$ = boxedUnit = BoxedUnit.UNIT;
                BoxedUnit $2$2 = BoxedUnit.UNIT;
                Var schedulerVar = Var$.MODULE$.apply(initialTimeout, this.evidence$1);
                return Tuple3$.MODULE$.apply(initialTimeout, (Object)$2$2, (Object)schedulerVar);
            }, this.evidence$1));
            return syntax.EffectOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)x$12 -> {
                Tuple3 tuple3 = x$12;
                if (tuple3 != null) {
                    Scheduler.JobHandler initialTimeout = (Scheduler.JobHandler)tuple3._1();
                    Var schedulerVar = (Var)tuple3._3();
                    Object object = syntax$.MODULE$.EffectOps(in.foreach((Function1 & Serializable)_$2 -> {
                        this.config.reporter().debug(new StringBuilder(23).append("Reset idle timeout for ").append(qsid$8).toString());
                        Object object = syntax$.MODULE$.EffectOps(schedulerVar.get());
                        return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)currentTimer -> {
                            Object object = syntax$.MODULE$.EffectOps(currentTimer.cancel());
                            return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                Object object = syntax$.MODULE$.EffectOps(this.createTimeout$1(qsid$8, cb$4, invoked$4, (Stream)in));
                                return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)timeout -> {
                                    Object object = syntax$.MODULE$.EffectOps(schedulerVar.set(timeout));
                                    return syntax.EffectOps$.MODULE$.map$extension(object, (Function1)(JProcedure1 & Serializable)x$1 -> {
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }, this.evidence$1);
                                }, this.evidence$1);
                            }, this.evidence$1);
                        }, this.evidence$1);
                    }));
                    return syntax.EffectOps$.MODULE$.map$extension(object, (Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }, this.evidence$1);
                }
                throw new MatchError((Object)tuple3);
            }, this.evidence$1);
        }, this.evidence$1);
    }

    private final void handleAppOrWsOutgoingCloseOrTimeout$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(Qsid qsid$20) {
        this.stateStorage.remove(qsid$20.deviceId(), qsid$20.sessionId());
    }

    private final Object handleAppOrWsOutgoingCloseOrTimeout$1(Qsid qsid$5, Stream incomingStream$1, Object incomingConsumed$1, Hub incomingHub$1, Frontend frontend, ApplicationInstance app, List ehs) {
        Object consumed = Effect$.MODULE$.apply(this.evidence$1).promise((Function1)(JProcedure1 & Serializable)cb -> {
            AtomicBoolean invoked = new AtomicBoolean(false);
            Object object = syntax$.MODULE$.EffectOps(this.handleCommunicationTimeout$1(qsid$5, incomingHub$1, (Function1)cb, invoked));
            syntax.EffectOps$.MODULE$.runAsyncForget$extension(object, this.config.reporter().Implicit(), this.evidence$1);
            Object object2 = syntax$.MODULE$.EffectOps(incomingConsumed$1);
            syntax.EffectOps$.MODULE$.runAsync$extension(object2, this.invokeOnce$1(qsid$5, (Function1)cb, invoked, "due connection close"), this.evidence$1);
        });
        Object object = syntax$.MODULE$.EffectOps(consumed);
        return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Object object = syntax$.MODULE$.EffectOps(incomingStream$1.cancel());
            return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = syntax$.MODULE$.EffectOps(frontend.outgoingMessages().cancel());
                return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = syntax$.MODULE$.EffectOps(app.topLevelComponentInstance().destroy());
                    return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        Object object = syntax$.MODULE$.EffectOps(syntax$.MODULE$.ListEffectOps(ehs.map((Function1 & Serializable)_$3 -> _$3.onDestroy()), this.evidence$1).sequence());
                        return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                            List list = x$1;
                            Object object = syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).delay((Function0 & Serializable)() -> {
                                this.handleAppOrWsOutgoingCloseOrTimeout$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(qsid$5);
                                return BoxedUnit.UNIT;
                            }));
                            return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                Object object = syntax$.MODULE$.EffectOps(this.apps.remove((Object)qsid$5));
                                return syntax.EffectOps$.MODULE$.map$extension(object, (Function1)(JProcedure1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }, this.evidence$1);
                            }, this.evidence$1);
                        }, this.evidence$1);
                    }, this.evidence$1);
                }, this.evidence$1);
            }, this.evidence$1);
        }, this.evidence$1);
    }

    private final Object handleStateChange$1(ApplicationInstance app, List ehs) {
        Object object = syntax$.MODULE$.EffectOps(app.stateStream());
        return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)stream -> stream.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Id id = (Id)tuple2._1();
                Object state = tuple2._2();
                Id id2 = id;
                Id id3 = Id$.MODULE$.TopLevel();
                if (id2 == null ? id3 != null : !id2.equals(id3)) {
                    return Effect$.MODULE$.apply(this.evidence$1).unit();
                }
                Object object = syntax$.MODULE$.EffectOps(syntax$.MODULE$.ListEffectOps(ehs.map((Function1 & Serializable)_$4 -> _$4.onState(state)), this.evidence$1).sequence());
                return syntax.EffectOps$.MODULE$.unit$extension(object, this.evidence$1);
            }
            throw new MatchError((Object)tuple2);
        }), this.evidence$1);
    }

    private final Object handleMessages$1(ApplicationInstance app, List ehs) {
        return app.messagesStream().foreach((Function1 & Serializable)m -> {
            Object object = syntax$.MODULE$.EffectOps(syntax$.MODULE$.ListEffectOps(ehs.map((Function1 & Serializable)_$5 -> _$5.onMessage(m)), this.evidence$1).sequence());
            return syntax.EffectOps$.MODULE$.unit$extension(object, this.evidence$1);
        });
    }

    private final Object create$1$$anonfun$1$$anonfun$1$$anonfun$1(Qsid qsid$25) {
        return Effect$.MODULE$.apply(this.evidence$1).fail((Throwable)BadRequestException$.MODULE$.apply(new StringBuilder(57).append("Top level state should exists. Snapshot for ").append(qsid$25).append(" is corrupted").toString()));
    }

    private final Object create$1$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$1(ApplicationInstance app$5, List ehs$8) {
        return this.handleStateChange$1(app$5, ehs$8);
    }

    private final Object create$1$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(ApplicationInstance app$7, List ehs$10) {
        return this.handleMessages$1(app$7, ehs$10);
    }

    private final Object create$1$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(Qsid qsid$32, Stream incomingStream$10, Object incomingConsumed$10, Hub incomingHub$11, Frontend frontend$6, ApplicationInstance app$9, List ehs$12) {
        return this.handleAppOrWsOutgoingCloseOrTimeout$1(qsid$32, incomingStream$10, incomingConsumed$10, incomingHub$11, frontend$6, app$9, ehs$12);
    }

    private final Object create$1(Qsid qsid$22, Stream incomingStream$3, Object incomingConsumed$3, Hub incomingHub$4) {
        this.config.reporter().debug(new StringBuilder(15).append("Create session ").append(qsid$22).toString());
        Object object = syntax$.MODULE$.EffectOps(this.stateStorage.get(qsid$22.deviceId(), qsid$22.sessionId()));
        return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)stateManager -> {
            Object object = syntax$.MODULE$.EffectOps(stateManager.read(Id$.MODULE$.TopLevel(), this.evidence$3));
            return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)maybeInitialState -> {
                Object object = syntax$.MODULE$.EffectOps(maybeInitialState.fold(() -> this.create$1$$anonfun$1$$anonfun$1$$anonfun$1(qsid$22), (Function1 & Serializable)_$6 -> Effect$.MODULE$.apply(this.evidence$1).pure(_$6)));
                return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)initialState -> {
                    Object object = syntax$.MODULE$.EffectOps(incomingHub$4.newStream());
                    Object object2 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)in -> {
                        Frontend<F> frontend = new Frontend<F>(in, this.config.heartbeatLimit(), this.evidence$1, this.config.reporter().Implicit(), this.config.executionContext());
                        ApplicationInstance<F, Object, M> app = new ApplicationInstance<F, Object, M>(qsid$22, frontend, stateManager, initialState, this.config.document(), this.config.rootPath(), this.config.router(), (Function2 & Serializable)(rc, k) -> this.pageService.setupStatefulProxy((StatefulRenderContext<Context.Binding<F, S, M>>)rc, qsid$22, (Function2<StatefulRenderContext<Context.Binding<F, S, M>>, Context.Binding<F, S, M>, BoxedUnit>)k), this.scheduler, this.config.reporter(), (PartialFunction<Throwable, Function1<Object, Object>>)this.config.recovery(), this.config.delayedRender(), this.evidence$1, (StateSerializer<Object>)this.evidence$2, (StateDeserializer<Object>)this.evidence$3, this.config.executionContext());
                        ComponentInstance.BrowserAccess browserAccess = app.topLevelComponentInstance().browserAccess();
                        return Tuple4$.MODULE$.apply(in, frontend, app, (Object)browserAccess);
                    }, this.evidence$1));
                    return syntax.EffectOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)x$1 -> {
                        Tuple4 tuple4 = x$1;
                        if (tuple4 != null) {
                            Stream in = (Stream)tuple4._1();
                            Frontend frontend = (Frontend)tuple4._2();
                            ApplicationInstance app = (ApplicationInstance)tuple4._3();
                            ComponentInstance.BrowserAccess browserAccess = (ComponentInstance.BrowserAccess)tuple4._4();
                            Object object = syntax$.MODULE$.EffectOps(syntax$.MODULE$.ListEffectOps(this.config.extensions().map((Function1 & Serializable)_$7 -> _$7.setup(browserAccess)), this.evidence$1).sequence());
                            Object object2 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)ehs -> {
                                Object object = syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).start(() -> this.create$1$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$1(app, ehs), this.config.executionContext()));
                                return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                                    Effect.Fiber fiber = x$1;
                                    Object object = syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).start(() -> this.create$1$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(app, ehs), this.config.executionContext()));
                                    return syntax.EffectOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$12 -> {
                                        Effect.Fiber fiber = x$12;
                                        Object object = syntax$.MODULE$.EffectOps(Effect$.MODULE$.apply(this.evidence$1).start(() -> this.create$1$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1(qsid$22, incomingStream$3, incomingConsumed$3, incomingHub$4, frontend, app, ehs), this.config.executionContext()));
                                        return syntax.EffectOps$.MODULE$.map$extension(object, (Function1)(JProcedure1 & Serializable)x$1 -> {
                                            Effect.Fiber fiber = x$1;
                                        }, this.evidence$1);
                                    }, this.evidence$1);
                                }, this.evidence$1);
                            }, this.evidence$1));
                            Object object3 = syntax$.MODULE$.EffectOps(syntax.EffectOps$.MODULE$.start$extension(object2, this.config.executionContext(), this.evidence$1));
                            return syntax.EffectOps$.MODULE$.flatMap$extension(object3, (Function1 & Serializable)x$12 -> {
                                Effect.Fiber fiber = x$12;
                                Object object = syntax$.MODULE$.EffectOps(app.initialize(this.config.executionContext()));
                                return syntax.EffectOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return app;
                                }, this.evidence$1);
                            }, this.evidence$1);
                        }
                        throw new MatchError((Object)tuple4);
                    }, this.evidence$1);
                }, this.evidence$1);
            }, this.evidence$1);
        }, this.evidence$1);
    }

    private final Object createAppIfNeeded$$anonfun$1$$anonfun$1(Qsid qsid$37, Stream incomingStream$13, Object incomingConsumed$13, Hub incomingHub$14) {
        return this.create$1(qsid$37, incomingStream$13, incomingConsumed$13, incomingHub$14);
    }

    private final /* synthetic */ Object createAppIfNeeded$$anonfun$1(Qsid qsid$33, Stream incomingStream$11, Object incomingConsumed$11, Hub incomingHub$12, boolean x$1) {
        boolean bl = x$1;
        if (bl) {
            Object object = syntax$.MODULE$.EffectOps(this.apps.getFill((Object)qsid$33, () -> this.createAppIfNeeded$$anonfun$1$$anonfun$1(qsid$33, incomingStream$11, incomingConsumed$11, incomingHub$12)));
            return syntax.EffectOps$.MODULE$.unit$extension(object, this.evidence$1);
        }
        if (!bl) {
            return this.apps.remove((Object)qsid$33);
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }
}

