/*
 * This software is licensed under the Apache License, Version 2.0
 * (the "License") agreement; you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.force66.circuit;

/**
 * Denotes circuit state. States are as follows:
 * <li><b>Closed</b> -- Normally working circuit.</li>
 * <li><b>Open</b> -- Circuit isn't currently functional and must be closed to restore normal functionality.</li>
 * <li><b>Half-Open</b> -- Circuit that has been open and an operation is now being allowed on a trial
 * basis.</li>
 * 
 * @author D. Ashmore
 *
 */
public enum CircuitState {OPEN, CLOSED, HALFOPEN}