/*
 * Decompiled with CFR 0.152.
 */
package org.force66.insanity;

import org.apache.commons.lang3.Validate;
import org.force66.insanity.RetryAlgorithm;
import org.force66.insanity.RetryException;

public class DefaultRetryAlgorithm
implements RetryAlgorithm {
    public static final Integer DEFAULT_MAX_NBR_RETRIES = 5;
    public static final Long DEFAULT_TIME_BETWEEN_RETRIES_IN_MILLIS = 300000L;
    private Integer maxNbrRetries;
    private Long timeBetweenRetriesInMillis;
    private int nbrFailures = 0;
    private long timeLastFailureInMillis = 0L;

    public DefaultRetryAlgorithm() {
        this(DEFAULT_MAX_NBR_RETRIES, DEFAULT_TIME_BETWEEN_RETRIES_IN_MILLIS);
    }

    public DefaultRetryAlgorithm(Integer maxNbrRetries, Long timeBetweenRetriesInMillis) {
        Validate.notNull((Object)maxNbrRetries, (String)"Null maxNbrRetries not allowed.", (Object[])new Object[0]);
        Validate.notNull((Object)timeBetweenRetriesInMillis, (String)"Null timeBetweenRetriesInMillis not allowed.", (Object[])new Object[0]);
        Validate.isTrue((maxNbrRetries > 0 ? 1 : 0) != 0, (String)"maxNbrRetries must be larger than 0.  value=%s", (long)maxNbrRetries.intValue());
        Validate.isTrue((timeBetweenRetriesInMillis > 0L ? 1 : 0) != 0, (String)"timeBetweenRetriesInMillis must be larger than 0.  value=%s", (long)timeBetweenRetriesInMillis);
        this.maxNbrRetries = maxNbrRetries;
        this.timeBetweenRetriesInMillis = timeBetweenRetriesInMillis;
    }

    @Override
    public boolean isExecutionAllowed() {
        if (this.nbrFailures >= this.maxNbrRetries) {
            return false;
        }
        if (this.timeLastFailureInMillis == 0L) {
            return true;
        }
        long millisUntilNextAttempt = this.timeBetweenRetriesInMillis - (System.currentTimeMillis() - this.timeLastFailureInMillis);
        if (millisUntilNextAttempt < 0L) {
            return true;
        }
        try {
            Thread.sleep(millisUntilNextAttempt);
        }
        catch (InterruptedException e) {
            throw new RetryException(e);
        }
        return true;
    }

    @Override
    public void reportExecutionFailure(Exception exceptionThrown) {
        ++this.nbrFailures;
        this.timeLastFailureInMillis = System.currentTimeMillis();
    }

    public Integer getMaxNbrRetries() {
        return this.maxNbrRetries;
    }

    public Long getTimeBetweenRetriesInMillis() {
        return this.timeBetweenRetriesInMillis;
    }

    public int getNbrFailures() {
        return this.nbrFailures;
    }

    public long getTimeLastFailureInMillis() {
        return this.timeLastFailureInMillis;
    }

    @Override
    public void reset() {
        this.nbrFailures = 0;
        this.timeLastFailureInMillis = 0L;
    }
}

