/*
 * Decompiled with CFR 0.152.
 */
package org.force66.insanity;

import java.util.concurrent.Callable;
import org.apache.commons.lang3.Validate;
import org.force66.insanity.DefaultRetryAlgorithm;
import org.force66.insanity.RetryAlgorithm;
import org.force66.insanity.RetryException;

public class RetryManager<T> {
    private RetryAlgorithm retryAlgorithm;

    public RetryManager() {
        this(new DefaultRetryAlgorithm());
    }

    public RetryManager(RetryAlgorithm algorithm) {
        Validate.notNull((Object)algorithm, (String)"Null algorithm not allowed.", (Object[])new Object[0]);
        this.retryAlgorithm = algorithm;
    }

    public T invoke(Callable<T> operation) {
        Validate.notNull(operation, (String)"Null operation not allowed.", (Object[])new Object[0]);
        int nbrTries = 0;
        Exception lastFailure = null;
        this.retryAlgorithm.reset();
        while (this.retryAlgorithm.isExecutionAllowed()) {
            ++nbrTries;
            try {
                T output = operation.call();
                return output;
            }
            catch (Exception e) {
                lastFailure = e;
                this.retryAlgorithm.reportExecutionFailure(e);
            }
        }
        throw new RetryException("invocation not successful.", lastFailure).addContextValue("callable class", operation.getClass().getName()).addContextValue("callable", (Object)operation.toString()).addContextValue("nbrTries", (Object)nbrTries);
    }

    protected RetryAlgorithm getRetryAlgorithm() {
        return this.retryAlgorithm;
    }
}

