/*
 * Copyright (c) 2020 ForgeRock. All rights reserved.
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file for details.
 */

package org.forgerock.android.auth;


import android.content.Context;
import android.content.SharedPreferences;

import lombok.RequiredArgsConstructor;
import okhttp3.CookieJar;

public class User {

    private String identifier;
    private SessionManager sessionManager;
    private SingleSignOnManager singleSignOnManager;
    private Context context;

    /*
    public User(Context context, String identifier) {
        this.context = context.getApplicationContext();
        this.identifier = identifier;
        this.singleSignOnManager = getSSOManager();
        this.sessionManager = SessionManager.builder()
                .tokenManager(getTokenManager())
                .singleSignOnManager(singleSignOnManager)
                .build();
    }

    private TokenManager getTokenManager() {
        return DefaultTokenManager.builder()
                .context(context)
                .oAuth2Client(getOAuth2Client())
                .sharedPreferences(getSharedPreferences())
                .build();
    }

    private SingleSignOnManager getSSOManager() {
        return DefaultSingleSignOnManager.builder()
                .context(context)
                .accountName(identifier)
                .serverConfig(getServerConfig())
                .build();
    }

    private OAuth2Client getOAuth2Client() {
        return OAuth2Client.builder()
                .clientId(Config.getInstance().getClientId())
                .scope(Config.getInstance().getScope())
                .redirectUri(Config.getInstance().getRedirectUri())
                .serverConfig(getServerConfig())
                .build();
    }

    private ServerConfig getServerConfig() {
        return ServerConfig.builder()
                .context(context)
                .identifier(identifier)
                .url(Config.getInstance().getUrl())
                .realm(Config.getInstance().getRealm())
                .timeout(Config.getInstance().getTimeout())
                .cookieJarSupplier(this::getCookieJar)
                .cookieName(Config.getInstance().getCookieName())
                .authenticateEndpoint(Config.getInstance().getAuthenticateEndpoint())
                .authorizeEndpoint(Config.getInstance().getAuthorizeEndpoint())
                .tokenEndpoint(Config.getInstance().getTokenEndpoint())
                .revokeEndpoint(Config.getInstance().getRevokeEndpoint())
                .userInfoEndpoint(Config.getInstance().getUserinfoEndpoint())
                .logoutEndpoint(Config.getInstance().getLogoutEndpoint())
                .build();
    }

    private CookieJar getCookieJar() {
        return SecureCookieJar.builder()
                .singleSignOnManager(singleSignOnManager)
                .context(context).build();
    }

    private SharedPreferences getSharedPreferences() {
        return new SecuredSharedPreferences(context,
                "org.forgerock.v1.TOKENS." + identifier,
                "org.forgerock.v1.KEYS." + identifier);

    }

    public void authenticate(Context context, String treeName, final NodeListener<Void> nodeListener) {
        FRAuth.builder()
                .serviceName(treeName)
                .context(context)
                .serverConfig(getServerConfig())
                .sessionManager(sessionManager)
                .interceptor(new OAuthInterceptor(sessionManager))
                .interceptor(new AccessTokenStoreInterceptor(sessionManager.getTokenManager()))
                .interceptor(new User.UserInterceptor())
                .build().next(context, nodeListener);
    }

    public void getAccessToken(FRListener<AccessToken> listener) {
        sessionManager.getAccessToken(listener);
    }

    public void logout(FRListener<Void> listener) {
        sessionManager.close(listener);
    }

    @RequiredArgsConstructor
    private static class UserInterceptor implements Interceptor {

        @Override
        public void intercept(Chain chain, Object any) {
            chain.proceed(null);
        }
    }

     */
}
