/*
 * Copyright (c) 2019 ForgeRock. All rights reserved.
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file for details.
 */

package org.forgerock.android.auth.detector;

import android.content.Context;

/**
 * Release-Keys and Test-Keys has to do with how the kernel is signed when it is compiled.
 * Test-Keys means it was signed with a custom key generated by a third-party developer.
 */
public class BuildTagsDetector implements RootDetector {

    @Override
    public double isRooted(Context context) {
        String buildTags = android.os.Build.TAGS;
        if (buildTags != null && buildTags.contains("test-keys")) {
            return 1.0;
        } else {
            return 0;
        }
    }
}
