/*
 * Copyright (c) 2019 - 2025 Ping Identity Corporation. All rights reserved.
 *
 * This software may be modified and distributed under the terms
 * of the MIT license. See the LICENSE file for details.
 */

package org.forgerock.android.auth;

/**
 * Constants for OAuth
 */
public class OAuth2 {

    public static final String ACCESS_TOKEN = "access_token";
    static final String ID_TOKEN = "id_token";
    static final String REFRESH_TOKEN = "refresh_token";
    static final String TOKEN = "token";
    static final String TOKEN_TYPE = "token_type";
    static final String SCOPE = "scope";
    static final String EXPIRES_IN = "expires_in";
    static final String EXPIRATION = "expiration";
    public static final String CLIENT_ID = "client_id";
    public static final String RESPONSE_TYPE = "response_type";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String DECISION = "decision";
    public static final String CODE_CHALLENGE = "code_challenge";
    public static final String CODE_CHALLENGE_METHOD = "code_challenge_method";
    public static final String CODE = "code";
    public static final String GRANT_TYPE = "grant_type";
    public static final String CODE_VERIFIER = "code_verifier";
    public static final String AUTHORIZATION_CODE = "authorization_code";
    public static final String CSRF = "csrf";
    public static final String STATE = "state";

    private OAuth2() {
    }

}
