/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.maven.plugins;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.forgerock.maven.plugins.utils.MyErrorHandler;
import org.forgerock.maven.plugins.utils.MyNameVerifier;
import org.forgerock.maven.plugins.utils.MyNamespaceContext;
import org.forgerock.maven.plugins.utils.MyX509TrustManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinkTester
extends AbstractMojo {
    private static final String DOCBOOK_XSD = "http://docbook.org/xml/5.0/xsd/docbook.xsd";
    private static final String DOCBOOK_NS = "http://docbook.org/ns/docbook";
    private static final String OLINK_ROLE = "http://docbook.org/xlink/role/olink";
    private String[] includes;
    private String[] excludes;
    protected MavenProject project = new MavenProject();
    private boolean validating;
    private boolean xIncludeAware;
    private boolean skipOlinks;
    private boolean skipUrls;
    private boolean failOnError;
    private String outputFile;
    private FileWriter fileWriter;
    private MultiValueMap failedUrls = new MultiValueMap();
    private MultiValueMap xmlIds = new MultiValueMap();
    private MultiValueMap olinks = new MultiValueMap();
    private Set<String> tested = new HashSet<String>();
    private String currentPath;
    private boolean failure;

    public LinkTester() {
        TrustManager[] trustAllCerts = new TrustManager[]{new MyX509TrustManager()};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception ex) {
            this.error("Unable to initialize trustAll SSL", ex);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.outputFile != null) {
            File file = new File(this.outputFile);
            if (file.exists()) {
                this.debug("Deleting existing outputFile: " + this.outputFile);
                file.delete();
            }
            try {
                file.createNewFile();
                this.fileWriter = new FileWriter(this.outputFile);
            }
            catch (IOException ioe) {
                this.error("Error while creating output file", ioe);
            }
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.project.getBasedir());
        scanner.setIncludes(this.includes);
        scanner.setExcludes(this.excludes);
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(this.xIncludeAware);
        if (this.validating) {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                Schema schema = sf.newSchema(new URL(DOCBOOK_XSD));
                dbf.setSchema(schema);
            }
            catch (Exception ex) {
                this.error("Error while constructing schema for validation", ex);
            }
        }
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        xpath.setNamespaceContext(new MyNamespaceContext());
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new MyErrorHandler(this));
            XPathExpression expr = xpath.compile("//@xml:id");
            for (String path : files) {
                this.setCurrentPath(path);
                try {
                    Document doc = db.parse(new File(path));
                    if (!this.skipOlinks) {
                        this.extractXmlIds(expr, doc, path);
                    }
                    NodeList nodes = doc.getElementsByTagNameNS(DOCBOOK_NS, "link");
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i);
                        NamedNodeMap attrs = node.getAttributes();
                        String url = null;
                        boolean isOlink = false;
                        for (int j = 0; j < attrs.getLength(); ++j) {
                            Node attr = attrs.item(j);
                            if (attr.getLocalName().equals("href")) {
                                url = attr.getNodeValue();
                                continue;
                            }
                            if (!attr.getLocalName().equals("role") || !attr.getNodeValue().equalsIgnoreCase(OLINK_ROLE)) continue;
                            isOlink = true;
                        }
                        if (url == null) continue;
                        if (isOlink && !this.skipOlinks) {
                            this.olinks.put((Object)path, (Object)url);
                            continue;
                        }
                        if (isOlink || this.skipUrls) continue;
                        this.checkUrl(path, url);
                    }
                }
                catch (Exception ex) {
                    this.error("Error while processing file: " + path + ". Error: " + ex.getMessage());
                }
            }
            if (!this.skipOlinks) {
                for (Map.Entry entry : this.olinks.entrySet()) {
                    for (String val : (Collection)entry.getValue()) {
                        this.checkOlink((String)entry.getKey(), val);
                    }
                }
            }
            if (!this.failedUrls.isEmpty()) {
                this.error("The following files had invalid URLs:\n" + this.failedUrls.toString());
            }
        }
        catch (Exception ex) {
            throw new MojoFailureException("Unexpected error while tesing links", (Throwable)ex);
        }
        finally {
            this.flushReport();
        }
        if (this.failOnError && (this.failure || !this.failedUrls.isEmpty())) {
            throw new MojoFailureException("One or more error occured during plugin execution");
        }
    }

    private void extractXmlIds(XPathExpression expr, Document doc, String path) throws XPathExpressionException {
        NodeList ids = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        if (ids != null) {
            for (int i = 0; i < ids.getLength(); ++i) {
                Node node = ids.item(i);
                File file = new File(path);
                this.xmlIds.put((Object)file.getParentFile().getName(), (Object)node.getNodeValue());
            }
        }
    }

    private void checkUrl(String path, String docUrl) {
        if (this.tested.contains(docUrl)) {
            if (this.failedUrls.containsValue((Object)docUrl)) {
                this.failedUrls.put((Object)path, (Object)docUrl);
            }
            return;
        }
        try {
            URL url = new URL(docUrl);
            URLConnection urlConn = url.openConnection();
            if (urlConn instanceof HttpURLConnection) {
                HttpURLConnection conn = (HttpURLConnection)urlConn;
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
                    httpsConn.setHostnameVerifier(new MyNameVerifier());
                }
                conn.setConnectTimeout(1000);
                int responseCode = conn.getResponseCode();
                if (responseCode >= 400) {
                    this.failedUrls.put((Object)path, (Object)docUrl);
                }
            }
        }
        catch (Exception ex) {
            this.warn(docUrl + ": " + ex.getClass().getName() + " " + ex.getMessage());
            this.failedUrls.put((Object)path, (Object)docUrl);
        }
        this.tested.add(docUrl);
    }

    private void checkOlink(String path, String olink) {
        String[] parts = olink.split("#");
        if (parts.length != 2) {
            this.failedUrls.put((Object)path, (Object)olink);
            return;
        }
        Collection coll = this.xmlIds.getCollection((Object)parts[0]);
        if (coll == null || !coll.contains(parts[1])) {
            this.failedUrls.put((Object)path, (Object)olink);
        }
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    private void setCurrentPath(String path) {
        this.currentPath = path;
    }

    public void setFailure() {
        this.failure = true;
    }

    public final void debug(String line) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)line);
            this.report("[DEBUG] " + line);
        }
    }

    public final void warn(String line) {
        this.getLog().warn((CharSequence)line);
        this.report("[WARNING] " + line);
    }

    public final void error(String line) {
        this.getLog().error((CharSequence)line);
        this.report("[ERROR] " + line);
    }

    public final void error(String line, Throwable throwable) {
        this.getLog().error((CharSequence)line, throwable);
        this.report("[ERROR] " + line, throwable);
    }

    private void report(String line) {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.write(line);
                this.fileWriter.write("\n");
            }
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)("Error while writing to outputFile: " + ioe.getMessage()));
        }
    }

    private void report(String line, Throwable throwable) {
        if (this.fileWriter != null) {
            this.report(line);
            throwable.printStackTrace(new PrintWriter(this.fileWriter));
        }
    }

    private void flushReport() {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.flush();
                this.fileWriter.close();
            }
            catch (IOException ioe) {
                this.getLog().error((CharSequence)("Error while flushing report: " + ioe.getMessage()));
            }
        }
    }
}

