/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.maven.plugins;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.forgerock.maven.plugins.model.DocSource;
import org.forgerock.maven.plugins.utils.LoggingErrorHandler;
import org.forgerock.maven.plugins.utils.TrustAllCertsX509TrustManager;
import org.forgerock.maven.plugins.utils.TrustAllHostnameVerifier;
import org.forgerock.maven.plugins.utils.XmlNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Mojo(name="check")
public class LinkTester
extends AbstractMojo {
    private static final String DOCBOOK_XSD = "http://docbook.org/xml/5.0/xsd/docbook.xsd";
    private static final String DOCBOOK_NS = "http://docbook.org/ns/docbook";
    private static final String OLINK_ROLE = "http://docbook.org/xlink/role/olink";
    private static final SSLSocketFactory TRUST_ALL_SOCKET_FACTORY;
    @Parameter
    private List<DocSource> docSources;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project = new MavenProject();
    @Parameter(defaultValue="false")
    private boolean validating;
    @Parameter(defaultValue="false")
    private boolean xIncludeAware;
    @Parameter(defaultValue="false")
    private boolean skipOlinks;
    @Parameter(defaultValue="false")
    private boolean skipUrls;
    @Parameter
    private String[] skipUrlPatterns;
    @Parameter(defaultValue="false")
    private boolean failOnError;
    @Parameter
    private File outputFile;
    private FileWriter fileWriter;
    private boolean failure;
    private String currentPath;
    private final List<Pattern> patterns = new ArrayList<Pattern>();
    private final MultiValueMap failedUrls = new MultiValueMap();
    private final MultiValueMap timedOutUrls = new MultiValueMap();
    private final MultiValueMap xmlIds = new MultiValueMap();
    private final MultiValueMap olinks = new MultiValueMap();
    private final Set<String> tested = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        XPathExpression expr;
        DocumentBuilder db;
        if (this.outputFile != null) {
            if (!this.outputFile.isAbsolute()) {
                this.outputFile = new File(this.project.getBasedir(), this.outputFile.getPath());
            }
            if (this.outputFile.exists()) {
                this.debug("Deleting existing outputFile: " + this.outputFile);
                this.outputFile.delete();
            }
            try {
                this.outputFile.createNewFile();
                this.fileWriter = new FileWriter(this.outputFile);
            }
            catch (IOException ioe) {
                this.error("Error while creating output file", ioe);
            }
        }
        this.initializeSkipUrlPatterns();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        dbf.setXIncludeAware(this.xIncludeAware);
        if (this.validating) {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                Schema schema = sf.newSchema(new URL(DOCBOOK_XSD));
                dbf.setSchema(schema);
            }
            catch (MalformedURLException murle) {
                this.error("Invalid URL provided as schema source", murle);
            }
            catch (SAXException saxe) {
                this.error("Parsing error occurred while constructing schema for validation", saxe);
            }
        }
        try {
            db = dbf.newDocumentBuilder();
            db.setErrorHandler(new LoggingErrorHandler(this));
        }
        catch (ParserConfigurationException pce) {
            throw new MojoExecutionException("Unable to create new DocumentBuilder", (Exception)pce);
        }
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        xpath.setNamespaceContext(new XmlNamespaceContext());
        try {
            expr = xpath.compile("//@xml:id");
        }
        catch (XPathExpressionException xpee) {
            throw new MojoExecutionException("Unable to compile Xpath expression", (Exception)xpee);
        }
        if (this.docSources != null) {
            for (DocSource docSource : this.docSources) {
                this.processDocSource(docSource, db, expr);
            }
        }
        try {
            if (!this.skipOlinks) {
                for (Map.Entry entry : this.olinks.entrySet()) {
                    for (String val : (Collection)entry.getValue()) {
                        this.checkOlink((String)entry.getKey(), val);
                    }
                }
            }
            if (!this.failedUrls.isEmpty()) {
                this.error("The following files had invalid URLs:\n" + this.failedUrls.toString());
            }
            if (!this.timedOutUrls.isEmpty()) {
                this.warn("The following files had unavailable URLs (connection or read timed out):\n" + this.timedOutUrls.toString());
            }
            if (this.failedUrls.isEmpty() && this.timedOutUrls.isEmpty() && !this.failure) {
                this.info("DocBook links successfully tested, no errors reported.");
            }
        }
        finally {
            this.flushReport();
        }
        if (this.failOnError && (this.failure || !this.failedUrls.isEmpty())) {
            throw new MojoFailureException("One or more error occurred during plugin execution");
        }
    }

    private void processDocSource(DocSource docSource, DocumentBuilder db, XPathExpression expr) {
        String[] files;
        DirectoryScanner scanner = new DirectoryScanner();
        File baseDir = docSource.getDirectory();
        if (baseDir == null) {
            baseDir = this.project.getBasedir();
        }
        scanner.setBasedir(baseDir);
        scanner.setIncludes(docSource.getIncludes());
        scanner.setExcludes(docSource.getExcludes());
        scanner.scan();
        for (String relativePath : files = scanner.getIncludedFiles()) {
            this.setCurrentPath(relativePath);
            try {
                Document doc = db.parse(new File(baseDir, relativePath));
                if (!this.skipOlinks) {
                    this.extractXmlIds(expr, doc, relativePath);
                }
                NodeList nodes = doc.getElementsByTagNameNS(DOCBOOK_NS, "link");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    NamedNodeMap attrs = node.getAttributes();
                    String url = null;
                    boolean isOlink = false;
                    for (int j = 0; j < attrs.getLength(); ++j) {
                        Node attr = attrs.item(j);
                        if (attr.getLocalName().equals("href")) {
                            url = attr.getNodeValue();
                            continue;
                        }
                        if (!attr.getLocalName().equals("role") || !attr.getNodeValue().equalsIgnoreCase(OLINK_ROLE)) continue;
                        isOlink = true;
                    }
                    if (url == null) continue;
                    if (isOlink && !this.skipOlinks) {
                        this.olinks.put((Object)relativePath, (Object)url);
                        continue;
                    }
                    if (isOlink || this.skipUrls) continue;
                    this.checkUrl(relativePath, url);
                }
            }
            catch (Exception ex) {
                this.error("Error while processing file: " + relativePath + ". Error: " + ex.getMessage(), ex);
            }
        }
    }

    private void extractXmlIds(XPathExpression expr, Document doc, String path) throws XPathExpressionException {
        NodeList ids = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        if (ids != null) {
            for (int i = 0; i < ids.getLength(); ++i) {
                Node node = ids.item(i);
                File file = new File(path);
                this.xmlIds.put((Object)file.getParentFile().getName(), (Object)node.getNodeValue());
            }
        }
    }

    private void checkUrl(String path, String docUrl) {
        if (this.shouldSkipUrl(docUrl)) {
            this.debug("Skipping " + docUrl + " since it matches a skipUrlPattern");
            return;
        }
        if (this.tested.contains(docUrl)) {
            if (this.failedUrls.containsValue((Object)docUrl)) {
                this.failedUrls.put((Object)path, (Object)docUrl);
            }
            return;
        }
        this.debug("Checking " + docUrl + " from file: " + path);
        try {
            URL url = new URL(docUrl);
            URLConnection urlConn = url.openConnection();
            if (urlConn instanceof HttpURLConnection) {
                HttpURLConnection conn = (HttpURLConnection)urlConn;
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
                    httpsConn.setHostnameVerifier(new TrustAllHostnameVerifier());
                    httpsConn.setSSLSocketFactory(TRUST_ALL_SOCKET_FACTORY);
                }
                conn.setConnectTimeout(1000);
                conn.setReadTimeout(15000);
                int responseCode = conn.getResponseCode();
                if (responseCode >= 400) {
                    this.warn(docUrl + ": received unexpected response code: " + responseCode);
                    this.failedUrls.put((Object)path, (Object)docUrl);
                }
            }
        }
        catch (SocketTimeoutException ste) {
            this.warn(docUrl + ": " + ste.getClass().getName() + " " + ste.getMessage());
            this.timedOutUrls.put((Object)path, (Object)docUrl);
        }
        catch (Exception ex) {
            this.warn(docUrl + ": " + ex.getClass().getName() + " " + ex.getMessage());
            this.failedUrls.put((Object)path, (Object)docUrl);
        }
        this.tested.add(docUrl);
    }

    private void checkOlink(String path, String olink) {
        String[] parts = olink.split("#");
        if (parts.length != 2) {
            this.failedUrls.put((Object)path, (Object)olink);
            return;
        }
        Collection coll = this.xmlIds.getCollection((Object)parts[0]);
        if (coll == null || !coll.contains(parts[1])) {
            this.failedUrls.put((Object)path, (Object)olink);
        }
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    private void setCurrentPath(String path) {
        this.currentPath = path;
    }

    public void fail(String errorMessage) {
        this.failure = true;
        this.error(errorMessage);
    }

    public final void debug(String line) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)line);
            this.report("[DEBUG] " + line);
        }
    }

    public final void warn(String line) {
        this.getLog().warn((CharSequence)line);
        this.report("[WARNING] " + line);
    }

    public final void info(String line) {
        this.getLog().info((CharSequence)line);
        this.report("[INFO] " + line);
    }

    public final void error(String line) {
        this.getLog().error((CharSequence)line);
        this.report("[ERROR] " + line);
    }

    public final void error(String line, Throwable throwable) {
        this.getLog().error((CharSequence)line, throwable);
        this.report("[ERROR] " + line, throwable);
    }

    private void report(String line) {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.write(line);
                this.fileWriter.write("\n");
            }
        }
        catch (IOException ioe) {
            this.getLog().error((CharSequence)("Error while writing to outputFile: " + ioe.getMessage()));
        }
    }

    private void report(String line, Throwable throwable) {
        if (this.fileWriter != null) {
            this.report(line);
            throwable.printStackTrace(new PrintWriter(this.fileWriter));
        }
    }

    private void flushReport() {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.flush();
                this.fileWriter.close();
            }
            catch (IOException ioe) {
                this.getLog().error((CharSequence)("Error while flushing report: " + ioe.getMessage()));
            }
        }
    }

    private void initializeSkipUrlPatterns() {
        if (this.skipUrlPatterns != null) {
            for (String pattern : this.skipUrlPatterns) {
                this.patterns.add(Pattern.compile(pattern));
            }
        }
    }

    private boolean shouldSkipUrl(String docUrl) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(docUrl).matches()) continue;
            return true;
        }
        return false;
    }

    static {
        TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllCertsX509TrustManager()};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            TRUST_ALL_SOCKET_FACTORY = sc.getSocketFactory();
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("Unable to initialize trustAllCerts SSLSocketFactory", gse);
        }
    }
}

