/*
 * Decompiled with CFR 0.152.
 */
package knockoff;

import java.io.Serializable;
import knockoff.Chunk;
import knockoff.CodeSpan$;
import knockoff.Emphasis;
import knockoff.Emphasis$;
import knockoff.HTMLSpan;
import knockoff.HTMLSpan$;
import knockoff.ImageLink$;
import knockoff.IndentedChunk;
import knockoff.IndentedChunk$;
import knockoff.KnockoffString$;
import knockoff.Link;
import knockoff.Link$;
import knockoff.LinkDefinitionChunk;
import knockoff.Span;
import knockoff.SpanConverter$SpanMatch$;
import knockoff.StringExtras;
import knockoff.Strong$;
import knockoff.Text;
import knockoff.Text$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public class SpanConverter
implements Function1<Chunk, Seq<Span>>,
StringExtras {
    private final Seq<LinkDefinitionChunk> definitions;
    public final SpanConverter$SpanMatch$ SpanMatch$lzy1;
    private final DelimMatcher matchUnderscoreEmphasis;
    private final DelimMatcher matchAsterixEmphasis;
    private final DelimMatcher matchUnderscoreStrong;
    private final DelimMatcher matchAsterixStrong;
    private final DelimMatcher matchUnderscoreStrongAndEm;
    private final DelimMatcher matchAsterixStrongAndEm;
    private final DelimMatcher matchDoubleCodes;
    private final DelimMatcher matchSingleCodes;
    private final Regex startElement;
    private final Regex matchEntityRE;
    private final Regex automaticLinkRE;

    public SpanConverter(Seq<LinkDefinitionChunk> definitions) {
        this.definitions = definitions;
        this.SpanMatch$lzy1 = new SpanConverter$SpanMatch$(this);
        this.matchUnderscoreEmphasis = new DelimMatcher(this, "_", (Function1<Seq<Span>, Span>)(Function1 & Serializable)_$3 -> Emphasis$.MODULE$.apply((Seq<Span>)_$3), true, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'\\')));
        this.matchAsterixEmphasis = new DelimMatcher(this, "*", (Function1<Seq<Span>, Span>)(Function1 & Serializable)_$4 -> Emphasis$.MODULE$.apply((Seq<Span>)_$4), true, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'\\')));
        this.matchUnderscoreStrong = new DelimMatcher(this, "__", (Function1<Seq<Span>, Span>)(Function1 & Serializable)_$5 -> Strong$.MODULE$.apply((Seq<Span>)_$5), true, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'\\')));
        this.matchAsterixStrong = new DelimMatcher(this, "**", (Function1<Seq<Span>, Span>)(Function1 & Serializable)_$6 -> Strong$.MODULE$.apply((Seq<Span>)_$6), true, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'\\')));
        this.matchUnderscoreStrongAndEm = new DelimMatcher(this, "___", (Function1<Seq<Span>, Span>)(Function1 & Serializable)seq -> Strong$.MODULE$.apply((Seq<Span>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Emphasis[]{Emphasis$.MODULE$.apply((Seq<Span>)seq)})))), true, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'\\')));
        this.matchAsterixStrongAndEm = new DelimMatcher(this, "***", (Function1<Seq<Span>, Span>)(Function1 & Serializable)seq -> Strong$.MODULE$.apply((Seq<Span>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Emphasis[]{Emphasis$.MODULE$.apply((Seq<Span>)seq)})))), true, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)'\\')));
        this.matchDoubleCodes = new DelimMatcher(this, "``", (Function1<Seq<Span>, Span>)(Function1 & Serializable)s -> CodeSpan$.MODULE$.apply(((Text)s.head()).content()), false, (Option<Object>)None$.MODULE$);
        this.matchSingleCodes = new DelimMatcher(this, "`", (Function1<Seq<Span>, Span>)(Function1 & Serializable)s -> CodeSpan$.MODULE$.apply(((Text)s.head()).content()), false, (Option<Object>)None$.MODULE$);
        this.startElement = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("<[ ]*([a-zA-Z0-9:_]+)[ \\t]*[^>]*?(/?+)>"));
        this.matchEntityRE = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("&\\w+;"));
        this.automaticLinkRE = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("<((http:|mailto:|https:)\\S+)>"));
    }

    public final SpanConverter$SpanMatch$ SpanMatch() {
        return this.SpanMatch$lzy1;
    }

    public Seq<Span> apply(Chunk chunk) {
        Seq seq;
        Chunk chunk2 = chunk;
        if (chunk2 instanceof IndentedChunk) {
            String string;
            IndentedChunk indentedChunk = IndentedChunk$.MODULE$.unapply((IndentedChunk)chunk2);
            String content = string = indentedChunk._1();
            seq = (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{new Text(content)}));
        } else {
            seq = this.convert(chunk.content(), (List<Span>)package$.MODULE$.Nil());
        }
        return seq;
    }

    public final Seq<Span> convert(String content, List<Span> current2) {
        List list;
        block3: {
            Option<String> option;
            SpanConverter spanConverter = this;
            List list2 = current2;
            String string = content;
            while (true) {
                if (string.isEmpty()) {
                    list = list2;
                    break block3;
                }
                SpanMatch textOnly = spanConverter.SpanMatch().apply(string.length(), (Option<Text>)None$.MODULE$, Text$.MODULE$.apply(string), (Option<String>)None$.MODULE$);
                SpanMatch best = (SpanMatch)spanConverter.matchers().foldLeft((Object)textOnly, (Function2 & Serializable)(current, findMatch) -> {
                    SpanMatch spanMatch;
                    Option option = (Option)findMatch.apply((Object)string);
                    if (None$.MODULE$.equals(option)) {
                        spanMatch = current;
                    } else if (option instanceof Some) {
                        SpanMatch nextMatch = (SpanMatch)((Some)option).value();
                        spanMatch = nextMatch.index() < current.index() ? nextMatch : current;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return spanMatch;
                });
                List list3 = best.before().toList();
                List updated = ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Span[]{best.current()}))).$colon$colon$colon(list3).$colon$colon$colon(list2);
                option = best.after();
                if (None$.MODULE$.equals(option)) {
                    list = updated;
                    break block3;
                }
                if (!(option instanceof Some)) break;
                String remaining = (String)((Some)option).value();
                SpanConverter spanConverter2 = spanConverter;
                String string2 = remaining;
                List list4 = updated;
                spanConverter = spanConverter2;
                string = string2;
                list2 = list4;
            }
            throw new MatchError(option);
        }
        return list;
    }

    public List<Function1<String, Option<SpanMatch>>> matchers() {
        return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{this.matchDoubleCodes(), this.matchSingleCodes(), (Function1 & Serializable)source -> this.findReferenceMatch((String)source), (Function1 & Serializable)source -> this.findAutomaticMatch((String)source), (Function1 & Serializable)source -> this.findNormalMatch((String)source), (Function1 & Serializable)source -> this.matchHTMLComment((String)source), (Function1 & Serializable)source -> this.matchEntity((String)source), (Function1 & Serializable)source -> this.matchHTMLSpan((String)source), this.matchUnderscoreStrongAndEm(), this.matchAsterixStrongAndEm(), this.matchUnderscoreStrong(), this.matchAsterixStrong(), this.matchUnderscoreEmphasis(), this.matchAsterixEmphasis()}));
    }

    public DelimMatcher matchUnderscoreEmphasis() {
        return this.matchUnderscoreEmphasis;
    }

    public DelimMatcher matchAsterixEmphasis() {
        return this.matchAsterixEmphasis;
    }

    public DelimMatcher matchUnderscoreStrong() {
        return this.matchUnderscoreStrong;
    }

    public DelimMatcher matchAsterixStrong() {
        return this.matchAsterixStrong;
    }

    public DelimMatcher matchUnderscoreStrongAndEm() {
        return this.matchUnderscoreStrongAndEm;
    }

    public DelimMatcher matchAsterixStrongAndEm() {
        return this.matchAsterixStrongAndEm;
    }

    public DelimMatcher matchDoubleCodes() {
        return this.matchDoubleCodes;
    }

    public DelimMatcher matchSingleCodes() {
        return this.matchSingleCodes;
    }

    public Option<SpanMatch> matchHTMLSpan(String source) {
        return this.startElement.findFirstMatchIn((CharSequence)source).map((Function1 & Serializable)open -> {
            SpanMatch spanMatch;
            String string = open.group(2);
            String string2 = "/";
            boolean hasEnd = !(string != null ? !string.equals(string2) : string2 != null);
            Option before = KnockoffString$.MODULE$.toOption$extension(this.KnockoffString(open.before())).map((Function1 & Serializable)_$7 -> Text$.MODULE$.apply((String)_$7));
            SpanMatch noEnd = this.SpanMatch().apply(open.start(), (Option<Text>)before, HTMLSpan$.MODULE$.apply(open.matched()), KnockoffString$.MODULE$.toOption$extension(this.KnockoffString(open.after())));
            if (!hasEnd) {
                Tuple2 tuple2;
                Option<Tuple2<Object, CharSequence>> option = this.hasMatchedClose(source, open.group(1), open.end(), 1);
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    int close = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    CharSequence after = (CharSequence)tuple2._2();
                    Option before2 = KnockoffString$.MODULE$.toOption$extension(this.KnockoffString(open.before())).map((Function1 & Serializable)_$8 -> Text$.MODULE$.apply((String)_$8));
                    HTMLSpan html = HTMLSpan$.MODULE$.apply(source.substring(open.start(), close));
                    spanMatch = this.SpanMatch().apply(open.start(), (Option<Text>)before2, html, KnockoffString$.MODULE$.toOption$extension(this.KnockoffString(after)));
                    return spanMatch;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    spanMatch = noEnd;
                }
                return spanMatch;
            } else {
                spanMatch = noEnd;
            }
            return spanMatch;
        });
    }

    private Option<Tuple2<Object, CharSequence>> hasMatchedClose(String source, String tag, int from, int opens) {
        None$ none$;
        block3: {
            Option nextClose;
            SpanConverter spanConverter = this;
            int n = opens;
            int n2 = from;
            while (true) {
                Regex opener = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?i)<[ ]*" + tag + "[ \t]*[^>]*?(/?+)*>"));
                Regex closer = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?i)</[ ]*" + tag + "[ ]*>"));
                Option nextOpen = opener.findFirstMatchIn((CharSequence)source.substring(n2));
                nextClose = closer.findFirstMatchIn((CharSequence)source.substring(n2));
                if (!nextClose.isDefined()) {
                    none$ = None$.MODULE$;
                    break block3;
                }
                if (nextOpen.isDefined() && ((Regex.Match)nextOpen.get()).start() < ((Regex.Match)nextClose.get()).start()) {
                    SpanConverter spanConverter2 = spanConverter;
                    int n3 = n2 + ((Regex.Match)nextOpen.get()).end();
                    int n4 = n + 1;
                    spanConverter = spanConverter2;
                    n2 = n3;
                    n = n4;
                    continue;
                }
                if (n <= 1) break;
                SpanConverter spanConverter3 = spanConverter;
                int n5 = n2 + ((Regex.Match)nextClose.get()).end();
                int n6 = n - 1;
                spanConverter = spanConverter3;
                n2 = n5;
                n = n6;
            }
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(n2 + ((Regex.Match)nextClose.get()).end())), (Object)((Regex.MatchData)nextClose.get()).after()));
        }
        return none$;
    }

    public Option<SpanMatch> matchEntity(String source) {
        return this.matchEntityRE.findFirstMatchIn((CharSequence)source).map((Function1 & Serializable)entityMatch -> {
            Option before = KnockoffString$.MODULE$.toOption$extension(this.KnockoffString(entityMatch.before())).map((Function1 & Serializable)_$9 -> Text$.MODULE$.apply((String)_$9));
            HTMLSpan html = HTMLSpan$.MODULE$.apply(entityMatch.matched());
            return this.SpanMatch().apply(entityMatch.start(), (Option<Text>)before, html, KnockoffString$.MODULE$.toOption$extension(this.KnockoffString(entityMatch.after())));
        });
    }

    public Option<SpanMatch> matchHTMLComment(String source) {
        None$ none$;
        int open = source.indexOf("<!--");
        if (open > -1) {
            int close = source.indexOf("-->", open);
            if (close > -1) {
                Option before = KnockoffString$.MODULE$.toOption$extension(this.KnockoffString(source.substring(0, open))).map((Function1 & Serializable)_$10 -> Text$.MODULE$.apply((String)_$10));
                HTMLSpan html = HTMLSpan$.MODULE$.apply(source.substring(open, close + "-->".length()));
                Option<String> after = KnockoffString$.MODULE$.toOption$extension(this.KnockoffString(source.substring(close + "-->".length())));
                none$ = Some$.MODULE$.apply((Object)this.SpanMatch().apply(open, (Option<Text>)before, html, after));
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<SpanMatch> findAutomaticMatch(String source) {
        return this.automaticLinkRE.findFirstMatchIn((CharSequence)source).map((Function1 & Serializable)aMatch -> {
            String url = aMatch.group(1);
            Option before = KnockoffString$.MODULE$.toOption$extension(this.KnockoffString(aMatch.before())).map((Function1 & Serializable)_$11 -> Text$.MODULE$.apply((String)_$11));
            Link link = Link$.MODULE$.apply((Seq<Span>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{Text$.MODULE$.apply(url)}))), url, (Option<String>)None$.MODULE$);
            return this.SpanMatch().apply(aMatch.start(), (Option<Text>)before, link, KnockoffString$.MODULE$.toOption$extension(this.KnockoffString(aMatch.after())));
        });
    }

    public Option<SpanMatch> findNormalMatch(String source) {
        int imageIdx = source.indexOf(33);
        int firstOpen = source.indexOf(91);
        return firstOpen == -1 ? None$.MODULE$ : KnockoffString$.MODULE$.findBalanced$extension(this.KnockoffString(source), '[', ']', firstOpen).flatMap((Function1 & Serializable)firstClose -> this.findNormalMatch$$anonfun$3(source, imageIdx, firstOpen, BoxesRunTime.unboxToInt((Object)firstClose)));
    }

    public Option<SpanMatch> findReferenceMatch(String source) {
        int firstOpen = source.indexOf(91);
        return firstOpen == -1 ? None$.MODULE$ : KnockoffString$.MODULE$.findBalanced$extension(this.KnockoffString(source), '[', ']', firstOpen).flatMap((Function1 & Serializable)firstClose -> this.findReferenceMatch$$anonfun$4(source, firstOpen, BoxesRunTime.unboxToInt((Object)firstClose)));
    }

    public static final /* synthetic */ Text knockoff$SpanConverter$DelimMatcher$$_$_$$anonfun$1(String _$2) {
        return Text$.MODULE$.apply(_$2);
    }

    private final /* synthetic */ Option findNormalMatch$$anonfun$3(String source$2, int imageIdx$1, int firstOpen$1, int firstClose) {
        String wrapped = source$2.substring(firstOpen$1 + 1, firstClose);
        String secondPart = source$2.substring(firstClose + 1);
        return StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\s*(\\()")).findFirstMatchIn((CharSequence)secondPart).flatMap((Function1 & Serializable)secondMatch -> {
            None$ none$;
            int secondOpen = secondMatch.start(1);
            int secondClose = BoxesRunTime.unboxToInt((Object)KnockoffString$.MODULE$.findBalanced$extension(this.KnockoffString(secondPart), '(', ')', secondOpen).get());
            if (secondClose == -1) {
                none$ = None$.MODULE$;
            } else {
                None$ none$2;
                Regex titleMatcher = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("<?([\\S&&[^)>]]*)>?[\\t ]+\"([^)]*)\""));
                String linkContent = secondPart.substring(secondOpen + 1, secondClose);
                ObjectRef url = ObjectRef.create((Object)"");
                Option option = titleMatcher.findFirstMatchIn((CharSequence)linkContent);
                if (option instanceof Some) {
                    Regex.Match matcher = (Regex.Match)((Some)option).value();
                    String string = matcher.group(1);
                    url.elem = string;
                    none$2 = Some$.MODULE$.apply((Object)matcher.group(2));
                } else if (None$.MODULE$.equals(option)) {
                    String string = linkContent;
                    url.elem = string;
                    none$2 = None$.MODULE$;
                } else {
                    throw new MatchError((Object)option);
                }
                None$ titleOpt = none$2;
                StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("<(.*)>")).findFirstMatchIn((CharSequence)((String)url.elem)).foreach((Function1)(JProcedure1 & Serializable)x -> {
                    String string = x.group(1);
                    url$1.elem = string;
                });
                Span link = (Span)(imageIdx$1 < firstOpen$1 && imageIdx$1 != -1 ? ImageLink$.MODULE$.apply(this.convert(wrapped, (List<Span>)package$.MODULE$.Nil()), (String)url.elem, (Option<String>)titleOpt) : Link$.MODULE$.apply(this.convert(wrapped, (List<Span>)package$.MODULE$.Nil()), (String)url.elem, (Option<String>)titleOpt));
                int start = imageIdx$1 != -1 ? Math.min(imageIdx$1, firstOpen$1) : firstOpen$1;
                None$ beforeOpt = start > 0 ? Some$.MODULE$.apply((Object)Text$.MODULE$.apply(source$2.substring(0, start))) : None$.MODULE$;
                int close = firstClose + secondClose + 1;
                None$ afterOpt = source$2.length() > close + 1 ? Some$.MODULE$.apply((Object)source$2.substring(close + 1)) : None$.MODULE$;
                none$ = Some$.MODULE$.apply((Object)this.SpanMatch().apply(start, (Option<Text>)beforeOpt, link, (Option<String>)afterOpt));
            }
            return none$;
        });
    }

    private final /* synthetic */ Option findReferenceMatch$$anonfun$4(String source$4, int firstOpen$3, int firstClose) {
        String secondPart = source$4.substring(firstClose + 1);
        return StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^\\s*(\\[)")).findFirstMatchIn((CharSequence)secondPart).flatMap((Function1 & Serializable)secondMatch -> {
            None$ none$;
            int secondClose = BoxesRunTime.unboxToInt((Object)KnockoffString$.MODULE$.findBalanced$extension(this.KnockoffString(secondPart), '[', ']', secondMatch.start(1)).get());
            if (secondClose == -1) {
                none$ = None$.MODULE$;
            } else {
                String no2 = secondPart.substring(secondMatch.start(1) + 1, secondClose);
                String refID = no2.isEmpty() ? source$4.substring(firstOpen$3 + 1, firstClose) : no2;
                Option precedingText = KnockoffString$.MODULE$.toOption$extension(this.KnockoffString(source$4.substring(0, firstOpen$3))).map((Function1 & Serializable)_$12 -> Text$.MODULE$.apply((String)_$12));
                none$ = this.definitions.find((Function1 & Serializable)_$13 -> _$13.id().equalsIgnoreCase(refID)).map((Function1 & Serializable)definition -> {
                    Link link = Link$.MODULE$.apply((Seq<Span>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{Text$.MODULE$.apply(source$4.substring(firstOpen$3 + 1, firstClose))}))), definition.url(), definition.title());
                    Option<String> after = KnockoffString$.MODULE$.toOption$extension(this.KnockoffString(source$4.substring(firstClose + secondClose + 2)));
                    return this.SpanMatch().apply(firstOpen$3, (Option<Text>)precedingText, link, after);
                });
            }
            return none$;
        });
    }

    public class DelimMatcher
    implements Function1<String, Option<SpanMatch>> {
        private final String delim;
        private final Function1<Seq<Span>, Span> toSpan;
        private final boolean recursive;
        private final Option<Object> escape;
        private final SpanConverter $outer;

        public DelimMatcher(SpanConverter $outer, String delim, Function1<Seq<Span>, Span> toSpan, boolean recursive, Option<Object> escape) {
            this.delim = delim;
            this.toSpan = toSpan;
            this.recursive = recursive;
            this.escape = escape;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public Option<SpanMatch> apply(String source) {
            None$ none$;
            SeqOps seqOps;
            List<Object> list = KnockoffString$.MODULE$.nextNIndicesOf$extension(this.$outer.KnockoffString(source), 2, this.delim, this.escape);
            if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq(list), 2) == 0) {
                int n = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0));
                int n2 = BoxesRunTime.unboxToInt((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1));
                int start = n;
                int end = n2;
                if (start + this.delim.length() >= end) {
                    none$ = None$.MODULE$;
                } else {
                    String contained = source.substring(start + this.delim.length(), end);
                    Seq content = this.recursive ? this.$outer.convert(contained, (List<Span>)package$.MODULE$.Nil()) : (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{Text$.MODULE$.apply(contained)}));
                    Option before = KnockoffString$.MODULE$.substringOption$extension(this.$outer.KnockoffString(source), 0, start).map(SpanConverter::knockoff$SpanConverter$DelimMatcher$$_$_$$anonfun$1);
                    Option<String> after = KnockoffString$.MODULE$.substringOption$extension(this.$outer.KnockoffString(source), end + this.delim.length(), source.length());
                    Span mapped = (Span)this.toSpan.apply((Object)content);
                    none$ = Some$.MODULE$.apply((Object)this.$outer.SpanMatch().apply(start, (Option<Text>)before, mapped, after));
                }
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public final SpanConverter knockoff$SpanConverter$DelimMatcher$$$outer() {
            return this.$outer;
        }
    }

    public class SpanMatch
    implements Product,
    Serializable {
        private final int index;
        private final Option before;
        private final Span current;
        private final Option after;
        private final SpanConverter $outer;

        public SpanMatch(SpanConverter $outer, int index, Option<Text> before, Span current, Option<String> after) {
            this.index = index;
            this.before = before;
            this.current = current;
            this.after = after;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.index());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.before()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.current()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.after()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SpanMatch)) return false;
            if (((SpanMatch)object).knockoff$SpanConverter$SpanMatch$$$outer() != this.$outer) return false;
            SpanMatch spanMatch = (SpanMatch)object;
            if (this.index() != spanMatch.index()) return false;
            Option<Text> option = this.before();
            Option<Text> option2 = spanMatch.before();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Span span = this.current();
            Span span2 = spanMatch.current();
            if (span == null) {
                if (span2 != null) {
                    return false;
                }
            } else if (!span.equals(span2)) return false;
            Option<String> option3 = this.after();
            Option<String> option4 = spanMatch.after();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!spanMatch.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SpanMatch;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "SpanMatch";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "index";
                    break;
                }
                case 1: {
                    string = "before";
                    break;
                }
                case 2: {
                    string = "current";
                    break;
                }
                case 3: {
                    string = "after";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public int index() {
            return this.index;
        }

        public Option<Text> before() {
            return this.before;
        }

        public Span current() {
            return this.current;
        }

        public Option<String> after() {
            return this.after;
        }

        public SpanMatch copy(int index, Option<Text> before, Span current, Option<String> after) {
            return new SpanMatch(this.$outer, index, before, current, after);
        }

        public int copy$default$1() {
            return this.index();
        }

        public Option<Text> copy$default$2() {
            return this.before();
        }

        public Span copy$default$3() {
            return this.current();
        }

        public Option<String> copy$default$4() {
            return this.after();
        }

        public int _1() {
            return this.index();
        }

        public Option<Text> _2() {
            return this.before();
        }

        public Span _3() {
            return this.current();
        }

        public Option<String> _4() {
            return this.after();
        }

        public final SpanConverter knockoff$SpanConverter$SpanMatch$$$outer() {
            return this.$outer;
        }
    }
}

