/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.ui.contentassist;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.util.OnChangeEvictingCache;

public class ContainerUtil {
    @Inject
    private IGlobalScopeProvider globalScopeProvider;
    @Inject
    private IResourceDescription.Manager descriptionManager;
    @Inject
    private IContainer.Manager containerManager;
    @Inject
    private ResourceDescriptionsProvider provider;

    public IResourceDescriptions getResourceDescriptions(Resource resource) {
        return this.provider.getResourceDescriptions(resource);
    }

    public List<IContainer> getVisibleContainers(Resource resource) {
        IResourceDescription description = this.descriptionManager.getResourceDescription(resource);
        IResourceDescriptions resourceDescriptions = this.getResourceDescriptions(resource);
        String cacheKey = this.getCacheKey("VisibleContainers", resource.getResourceSet());
        OnChangeEvictingCache.CacheAdapter cache = new OnChangeEvictingCache().getOrCreate(resource);
        List result = null;
        result = (List)cache.get((Object)cacheKey);
        if (result == null) {
            result = this.containerManager.getVisibleContainers(description, resourceDescriptions);
            cache.set((Object)cacheKey, (Object)result);
        }
        return result;
    }

    protected String getCacheKey(String base, ResourceSet context) {
        Map loadOptions = context.getLoadOptions();
        if (loadOptions.containsKey("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE")) {
            return String.valueOf(base) + "@" + "org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE";
        }
        return String.valueOf(base) + "@DEFAULT_SCOPE";
    }
}

