/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.ui.contentassist;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FStructType;
import org.franca.core.franca.FType;
import org.franca.core.franca.FTypeCollection;
import org.franca.core.franca.FUnionType;
import org.franca.core.utils.FrancaIDLUtils;
import org.franca.deploymodel.core.FDModelUtils;
import org.franca.deploymodel.dsl.fDeploy.FDAbstractExtensionElement;
import org.franca.deploymodel.dsl.fDeploy.FDBuiltInPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDModel;
import org.franca.deploymodel.dsl.fDeploy.FDOverwriteElement;
import org.franca.deploymodel.dsl.fDeploy.FDeployPackage;
import org.franca.deploymodel.dsl.fDeploy.Import;
import org.franca.deploymodel.dsl.scoping.DeploySpecProvider;
import org.franca.deploymodel.dsl.ui.contentassist.AbstractFDeployProposalProvider;
import org.franca.deploymodel.dsl.ui.contentassist.ContainerUtil;
import org.franca.deploymodel.extensions.ExtensionRegistry;
import org.franca.deploymodel.extensions.IFDeployExtension;

public class FDeployProposalProvider
extends AbstractFDeployProposalProvider {
    @Inject
    DeploySpecProvider deploySpecProvider;
    @Inject
    ContainerUtil containerUtil;
    private static final List<String> extensionsForImportURIScope = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"fidl", "fdepl"}));
    private Set<String> filteredKeywords = Sets.newHashSet();

    public void complete_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Assignment ass = GrammarUtil.containingAssignment((EObject)ruleCall);
        if (ass == null || !"importURI".equals(ass.getFeature())) {
            super.complete_STRING(model, ruleCall, context, acceptor);
        }
    }

    @Override
    public void completeFDTypes_Target(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        IScope scope = this.getScopeProvider().getScope(model, FDeployPackage.Literals.FD_TYPES__TARGET);
        Iterable _allElements = scope.getAllElements();
        for (IEObjectDescription description : _allElements) {
            EObject _eObjectOrProxy = description.getEObjectOrProxy();
            FTypeCollection collection = (FTypeCollection)_eObjectOrProxy;
            String qualifiedName = description.getQualifiedName().toString();
            String uri = collection.eResource().getURI().toString();
            if (collection.getName() == null || collection.getName().isEmpty()) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(qualifiedName);
                _builder.append(" (anonymous) - ");
                _builder.append(uri);
                acceptor.accept(this.createCompletionProposal(qualifiedName, _builder.toString(), null, context));
                continue;
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(qualifiedName);
            _builder_1.append(" - ");
            _builder_1.append(uri);
            acceptor.accept(this.createCompletionProposal(qualifiedName, _builder_1.toString(), null, context));
        }
    }

    @Override
    public void completeImport_ImportURI(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List<IContainer> visibleContainers = this.containerUtil.getVisibleContainers(model.eResource());
        URI fromURI = model.eResource().getURI();
        ArrayList proposedURIs = CollectionLiterals.newArrayList((Object[])new URI[0]);
        FDModel fdmodel = null;
        if (model instanceof FDModel) {
            fdmodel = (FDModel)model;
        } else if (model instanceof Import) {
            EObject _eContainer = ((Import)model).eContainer();
            fdmodel = (FDModel)_eContainer;
        }
        EList imports = fdmodel.getImports();
        ArrayList importedUris = Lists.newArrayList();
        for (Import import1 : imports) {
            importedUris.add(import1.getImportURI());
        }
        for (IContainer iContainer : visibleContainers) {
            Iterable resourceDescriptions = iContainer.getResourceDescriptions();
            for (IResourceDescription _next : resourceDescriptions) {
                IResourceDescription desc = _next;
                URI uri = desc.getURI();
                if (uri.equals(fromURI) || !extensionsForImportURIScope.contains(uri.fileExtension())) continue;
                proposedURIs.add(desc.getURI());
            }
        }
        for (URI uri : proposedURIs) {
            boolean _not;
            String result = FrancaIDLUtils.relativeURIString((URI)fromURI, (URI)uri);
            boolean _contains = importedUris.contains(result);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            StringConcatenation _builder = new StringConcatenation();
            String _lastSegment = uri.lastSegment();
            _builder.append(_lastSegment);
            _builder.append(" - ");
            _builder.append(result);
            String displayString = _builder.toString();
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("\"");
            _builder_1.append(result);
            _builder_1.append("\"");
            acceptor.accept(this.createCompletionProposal(_builder_1.toString(), displayString, null, context));
        }
        ArrayList classpathResources = CollectionLiterals.newArrayList((Object[])new URI[0]);
        ResourceSet _resourceSet = model.eResource().getResourceSet();
        XtextResourceSet resourceSet = (XtextResourceSet)_resourceSet;
        Object classpathURIContext = resourceSet.getClasspathURIContext();
        if (classpathURIContext instanceof JavaProject) {
            for (IContainer iContainer_1 : visibleContainers) {
                Iterable resourceDescriptions = iContainer_1.getResourceDescriptions();
                for (IResourceDescription rd : resourceDescriptions) {
                    URI uri_1 = rd.getURI();
                    String uriModel = model.eResource().getURI().toString();
                    if (uri_1.toString() == uriModel || !extensionsForImportURIScope.contains(uri_1.fileExtension())) continue;
                    classpathResources.add(uri_1);
                }
            }
        }
        this.createProposals(context, acceptor, classpathResources, fromURI, importedUris);
        super.completeImport_ImportURI(model, assignment, context, acceptor);
    }

    private void createProposals(ContentAssistContext context, ICompletionProposalAcceptor acceptor, List<URI> classpathResources, URI fromURI, List<String> importedUris) {
        for (URI path : classpathResources) {
            boolean _not;
            String classpathString = this.toClassPathString(path);
            boolean _contains = importedUris.contains(classpathString);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("\"");
            _builder.append(classpathString);
            _builder.append("\"");
            String result = _builder.toString();
            StringConcatenation _builder_1 = new StringConcatenation();
            String _lastSegment = path.lastSegment();
            _builder_1.append(_lastSegment);
            _builder_1.append(" - ");
            _builder_1.append(classpathString);
            String displayString = _builder_1.toString();
            acceptor.accept(this.createCompletionProposal(result, displayString, null, context));
        }
    }

    @Override
    public void completeImport_ImportedSpec(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Collection entries = this.deploySpecProvider.getEntries();
        for (DeploySpecProvider.DeploySpecEntry dse : entries) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(dse.alias);
            _builder.append(" - ");
            _builder.append(dse.resourceId);
            acceptor.accept(this.createCompletionProposal(dse.alias, _builder.toString(), null, context));
        }
    }

    private String toClassPathString(URI uri) {
        String _xblockexpression = null;
        List<String> segments = this.classPathSegments(uri.segmentsList());
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("classpath:/");
        String _join = IterableExtensions.join(segments, (CharSequence)"/");
        _builder.append(_join);
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private List<String> classPathSegments(List<String> list) {
        return list.subList(3, list.size());
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        IFDeployExtension.AbstractElementDef elementDef;
        EObject obj;
        boolean _contains = this.filteredKeywords.contains(keyword.getValue());
        if (_contains) {
            return;
        }
        String _value = keyword.getValue();
        boolean _equals = Objects.equal((Object)_value, (Object)"as");
        if (_equals && (obj = contentAssistContext.getPreviousModel()) instanceof FDAbstractExtensionElement && ((elementDef = ExtensionRegistry.getElement((FDAbstractExtensionElement)((FDAbstractExtensionElement)obj))) == null || !elementDef.mayHaveName())) {
            return;
        }
        super.completeKeyword(keyword, contentAssistContext, acceptor);
    }

    @Override
    public void complete_PROPERTY_HOST(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String proposal;
        FDBuiltInPropertyHost[] _values = FDBuiltInPropertyHost.values();
        FDBuiltInPropertyHost[] fDBuiltInPropertyHostArray = _values;
        int n = _values.length;
        int n2 = 0;
        while (n2 < n) {
            FDBuiltInPropertyHost host = fDBuiltInPropertyHostArray[n2];
            proposal = host.getLiteral();
            String displayString = String.valueOf(proposal) + " (built-in)";
            acceptor.accept(this.createCompletionProposal(proposal, displayString, null, context));
            ++n2;
        }
        Map extensionHosts = ExtensionRegistry.getHosts();
        Set _keySet = extensionHosts.keySet();
        for (IFDeployExtension.Host host_1 : _keySet) {
            proposal = host_1.getName();
            String _shortDescription = ((IFDeployExtension)extensionHosts.get(host_1)).getShortDescription();
            String _plus = String.valueOf(proposal) + " (" + _shortDescription;
            String displayString = String.valueOf(_plus) + ")";
            acceptor.accept(this.createCompletionProposal(proposal, displayString, null, context));
        }
    }

    @Override
    public void completeFDExtensionRoot_Tag(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Map roots = ExtensionRegistry.getRoots();
        Set _keySet = roots.keySet();
        for (IFDeployExtension.RootDef root : _keySet) {
            String proposal = root.getTag();
            String _shortDescription = ((IFDeployExtension)roots.get(root)).getShortDescription();
            String _plus = String.valueOf(proposal) + " (" + _shortDescription;
            String displayString = String.valueOf(_plus) + ")";
            acceptor.accept(this.createCompletionProposal(proposal, displayString, null, context));
        }
        AbstractElement _terminal = assignment.getTerminal();
        this.completeRuleCall((RuleCall)_terminal, context, acceptor);
    }

    @Override
    public void complete_FDExtensionElement(EObject elem, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (elem instanceof FDAbstractExtensionElement) {
            IFDeployExtension.AbstractElementDef elementDef = ExtensionRegistry.getElement((FDAbstractExtensionElement)((FDAbstractExtensionElement)elem));
            Collection _children = elementDef.getChildren();
            for (IFDeployExtension.ElementDef child : _children) {
                String proposal = child.getTag();
                String displayString = String.valueOf(proposal) + " (from extension)";
                acceptor.accept(this.createCompletionProposal(proposal, displayString, null, context));
            }
        }
    }

    @Override
    public void completeFDExtensionType_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Map types = ExtensionRegistry.getTypes();
        Set _keySet = types.keySet();
        for (IFDeployExtension.TypeDef type : _keySet) {
            String proposal = type.getName();
            String _shortDescription = ((IFDeployExtension)types.get(type)).getShortDescription();
            String _plus = String.valueOf(proposal) + " (" + _shortDescription;
            String displayString = String.valueOf(_plus) + ")";
            acceptor.accept(this.createCompletionProposal(proposal, displayString, null, context));
        }
        AbstractElement _terminal = assignment.getTerminal();
        this.completeRuleCall((RuleCall)_terminal, context, acceptor);
    }

    @Override
    public void complete_FDTypeOverwrites(EObject elem, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        FType targetType = null;
        if (elem instanceof FDOverwriteElement) {
            targetType = FDModelUtils.getOverwriteTargetType((FDOverwriteElement)((FDOverwriteElement)elem));
        }
        if (targetType == null) {
            this.showKeywords(false, false, false, false);
        } else if (targetType instanceof FEnumerationType) {
            this.showKeywords(true, true, false, false);
        } else if (targetType instanceof FStructType) {
            this.showKeywords(true, false, true, false);
        } else if (targetType instanceof FUnionType) {
            this.showKeywords(true, false, false, true);
        } else {
            this.showKeywords(true, false, false, false);
        }
    }

    private void showKeywords(boolean plain, boolean enumeration, boolean struct, boolean union) {
        if (plain) {
            this.filteredKeywords.remove("#");
        } else {
            this.filteredKeywords.add("#");
        }
        if (enumeration) {
            this.filteredKeywords.remove("#enumeration");
        } else {
            this.filteredKeywords.add("#enumeration");
        }
        if (struct) {
            this.filteredKeywords.remove("#struct");
        } else {
            this.filteredKeywords.add("#struct");
        }
        if (union) {
            this.filteredKeywords.remove("#union");
        } else {
            this.filteredKeywords.add("#union");
        }
    }
}

