/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.ui.internal;

import com.google.inject.Module;
import org.franca.deploymodel.dsl.ui.FDeployUiModule;
import org.franca.deploymodel.dsl.ui.FDeployUiModuleWithoutJDT;
import org.franca.deploymodel.dsl.ui.internal.DslActivator;

public class FDeployAdaptiveActivator
extends DslActivator {
    @Override
    protected Module getUiModule(String grammar) {
        if ("org.franca.deploymodel.dsl.FDeploy".equals(grammar)) {
            boolean jdtAvailable = this.isJDTAvailable();
            if (jdtAvailable) {
                System.out.println("Franca Deployment: JDT is available.");
                return new FDeployUiModule(this);
            }
            System.out.println("Franca Deployment: JDT is not available.");
            return new FDeployUiModuleWithoutJDT(this);
        }
        throw new IllegalArgumentException(grammar);
    }

    private boolean isJDTAvailable() {
        boolean jdtAvailable;
        ClassLoader classLoader = FDeployAdaptiveActivator.class.getClassLoader();
        try {
            Class.forName("org.eclipse.jdt.core.JavaCore", false, classLoader);
            jdtAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            jdtAvailable = false;
        }
        return jdtAvailable;
    }
}

