/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.franca.core.franca.FType;
import org.franca.deploymodel.core.FDModelUtils;
import org.franca.deploymodel.core.FDPropertyHost;
import org.franca.deploymodel.core.GenericPropertyAccessor;
import org.franca.deploymodel.core.PropertyMappings;
import org.franca.deploymodel.dsl.fDeploy.FDArgument;
import org.franca.deploymodel.dsl.fDeploy.FDArray;
import org.franca.deploymodel.dsl.fDeploy.FDAttribute;
import org.franca.deploymodel.dsl.fDeploy.FDBoolean;
import org.franca.deploymodel.dsl.fDeploy.FDBroadcast;
import org.franca.deploymodel.dsl.fDeploy.FDBuiltInPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDDeclaration;
import org.franca.deploymodel.dsl.fDeploy.FDEnumerator;
import org.franca.deploymodel.dsl.fDeploy.FDField;
import org.franca.deploymodel.dsl.fDeploy.FDGeneric;
import org.franca.deploymodel.dsl.fDeploy.FDInteger;
import org.franca.deploymodel.dsl.fDeploy.FDInterface;
import org.franca.deploymodel.dsl.fDeploy.FDMap;
import org.franca.deploymodel.dsl.fDeploy.FDMethod;
import org.franca.deploymodel.dsl.fDeploy.FDProperty;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDString;
import org.franca.deploymodel.dsl.fDeploy.FDStruct;
import org.franca.deploymodel.dsl.fDeploy.FDTypedef;
import org.franca.deploymodel.dsl.fDeploy.FDUnion;
import org.franca.deploymodel.dsl.fDeploy.FDValue;
import org.franca.deploymodel.dsl.fDeploy.Import;

public class FDeployLabelProvider
extends DefaultEObjectLabelProvider {
    private final String DEFAULT_PROPERTY_MARKER = "?";
    private final String DEFAULT_VALUE_MARKER = "?=";

    @Inject
    public FDeployLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    public String text(FDMethod element) {
        return element.getTarget().getName();
    }

    public String text(FDInterface element) {
        return element.getTarget().getName();
    }

    public String text(FDAttribute element) {
        return element.getTarget().getName();
    }

    public String text(FDBroadcast element) {
        return element.getTarget().getName();
    }

    public String text(FDArgument element) {
        return element.getTarget().getName();
    }

    public String text(FDArray element) {
        return element.getTarget().getName();
    }

    public String text(FDField element) {
        return element.getTarget().getName();
    }

    public String text(FDStruct element) {
        return element.getTarget().getName();
    }

    public String text(FDUnion element) {
        return element.getTarget().getName();
    }

    public String text(FDMap element) {
        return element.getTarget().getName();
    }

    public String text(FDTypedef element) {
        return element.getTarget().getName();
    }

    public String text(FDProperty element) {
        return element.getDecl().getName();
    }

    public String text(FDInteger element) {
        String _defaultMarker = this.getDefaultMarker((EObject)element);
        String _valueOf = String.valueOf(element.getValue());
        return String.valueOf(_defaultMarker) + _valueOf;
    }

    public String text(FDString element) {
        String _defaultMarker = this.getDefaultMarker((EObject)element);
        String _value = element.getValue();
        return String.valueOf(_defaultMarker) + _value;
    }

    public String text(FDBoolean element) {
        String _defaultMarker = this.getDefaultMarker((EObject)element);
        String _value = element.getValue();
        return String.valueOf(_defaultMarker) + _value;
    }

    public String text(FDGeneric element) {
        String dm = this.getDefaultMarker((EObject)element);
        boolean _isEnumerator = FDModelUtils.isEnumerator((FDValue)element);
        if (_isEnumerator) {
            String _name = FDModelUtils.getEnumerator((FDValue)element).getName();
            return String.valueOf(dm) + _name;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(dm);
        _builder.append("UNKNOWN");
        return _builder.toString();
    }

    public String text(FDEnumerator element) {
        String _defaultMarker = this.getDefaultMarker((EObject)element);
        String _name = element.getName();
        return String.valueOf(_defaultMarker) + _name;
    }

    public String text(FDDeclaration element) {
        String name = element.getHost().getName();
        String _upperCase = name.substring(0, 1).toUpperCase();
        String _lowerCase = name.substring(1).toLowerCase();
        return String.valueOf(_upperCase) + _lowerCase;
    }

    public String text(FDPropertyDecl element) {
        boolean _not;
        String name = new String();
        boolean _isMandatory = PropertyMappings.isMandatory((FDPropertyDecl)element);
        boolean bl = _not = !_isMandatory;
        if (_not) {
            String _name = name;
            name = String.valueOf(_name) + "?";
        }
        String _name_1 = name;
        String _name_2 = element.getName();
        name = String.valueOf(_name_1) + _name_2;
        return name;
    }

    public String getDefaultMarker(EObject element) {
        boolean _isDefault;
        boolean _isSpecification = GenericPropertyAccessor.isSpecification((EObject)element);
        if (_isSpecification && (_isDefault = GenericPropertyAccessor.isDefault((EObject)element))) {
            return "?=";
        }
        return "";
    }

    public String image(FDInterface element) {
        return "interface.png";
    }

    public String image(FDAttribute element) {
        return "attribute.gif";
    }

    public String image(FDMethod element) {
        return "method.gif";
    }

    public String image(FDField element) {
        return "field.gif";
    }

    public String image(FDGeneric element) {
        boolean _isEnumerator = FDModelUtils.isEnumerator((FDValue)element);
        if (_isEnumerator) {
            return "enum.gif";
        }
        return null;
    }

    public String image(FDEnumerator element) {
        return "enumerator.gif";
    }

    public String image(FType element) {
        return "types.gif";
    }

    public String image(FDStruct element) {
        return "struct.gif";
    }

    public String image(FDUnion element) {
        return "struct.gif";
    }

    public String image(Import element) {
        return "import.gif";
    }

    public String image(FDBroadcast element) {
        return "event.png";
    }

    public String image(FDArgument element) {
        EObject parent = element.eContainer().eContainer();
        if (parent instanceof FDBroadcast || parent instanceof FDMethod && ((FDMethod)parent).getOutArguments().getArguments().contains((Object)element)) {
            return "overlay-out.gif";
        }
        return "overlay-in.gif";
    }

    public String image(FDDeclaration element) {
        FDPropertyHost host = element.getHost();
        FDBuiltInPropertyHost builtin = host.getBuiltIn();
        if (builtin == null) {
            return null;
        }
        if (builtin != null) {
            switch (builtin) {
                case INTERFACES: {
                    return "interface.png";
                }
                case ATTRIBUTES: {
                    return "attribute.gif";
                }
                case METHODS: {
                    return "method.gif";
                }
                case STRUCT_FIELDS: {
                    return "field.gif";
                }
                case UNION_FIELDS: {
                    return "field.gif";
                }
                case FIELDS: {
                    return "field.gif";
                }
                case ENUMERATIONS: {
                    return "enum.gif";
                }
                case ENUMERATORS: {
                    return "enumerator.gif";
                }
                case BROADCASTS: {
                    return "event.png";
                }
                case STRINGS: {
                    return "strings.png";
                }
                case NUMBERS: 
                case INTEGERS: 
                case FLOATS: {
                    return "numbers.png";
                }
                case ARRAYS: {
                    return "arrays.png";
                }
                case MAPS: {
                    return "map.png";
                }
            }
        }
        return null;
    }
}

