/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.ui.quickfix;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.FrancaModelExtensions;
import org.franca.core.franca.FArgument;
import org.franca.core.franca.FArrayType;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FEnumerator;
import org.franca.core.franca.FField;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FMapType;
import org.franca.core.franca.FMethod;
import org.franca.core.franca.FStructType;
import org.franca.core.franca.FType;
import org.franca.core.franca.FTypeDef;
import org.franca.core.franca.FUnionType;
import org.franca.deploymodel.core.FDModelUtils;
import org.franca.deploymodel.core.PropertyMappings;
import org.franca.deploymodel.dsl.fDeploy.FDArgument;
import org.franca.deploymodel.dsl.fDeploy.FDArgumentList;
import org.franca.deploymodel.dsl.fDeploy.FDArray;
import org.franca.deploymodel.dsl.fDeploy.FDBroadcast;
import org.franca.deploymodel.dsl.fDeploy.FDComplexValue;
import org.franca.deploymodel.dsl.fDeploy.FDElement;
import org.franca.deploymodel.dsl.fDeploy.FDEnumValue;
import org.franca.deploymodel.dsl.fDeploy.FDEnumeration;
import org.franca.deploymodel.dsl.fDeploy.FDField;
import org.franca.deploymodel.dsl.fDeploy.FDInterface;
import org.franca.deploymodel.dsl.fDeploy.FDMap;
import org.franca.deploymodel.dsl.fDeploy.FDMapKey;
import org.franca.deploymodel.dsl.fDeploy.FDMapValue;
import org.franca.deploymodel.dsl.fDeploy.FDMethod;
import org.franca.deploymodel.dsl.fDeploy.FDProperty;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDRootElement;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.fDeploy.FDStruct;
import org.franca.deploymodel.dsl.fDeploy.FDTypeRef;
import org.franca.deploymodel.dsl.fDeploy.FDTypes;
import org.franca.deploymodel.dsl.fDeploy.FDUnion;
import org.franca.deploymodel.dsl.fDeploy.FDeployFactory;
import org.franca.deploymodel.dsl.ui.quickfix.ExtensibleDefaultValueProvider;
import org.franca.deploymodel.dsl.ui.quickfix.FDeployQuickfixProviderUtil;
import org.franca.deploymodel.dsl.validation.FrancaQuickFixConstants;

public class FDeployQuickfixProvider
extends DefaultQuickfixProvider {
    @Fix(value="UPPERCASE_PROPERTYNAME_QUICKFIX")
    public void setUppercasePropertyName(Issue issue, IssueResolutionAcceptor acceptor) {
        String data = issue.getData()[0];
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Set first character to uppercase for property ");
        _builder.append(data);
        String description = _builder.toString();
        ISemanticModification _function = new ISemanticModification(){

            public void apply(EObject obj, IModificationContext context) throws Exception {
                if (obj instanceof FDPropertyDecl) {
                    boolean _tripleNotEquals;
                    FDTypeRef _type = ((FDPropertyDecl)obj).getType();
                    boolean bl = _tripleNotEquals = _type != null;
                    if (_tripleNotEquals) {
                        String newName = StringExtensions.toFirstUpper((String)((FDPropertyDecl)obj).getName());
                        ((FDPropertyDecl)obj).setName(newName);
                    }
                }
            }
        };
        acceptor.accept(issue, description, description, "", _function);
    }

    @Fix(value="DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX")
    public void applyRecursiveFix(Issue issue, IssueResolutionAcceptor acceptor) {
        final FrancaQuickFixConstants type = FrancaQuickFixConstants.valueOf((String)issue.getData()[1]);
        String _xifexpression = null;
        _xifexpression = type == FrancaQuickFixConstants.INTERFACE ? null : issue.getData()[0];
        final String elementName = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Fix all issues for element '");
        String _get = issue.getData()[0];
        _builder.append(_get);
        _builder.append("'");
        String description = _builder.toString();
        ISemanticModification _function = new ISemanticModification(){

            public void apply(EObject obj, IModificationContext context) throws Exception {
                if (obj instanceof FDInterface) {
                    FDeployQuickfixProvider.this.applyFixForInterfaceInternal((FDInterface)obj, type, elementName, true);
                } else if (obj instanceof FDTypes) {
                    FDeployQuickfixProvider.this.applyFixForTypesInternal((FDTypes)obj, type, elementName, true);
                } else if (obj instanceof FDElement) {
                    FDeployQuickfixProvider.this.applyFixForElementInternal((FDElement)obj, true);
                }
            }
        };
        acceptor.accept(issue, description, description, "", _function);
    }

    @Fix(value="DEPLOYMENT_ELEMENT_QUICKFIX")
    public void applyFixForInterface(Issue issue, IssueResolutionAcceptor acceptor) {
        final String elementName = issue.getData()[0];
        final FrancaQuickFixConstants type = FrancaQuickFixConstants.valueOf((String)issue.getData()[1]);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Add missing ");
        String _lowerCase = type.toString().toLowerCase();
        _builder.append(_lowerCase);
        _builder.append(" '");
        _builder.append(elementName);
        _builder.append("'");
        String description = _builder.toString();
        ISemanticModification _function = new ISemanticModification(){

            public void apply(EObject obj, IModificationContext context) throws Exception {
                if (obj instanceof FDInterface) {
                    FDeployQuickfixProvider.this.applyFixForInterfaceInternal((FDInterface)obj, type, elementName, false);
                } else if (obj instanceof FDTypes) {
                    FDeployQuickfixProvider.this.applyFixForTypesInternal((FDTypes)obj, type, elementName, false);
                }
            }
        };
        acceptor.accept(issue, description, description, "", _function);
    }

    @Fix(value="MANDATORY_PROPERTIES_QUICKFIX")
    public void applyFixForElement(Issue issue, IssueResolutionAcceptor acceptor) {
        String elementName = issue.getData()[0];
        String _xifexpression = null;
        int _size = ((List)Conversions.doWrapArray((Object)issue.getData())).size();
        boolean _greaterThan = _size > 1;
        _xifexpression = _greaterThan ? issue.getData()[1] : null;
        final String detail = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Add all missing mandatory properties for element '");
        _builder.append(elementName);
        _builder.append("'");
        String description = _builder.toString();
        ISemanticModification _function = new ISemanticModification(){

            public void apply(EObject obj, IModificationContext context) throws Exception {
                FDElement mapped = FDeployQuickfixProvider.this.mapActualElement(obj, detail);
                if (mapped != null) {
                    FDeployQuickfixProvider.this.applyFixForElementInternal(mapped, false);
                }
            }
        };
        acceptor.accept(issue, description, description, "", _function);
    }

    private FDElement mapActualElement(EObject obj, String detail) {
        FDElement _xifexpression = null;
        if (obj instanceof FDElement) {
            FDElement _xifexpression_1 = null;
            if (detail == null) {
                _xifexpression_1 = (FDElement)obj;
            } else {
                FDMapKey _xifexpression_2 = null;
                String _string = FrancaQuickFixConstants.MAP_KEY.toString();
                boolean _equals = Objects.equal((Object)detail, (Object)_string);
                if (_equals) {
                    FDMapKey _xifexpression_3 = null;
                    _xifexpression_3 = obj instanceof FDMap ? ((FDMap)obj).getKey() : null;
                    _xifexpression_2 = _xifexpression_3;
                } else {
                    FDMapValue _xifexpression_4 = null;
                    String _string_1 = FrancaQuickFixConstants.MAP_VALUE.toString();
                    boolean _equals_1 = Objects.equal((Object)detail, (Object)_string_1);
                    if (_equals_1) {
                        FDMapValue _xifexpression_5 = null;
                        _xifexpression_5 = obj instanceof FDMap ? ((FDMap)obj).getValue() : null;
                        _xifexpression_4 = _xifexpression_5;
                    } else {
                        _xifexpression_4 = null;
                    }
                    _xifexpression_2 = _xifexpression_4;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    @Fix(value="METHOD_ARGUMENT_QUICKFIX")
    public void applyFixForMethod(Issue issue, IssueResolutionAcceptor acceptor) {
        String opName = issue.getData()[0];
        final String argumentName = issue.getData()[1];
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Add missing argument '");
        _builder.append(argumentName);
        _builder.append("' for method '");
        _builder.append(opName);
        _builder.append("'");
        String description = _builder.toString();
        ISemanticModification _function = new ISemanticModification(){

            public void apply(EObject obj, IModificationContext context) throws Exception {
                if (obj instanceof FDMethod) {
                    FDeployQuickfixProvider.this.applyFixForMethodInternal((FDMethod)obj, false, new String[]{argumentName});
                }
            }
        };
        acceptor.accept(issue, description, description, "", _function);
    }

    @Fix(value="BROADCAST_ARGUMENT_QUICKFIX")
    public void applyFixForBroadcast(Issue issue, IssueResolutionAcceptor acceptor) {
        String opName = issue.getData()[0];
        final String argumentName = issue.getData()[1];
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Add missing argument '");
        _builder.append(argumentName);
        _builder.append("' for broadcast '");
        _builder.append(opName);
        _builder.append("'");
        String description = _builder.toString();
        ISemanticModification _function = new ISemanticModification(){

            public void apply(EObject obj, IModificationContext context) throws Exception {
                if (obj instanceof FDBroadcast) {
                    FDeployQuickfixProvider.this.applyFixForBroadcastInternal((FDBroadcast)obj, false, new String[]{argumentName});
                }
            }
        };
        acceptor.accept(issue, description, description, "", _function);
    }

    @Fix(value="COMPOUND_FIELD_QUICKFIX")
    public void applyFixForCompound(Issue issue, IssueResolutionAcceptor acceptor) {
        String compoundName = issue.getData()[0];
        final String fieldName = issue.getData()[1];
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Add missing field '");
        _builder.append(fieldName);
        _builder.append("' for compound '");
        _builder.append(compoundName);
        _builder.append("'");
        String description = _builder.toString();
        ISemanticModification _function = new ISemanticModification(){

            public void apply(EObject obj, IModificationContext context) throws Exception {
                if (obj instanceof FDUnion) {
                    FDeployQuickfixProvider.this.applyFixForUnionInternal((FDUnion)obj, false, new String[]{fieldName});
                } else if (obj instanceof FDStruct) {
                    FDeployQuickfixProvider.this.applyFixForStructInternal((FDStruct)obj, false, new String[]{fieldName});
                }
            }
        };
        acceptor.accept(issue, description, description, "", _function);
    }

    @Fix(value="ENUMERATOR_ENUM_QUICKFIX")
    public void applyFixForEnumeration(Issue issue, IssueResolutionAcceptor acceptor) {
        String enumeratorName = issue.getData()[0];
        final String enumName = issue.getData()[1];
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Add enumerator '");
        _builder.append(enumName);
        _builder.append("' for enumeration '");
        _builder.append(enumeratorName);
        _builder.append("'");
        String description = _builder.toString();
        ISemanticModification _function = new ISemanticModification(){

            public void apply(EObject obj, IModificationContext context) throws Exception {
                if (obj instanceof FDEnumeration) {
                    FDeployQuickfixProvider.this.applyFixForEnumerationInternal((FDEnumeration)obj, false, new String[]{enumName});
                }
            }
        };
        acceptor.accept(issue, description, description, "", _function);
    }

    @Fix(value="MAP_KEY_QUICKFIX")
    public void applyFixForMapKey(Issue issue, IssueResolutionAcceptor acceptor) {
        String mapName = issue.getData()[0];
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Add key section for map type '");
        _builder.append(mapName);
        _builder.append("'");
        String description = _builder.toString();
        ISemanticModification _function = new ISemanticModification(){

            public void apply(EObject obj, IModificationContext context) throws Exception {
                if (obj instanceof FDMap) {
                    FDeployQuickfixProvider.this.applyFixForMapKeyInternal((FDMap)obj, false);
                }
            }
        };
        acceptor.accept(issue, description, description, "", _function);
    }

    @Fix(value="MAP_VALUE_QUICKFIX")
    public void applyFixForMapValue(Issue issue, IssueResolutionAcceptor acceptor) {
        String mapName = issue.getData()[0];
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Add value section for map type '");
        _builder.append(mapName);
        _builder.append("'");
        String description = _builder.toString();
        ISemanticModification _function = new ISemanticModification(){

            public void apply(EObject obj, IModificationContext context) throws Exception {
                if (obj instanceof FDMap) {
                    FDeployQuickfixProvider.this.applyFixForMapValueInternal((FDMap)obj, false);
                }
            }
        };
        acceptor.accept(issue, description, description, "", _function);
    }

    private void applyFixForMethodInternal(FDMethod method, boolean isRecursive, String ... args) {
        if (method.getTarget().getInArgs().size() > 0 && method.getInArguments() == null) {
            method.setInArguments(FDeployFactory.eINSTANCE.createFDArgumentList());
        }
        this.applyFixForArgList(method.getInArguments(), (List<FArgument>)method.getTarget().getInArgs(), isRecursive, args);
        if (method.getTarget().getOutArgs().size() > 0 && method.getOutArguments() == null) {
            method.setOutArguments(FDeployFactory.eINSTANCE.createFDArgumentList());
        }
        this.applyFixForArgList(method.getOutArguments(), (List<FArgument>)method.getTarget().getOutArgs(), isRecursive, args);
    }

    private void applyFixForBroadcastInternal(FDBroadcast broadcast, boolean isRecursive, String ... args) {
        if (broadcast.getTarget().getOutArgs().size() > 0 && broadcast.getOutArguments() == null) {
            broadcast.setOutArguments(FDeployFactory.eINSTANCE.createFDArgumentList());
        }
        this.applyFixForArgList(broadcast.getOutArguments(), (List<FArgument>)broadcast.getTarget().getOutArgs(), isRecursive, args);
    }

    private void applyFixForArgList(FDArgumentList fdArglist, List<FArgument> fArglist, boolean isRecursive, String ... args) {
        for (FArgument arg : fArglist) {
            if (args.length != 0 && !((List)Conversions.doWrapArray((Object)args)).contains(arg.getName())) continue;
            FDArgument fdArg = FDeployQuickfixProviderUtil.getArgument(fdArglist, arg);
            if (fdArg == null) {
                fdArg = FDeployQuickfixProvider.init(FDeployFactory.eINSTANCE.createFDArgument());
                fdArg.setTarget(arg);
                fdArglist.getArguments().add((Object)fdArg);
            }
            if (!isRecursive) continue;
            this.applyFixForElementInternal((FDElement)fdArg, isRecursive);
        }
    }

    private void applyFixForUnionInternal(FDUnion union, boolean isRecursive, String ... fields) {
        EList _elements = union.getTarget().getElements();
        for (FField field : _elements) {
            if (fields.length != 0 && !((List)Conversions.doWrapArray((Object)fields)).contains(field.getName())) continue;
            FDField fdField = FDeployQuickfixProviderUtil.getField((EList<FDField>)union.getFields(), field);
            if (fdField == null) {
                fdField = FDeployQuickfixProvider.init(FDeployFactory.eINSTANCE.createFDField());
                fdField.setTarget(field);
                union.getFields().add((Object)fdField);
            }
            if (!isRecursive) continue;
            this.applyFixForElementInternal((FDElement)fdField, isRecursive);
        }
    }

    private void applyFixForStructInternal(FDStruct struct, boolean isRecursive, String ... fields) {
        EList _elements = struct.getTarget().getElements();
        for (FField field : _elements) {
            if (fields.length != 0 && !((List)Conversions.doWrapArray((Object)fields)).contains(field.getName())) continue;
            FDField fdField = FDeployQuickfixProviderUtil.getField((EList<FDField>)struct.getFields(), field);
            if (fdField == null) {
                fdField = FDeployQuickfixProvider.init(FDeployFactory.eINSTANCE.createFDField());
                fdField.setTarget(field);
                struct.getFields().add((Object)fdField);
            }
            if (!isRecursive) continue;
            this.applyFixForElementInternal((FDElement)fdField, isRecursive);
        }
    }

    private void applyFixForEnumerationInternal(FDEnumeration enumeration, boolean isRecursive, String ... enumerators) {
        EList _enumerators = enumeration.getTarget().getEnumerators();
        for (FEnumerator e : _enumerators) {
            if (enumerators.length != 0 && !((List)Conversions.doWrapArray((Object)enumerators)).contains(e.getName())) continue;
            FDEnumValue fdEnum = FDeployQuickfixProviderUtil.getEnumerator((EList<FDEnumValue>)enumeration.getEnumerators(), e);
            if (fdEnum == null) {
                fdEnum = FDeployQuickfixProvider.init(FDeployFactory.eINSTANCE.createFDEnumValue());
                fdEnum.setTarget(e);
                enumeration.getEnumerators().add((Object)fdEnum);
            }
            if (!isRecursive) continue;
            this.applyFixForElementInternal((FDElement)fdEnum, isRecursive);
        }
    }

    private void applyFixForMapInternal(FDMap map, boolean isRecursive) {
        this.applyFixForMapKeyInternal(map, isRecursive);
        this.applyFixForMapValueInternal(map, isRecursive);
    }

    private void applyFixForMapKeyInternal(FDMap map, boolean isRecursive) {
        FDMapKey fdMapKey = FDeployQuickfixProvider.init(FDeployFactory.eINSTANCE.createFDMapKey());
        map.setKey(fdMapKey);
        if (isRecursive) {
            this.applyFixForElementInternal((FDElement)fdMapKey, isRecursive);
        }
    }

    private void applyFixForMapValueInternal(FDMap map, boolean isRecursive) {
        FDMapValue fdMapValue = FDeployQuickfixProvider.init(FDeployFactory.eINSTANCE.createFDMapValue());
        map.setValue(fdMapValue);
        if (isRecursive) {
            this.applyFixForElementInternal((FDElement)fdMapValue, isRecursive);
        }
    }

    private void applyFixForElementInternal(FDElement element, boolean isRecursive) {
        FDRootElement root = FDModelUtils.getTopmostRootElement((FDElement)element);
        if (root == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Cannot find root element for element ");
            _builder.append((Object)element);
            throw new RuntimeException(_builder.toString());
        }
        List decls = PropertyMappings.getAllPropertyDecls((FDSpecification)root.getSpec(), (FDElement)element);
        boolean changed = false;
        for (FDPropertyDecl decl : decls) {
            if (FDeployQuickfixProviderUtil.hasPropertyDeclaration((List<FDProperty>)element.getProperties().getItems(), decl) || !PropertyMappings.isMandatory((FDPropertyDecl)decl)) continue;
            FDProperty prop = FDeployFactory.eINSTANCE.createFDProperty();
            prop.setDecl(decl);
            FDComplexValue defaultVal = ExtensibleDefaultValueProvider.generateDefaultValue(root, element, prop, decl.getType());
            if (defaultVal == null) continue;
            prop.setValue(defaultVal);
            element.getProperties().getItems().add((Object)prop);
            changed = true;
        }
        if (changed) {
            String orig = root.getName();
            root.setName("dummy");
            root.setName(orig);
        }
        if (isRecursive) {
            boolean _matched = false;
            if (element instanceof FDMethod) {
                _matched = true;
                this.applyFixForMethodInternal((FDMethod)element, isRecursive, new String[0]);
            }
            if (!_matched && element instanceof FDBroadcast) {
                _matched = true;
                this.applyFixForBroadcastInternal((FDBroadcast)element, isRecursive, new String[0]);
            }
            if (!_matched && element instanceof FDUnion) {
                _matched = true;
                this.applyFixForUnionInternal((FDUnion)element, isRecursive, new String[0]);
            }
            if (!_matched && element instanceof FDStruct) {
                _matched = true;
                this.applyFixForStructInternal((FDStruct)element, isRecursive, new String[0]);
            }
            if (!_matched && element instanceof FDEnumeration) {
                _matched = true;
                this.applyFixForEnumerationInternal((FDEnumeration)element, isRecursive, new String[0]);
            }
            if (!_matched && element instanceof FDMap) {
                _matched = true;
                this.applyFixForMapInternal((FDMap)element, isRecursive);
            }
        }
    }

    private void applyFixForInterfaceInternal(FDInterface deploymentInterface, FrancaQuickFixConstants type, String elementName, final boolean isRecursive) {
        String name;
        if (type == FrancaQuickFixConstants.INTERFACE) {
            this.applyFixForElementInternal((FDElement)deploymentInterface, true);
        }
        HashSet elements = CollectionLiterals.newHashSet((Object[])new FDElement[0]);
        FInterface target = deploymentInterface.getTarget();
        if (elementName == null) {
            EList _attributes = target.getAttributes();
            for (FAttribute tc : _attributes) {
                elements.add(FDeployQuickfixProviderUtil.getOrCreateAttribute(deploymentInterface, tc.getName()));
            }
        } else if (type == FrancaQuickFixConstants.ATTRIBUTE) {
            elements.add(FDeployQuickfixProviderUtil.getOrCreateAttribute(deploymentInterface, elementName));
        }
        if (elementName == null) {
            EList _methods = target.getMethods();
            for (FMethod tc_1 : _methods) {
                name = FrancaModelExtensions.getUniqueName((FMethod)tc_1);
                elements.add(FDeployQuickfixProviderUtil.getOrCreateMethod(deploymentInterface, name));
            }
        } else if (type == FrancaQuickFixConstants.METHOD) {
            elements.add(FDeployQuickfixProviderUtil.getOrCreateMethod(deploymentInterface, elementName));
        }
        if (elementName == null) {
            EList _broadcasts = target.getBroadcasts();
            for (FBroadcast tc_2 : _broadcasts) {
                name = FrancaModelExtensions.getUniqueName((FBroadcast)tc_2);
                elements.add(FDeployQuickfixProviderUtil.getOrCreateBroadcast(deploymentInterface, name));
            }
        } else if (type == FrancaQuickFixConstants.BROADCAST) {
            elements.add(FDeployQuickfixProviderUtil.getOrCreateBroadcast(deploymentInterface, elementName));
        }
        EList _types = target.getTypes();
        for (FType tc_3 : _types) {
            if (tc_3 instanceof FArrayType) {
                if (elementName == null) {
                    elements.add(FDeployQuickfixProviderUtil.getOrCreateArray(deploymentInterface, ((FArrayType)tc_3).getName()));
                    continue;
                }
                if (type != FrancaQuickFixConstants.ARRAY || !((FArrayType)tc_3).getName().equals(elementName)) continue;
                elements.add(FDeployQuickfixProviderUtil.getOrCreateArray(deploymentInterface, elementName));
                continue;
            }
            if (tc_3 instanceof FStructType) {
                if (elementName == null) {
                    elements.add(FDeployQuickfixProviderUtil.getOrCreateStruct(deploymentInterface, ((FStructType)tc_3).getName()));
                    continue;
                }
                if (type != FrancaQuickFixConstants.STRUCT || !((FStructType)tc_3).getName().equals(elementName)) continue;
                elements.add(FDeployQuickfixProviderUtil.getOrCreateStruct(deploymentInterface, elementName));
                continue;
            }
            if (tc_3 instanceof FUnionType) {
                if (elementName == null) {
                    elements.add(FDeployQuickfixProviderUtil.getOrCreateUnion(deploymentInterface, ((FUnionType)tc_3).getName()));
                    continue;
                }
                if (type != FrancaQuickFixConstants.UNION || !((FUnionType)tc_3).getName().equals(elementName)) continue;
                elements.add(FDeployQuickfixProviderUtil.getOrCreateUnion(deploymentInterface, elementName));
                continue;
            }
            if (tc_3 instanceof FEnumerationType) {
                if (elementName == null) {
                    elements.add(FDeployQuickfixProviderUtil.getOrCreateEnumeration(deploymentInterface, ((FEnumerationType)tc_3).getName()));
                    continue;
                }
                if (type != FrancaQuickFixConstants.ENUMERATION || !((FEnumerationType)tc_3).getName().equals(elementName)) continue;
                elements.add(FDeployQuickfixProviderUtil.getOrCreateEnumeration(deploymentInterface, elementName));
                continue;
            }
            if (tc_3 instanceof FMapType) {
                if (elementName == null) {
                    elements.add(FDeployQuickfixProviderUtil.getOrCreateMap(deploymentInterface, ((FMapType)tc_3).getName()));
                    continue;
                }
                if (type != FrancaQuickFixConstants.MAP || !((FMapType)tc_3).getName().equals(elementName)) continue;
                elements.add(FDeployQuickfixProviderUtil.getOrCreateMap(deploymentInterface, elementName));
                continue;
            }
            if (!(tc_3 instanceof FTypeDef)) continue;
            if (elementName == null) {
                elements.add(FDeployQuickfixProviderUtil.getOrCreateTypedef(deploymentInterface, ((FTypeDef)tc_3).getName()));
                continue;
            }
            if (type != FrancaQuickFixConstants.TYPEDEF || !((FTypeDef)tc_3).getName().equals(elementName)) continue;
            elements.add(FDeployQuickfixProviderUtil.getOrCreateTypedef(deploymentInterface, elementName));
        }
        if (isRecursive) {
            Consumer<FDElement> _function = new Consumer<FDElement>(){

                @Override
                public void accept(FDElement it) {
                    FDeployQuickfixProvider.this.applyFixForElementInternal(it, isRecursive);
                }
            };
            elements.forEach(_function);
        }
    }

    private void applyFixForTypesInternal(FDTypes types, FrancaQuickFixConstants type, String elementName, boolean isRecursive) {
        FDArray _switchResult = null;
        if (type != null) {
            switch (type) {
                case ARRAY: {
                    _switchResult = FDeployQuickfixProviderUtil.getOrCreateArray(types, elementName);
                    break;
                }
                case STRUCT: {
                    _switchResult = FDeployQuickfixProviderUtil.getOrCreateStruct(types, elementName);
                    break;
                }
                case ENUMERATION: {
                    _switchResult = FDeployQuickfixProviderUtil.getOrCreateEnumeration(types, elementName);
                    break;
                }
                case UNION: {
                    _switchResult = FDeployQuickfixProviderUtil.getOrCreateUnion(types, elementName);
                    break;
                }
                case MAP: {
                    _switchResult = FDeployQuickfixProviderUtil.getOrCreateMap(types, elementName);
                    break;
                }
                case TYPEDEF: {
                    _switchResult = FDeployQuickfixProviderUtil.getOrCreateTypedef(types, elementName);
                    break;
                }
                default: {
                    _switchResult = null;
                    break;
                }
            }
        } else {
            _switchResult = null;
        }
        FDArray deploymentElement = _switchResult;
        if (isRecursive && deploymentElement != null) {
            this.applyFixForElementInternal((FDElement)deploymentElement, isRecursive);
        }
    }

    private static <T extends FDElement> T init(T elem) {
        T _xblockexpression = null;
        elem.setProperties(FDeployFactory.eINSTANCE.createFDPropertySet());
        _xblockexpression = elem;
        return _xblockexpression;
    }
}

