/*
 * generated by Xtext
 */
package org.franca.deploymodel.dsl.ui.labeling

import com.google.inject.Inject
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider
import org.franca.core.franca.FType
import org.franca.deploymodel.core.FDModelUtils
import org.franca.deploymodel.core.GenericPropertyAccessor
import org.franca.deploymodel.core.PropertyMappings
import org.franca.deploymodel.dsl.fDeploy.FDArgument
import org.franca.deploymodel.dsl.fDeploy.FDArray
import org.franca.deploymodel.dsl.fDeploy.FDAttribute
import org.franca.deploymodel.dsl.fDeploy.FDBoolean
import org.franca.deploymodel.dsl.fDeploy.FDBroadcast
import org.franca.deploymodel.dsl.fDeploy.FDDeclaration
import org.franca.deploymodel.dsl.fDeploy.FDEnumerator
import org.franca.deploymodel.dsl.fDeploy.FDField
import org.franca.deploymodel.dsl.fDeploy.FDGeneric
import org.franca.deploymodel.dsl.fDeploy.FDInteger
import org.franca.deploymodel.dsl.fDeploy.FDInterface
import org.franca.deploymodel.dsl.fDeploy.FDMap
import org.franca.deploymodel.dsl.fDeploy.FDMethod
import org.franca.deploymodel.dsl.fDeploy.FDProperty
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl
import org.franca.deploymodel.dsl.fDeploy.FDString
import org.franca.deploymodel.dsl.fDeploy.FDStruct
import org.franca.deploymodel.dsl.fDeploy.FDTypedef
import org.franca.deploymodel.dsl.fDeploy.FDUnion
import org.franca.deploymodel.dsl.fDeploy.Import

/** 
 * Provides labels for a EObjects.
 * see http://www.eclipse.org/Xtext/documentation/latest/xtext.html#labelProvider
 */
class FDeployLabelProvider extends DefaultEObjectLabelProvider {
	final String DEFAULT_PROPERTY_MARKER = "?"
	final String DEFAULT_VALUE_MARKER = "?="

	@Inject new(AdapterFactoryLabelProvider delegate) {
		super(delegate)
	}

	def String text(FDMethod element) {
		return element.getTarget().getName()
	}

	def String text(FDInterface element) {
		return element.getTarget().getName()
	}

	def String text(FDAttribute element) {
		return element.getTarget().getName()
	}

	def String text(FDBroadcast element) {
		return element.getTarget().getName()
	}

	def String text(FDArgument element) {
		return element.getTarget().getName()
	}

	def String text(FDArray element) {
		return element.getTarget().getName()
	}

	def String text(FDField element) {
		return element.getTarget().getName()
	}

	def String text(FDStruct element) {
		return element.getTarget().getName()
	}

	def String text(FDUnion element) {
		return element.getTarget().getName()
	}

	def String text(FDMap element) {
		return element.getTarget().getName()
	}

	def String text(FDTypedef element) {
		return element.getTarget().getName()
	}

	def String text(FDProperty element) {
		return element.getDecl().getName()
	}

	def String text(FDInteger element) {
		return getDefaultMarker(element) + String.valueOf(element.getValue())
	}

	def String text(FDString element) {
		return getDefaultMarker(element) + element.getValue()
	}

	def String text(FDBoolean element) {
		return getDefaultMarker(element) + element.getValue()
	}

	def String text(FDGeneric element) {
		var String dm = getDefaultMarker(element)
		if (FDModelUtils.isEnumerator(element)) {
			return dm + FDModelUtils.getEnumerator(element).getName()
		}
		return '''dmUNKNOWN''' // shouldn't happen
	}

	def String text(FDEnumerator element) {
		return getDefaultMarker(element) + element.getName()
	}

	def String text(FDDeclaration element) {
		var String name = element.getHost().getName
		return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase()
	}

	def String text(FDPropertyDecl element) {
		var String name = new String()
		if (!PropertyMappings.isMandatory(element)) {
			name += DEFAULT_PROPERTY_MARKER
		}
		name += element.getName()
		return name
	}

	def String getDefaultMarker(EObject element) {
		if (GenericPropertyAccessor.isSpecification(element)) {
			if (GenericPropertyAccessor.isDefault(element)) {
				return DEFAULT_VALUE_MARKER
			}
		}
		return ""
	}

	def String image(FDInterface element) {
		return "interface.png"
	}

	def String image(FDAttribute element) {
		return "attribute.gif"
	}

	def String image(FDMethod element) {
		return "method.gif"
	}

	def String image(FDField element) {
		return "field.gif"
	}

	def String image(FDGeneric element) {
		if (FDModelUtils.isEnumerator(element)) {
			return "enum.gif"
		}
		return null // shouldn't happen
	}

	def String image(FDEnumerator element) {
		return "enumerator.gif"
	}

	def String image(FType element) {
		return "types.gif"
	}

	def String image(FDStruct element) {
		return "struct.gif"
	}

	def String image(FDUnion element) {
		return "struct.gif" // TODO: different image for unions?
	}

	def String image(Import element) {
		return "import.gif"
	}

	def String image(FDBroadcast element) {
		return "event.png"
	}

	def String image(FDArgument element) {
		var EObject parent = element.eContainer().eContainer()
		if (parent instanceof FDBroadcast ||
			(parent instanceof FDMethod && ((parent as FDMethod)).getOutArguments().getArguments().contains(element))) {
			return "overlay-out.gif"
		} else {
			return "overlay-in.gif"
		}
	}

	def String image(FDDeclaration element) {
		val host = element.host
		val builtin = host.builtIn
		if (builtin===null) {
			// this is a host from a deployment extension
			// TODO: provide sensible default, or icon from extension 
			return null
		}

		switch (builtin) {
			case INTERFACES: {
				return "interface.png"
			}
			case ATTRIBUTES: {
				return "attribute.gif"
			}
			case METHODS: {
				return "method.gif"
			}
			case STRUCT_FIELDS: {
				return "field.gif"
			}
			case UNION_FIELDS: {
				return "field.gif"
			}
			case FIELDS: {
				return "field.gif"
			}
			case ENUMERATIONS: {
				return "enum.gif"
			}
			case ENUMERATORS: {
				return "enumerator.gif"
			}
			case BROADCASTS: {
				return "event.png"
			}
			case STRINGS: {
				return "strings.png"
			}
			case NUMBERS, // fall-through
			case INTEGERS, // fall-through
			case FLOATS: {
				return "numbers.png"
			}
			case ARRAYS: {
				return "arrays.png"
			}
			case MAPS: {
				return "map.png"
			}
		}
		return null
	}
}
