/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.CollectionAndSequence;
import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ParameterRole;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template._TemplateAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ListIterator;

final class HashLiteral
extends Expression {
    private final ArrayList keys;
    private final ArrayList values;
    private final int size;

    HashLiteral(ArrayList keys, ArrayList values) {
        this.keys = keys;
        this.values = values;
        this.size = keys.size();
        keys.trimToSize();
        values.trimToSize();
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        return new SequenceHash(env);
    }

    public String getCanonicalForm() {
        StringBuilder buf = new StringBuilder("{");
        for (int i = 0; i < this.size; ++i) {
            Expression key = (Expression)this.keys.get(i);
            Expression value = (Expression)this.values.get(i);
            buf.append(key.getCanonicalForm());
            buf.append(": ");
            buf.append(value.getCanonicalForm());
            if (i == this.size - 1) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    String getNodeTypeSymbol() {
        return "{...}";
    }

    boolean isLiteral() {
        if (this.constantValue != null) {
            return true;
        }
        for (int i = 0; i < this.size; ++i) {
            Expression key = (Expression)this.keys.get(i);
            Expression value = (Expression)this.values.get(i);
            if (key.isLiteral() && value.isLiteral()) continue;
            return false;
        }
        return true;
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        ArrayList clonedKeys = (ArrayList)this.keys.clone();
        ListIterator<Expression> iter = clonedKeys.listIterator();
        while (iter.hasNext()) {
            iter.set(((Expression)iter.next()).deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState));
        }
        ArrayList clonedValues = (ArrayList)this.values.clone();
        ListIterator<Expression> iter2 = clonedValues.listIterator();
        while (iter2.hasNext()) {
            iter2.set(((Expression)iter2.next()).deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState));
        }
        return new HashLiteral(clonedKeys, clonedValues);
    }

    int getParameterCount() {
        return this.size * 2;
    }

    Object getParameterValue(int idx) {
        this.checkIndex(idx);
        return idx % 2 == 0 ? this.keys.get(idx / 2) : this.values.get(idx / 2);
    }

    ParameterRole getParameterRole(int idx) {
        this.checkIndex(idx);
        return idx % 2 == 0 ? ParameterRole.ITEM_KEY : ParameterRole.ITEM_VALUE;
    }

    private void checkIndex(int idx) {
        if (idx >= this.size * 2) {
            throw new IndexOutOfBoundsException();
        }
    }

    private class SequenceHash
    implements TemplateHashModelEx {
        private HashMap map;
        private TemplateCollectionModel keyCollection;
        private TemplateCollectionModel valueCollection;

        SequenceHash(Environment env) throws TemplateException {
            if (_TemplateAPI.getTemplateLanguageVersionAsInt(HashLiteral.this) >= _TemplateAPI.VERSION_INT_2_3_21) {
                this.map = new LinkedHashMap();
                for (int i = 0; i < HashLiteral.this.size; ++i) {
                    Expression keyExp = (Expression)HashLiteral.this.keys.get(i);
                    Expression valExp = (Expression)HashLiteral.this.values.get(i);
                    String key = keyExp.evalAndCoerceToPlainText(env);
                    TemplateModel value = valExp.eval(env);
                    if (env == null || !env.isClassicCompatible()) {
                        valExp.assertNonNull(value, env);
                    }
                    this.map.put(key, value);
                }
            } else {
                this.map = new HashMap();
                ArrayList<String> keyList = new ArrayList<String>(HashLiteral.this.size);
                ArrayList<TemplateModel> valueList = new ArrayList<TemplateModel>(HashLiteral.this.size);
                for (int i = 0; i < HashLiteral.this.size; ++i) {
                    Expression keyExp = (Expression)HashLiteral.this.keys.get(i);
                    Expression valExp = (Expression)HashLiteral.this.values.get(i);
                    String key = keyExp.evalAndCoerceToPlainText(env);
                    TemplateModel value = valExp.eval(env);
                    if (env == null || !env.isClassicCompatible()) {
                        valExp.assertNonNull(value, env);
                    }
                    this.map.put(key, value);
                    keyList.add(key);
                    valueList.add(value);
                }
                this.keyCollection = new CollectionAndSequence(new SimpleSequence(keyList));
                this.valueCollection = new CollectionAndSequence(new SimpleSequence(valueList));
            }
        }

        public int size() {
            return HashLiteral.this.size;
        }

        public TemplateCollectionModel keys() {
            if (this.keyCollection == null) {
                this.keyCollection = new CollectionAndSequence(new SimpleSequence(this.map.keySet()));
            }
            return this.keyCollection;
        }

        public TemplateCollectionModel values() {
            if (this.valueCollection == null) {
                this.valueCollection = new CollectionAndSequence(new SimpleSequence(this.map.values()));
            }
            return this.valueCollection;
        }

        public TemplateModel get(String key) {
            return (TemplateModel)this.map.get(key);
        }

        public boolean isEmpty() {
            return HashLiteral.this.size == 0;
        }

        public String toString() {
            return HashLiteral.this.getCanonicalForm();
        }
    }
}

