/* FMParserTokenManager.java */
/* Generated By:JavaCC: Do not edit this line. FMParserTokenManager.java */
package freemarker.core;
import freemarker.template.*;
import freemarker.template.utility.*;
import java.io.*;
import java.util.*;

/** Token Manager. */
@SuppressWarnings("unused")class FMParserTokenManager implements FMParserConstants {
    private static final String PLANNED_DIRECTIVE_HINT
            = "(If you have seen this directive in use elsewhere, this was a planned directive, "
                + "so maybe you need to upgrade FreeMarker.)";

    /**
     * The noparseTag is set when we enter a block of text that the parser more or less ignores. These are <noparse> and
     * <comment>. This variable tells us what the closing tag should be, and when we hit that, we resume parsing. Note
     * that with this scheme, <comment> and <noparse> tags cannot nest recursively, but it is not clear how important
     * that is.
     */
    String noparseTag;

    /**
     * Keeps track of how deeply nested we have the hash literals. This is necessary since we need to be able to
     * distinguish the } used to close a hash literal and the one used to close a ${
     */
    private FMParser parser;
    private int postInterpolationLexState = -1;
    private int hashLiteralNesting;
    private int parenthesisNesting;
    private int bracketNesting;
    private boolean inFTLHeader;
    boolean strictEscapeSyntax,
            squBracTagSyntax,
            autodetectTagSyntax,
            directiveSyntaxEstablished,
            inInvocation;
    int initialNamingConvention;
    int namingConvention;
    Token namingConventionEstabilisher;
    int incompatibleImprovements;

    void setParser(FMParser parser) {
        this.parser = parser;
    }

    // This method checks if we are in a strict mode where all
    // FreeMarker directives must start with <#. It also handles
    // tag syntax detection. If you update this logic, take a look
    // at the UNKNOWN_DIRECTIVE token too.
    private void strictSyntaxCheck(Token tok, int tokenNamingConvention, int newLexState) {
        final String image = tok.image;

        // Non-strict syntax (deprecated) only supports legacy naming convention.
        // We didn't push this on the tokenizer because it made it slow, so we filter here.
        if (!strictEscapeSyntax
                && (tokenNamingConvention == Configuration.CAMEL_CASE_NAMING_CONVENTION)
                && !isStrictTag(image)) {
            tok.kind = STATIC_TEXT_NON_WS;
            return;
        }

        char firstChar = image.charAt(0);
        if (autodetectTagSyntax && !directiveSyntaxEstablished) {
            squBracTagSyntax = (firstChar == '[');
        }
        if ((firstChar == '[' && !squBracTagSyntax) || (firstChar == '<' && squBracTagSyntax)) {
            tok.kind = STATIC_TEXT_NON_WS;
            return;
        }

        if (!strictEscapeSyntax) {
            // Legacy feature (or bug?): Tag syntax never gets estabilished in non-strict mode.
            // We do establilish the naming convention though.
            checkNamingConvention(tok, tokenNamingConvention);
            SwitchTo(newLexState);
            return;
        }

        // For square bracket tags there's no non-strict token, so we are sure that it's an FTL tag.
        // But if it's an angle bracket tag, we have to check if it's just static text or and FTL tag, because the
        // tokenizer will emit the same kind of token for both.
        if (!squBracTagSyntax && !isStrictTag(image)) {
            tok.kind = STATIC_TEXT_NON_WS;
            return;
        }

        // We only get here if this is a strict FTL tag.
        directiveSyntaxEstablished = true;

        checkNamingConvention(tok, tokenNamingConvention);

        SwitchTo(newLexState);
    }

    void checkNamingConvention(Token tok) {
        checkNamingConvention(tok, _CoreStringUtils.getIdentifierNamingConvention(tok.image));
    }

    void checkNamingConvention(Token tok, int tokenNamingConvention) {
        if (tokenNamingConvention != Configuration.AUTO_DETECT_NAMING_CONVENTION) {
                if (namingConvention == Configuration.AUTO_DETECT_NAMING_CONVENTION) {
                    namingConvention = tokenNamingConvention;
                    namingConventionEstabilisher = tok;
                } else if (namingConvention != tokenNamingConvention) {
                throw newNameConventionMismatchException(tok);
                }
        }
    }

    private TokenMgrError newNameConventionMismatchException(Token tok) {
        return new TokenMgrError(
                "Naming convention mismatch. "
                + "Identifiers that are part of the template language (not the user specified ones) "
                + (initialNamingConvention == Configuration.AUTO_DETECT_NAMING_CONVENTION
                    ? "must consistently use the same naming convention within the same template. This template uses "
                    : "must use the configured naming convention, which is the ")
                + (namingConvention == Configuration.CAMEL_CASE_NAMING_CONVENTION
                            ? "camel case naming convention (like: exampleName) "
                            : (namingConvention == Configuration.LEGACY_NAMING_CONVENTION
                                    ? "legacy naming convention (directive (tag) names are like examplename, "
                                      + "everything else is like example_name) "
                                    : "??? (internal error)"
                                    ))
                + (namingConventionEstabilisher != null
                        ? "estabilished by auto-detection at "
                            + MessageUtil.formatPosition(
                                    namingConventionEstabilisher.beginLine, namingConventionEstabilisher.beginColumn)
                            + " by token " + StringUtil.jQuote(namingConventionEstabilisher.image.trim())
                        : "")
                + ", but the problematic token, " + StringUtil.jQuote(tok.image.trim())
                + ", uses a different convention.",
                TokenMgrError.LEXICAL_ERROR,
                tok.beginLine, tok.beginColumn, tok.endLine, tok.endColumn);
    }

    /**
     * Used for tags whose name isn't affected by naming convention.
     */
    private void strictSyntaxCheck(Token tok, int newLexState) {
        strictSyntaxCheck(tok, Configuration.AUTO_DETECT_NAMING_CONVENTION, newLexState);
    }

    private boolean isStrictTag(String image) {
        return image.length() > 2 && (image.charAt(1) == '#' || image.charAt(2) == '#');
    }

    /**
     * Detects the naming convention used, both in start- and end-tag tokens.
     *
     * @param charIdxInName
     *         The index of the deciding character relatively to the first letter of the name.
     */
    private static int getTagNamingConvention(Token tok, int charIdxInName) {
        return _CoreStringUtils.isUpperUSASCII(getTagNameCharAt(tok, charIdxInName))
                ? Configuration.CAMEL_CASE_NAMING_CONVENTION : Configuration.LEGACY_NAMING_CONVENTION;
    }

    static char getTagNameCharAt(Token tok, int charIdxInName) {
        final String image = tok.image;

        // Skip tag delimiter:
        int idx = 0;
        for (;;) {
            final char c = image.charAt(idx);
            if (c != '<' && c != '[' && c != '/' && c != '#') {
                break;
            }
            idx++;
        }

        return image.charAt(idx + charIdxInName);
    }

    private void unifiedCall(Token tok) {
        char firstChar = tok.image.charAt(0);
        if (autodetectTagSyntax && !directiveSyntaxEstablished) {
            squBracTagSyntax = (firstChar == '[');
        }
        if (squBracTagSyntax && firstChar == '<') {
            tok.kind = STATIC_TEXT_NON_WS;
            return;
        }
        if (!squBracTagSyntax && firstChar == '[') {
            tok.kind = STATIC_TEXT_NON_WS;
            return;
        }
        directiveSyntaxEstablished = true;
        SwitchTo(NO_SPACE_EXPRESSION);
    }

    private void unifiedCallEnd(Token tok) {
        char firstChar = tok.image.charAt(0);
        if (squBracTagSyntax && firstChar == '<') {
            tok.kind = STATIC_TEXT_NON_WS;
            return;
        }
        if (!squBracTagSyntax && firstChar == '[') {
            tok.kind = STATIC_TEXT_NON_WS;
            return;
        }
    }

    private void closeBracket(Token tok) {
        if (bracketNesting > 0) {
            --bracketNesting;
        } else {
            tok.kind = DIRECTIVE_END;
            if (inFTLHeader) {
                eatNewline();
                inFTLHeader = false;
            }
            SwitchTo(DEFAULT);
        }
    }

    private void startInterpolation(Token tok) {
        if (postInterpolationLexState != -1) {
            char c = tok.image.charAt(0);
            throw new TokenMgrError(
                    "You can't start an interpolation (" + c + "{...}) here "
                    + "as you are inside another interpolation.)",
                    TokenMgrError.LEXICAL_ERROR,
                    tok.beginLine, tok.beginColumn,
                    tok.endLine, tok.endColumn);
        }
        postInterpolationLexState = curLexState;
        SwitchTo(FM_EXPRESSION);
    }

    /**
     * @param tok
     *         Assumed to be an '}', or something that is the closing pair of another "mirror image" character.
     */
    private void endInterpolation(Token tok) {
        if (postInterpolationLexState == -1) {
            char c = tok.image.charAt(0);
            throw new TokenMgrError(
                    "You can't have an \"" + c + "\" here, as there's nothing open that it could close.",
                    TokenMgrError.LEXICAL_ERROR,
                    tok.beginLine, tok.beginColumn,
                    tok.endLine, tok.endColumn);
        }
        SwitchTo(postInterpolationLexState);
        postInterpolationLexState = -1;
    }

    private void eatNewline() {
        int charsRead = 0;
        try {
            while (true) {
                char c = input_stream.readChar();
                ++charsRead;
                if (!Character.isWhitespace(c)) {
                    input_stream.backup(charsRead);
                    return;
                } else if (c == '\r') {
                    char next = input_stream.readChar();
                    ++charsRead;
                    if (next != '\n') {
                        input_stream.backup(1);
                    }
                    return;
                } else if (c == '\n') {
                    return;
                }
            }
        } catch (IOException ioe) {
            input_stream.backup(charsRead);
        }
    }

    private void ftlHeader(Token matchedToken) {
        if (!directiveSyntaxEstablished) {
            squBracTagSyntax = matchedToken.image.charAt(0) == '[';
            directiveSyntaxEstablished = true;
            autodetectTagSyntax = false;
        }
        String img = matchedToken.image;
        char firstChar = img.charAt(0);
        char lastChar = img.charAt(img.length() - 1);
        if ((firstChar == '[' && !squBracTagSyntax) || (firstChar == '<' && squBracTagSyntax)) {
            matchedToken.kind = STATIC_TEXT_NON_WS;
        }
        if (matchedToken.kind != STATIC_TEXT_NON_WS) {
            if (lastChar != '>' && lastChar != ']') {
                SwitchTo(FM_EXPRESSION);
                inFTLHeader = true;
            } else {
                eatNewline();
            }
        }
    }

  /** Debug output. */
  public  java.io.PrintStream debugStream = System.out;
  /** Set debug output. */
  public  void setDebugStream(java.io.PrintStream ds) { debugStream = ds; }
private int jjMoveStringLiteralDfa0_7()
{
   return jjMoveNfa_7(0, 0);
}
static final long[] jjbitVec0 = {
   0xfffffffffffffffeL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static final long[] jjbitVec2 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
private int jjMoveNfa_7(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 13;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xefffdfffffffffffL & l) != 0L)
                  {
                     if (kind > 154)
                        kind = 154;
                     { jjCheckNAdd(6); }
                  }
                  else if ((0x1000200000000000L & l) != 0L)
                  {
                     if (kind > 155)
                        kind = 155;
                  }
                  if (curChar == 45)
                     { jjAddStates(0, 1); }
                  else if (curChar == 60)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 1:
                  if (curChar == 47)
                     { jjCheckNAddTwoStates(2, 3); }
                  break;
               case 2:
                  if (curChar == 35)
                     { jjCheckNAdd(3); }
                  break;
               case 4:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(2, 3); }
                  break;
               case 5:
                  if (curChar == 62 && kind > 153)
                     kind = 153;
                  break;
               case 6:
                  if ((0xefffdfffffffffffL & l) == 0L)
                     break;
                  if (kind > 154)
                     kind = 154;
                  { jjCheckNAdd(6); }
                  break;
               case 7:
                  if ((0x1000200000000000L & l) != 0L && kind > 155)
                     kind = 155;
                  break;
               case 8:
                  if (curChar == 45)
                     { jjAddStates(0, 1); }
                  break;
               case 9:
                  if (curChar == 62 && kind > 152)
                     kind = 152;
                  break;
               case 10:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 12:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xfffffffff7ffffffL & l) != 0L)
                  {
                     if (kind > 154)
                        kind = 154;
                     { jjCheckNAdd(6); }
                  }
                  else if (curChar == 91)
                  {
                     if (kind > 155)
                        kind = 155;
                  }
                  if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 3:
                  if ((0x7fffffe07fffffeL & l) != 0L)
                     { jjAddStates(4, 6); }
                  break;
               case 5:
                  if (curChar == 93 && kind > 153)
                     kind = 153;
                  break;
               case 6:
                  if ((0xfffffffff7ffffffL & l) == 0L)
                     break;
                  if (kind > 154)
                     kind = 154;
                  { jjCheckNAdd(6); }
                  break;
               case 7:
                  if (curChar == 91 && kind > 155)
                     kind = 155;
                  break;
               case 11:
                  if (curChar == 93 && kind > 152)
                     kind = 152;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
               case 6:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 154)
                     kind = 154;
                  { jjCheckNAdd(6); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 13 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_1(int pos, long active0, long active1){
   switch (pos)
   {
      case 0:
         if ((active1 & 0xc0000L) != 0L)
         {
            jjmatchedKind = 81;
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_1(int pos, long active0, long active1){
   return jjMoveNfa_1(jjStopStringLiteralDfa_1(pos, active0, active1), pos + 1);
}
private int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
private int jjMoveStringLiteralDfa0_1(){
   switch(curChar)
   {
      case 35:
         return jjMoveStringLiteralDfa1_1(0x80000L);
      case 36:
         return jjMoveStringLiteralDfa1_1(0x40000L);
      default :
         return jjMoveNfa_1(2, 0);
   }
}
private int jjMoveStringLiteralDfa1_1(long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_1(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 123:
         if ((active1 & 0x40000L) != 0L)
            return jjStopAtPos(1, 82);
         else if ((active1 & 0x80000L) != 0L)
            return jjStopAtPos(1, 83);
         break;
      default :
         break;
   }
   return jjStartNfa_1(0, 0L, active1);
}
private int jjMoveNfa_1(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 3;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 2:
                  if ((0xefffffe6ffffd9ffL & l) != 0L)
                  {
                     if (kind > 80)
                        kind = 80;
                     { jjCheckNAdd(1); }
                  }
                  else if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 79)
                        kind = 79;
                     { jjCheckNAdd(0); }
                  }
                  else if ((0x1000001800000000L & l) != 0L)
                  {
                     if (kind > 81)
                        kind = 81;
                  }
                  break;
               case 0:
                  if ((0x100002600L & l) == 0L)
                     break;
                  kind = 79;
                  { jjCheckNAdd(0); }
                  break;
               case 1:
                  if ((0xefffffe6ffffd9ffL & l) == 0L)
                     break;
                  kind = 80;
                  { jjCheckNAdd(1); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 2:
                  if ((0xf7fffffff7ffffffL & l) != 0L)
                  {
                     if (kind > 80)
                        kind = 80;
                     { jjCheckNAdd(1); }
                  }
                  else if ((0x800000008000000L & l) != 0L)
                  {
                     if (kind > 81)
                        kind = 81;
                  }
                  break;
               case 1:
                  if ((0xf7fffffff7ffffffL & l) == 0L)
                     break;
                  kind = 80;
                  { jjCheckNAdd(1); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 2:
               case 1:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAdd(1); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 3 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_0(int pos, long active0, long active1){
   switch (pos)
   {
      case 0:
         if ((active1 & 0xc0000L) != 0L)
         {
            jjmatchedKind = 81;
            return -1;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_0(int pos, long active0, long active1){
   return jjMoveNfa_0(jjStopStringLiteralDfa_0(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_0(){
   switch(curChar)
   {
      case 35:
         return jjMoveStringLiteralDfa1_0(0x80000L);
      case 36:
         return jjMoveStringLiteralDfa1_0(0x40000L);
      default :
         return jjMoveNfa_0(2, 0);
   }
}
private int jjMoveStringLiteralDfa1_0(long active1){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(0, 0L, active1);
      return 1;
   }
   switch(curChar)
   {
      case 123:
         if ((active1 & 0x40000L) != 0L)
            return jjStopAtPos(1, 82);
         else if ((active1 & 0x80000L) != 0L)
            return jjStopAtPos(1, 83);
         break;
      default :
         break;
   }
   return jjStartNfa_0(0, 0L, active1);
}
static final long[] jjbitVec3 = {
   0xfff00000fffffffeL, 0xffffffffffffdfffL, 0xfffff02fffffffffL, 0x16000000007fffffL
};
static final long[] jjbitVec4 = {
   0x0L, 0x0L, 0x420040000000000L, 0xff7fffffff7fffffL
};
static final long[] jjbitVec5 = {
   0x0L, 0x8002000000000000L, 0x1fff0000L, 0x0L
};
static final long[] jjbitVec6 = {
   0xf3ffbd503e2ffc84L, 0x43e0L, 0x18L, 0x0L
};
static final long[] jjbitVec7 = {
   0xffff7fffffffffffL, 0xffffffff7fffffffL, 0xffffffffffffffffL, 0xc781fffffffffL
};
static final long[] jjbitVec8 = {
   0xffff20bfffffffffL, 0x80ffffffffffL, 0x7f7f7f7f007fffffL, 0x7f7f7f7fL
};
static final long[] jjbitVec9 = {
   0x800000000000L, 0x0L, 0x0L, 0x0L
};
static final long[] jjbitVec10 = {
   0x183e000000000060L, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static final long[] jjbitVec11 = {
   0xffffffffffffffffL, 0xffffffffffffffffL, 0x7ffffff0000ffffL, 0xffff000000000000L
};
static final long[] jjbitVec12 = {
   0xffffffffffffffffL, 0xffffffffffffffffL, 0x0L, 0x0L
};
static final long[] jjbitVec13 = {
   0xffffffffffffffffL, 0xffffffffffffffffL, 0x3fffffffffffffL, 0x0L
};
static final long[] jjbitVec14 = {
   0xffffffffffffffffL, 0xffffffffffffffffL, 0x1fffL, 0x3fffffffffff0000L
};
static final long[] jjbitVec15 = {
   0xfffffff1fffL, 0x80007fffffffffffL, 0xffffffff00ffffffL, 0x3fffffffffL
};
static final long[] jjbitVec16 = {
   0xfffffffcff800000L, 0xffffffffffffffffL, 0x7ff000f79ffL, 0xff00000000000000L
};
static final long[] jjbitVec17 = {
   0x7fffff7bbL, 0xfffffffffffffL, 0xffffffffffffcL, 0x8fc000003ff0000L
};
static final long[] jjbitVec18 = {
   0xffff003fffffffffL, 0x1fffffff0000007fL, 0x7fffffffffff0L, 0x3ff8000L
};
static final long[] jjbitVec19 = {
   0x1ffffffffffL, 0x47fffff03ff0ff7L, 0x3e62ffffffffffffL, 0x1c07ff38000005L
};
static final long[] jjbitVec20 = {
   0x7f7f007e7e7eL, 0x0L, 0x0L, 0x3ff0007ffffffffL
};
static final long[] jjbitVec21 = {
   0xffffffffffffffffL, 0xffffffffffffffffL, 0xffff000fffffffffL, 0xffffffffffff87fL
};
static final long[] jjbitVec22 = {
   0x5f7ffdffa0f8007fL, 0xffffffffffffffdbL, 0x3ffffffffffffL, 0xfffffffffff80000L
};
static final long[] jjbitVec23 = {
   0x3fffffffffffffffL, 0xffffffffffff0000L, 0xfffffffffffcffffL, 0xfff0000000000ffL
};
static final long[] jjbitVec24 = {
   0x0L, 0xffdf000000000000L, 0xffffffffffffffffL, 0x1fffffffffffffffL
};
static final long[] jjbitVec25 = {
   0x7fffffe03ff0000L, 0xffffffc007fffffeL, 0x7fffffffffffffffL, 0x1cfcfcfcL
};
private int jjMoveNfa_0(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 713;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 2:
                  if ((0xefffffe6ffffd9ffL & l) != 0L)
                  {
                     if (kind > 80)
                        kind = 80;
                     { jjCheckNAdd(1); }
                  }
                  else if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 79)
                        kind = 79;
                     { jjCheckNAdd(0); }
                  }
                  else if ((0x1000001800000000L & l) != 0L)
                  {
                     if (kind > 81)
                        kind = 81;
                  }
                  if (curChar == 60)
                     { jjAddStates(7, 8); }
                  if (curChar == 60)
                     { jjCheckNAddStates(9, 100); }
                  if (curChar == 60)
                     { jjCheckNAddStates(101, 147); }
                  break;
               case 0:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 79)
                     kind = 79;
                  { jjCheckNAdd(0); }
                  break;
               case 1:
                  if ((0xefffffe6ffffd9ffL & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAdd(1); }
                  break;
               case 3:
                  if (curChar == 60)
                     { jjCheckNAddStates(101, 147); }
                  break;
               case 5:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(148, 149); }
                  break;
               case 6:
                  if (curChar == 62 && kind > 6)
                     kind = 6;
                  break;
               case 14:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(150, 151); }
                  break;
               case 15:
                  if (curChar == 62 && kind > 7)
                     kind = 7;
                  break;
               case 23:
                  if ((0x100002600L & l) != 0L && kind > 8)
                     kind = 8;
                  break;
               case 28:
                  if ((0x100002600L & l) != 0L && kind > 9)
                     kind = 9;
                  break;
               case 33:
                  if ((0x100002600L & l) != 0L && kind > 10)
                     kind = 10;
                  break;
               case 38:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(152, 153); }
                  break;
               case 40:
                  if ((0x100002600L & l) != 0L && kind > 11)
                     kind = 11;
                  break;
               case 47:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(154, 155); }
                  break;
               case 48:
                  if (curChar == 62 && kind > 12)
                     kind = 12;
                  break;
               case 54:
                  if ((0x100002600L & l) != 0L && kind > 13)
                     kind = 13;
                  break;
               case 60:
                  if ((0x100002600L & l) != 0L && kind > 14)
                     kind = 14;
                  break;
               case 67:
                  if ((0x100002600L & l) != 0L && kind > 15)
                     kind = 15;
                  break;
               case 72:
                  if ((0x100002600L & l) != 0L && kind > 16)
                     kind = 16;
                  break;
               case 79:
                  if ((0x100002600L & l) != 0L && kind > 17)
                     kind = 17;
                  break;
               case 86:
                  if ((0x100002600L & l) != 0L && kind > 18)
                     kind = 18;
                  break;
               case 92:
                  if ((0x100002600L & l) != 0L && kind > 19)
                     kind = 19;
                  break;
               case 100:
                  if ((0x100002600L & l) != 0L && kind > 20)
                     kind = 20;
                  break;
               case 107:
                  if ((0x100002600L & l) != 0L && kind > 21)
                     kind = 21;
                  break;
               case 116:
                  if ((0x100002600L & l) != 0L && kind > 22)
                     kind = 22;
                  break;
               case 122:
                  if ((0x100002600L & l) != 0L && kind > 23)
                     kind = 23;
                  break;
               case 132:
                  if ((0x100002600L & l) != 0L && kind > 24)
                     kind = 24;
                  break;
               case 138:
                  if ((0x100002600L & l) != 0L && kind > 25)
                     kind = 25;
                  break;
               case 143:
                  if ((0x100002600L & l) != 0L && kind > 26)
                     kind = 26;
                  break;
               case 150:
                  if ((0x100002600L & l) != 0L && kind > 27)
                     kind = 27;
                  break;
               case 155:
                  if ((0x100002600L & l) != 0L && kind > 28)
                     kind = 28;
                  break;
               case 165:
                  if ((0x100002600L & l) != 0L && kind > 29)
                     kind = 29;
                  break;
               case 178:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(156, 157); }
                  break;
               case 179:
                  if (curChar == 62 && kind > 30)
                     kind = 30;
                  break;
               case 187:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(158, 159); }
                  break;
               case 188:
                  if (curChar == 62 && kind > 31)
                     kind = 31;
                  break;
               case 201:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(160, 161); }
                  break;
               case 202:
                  if (curChar == 62 && kind > 32)
                     kind = 32;
                  break;
               case 211:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(162, 163); }
                  break;
               case 212:
                  if (curChar == 62 && kind > 33)
                     kind = 33;
                  break;
               case 222:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(164, 165); }
                  break;
               case 223:
                  if (curChar == 62 && kind > 35)
                     kind = 35;
                  break;
               case 229:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(166, 168); }
                  break;
               case 230:
                  if (curChar == 47)
                     { jjCheckNAdd(231); }
                  break;
               case 231:
                  if (curChar == 62 && kind > 54)
                     kind = 54;
                  break;
               case 236:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(169, 171); }
                  break;
               case 237:
                  if (curChar == 47)
                     { jjCheckNAdd(238); }
                  break;
               case 238:
                  if (curChar == 62 && kind > 55)
                     kind = 55;
                  break;
               case 244:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(172, 174); }
                  break;
               case 245:
                  if (curChar == 47)
                     { jjCheckNAdd(246); }
                  break;
               case 246:
                  if (curChar == 62 && kind > 56)
                     kind = 56;
                  break;
               case 255:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(175, 177); }
                  break;
               case 256:
                  if (curChar == 47)
                     { jjCheckNAdd(257); }
                  break;
               case 257:
                  if (curChar == 62 && kind > 57)
                     kind = 57;
                  break;
               case 264:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(178, 180); }
                  break;
               case 265:
                  if (curChar == 47)
                     { jjCheckNAdd(266); }
                  break;
               case 266:
                  if (curChar == 62 && kind > 58)
                     kind = 58;
                  break;
               case 271:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(181, 183); }
                  break;
               case 272:
                  if (curChar == 47)
                     { jjCheckNAdd(273); }
                  break;
               case 273:
                  if (curChar == 62 && kind > 59)
                     kind = 59;
                  break;
               case 279:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(184, 186); }
                  break;
               case 280:
                  if (curChar == 47)
                     { jjCheckNAdd(281); }
                  break;
               case 281:
                  if (curChar == 62 && kind > 60)
                     kind = 60;
                  break;
               case 283:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(187, 189); }
                  break;
               case 284:
                  if (curChar == 47)
                     { jjCheckNAdd(285); }
                  break;
               case 285:
                  if (curChar == 62 && kind > 61)
                     kind = 61;
                  break;
               case 288:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(190, 192); }
                  break;
               case 289:
                  if (curChar == 47)
                     { jjCheckNAdd(290); }
                  break;
               case 290:
                  if (curChar == 62 && kind > 62)
                     kind = 62;
                  break;
               case 293:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(193, 195); }
                  break;
               case 294:
                  if (curChar == 47)
                     { jjCheckNAdd(295); }
                  break;
               case 295:
                  if (curChar == 62 && kind > 63)
                     kind = 63;
                  break;
               case 298:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(196, 197); }
                  break;
               case 299:
                  if (curChar == 62 && kind > 64)
                     kind = 64;
                  break;
               case 307:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(198, 200); }
                  break;
               case 308:
                  if (curChar == 47)
                     { jjCheckNAdd(309); }
                  break;
               case 309:
                  if (curChar == 62 && kind > 65)
                     kind = 65;
                  break;
               case 316:
                  if ((0x100002600L & l) != 0L && kind > 66)
                     kind = 66;
                  break;
               case 323:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(201, 203); }
                  break;
               case 324:
                  if (curChar == 47)
                     { jjCheckNAdd(325); }
                  break;
               case 325:
                  if (curChar == 62 && kind > 67)
                     kind = 67;
                  break;
               case 333:
                  if ((0x100002600L & l) != 0L && kind > 68)
                     kind = 68;
                  break;
               case 341:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(204, 206); }
                  break;
               case 342:
                  if (curChar == 47)
                     { jjCheckNAdd(343); }
                  break;
               case 343:
                  if (curChar == 62 && kind > 69)
                     kind = 69;
                  break;
               case 352:
                  if ((0x100002600L & l) != 0L && kind > 70)
                     kind = 70;
                  break;
               case 361:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(207, 208); }
                  break;
               case 362:
                  if (curChar == 62 && kind > 72)
                     kind = 72;
                  break;
               case 368:
                  if (curChar == 60)
                     { jjCheckNAddStates(9, 100); }
                  break;
               case 369:
                  if (curChar == 35)
                     { jjCheckNAdd(12); }
                  break;
               case 370:
                  if (curChar == 35)
                     { jjCheckNAdd(21); }
                  break;
               case 371:
                  if (curChar == 35)
                     { jjCheckNAdd(24); }
                  break;
               case 372:
                  if (curChar == 35)
                     { jjCheckNAdd(31); }
                  break;
               case 373:
                  if (curChar == 35)
                     { jjCheckNAdd(36); }
                  break;
               case 374:
                  if (curChar == 35)
                     { jjCheckNAdd(45); }
                  break;
               case 375:
                  if (curChar == 35)
                     { jjCheckNAdd(50); }
                  break;
               case 376:
                  if (curChar == 35)
                     { jjCheckNAdd(58); }
                  break;
               case 377:
                  if (curChar == 35)
                     { jjCheckNAdd(65); }
                  break;
               case 378:
                  if (curChar == 35)
                     { jjCheckNAdd(70); }
                  break;
               case 379:
                  if (curChar == 35)
                     { jjCheckNAdd(77); }
                  break;
               case 380:
                  if (curChar == 35)
                     { jjCheckNAdd(84); }
                  break;
               case 381:
                  if (curChar == 35)
                     { jjCheckNAdd(90); }
                  break;
               case 382:
                  if (curChar == 35)
                     { jjCheckNAdd(98); }
                  break;
               case 383:
                  if (curChar == 35)
                     { jjCheckNAdd(105); }
                  break;
               case 384:
                  if (curChar == 35)
                     { jjCheckNAdd(114); }
                  break;
               case 385:
                  if (curChar == 35)
                     { jjCheckNAdd(120); }
                  break;
               case 386:
                  if (curChar == 35)
                     { jjCheckNAdd(130); }
                  break;
               case 387:
                  if (curChar == 35)
                     { jjCheckNAdd(136); }
                  break;
               case 388:
                  if (curChar == 35)
                     { jjCheckNAdd(141); }
                  break;
               case 389:
                  if (curChar == 35)
                     { jjCheckNAdd(148); }
                  break;
               case 390:
                  if (curChar == 35)
                     { jjCheckNAdd(153); }
                  break;
               case 391:
                  if (curChar == 35)
                     { jjCheckNAdd(161); }
                  break;
               case 392:
                  if (curChar == 35)
                     { jjCheckNAdd(174); }
                  break;
               case 393:
                  if (curChar == 35)
                     { jjCheckNAdd(183); }
                  break;
               case 394:
                  if (curChar == 35)
                     { jjCheckNAdd(199); }
                  break;
               case 395:
                  if (curChar == 35)
                     { jjCheckNAdd(209); }
                  break;
               case 396:
                  if (curChar == 35)
                     { jjCheckNAdd(218); }
                  break;
               case 397:
                  if (curChar == 35)
                     { jjCheckNAdd(227); }
                  break;
               case 398:
                  if (curChar == 47)
                     { jjCheckNAdd(402); }
                  break;
               case 400:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(209, 210); }
                  break;
               case 401:
                  if (curChar == 62 && kind > 36)
                     kind = 36;
                  break;
               case 403:
                  if (curChar == 35)
                     { jjCheckNAdd(402); }
                  break;
               case 404:
               case 667:
                  if (curChar == 47)
                     { jjCheckNAdd(403); }
                  break;
               case 405:
                  if (curChar == 47)
                     { jjCheckNAdd(411); }
                  break;
               case 407:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(211, 212); }
                  break;
               case 408:
                  if (curChar == 62 && kind > 37)
                     kind = 37;
                  break;
               case 412:
                  if (curChar == 35)
                     { jjCheckNAdd(411); }
                  break;
               case 413:
               case 668:
                  if (curChar == 47)
                     { jjCheckNAdd(412); }
                  break;
               case 414:
                  if (curChar == 47)
                     { jjCheckNAdd(421); }
                  break;
               case 416:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(213, 214); }
                  break;
               case 417:
                  if (curChar == 62 && kind > 38)
                     kind = 38;
                  break;
               case 422:
                  if (curChar == 35)
                     { jjCheckNAdd(421); }
                  break;
               case 423:
               case 669:
                  if (curChar == 47)
                     { jjCheckNAdd(422); }
                  break;
               case 424:
                  if (curChar == 47)
                     { jjCheckNAdd(429); }
                  break;
               case 426:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(215, 216); }
                  break;
               case 427:
                  if (curChar == 62 && kind > 39)
                     kind = 39;
                  break;
               case 430:
                  if (curChar == 35)
                     { jjCheckNAdd(429); }
                  break;
               case 431:
               case 670:
                  if (curChar == 47)
                     { jjCheckNAdd(430); }
                  break;
               case 432:
                  if (curChar == 47)
                     { jjCheckNAdd(441); }
                  break;
               case 434:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(217, 218); }
                  break;
               case 435:
                  if (curChar == 62 && kind > 40)
                     kind = 40;
                  break;
               case 442:
                  if (curChar == 35)
                     { jjCheckNAdd(441); }
                  break;
               case 443:
               case 671:
                  if (curChar == 47)
                     { jjCheckNAdd(442); }
                  break;
               case 444:
                  if (curChar == 47)
                     { jjCheckNAdd(453); }
                  break;
               case 446:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(219, 220); }
                  break;
               case 447:
                  if (curChar == 62 && kind > 41)
                     kind = 41;
                  break;
               case 454:
                  if (curChar == 35)
                     { jjCheckNAdd(453); }
                  break;
               case 455:
               case 672:
                  if (curChar == 47)
                     { jjCheckNAdd(454); }
                  break;
               case 456:
                  if (curChar == 47)
                     { jjCheckNAdd(465); }
                  break;
               case 460:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(221, 222); }
                  break;
               case 461:
                  if (curChar == 62 && kind > 42)
                     kind = 42;
                  break;
               case 466:
                  if (curChar == 35)
                     { jjCheckNAdd(465); }
                  break;
               case 467:
               case 673:
                  if (curChar == 47)
                     { jjCheckNAdd(466); }
                  break;
               case 468:
                  if (curChar == 47)
                     { jjCheckNAdd(475); }
                  break;
               case 470:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(223, 224); }
                  break;
               case 471:
                  if (curChar == 62 && kind > 43)
                     kind = 43;
                  break;
               case 476:
                  if (curChar == 35)
                     { jjCheckNAdd(475); }
                  break;
               case 477:
               case 674:
                  if (curChar == 47)
                     { jjCheckNAdd(476); }
                  break;
               case 478:
                  if (curChar == 47)
                     { jjCheckNAdd(486); }
                  break;
               case 480:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(225, 226); }
                  break;
               case 481:
                  if (curChar == 62 && kind > 44)
                     kind = 44;
                  break;
               case 487:
                  if (curChar == 35)
                     { jjCheckNAdd(486); }
                  break;
               case 488:
               case 675:
                  if (curChar == 47)
                     { jjCheckNAdd(487); }
                  break;
               case 489:
                  if (curChar == 47)
                     { jjCheckNAdd(497); }
                  break;
               case 491:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(227, 228); }
                  break;
               case 492:
                  if (curChar == 62 && kind > 45)
                     kind = 45;
                  break;
               case 498:
                  if (curChar == 35)
                     { jjCheckNAdd(497); }
                  break;
               case 499:
               case 676:
                  if (curChar == 47)
                     { jjCheckNAdd(498); }
                  break;
               case 500:
                  if (curChar == 47)
                     { jjCheckNAdd(510); }
                  break;
               case 502:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(229, 230); }
                  break;
               case 503:
                  if (curChar == 62 && kind > 46)
                     kind = 46;
                  break;
               case 511:
                  if (curChar == 35)
                     { jjCheckNAdd(510); }
                  break;
               case 512:
               case 677:
                  if (curChar == 47)
                     { jjCheckNAdd(511); }
                  break;
               case 513:
                  if (curChar == 47)
                     { jjCheckNAdd(520); }
                  break;
               case 515:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(231, 232); }
                  break;
               case 516:
                  if (curChar == 62 && kind > 47)
                     kind = 47;
                  break;
               case 521:
                  if (curChar == 35)
                     { jjCheckNAdd(520); }
                  break;
               case 522:
               case 678:
                  if (curChar == 47)
                     { jjCheckNAdd(521); }
                  break;
               case 523:
                  if (curChar == 47)
                     { jjCheckNAdd(537); }
                  break;
               case 527:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(233, 234); }
                  break;
               case 528:
                  if (curChar == 62 && kind > 48)
                     kind = 48;
                  break;
               case 538:
                  if (curChar == 35)
                     { jjCheckNAdd(537); }
                  break;
               case 539:
               case 679:
                  if (curChar == 47)
                     { jjCheckNAdd(538); }
                  break;
               case 540:
                  if (curChar == 47)
                     { jjCheckNAdd(549); }
                  break;
               case 544:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(235, 236); }
                  break;
               case 545:
                  if (curChar == 62 && kind > 49)
                     kind = 49;
                  break;
               case 550:
                  if (curChar == 35)
                     { jjCheckNAdd(549); }
                  break;
               case 551:
               case 680:
                  if (curChar == 47)
                     { jjCheckNAdd(550); }
                  break;
               case 552:
                  if (curChar == 47)
                     { jjCheckNAdd(568); }
                  break;
               case 556:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(237, 238); }
                  break;
               case 557:
                  if (curChar == 62 && kind > 50)
                     kind = 50;
                  break;
               case 569:
                  if (curChar == 35)
                     { jjCheckNAdd(568); }
                  break;
               case 570:
               case 681:
                  if (curChar == 47)
                     { jjCheckNAdd(569); }
                  break;
               case 571:
                  if (curChar == 47)
                     { jjCheckNAdd(581); }
                  break;
               case 573:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(239, 240); }
                  break;
               case 574:
                  if (curChar == 62 && kind > 51)
                     kind = 51;
                  break;
               case 582:
                  if (curChar == 35)
                     { jjCheckNAdd(581); }
                  break;
               case 583:
               case 682:
                  if (curChar == 47)
                     { jjCheckNAdd(582); }
                  break;
               case 584:
                  if (curChar == 47)
                     { jjCheckNAdd(595); }
                  break;
               case 586:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(241, 242); }
                  break;
               case 587:
                  if (curChar == 62 && kind > 52)
                     kind = 52;
                  break;
               case 596:
                  if (curChar == 35)
                     { jjCheckNAdd(595); }
                  break;
               case 597:
               case 683:
                  if (curChar == 47)
                     { jjCheckNAdd(596); }
                  break;
               case 598:
                  if (curChar == 47)
                     { jjCheckNAdd(606); }
                  break;
               case 600:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(243, 244); }
                  break;
               case 601:
                  if (curChar == 62 && kind > 53)
                     kind = 53;
                  break;
               case 607:
                  if (curChar == 35)
                     { jjCheckNAdd(606); }
                  break;
               case 608:
               case 684:
                  if (curChar == 47)
                     { jjCheckNAdd(607); }
                  break;
               case 609:
                  if (curChar == 35)
                     { jjCheckNAdd(234); }
                  break;
               case 610:
                  if (curChar == 35)
                     { jjCheckNAdd(242); }
                  break;
               case 611:
                  if (curChar == 35)
                     { jjCheckNAdd(253); }
                  break;
               case 612:
                  if (curChar == 35)
                     { jjCheckNAdd(262); }
                  break;
               case 613:
                  if (curChar == 35)
                     { jjCheckNAdd(269); }
                  break;
               case 614:
                  if (curChar == 35)
                     { jjCheckNAdd(277); }
                  break;
               case 615:
                  if (curChar == 35)
                     { jjCheckNAdd(278); }
                  break;
               case 616:
                  if (curChar == 35)
                     { jjCheckNAdd(286); }
                  break;
               case 617:
                  if (curChar == 35)
                     { jjCheckNAdd(291); }
                  break;
               case 618:
                  if (curChar == 35)
                     { jjCheckNAdd(296); }
                  break;
               case 619:
                  if (curChar == 35)
                     { jjCheckNAdd(305); }
                  break;
               case 620:
                  if (curChar == 35)
                     { jjCheckNAdd(314); }
                  break;
               case 621:
                  if (curChar == 35)
                     { jjCheckNAdd(321); }
                  break;
               case 622:
                  if (curChar == 35)
                     { jjCheckNAdd(331); }
                  break;
               case 623:
                  if (curChar == 35)
                     { jjCheckNAdd(339); }
                  break;
               case 624:
                  if (curChar == 35)
                     { jjCheckNAdd(350); }
                  break;
               case 625:
                  if (curChar == 35)
                     { jjCheckNAdd(357); }
                  break;
               case 626:
                  if (curChar == 47)
                     { jjCheckNAdd(634); }
                  break;
               case 628:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(245, 246); }
                  break;
               case 629:
                  if (curChar == 62 && kind > 71)
                     kind = 71;
                  break;
               case 635:
                  if (curChar == 35)
                     { jjCheckNAdd(634); }
                  break;
               case 636:
               case 685:
                  if (curChar == 47)
                     { jjCheckNAdd(635); }
                  break;
               case 637:
                  if (curChar == 35)
                     { jjCheckNAdd(367); }
                  break;
               case 638:
                  if (curChar == 47)
                     { jjCheckNAdd(648); }
                  break;
               case 642:
                  if ((0x100002600L & l) != 0L)
                     { jjAddStates(247, 248); }
                  break;
               case 643:
                  if (curChar == 62 && kind > 73)
                     kind = 73;
                  break;
               case 649:
                  if (curChar == 35)
                     { jjCheckNAdd(648); }
                  break;
               case 650:
               case 686:
                  if (curChar == 47)
                     { jjCheckNAdd(649); }
                  break;
               case 653:
                  if ((0x100002600L & l) != 0L && kind > 76)
                     kind = 76;
                  break;
               case 656:
                  if (curChar == 35)
                     jjstateSet[jjnewStateCnt++] = 655;
                  break;
               case 658:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 659;
                  break;
               case 659:
                  if (curChar == 62 && kind > 77)
                     kind = 77;
                  break;
               case 662:
                  if (curChar == 35)
                     jjstateSet[jjnewStateCnt++] = 661;
                  break;
               case 663:
                  if (curChar == 35)
                     jjstateSet[jjnewStateCnt++] = 664;
                  break;
               case 665:
               case 693:
                  if (curChar == 47)
                     { jjCheckNAdd(663); }
                  break;
               case 689:
                  if (curChar == 35)
                     jjstateSet[jjnewStateCnt++] = 688;
                  break;
               case 692:
                  if (curChar == 35)
                     jjstateSet[jjnewStateCnt++] = 691;
                  break;
               case 694:
                  if (curChar == 60)
                     { jjAddStates(7, 8); }
                  break;
               case 695:
                  if (curChar == 45 && kind > 34)
                     kind = 34;
                  break;
               case 696:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 695;
                  break;
               case 697:
                  if (curChar == 35)
                     jjstateSet[jjnewStateCnt++] = 696;
                  break;
               case 699:
                  if (curChar == 36)
                     { jjCheckNAddStates(249, 253); }
                  break;
               case 700:
                  if ((0x3ff001000000000L & l) != 0L)
                     { jjCheckNAddStates(249, 253); }
                  break;
               case 702:
                  if ((0x400600000000000L & l) != 0L)
                     { jjCheckNAddStates(249, 253); }
                  break;
               case 703:
                  if (curChar == 46)
                     { jjAddStates(254, 255); }
                  break;
               case 704:
                  if (curChar == 36)
                     { jjCheckNAddStates(256, 260); }
                  break;
               case 705:
                  if ((0x3ff001000000000L & l) != 0L)
                     { jjCheckNAddStates(256, 260); }
                  break;
               case 707:
                  if ((0x400600000000000L & l) != 0L)
                     { jjCheckNAddStates(256, 260); }
                  break;
               case 708:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddTwoStates(708, 709); }
                  break;
               case 709:
                  if (curChar == 62 && kind > 75)
                     kind = 75;
                  break;
               case 712:
                  if (curChar == 47)
                     jjstateSet[jjnewStateCnt++] = 698;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 2:
                  if ((0xf7fffffff7ffffffL & l) != 0L)
                  {
                     if (kind > 80)
                        kind = 80;
                     { jjCheckNAdd(1); }
                  }
                  else if ((0x800000008000000L & l) != 0L)
                  {
                     if (kind > 81)
                        kind = 81;
                  }
                  if (curChar == 91)
                     { jjAddStates(7, 8); }
                  if (curChar == 91)
                     { jjAddStates(261, 332); }
                  break;
               case 1:
                  if ((0xf7fffffff7ffffffL & l) == 0L)
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAdd(1); }
                  break;
               case 4:
                  if (curChar == 116)
                     { jjAddStates(148, 149); }
                  break;
               case 6:
                  if (curChar == 93 && kind > 6)
                     kind = 6;
                  break;
               case 7:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 8:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 9:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 8;
                  break;
               case 10:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 11:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 12:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 13:
                  if (curChar == 114)
                     { jjAddStates(150, 151); }
                  break;
               case 15:
                  if (curChar == 93 && kind > 7)
                     kind = 7;
                  break;
               case 16:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 17:
                  if (curChar == 118)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 18:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 17;
                  break;
               case 19:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 18;
                  break;
               case 20:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 19;
                  break;
               case 21:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 20;
                  break;
               case 22:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 23;
                  break;
               case 24:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 22;
                  break;
               case 25:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 26;
                  break;
               case 26:
                  if ((0x20000000200L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 27;
                  break;
               case 27:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 28;
                  break;
               case 29:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 25;
                  break;
               case 30:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 29;
                  break;
               case 31:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 30;
                  break;
               case 32:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 34:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 32;
                  break;
               case 35:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 34;
                  break;
               case 36:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 35;
                  break;
               case 37:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 38;
                  break;
               case 39:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 40;
                  break;
               case 41:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 39;
                  break;
               case 42:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 37;
                  break;
               case 43:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 42;
                  break;
               case 44:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 43;
                  break;
               case 45:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 44;
                  break;
               case 46:
                  if (curChar == 112)
                     { jjAddStates(154, 155); }
                  break;
               case 48:
                  if (curChar == 93 && kind > 12)
                     kind = 12;
                  break;
               case 49:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 46;
                  break;
               case 50:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 49;
                  break;
               case 51:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 52;
                  break;
               case 52:
                  if ((0x2000000020L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 56;
                  break;
               case 53:
                  if (curChar == 104)
                     jjstateSet[jjnewStateCnt++] = 54;
                  break;
               case 55:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 53;
                  break;
               case 56:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 55;
                  break;
               case 57:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 51;
                  break;
               case 58:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 59:
                  if (curChar == 104)
                     jjstateSet[jjnewStateCnt++] = 60;
                  break;
               case 61:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 59;
                  break;
               case 62:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 61;
                  break;
               case 63:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 64:
                  if (curChar == 119)
                     jjstateSet[jjnewStateCnt++] = 63;
                  break;
               case 65:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 64;
                  break;
               case 66:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 68:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 66;
                  break;
               case 69:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 68;
                  break;
               case 70:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 69;
                  break;
               case 71:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 72;
                  break;
               case 73:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 71;
                  break;
               case 74:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 75:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 74;
                  break;
               case 76:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 75;
                  break;
               case 77:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 76;
                  break;
               case 78:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 80:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 78;
                  break;
               case 81:
                  if (curChar == 98)
                     jjstateSet[jjnewStateCnt++] = 80;
                  break;
               case 82:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 81;
                  break;
               case 83:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 84:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 83;
                  break;
               case 85:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 86;
                  break;
               case 87:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 85;
                  break;
               case 88:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 87;
                  break;
               case 89:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 88;
                  break;
               case 90:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 89;
                  break;
               case 91:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 92;
                  break;
               case 93:
                  if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 91;
                  break;
               case 94:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 93;
                  break;
               case 95:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 94;
                  break;
               case 96:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 95;
                  break;
               case 97:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 96;
                  break;
               case 98:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 97;
                  break;
               case 99:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 100;
                  break;
               case 101:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 99;
                  break;
               case 102:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 101;
                  break;
               case 103:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 102;
                  break;
               case 104:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 103;
                  break;
               case 105:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 104;
                  break;
               case 106:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 107;
                  break;
               case 108:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 106;
                  break;
               case 109:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 108;
                  break;
               case 110:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 109;
                  break;
               case 111:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 110;
                  break;
               case 112:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 111;
                  break;
               case 113:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 112;
                  break;
               case 114:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 113;
                  break;
               case 115:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 116;
                  break;
               case 117:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 115;
                  break;
               case 118:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 117;
                  break;
               case 119:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 118;
                  break;
               case 120:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 119;
                  break;
               case 121:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 122;
                  break;
               case 123:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 121;
                  break;
               case 124:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 123;
                  break;
               case 125:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 124;
                  break;
               case 126:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 125;
                  break;
               case 127:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 126;
                  break;
               case 128:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 127;
                  break;
               case 129:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 128;
                  break;
               case 130:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 129;
                  break;
               case 131:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 132;
                  break;
               case 133:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 131;
                  break;
               case 134:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 133;
                  break;
               case 135:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 134;
                  break;
               case 136:
                  if (curChar == 118)
                     jjstateSet[jjnewStateCnt++] = 135;
                  break;
               case 137:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 138;
                  break;
               case 139:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 137;
                  break;
               case 140:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 139;
                  break;
               case 141:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 140;
                  break;
               case 142:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 143;
                  break;
               case 144:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 142;
                  break;
               case 145:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 144;
                  break;
               case 146:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 145;
                  break;
               case 147:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 146;
                  break;
               case 148:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 147;
                  break;
               case 149:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 150;
                  break;
               case 151:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 149;
                  break;
               case 152:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 151;
                  break;
               case 153:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 152;
                  break;
               case 154:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 155;
                  break;
               case 156:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 154;
                  break;
               case 157:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 156;
                  break;
               case 158:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 157;
                  break;
               case 159:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 158;
                  break;
               case 160:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 159;
                  break;
               case 161:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 160;
                  break;
               case 162:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 163;
                  break;
               case 163:
                  if ((0x4000000040L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 169;
                  break;
               case 164:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 165;
                  break;
               case 166:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 164;
                  break;
               case 167:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 166;
                  break;
               case 168:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 167;
                  break;
               case 169:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 168;
                  break;
               case 170:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 162;
                  break;
               case 171:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 170;
                  break;
               case 172:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 171;
                  break;
               case 173:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 172;
                  break;
               case 174:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 173;
                  break;
               case 175:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 176;
                  break;
               case 176:
                  if ((0x2000000020L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 180;
                  break;
               case 177:
                  if (curChar == 99)
                     { jjAddStates(156, 157); }
                  break;
               case 179:
                  if (curChar == 93 && kind > 30)
                     kind = 30;
                  break;
               case 180:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 177;
                  break;
               case 181:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 175;
                  break;
               case 182:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 181;
                  break;
               case 183:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 182;
                  break;
               case 184:
                  if (curChar == 111)
                     { jjAddStates(333, 334); }
                  break;
               case 185:
                  if (curChar == 101)
                     { jjCheckNAdd(189); }
                  break;
               case 186:
                  if (curChar == 99)
                     { jjAddStates(158, 159); }
                  break;
               case 188:
                  if (curChar == 93 && kind > 31)
                     kind = 31;
                  break;
               case 189:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 186;
                  break;
               case 190:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 185;
                  break;
               case 191:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 190;
                  break;
               case 192:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 191;
                  break;
               case 193:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 192;
                  break;
               case 194:
                  if (curChar == 69)
                     { jjCheckNAdd(189); }
                  break;
               case 195:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 194;
                  break;
               case 196:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 195;
                  break;
               case 197:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 196;
                  break;
               case 198:
                  if (curChar == 65)
                     jjstateSet[jjnewStateCnt++] = 197;
                  break;
               case 199:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 184;
                  break;
               case 200:
                  if (curChar == 115)
                     { jjAddStates(160, 161); }
                  break;
               case 202:
                  if (curChar == 93 && kind > 32)
                     kind = 32;
                  break;
               case 203:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 200;
                  break;
               case 204:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 203;
                  break;
               case 205:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 204;
                  break;
               case 206:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 205;
                  break;
               case 207:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 206;
                  break;
               case 208:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 207;
                  break;
               case 209:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 208;
                  break;
               case 210:
                  if (curChar == 116)
                     { jjAddStates(162, 163); }
                  break;
               case 212:
                  if (curChar == 93 && kind > 33)
                     kind = 33;
                  break;
               case 213:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 210;
                  break;
               case 214:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 213;
                  break;
               case 215:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 214;
                  break;
               case 216:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 215;
                  break;
               case 217:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 216;
                  break;
               case 218:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 217;
                  break;
               case 219:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 220;
                  break;
               case 220:
                  if ((0x1000000010000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 226;
                  break;
               case 221:
                  if (curChar == 101)
                     { jjAddStates(164, 165); }
                  break;
               case 223:
                  if (curChar == 93 && kind > 35)
                     kind = 35;
                  break;
               case 224:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 221;
                  break;
               case 225:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 224;
                  break;
               case 226:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 225;
                  break;
               case 227:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 219;
                  break;
               case 228:
                  if (curChar == 101)
                     { jjAddStates(166, 168); }
                  break;
               case 231:
                  if (curChar == 93 && kind > 54)
                     kind = 54;
                  break;
               case 232:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 228;
                  break;
               case 233:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 232;
                  break;
               case 234:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 233;
                  break;
               case 235:
                  if (curChar == 107)
                     { jjAddStates(169, 171); }
                  break;
               case 238:
                  if (curChar == 93 && kind > 55)
                     kind = 55;
                  break;
               case 239:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 235;
                  break;
               case 240:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 239;
                  break;
               case 241:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 240;
                  break;
               case 242:
                  if (curChar == 98)
                     jjstateSet[jjnewStateCnt++] = 241;
                  break;
               case 243:
                  if (curChar == 101)
                     { jjAddStates(172, 174); }
                  break;
               case 246:
                  if (curChar == 93 && kind > 56)
                     kind = 56;
                  break;
               case 247:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 243;
                  break;
               case 248:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 247;
                  break;
               case 249:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 248;
                  break;
               case 250:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 249;
                  break;
               case 251:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 250;
                  break;
               case 252:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 251;
                  break;
               case 253:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 252;
                  break;
               case 254:
                  if (curChar == 110)
                     { jjAddStates(175, 177); }
                  break;
               case 257:
                  if (curChar == 93 && kind > 57)
                     kind = 57;
                  break;
               case 258:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 254;
                  break;
               case 259:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 258;
                  break;
               case 260:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 259;
                  break;
               case 261:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 260;
                  break;
               case 262:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 261;
                  break;
               case 263:
                  if (curChar == 112)
                     { jjAddStates(178, 180); }
                  break;
               case 266:
                  if (curChar == 93 && kind > 58)
                     kind = 58;
                  break;
               case 267:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 263;
                  break;
               case 268:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 267;
                  break;
               case 269:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 268;
                  break;
               case 270:
                  if (curChar == 104)
                     { jjAddStates(181, 183); }
                  break;
               case 273:
                  if (curChar == 93 && kind > 59)
                     kind = 59;
                  break;
               case 274:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 270;
                  break;
               case 275:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 274;
                  break;
               case 276:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 275;
                  break;
               case 277:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 276;
                  break;
               case 278:
                  if (curChar == 116)
                     { jjAddStates(184, 186); }
                  break;
               case 281:
                  if (curChar == 93 && kind > 60)
                     kind = 60;
                  break;
               case 282:
                  if (curChar == 116)
                     { jjAddStates(187, 189); }
                  break;
               case 285:
                  if (curChar == 93 && kind > 61)
                     kind = 61;
                  break;
               case 286:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 282;
                  break;
               case 287:
                  if (curChar == 116)
                     { jjAddStates(190, 192); }
                  break;
               case 290:
                  if (curChar == 93 && kind > 62)
                     kind = 62;
                  break;
               case 291:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 287;
                  break;
               case 292:
                  if (curChar == 116)
                     { jjAddStates(193, 195); }
                  break;
               case 295:
                  if (curChar == 93 && kind > 63)
                     kind = 63;
                  break;
               case 296:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 292;
                  break;
               case 297:
                  if (curChar == 116)
                     { jjAddStates(196, 197); }
                  break;
               case 299:
                  if (curChar == 93 && kind > 64)
                     kind = 64;
                  break;
               case 300:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 297;
                  break;
               case 301:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 300;
                  break;
               case 302:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 301;
                  break;
               case 303:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 302;
                  break;
               case 304:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 303;
                  break;
               case 305:
                  if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 304;
                  break;
               case 306:
                  if (curChar == 100)
                     { jjAddStates(198, 200); }
                  break;
               case 309:
                  if (curChar == 93 && kind > 65)
                     kind = 65;
                  break;
               case 310:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 306;
                  break;
               case 311:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 310;
                  break;
               case 312:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 311;
                  break;
               case 313:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 312;
                  break;
               case 314:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 313;
                  break;
               case 315:
                  if (curChar == 100)
                     jjstateSet[jjnewStateCnt++] = 316;
                  break;
               case 317:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 315;
                  break;
               case 318:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 317;
                  break;
               case 319:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 318;
                  break;
               case 320:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 319;
                  break;
               case 321:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 320;
                  break;
               case 322:
                  if (curChar == 101)
                     { jjAddStates(201, 203); }
                  break;
               case 325:
                  if (curChar == 93 && kind > 67)
                     kind = 67;
                  break;
               case 326:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 322;
                  break;
               case 327:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 326;
                  break;
               case 328:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 327;
                  break;
               case 329:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 328;
                  break;
               case 330:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 329;
                  break;
               case 331:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 330;
                  break;
               case 332:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 333;
                  break;
               case 334:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 332;
                  break;
               case 335:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 334;
                  break;
               case 336:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 335;
                  break;
               case 337:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 336;
                  break;
               case 338:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 337;
                  break;
               case 339:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 338;
                  break;
               case 340:
                  if (curChar == 107)
                     { jjAddStates(204, 206); }
                  break;
               case 343:
                  if (curChar == 93 && kind > 69)
                     kind = 69;
                  break;
               case 344:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 340;
                  break;
               case 345:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 344;
                  break;
               case 346:
                  if (curChar == 98)
                     jjstateSet[jjnewStateCnt++] = 345;
                  break;
               case 347:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 346;
                  break;
               case 348:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 347;
                  break;
               case 349:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 348;
                  break;
               case 350:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 349;
                  break;
               case 351:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 352;
                  break;
               case 353:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 351;
                  break;
               case 354:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 353;
                  break;
               case 355:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 354;
                  break;
               case 356:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 355;
                  break;
               case 357:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 356;
                  break;
               case 358:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 359;
                  break;
               case 359:
                  if ((0x2000000020L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 366;
                  break;
               case 360:
                  if (curChar == 101)
                     { jjAddStates(207, 208); }
                  break;
               case 362:
                  if (curChar == 93 && kind > 72)
                     kind = 72;
                  break;
               case 363:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 360;
                  break;
               case 364:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 363;
                  break;
               case 365:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 364;
                  break;
               case 366:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 365;
                  break;
               case 367:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 358;
                  break;
               case 399:
                  if (curChar == 102)
                     { jjAddStates(209, 210); }
                  break;
               case 401:
                  if (curChar == 93 && kind > 36)
                     kind = 36;
                  break;
               case 402:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 399;
                  break;
               case 406:
                  if (curChar == 116)
                     { jjAddStates(211, 212); }
                  break;
               case 408:
                  if (curChar == 93 && kind > 37)
                     kind = 37;
                  break;
               case 409:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 406;
                  break;
               case 410:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 409;
                  break;
               case 411:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 410;
                  break;
               case 415:
                  if (curChar == 115)
                     { jjAddStates(213, 214); }
                  break;
               case 417:
                  if (curChar == 93 && kind > 38)
                     kind = 38;
                  break;
               case 418:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 415;
                  break;
               case 419:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 418;
                  break;
               case 420:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 419;
                  break;
               case 421:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 420;
                  break;
               case 425:
                  if (curChar == 112)
                     { jjAddStates(215, 216); }
                  break;
               case 427:
                  if (curChar == 93 && kind > 39)
                     kind = 39;
                  break;
               case 428:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 425;
                  break;
               case 429:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 428;
                  break;
               case 433:
                  if (curChar == 114)
                     { jjAddStates(217, 218); }
                  break;
               case 435:
                  if (curChar == 93 && kind > 40)
                     kind = 40;
                  break;
               case 436:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 433;
                  break;
               case 437:
                  if (curChar == 118)
                     jjstateSet[jjnewStateCnt++] = 436;
                  break;
               case 438:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 437;
                  break;
               case 439:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 438;
                  break;
               case 440:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 439;
                  break;
               case 441:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 440;
                  break;
               case 445:
                  if (curChar == 116)
                     { jjAddStates(219, 220); }
                  break;
               case 447:
                  if (curChar == 93 && kind > 41)
                     kind = 41;
                  break;
               case 448:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 445;
                  break;
               case 449:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 448;
                  break;
               case 450:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 449;
                  break;
               case 451:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 450;
                  break;
               case 452:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 451;
                  break;
               case 453:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 452;
                  break;
               case 457:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 458;
                  break;
               case 458:
                  if ((0x2000000020L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 463;
                  break;
               case 459:
                  if (curChar == 104)
                     { jjAddStates(221, 222); }
                  break;
               case 461:
                  if (curChar == 93 && kind > 42)
                     kind = 42;
                  break;
               case 462:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 459;
                  break;
               case 463:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 462;
                  break;
               case 464:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 457;
                  break;
               case 465:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 464;
                  break;
               case 469:
                  if (curChar == 108)
                     { jjAddStates(223, 224); }
                  break;
               case 471:
                  if (curChar == 93 && kind > 43)
                     kind = 43;
                  break;
               case 472:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 469;
                  break;
               case 473:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 472;
                  break;
               case 474:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 473;
                  break;
               case 475:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 474;
                  break;
               case 479:
                  if (curChar == 108)
                     { jjAddStates(225, 226); }
                  break;
               case 481:
                  if (curChar == 93 && kind > 44)
                     kind = 44;
                  break;
               case 482:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 479;
                  break;
               case 483:
                  if (curChar == 98)
                     jjstateSet[jjnewStateCnt++] = 482;
                  break;
               case 484:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 483;
                  break;
               case 485:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 484;
                  break;
               case 486:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 485;
                  break;
               case 490:
                  if (curChar == 110)
                     { jjAddStates(227, 228); }
                  break;
               case 492:
                  if (curChar == 93 && kind > 45)
                     kind = 45;
                  break;
               case 493:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 490;
                  break;
               case 494:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 493;
                  break;
               case 495:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 494;
                  break;
               case 496:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 495;
                  break;
               case 497:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 496;
                  break;
               case 501:
                  if (curChar == 110)
                     { jjAddStates(229, 230); }
                  break;
               case 503:
                  if (curChar == 93 && kind > 46)
                     kind = 46;
                  break;
               case 504:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 501;
                  break;
               case 505:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 504;
                  break;
               case 506:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 505;
                  break;
               case 507:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 506;
                  break;
               case 508:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 507;
                  break;
               case 509:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 508;
                  break;
               case 510:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 509;
                  break;
               case 514:
                  if (curChar == 111)
                     { jjAddStates(231, 232); }
                  break;
               case 516:
                  if (curChar == 93 && kind > 47)
                     kind = 47;
                  break;
               case 517:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 514;
                  break;
               case 518:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 517;
                  break;
               case 519:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 518;
                  break;
               case 520:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 519;
                  break;
               case 524:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 525;
                  break;
               case 525:
                  if ((0x4000000040L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 532;
                  break;
               case 526:
                  if (curChar == 116)
                     { jjAddStates(233, 234); }
                  break;
               case 528:
                  if (curChar == 93 && kind > 48)
                     kind = 48;
                  break;
               case 529:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 526;
                  break;
               case 530:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 529;
                  break;
               case 531:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 530;
                  break;
               case 532:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 531;
                  break;
               case 533:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 524;
                  break;
               case 534:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 533;
                  break;
               case 535:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 534;
                  break;
               case 536:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 535;
                  break;
               case 537:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 536;
                  break;
               case 541:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 542;
                  break;
               case 542:
                  if ((0x2000000020L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 546;
                  break;
               case 543:
                  if (curChar == 99)
                     { jjAddStates(235, 236); }
                  break;
               case 545:
                  if (curChar == 93 && kind > 49)
                     kind = 49;
                  break;
               case 546:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 543;
                  break;
               case 547:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 541;
                  break;
               case 548:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 547;
                  break;
               case 549:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 548;
                  break;
               case 553:
                  if (curChar == 111)
                     { jjAddStates(335, 336); }
                  break;
               case 554:
                  if (curChar == 101)
                     { jjCheckNAdd(558); }
                  break;
               case 555:
                  if (curChar == 99)
                     { jjAddStates(237, 238); }
                  break;
               case 557:
                  if (curChar == 93 && kind > 50)
                     kind = 50;
                  break;
               case 558:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 555;
                  break;
               case 559:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 554;
                  break;
               case 560:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 559;
                  break;
               case 561:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 560;
                  break;
               case 562:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 561;
                  break;
               case 563:
                  if (curChar == 69)
                     { jjCheckNAdd(558); }
                  break;
               case 564:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 563;
                  break;
               case 565:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 564;
                  break;
               case 566:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 565;
                  break;
               case 567:
                  if (curChar == 65)
                     jjstateSet[jjnewStateCnt++] = 566;
                  break;
               case 568:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 553;
                  break;
               case 572:
                  if (curChar == 115)
                     { jjAddStates(239, 240); }
                  break;
               case 574:
                  if (curChar == 93 && kind > 51)
                     kind = 51;
                  break;
               case 575:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 572;
                  break;
               case 576:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 575;
                  break;
               case 577:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 576;
                  break;
               case 578:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 577;
                  break;
               case 579:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 578;
                  break;
               case 580:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 579;
                  break;
               case 581:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 580;
                  break;
               case 585:
                  if (curChar == 109)
                     { jjAddStates(241, 242); }
                  break;
               case 587:
                  if (curChar == 93 && kind > 52)
                     kind = 52;
                  break;
               case 588:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 585;
                  break;
               case 589:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 588;
                  break;
               case 590:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 589;
                  break;
               case 591:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 590;
                  break;
               case 592:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 591;
                  break;
               case 593:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 592;
                  break;
               case 594:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 593;
                  break;
               case 595:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 594;
                  break;
               case 599:
                  if (curChar == 104)
                     { jjAddStates(243, 244); }
                  break;
               case 601:
                  if (curChar == 93 && kind > 53)
                     kind = 53;
                  break;
               case 602:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 599;
                  break;
               case 603:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 602;
                  break;
               case 604:
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 603;
                  break;
               case 605:
                  if (curChar == 119)
                     jjstateSet[jjnewStateCnt++] = 604;
                  break;
               case 606:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 605;
                  break;
               case 627:
                  if (curChar == 101)
                     { jjAddStates(245, 246); }
                  break;
               case 629:
                  if (curChar == 93 && kind > 71)
                     kind = 71;
                  break;
               case 630:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 627;
                  break;
               case 631:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 630;
                  break;
               case 632:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 631;
                  break;
               case 633:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 632;
                  break;
               case 634:
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 633;
                  break;
               case 639:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 640;
                  break;
               case 640:
                  if ((0x2000000020L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 647;
                  break;
               case 641:
                  if (curChar == 101)
                     { jjAddStates(247, 248); }
                  break;
               case 643:
                  if (curChar == 93 && kind > 73)
                     kind = 73;
                  break;
               case 644:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 641;
                  break;
               case 645:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 644;
                  break;
               case 646:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 645;
                  break;
               case 647:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 646;
                  break;
               case 648:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 639;
                  break;
               case 651:
                  if (curChar == 64 && kind > 74)
                     kind = 74;
                  break;
               case 652:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 653;
                  break;
               case 654:
               case 687:
                  if (curChar == 116)
                     { jjCheckNAdd(652); }
                  break;
               case 655:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 654;
                  break;
               case 657:
                  if (curChar == 108)
                     { jjAddStates(337, 338); }
                  break;
               case 659:
                  if (curChar == 93 && kind > 77)
                     kind = 77;
                  break;
               case 660:
               case 690:
                  if (curChar == 116)
                     { jjCheckNAdd(657); }
                  break;
               case 661:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 660;
                  break;
               case 664:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 78)
                     kind = 78;
                  jjstateSet[jjnewStateCnt++] = 664;
                  break;
               case 666:
                  if (curChar == 91)
                     { jjAddStates(261, 332); }
                  break;
               case 688:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 687;
                  break;
               case 691:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 690;
                  break;
               case 694:
                  if (curChar == 91)
                     { jjAddStates(7, 8); }
                  break;
               case 698:
                  if (curChar == 64)
                     { jjCheckNAddStates(339, 342); }
                  break;
               case 699:
               case 700:
                  if ((0x7fffffe87ffffffL & l) != 0L)
                     { jjCheckNAddStates(249, 253); }
                  break;
               case 701:
               case 711:
                  if (curChar == 92)
                     { jjCheckNAdd(702); }
                  break;
               case 704:
               case 705:
                  if ((0x7fffffe87ffffffL & l) != 0L)
                     { jjCheckNAddStates(256, 260); }
                  break;
               case 706:
               case 710:
                  if (curChar == 92)
                     { jjCheckNAdd(707); }
                  break;
               case 709:
                  if (curChar == 93 && kind > 75)
                     kind = 75;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 2:
               case 1:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 80)
                     kind = 80;
                  { jjCheckNAdd(1); }
                  break;
               case 699:
               case 700:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(249, 253); }
                  break;
               case 704:
               case 705:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(256, 260); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 713 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_2(int pos, long active0, long active1, long active2){
   switch (pos)
   {
      case 0:
         if ((active2 & 0x8L) != 0L)
            return 2;
         if ((active1 & 0x800400000000000L) != 0L)
            return 42;
         if ((active1 & 0x400002c00000000L) != 0L)
            return 46;
         if ((active1 & 0xc0000000L) != 0L || (active2 & 0xe00L) != 0L)
         {
            jjmatchedKind = 140;
            return 96;
         }
         return -1;
      case 1:
         if ((active2 & 0x600L) != 0L)
            return 96;
         if ((active1 & 0x400002800000000L) != 0L)
            return 45;
         if ((active1 & 0xc0000000L) != 0L || (active2 & 0x800L) != 0L)
         {
            if (jjmatchedPos != 1)
            {
               jjmatchedKind = 140;
               jjmatchedPos = 1;
            }
            return 96;
         }
         return -1;
      case 2:
         if ((active1 & 0xc0000000L) != 0L || (active2 & 0x800L) != 0L)
         {
            jjmatchedKind = 140;
            jjmatchedPos = 2;
            return 96;
         }
         return -1;
      case 3:
         if ((active1 & 0x80000000L) != 0L)
            return 96;
         if ((active1 & 0x40000000L) != 0L || (active2 & 0x800L) != 0L)
         {
            jjmatchedKind = 140;
            jjmatchedPos = 3;
            return 96;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_2(int pos, long active0, long active1, long active2){
   return jjMoveNfa_2(jjStopStringLiteralDfa_2(pos, active0, active1, active2), pos + 1);
}
private int jjMoveStringLiteralDfa0_2(){
   switch(curChar)
   {
      case 33:
         jjmatchedKind = 127;
         return jjMoveStringLiteralDfa1_2(0x40000000000L, 0x0L);
      case 37:
         jjmatchedKind = 124;
         return jjMoveStringLiteralDfa1_2(0x800000000000L, 0x0L);
      case 40:
         return jjStopAtPos(0, 133);
      case 41:
         return jjStopAtPos(0, 134);
      case 42:
         jjmatchedKind = 120;
         return jjMoveStringLiteralDfa1_2(0x200200000000000L, 0x0L);
      case 43:
         jjmatchedKind = 118;
         return jjMoveStringLiteralDfa1_2(0x1080000000000L, 0x0L);
      case 44:
         return jjStopAtPos(0, 128);
      case 45:
         jjmatchedKind = 119;
         return jjMoveStringLiteralDfa1_2(0x2100000000000L, 0x0L);
      case 46:
         jjmatchedKind = 98;
         return jjMoveStringLiteralDfa1_2(0x400002800000000L, 0x0L);
      case 47:
         jjmatchedKind = 123;
         return jjMoveStringLiteralDfa1_2(0x400000000000L, 0x0L);
      case 58:
         return jjStopAtPos(0, 130);
      case 59:
         return jjStopAtPos(0, 129);
      case 61:
         jjmatchedKind = 104;
         return jjMoveStringLiteralDfa1_2(0x20000000000L, 0x0L);
      case 62:
         return jjStopAtPos(0, 146);
      case 63:
         jjmatchedKind = 102;
         return jjMoveStringLiteralDfa1_2(0x8000000000L, 0x0L);
      case 91:
         return jjStartNfaWithStates_2(0, 131, 2);
      case 93:
         return jjStopAtPos(0, 132);
      case 97:
         return jjMoveStringLiteralDfa1_2(0x0L, 0x400L);
      case 102:
         return jjMoveStringLiteralDfa1_2(0x40000000L, 0x0L);
      case 105:
         return jjMoveStringLiteralDfa1_2(0x0L, 0x200L);
      case 116:
         return jjMoveStringLiteralDfa1_2(0x80000000L, 0x0L);
      case 117:
         return jjMoveStringLiteralDfa1_2(0x0L, 0x800L);
      case 123:
         return jjStopAtPos(0, 135);
      case 125:
         return jjStopAtPos(0, 136);
      default :
         return jjMoveNfa_2(1, 0);
   }
}
private int jjMoveStringLiteralDfa1_2(long active1, long active2){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(0, 0L, active1, active2);
      return 1;
   }
   switch(curChar)
   {
      case 42:
         if ((active1 & 0x200000000000000L) != 0L)
            return jjStopAtPos(1, 121);
         break;
      case 43:
         if ((active1 & 0x1000000000000L) != 0L)
            return jjStopAtPos(1, 112);
         break;
      case 45:
         if ((active1 & 0x2000000000000L) != 0L)
            return jjStopAtPos(1, 113);
         break;
      case 46:
         if ((active1 & 0x800000000L) != 0L)
         {
            jjmatchedKind = 99;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_2(active1, 0x400002000000000L, active2, 0L);
      case 61:
         if ((active1 & 0x20000000000L) != 0L)
            return jjStopAtPos(1, 105);
         else if ((active1 & 0x40000000000L) != 0L)
            return jjStopAtPos(1, 106);
         else if ((active1 & 0x80000000000L) != 0L)
            return jjStopAtPos(1, 107);
         else if ((active1 & 0x100000000000L) != 0L)
            return jjStopAtPos(1, 108);
         else if ((active1 & 0x200000000000L) != 0L)
            return jjStopAtPos(1, 109);
         else if ((active1 & 0x400000000000L) != 0L)
            return jjStopAtPos(1, 110);
         else if ((active1 & 0x800000000000L) != 0L)
            return jjStopAtPos(1, 111);
         break;
      case 63:
         if ((active1 & 0x8000000000L) != 0L)
            return jjStopAtPos(1, 103);
         break;
      case 97:
         return jjMoveStringLiteralDfa2_2(active1, 0x40000000L, active2, 0L);
      case 110:
         if ((active2 & 0x200L) != 0L)
            return jjStartNfaWithStates_2(1, 137, 96);
         break;
      case 114:
         return jjMoveStringLiteralDfa2_2(active1, 0x80000000L, active2, 0L);
      case 115:
         if ((active2 & 0x400L) != 0L)
            return jjStartNfaWithStates_2(1, 138, 96);
         return jjMoveStringLiteralDfa2_2(active1, 0L, active2, 0x800L);
      default :
         break;
   }
   return jjStartNfa_2(0, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa2_2(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_2(0, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(1, 0L, active1, active2);
      return 2;
   }
   switch(curChar)
   {
      case 42:
         if ((active1 & 0x2000000000L) != 0L)
            return jjStopAtPos(2, 101);
         break;
      case 46:
         if ((active1 & 0x400000000000000L) != 0L)
            return jjStopAtPos(2, 122);
         break;
      case 105:
         return jjMoveStringLiteralDfa3_2(active1, 0L, active2, 0x800L);
      case 108:
         return jjMoveStringLiteralDfa3_2(active1, 0x40000000L, active2, 0L);
      case 117:
         return jjMoveStringLiteralDfa3_2(active1, 0x80000000L, active2, 0L);
      default :
         break;
   }
   return jjStartNfa_2(1, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa3_2(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_2(1, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(2, 0L, active1, active2);
      return 3;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x80000000L) != 0L)
            return jjStartNfaWithStates_2(3, 95, 96);
         break;
      case 110:
         return jjMoveStringLiteralDfa4_2(active1, 0L, active2, 0x800L);
      case 115:
         return jjMoveStringLiteralDfa4_2(active1, 0x40000000L, active2, 0L);
      default :
         break;
   }
   return jjStartNfa_2(2, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa4_2(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_2(2, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_2(3, 0L, active1, active2);
      return 4;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x40000000L) != 0L)
            return jjStartNfaWithStates_2(4, 94, 96);
         break;
      case 103:
         if ((active2 & 0x800L) != 0L)
            return jjStartNfaWithStates_2(4, 139, 96);
         break;
      default :
         break;
   }
   return jjStartNfa_2(3, 0L, active1, active2);
}
private int jjStartNfaWithStates_2(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_2(state, pos + 1);
}
private int jjMoveNfa_2(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 96;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 42:
                  if (curChar == 62 && kind > 147)
                     kind = 147;
                  break;
               case 46:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 47;
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 45;
                  break;
               case 1:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 96)
                        kind = 96;
                     { jjCheckNAddStates(343, 345); }
                  }
                  else if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 84)
                        kind = 84;
                     { jjCheckNAdd(0); }
                  }
                  else if (curChar == 38)
                     { jjAddStates(346, 351); }
                  else if (curChar == 46)
                     { jjAddStates(352, 353); }
                  else if (curChar == 47)
                     { jjAddStates(354, 355); }
                  else if (curChar == 35)
                     { jjCheckNAdd(38); }
                  else if (curChar == 36)
                     { jjCheckNAdd(38); }
                  else if (curChar == 60)
                     { jjCheckNAdd(27); }
                  else if (curChar == 39)
                     { jjCheckNAddStates(356, 358); }
                  else if (curChar == 34)
                     { jjCheckNAddStates(359, 361); }
                  if (curChar == 36)
                  {
                     if (kind > 140)
                        kind = 140;
                     { jjCheckNAddTwoStates(34, 35); }
                  }
                  else if (curChar == 38)
                  {
                     if (kind > 125)
                        kind = 125;
                  }
                  else if (curChar == 60)
                  {
                     if (kind > 114)
                        kind = 114;
                  }
                  if (curChar == 60)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 45:
                  if (curChar == 33)
                  {
                     if (kind > 100)
                        kind = 100;
                  }
                  else if (curChar == 60)
                  {
                     if (kind > 100)
                        kind = 100;
                  }
                  break;
               case 96:
               case 34:
                  if ((0x3ff001000000000L & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 0:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 84)
                     kind = 84;
                  { jjCheckNAdd(0); }
                  break;
               case 2:
                  if ((0xa00000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 3:
                  if (curChar == 45 && kind > 85)
                     kind = 85;
                  break;
               case 4:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 3;
                  break;
               case 5:
                  if (curChar == 34)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 6:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 9:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 10:
                  if (curChar == 34 && kind > 92)
                     kind = 92;
                  break;
               case 11:
                  if ((0x9400000000L & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 12:
                  if (curChar == 39)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 13:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 16:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 17:
                  if (curChar == 39 && kind > 92)
                     kind = 92;
                  break;
               case 18:
                  if ((0x9400000000L & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 20:
                  if (curChar == 34)
                     { jjCheckNAddTwoStates(21, 22); }
                  break;
               case 21:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     { jjCheckNAddTwoStates(21, 22); }
                  break;
               case 22:
                  if (curChar == 34 && kind > 93)
                     kind = 93;
                  break;
               case 23:
                  if (curChar == 39)
                     { jjCheckNAddTwoStates(24, 25); }
                  break;
               case 24:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     { jjCheckNAddTwoStates(24, 25); }
                  break;
               case 25:
                  if (curChar == 39 && kind > 93)
                     kind = 93;
                  break;
               case 26:
                  if (curChar == 60 && kind > 114)
                     kind = 114;
                  break;
               case 27:
                  if (curChar == 61 && kind > 115)
                     kind = 115;
                  break;
               case 28:
                  if (curChar == 60)
                     { jjCheckNAdd(27); }
                  break;
               case 29:
               case 84:
                  if (curChar == 38 && kind > 125)
                     kind = 125;
                  break;
               case 33:
                  if (curChar != 36)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 36:
                  if ((0x400600000000000L & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 39:
                  if (curChar == 36)
                     { jjCheckNAdd(38); }
                  break;
               case 40:
                  if (curChar == 35)
                     { jjCheckNAdd(38); }
                  break;
               case 41:
                  if (curChar == 47)
                     { jjAddStates(354, 355); }
                  break;
               case 44:
                  if (curChar == 46)
                     { jjAddStates(352, 353); }
                  break;
               case 47:
                  if (curChar == 33 && kind > 100)
                     kind = 100;
                  break;
               case 48:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 49:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 96)
                     kind = 96;
                  { jjCheckNAddStates(343, 345); }
                  break;
               case 50:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 96)
                     kind = 96;
                  { jjCheckNAdd(50); }
                  break;
               case 51:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(51, 52); }
                  break;
               case 52:
                  if (curChar == 46)
                     { jjCheckNAdd(53); }
                  break;
               case 53:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 97)
                     kind = 97;
                  { jjCheckNAdd(53); }
                  break;
               case 70:
                  if (curChar == 38)
                     { jjAddStates(346, 351); }
                  break;
               case 71:
                  if (curChar == 59 && kind > 114)
                     kind = 114;
                  break;
               case 74:
                  if (curChar == 59)
                     { jjCheckNAdd(27); }
                  break;
               case 77:
                  if (curChar == 59 && kind > 116)
                     kind = 116;
                  break;
               case 80:
                  if (curChar == 61 && kind > 117)
                     kind = 117;
                  break;
               case 81:
                  if (curChar == 59)
                     jjstateSet[jjnewStateCnt++] = 80;
                  break;
               case 85:
                  if (curChar == 59 && kind > 125)
                     kind = 125;
                  break;
               case 89:
                  if (curChar == 38)
                     jjstateSet[jjnewStateCnt++] = 88;
                  break;
               case 90:
                  if (curChar == 59)
                     jjstateSet[jjnewStateCnt++] = 89;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 42:
                  if (curChar == 93 && kind > 147)
                     kind = 147;
                  break;
               case 1:
                  if ((0x7fffffe87ffffffL & l) != 0L)
                  {
                     if (kind > 140)
                        kind = 140;
                     { jjCheckNAddTwoStates(34, 35); }
                  }
                  else if (curChar == 92)
                     { jjAddStates(362, 366); }
                  else if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 31;
                  else if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 2;
                  if (curChar == 103)
                     { jjCheckNAddTwoStates(62, 95); }
                  else if (curChar == 108)
                     { jjCheckNAddTwoStates(55, 57); }
                  else if (curChar == 92)
                     { jjCheckNAdd(36); }
                  else if (curChar == 124)
                  {
                     if (kind > 126)
                        kind = 126;
                  }
                  else if (curChar == 114)
                     { jjAddStates(367, 368); }
                  break;
               case 96:
                  if ((0x7fffffe87ffffffL & l) != 0L)
                  {
                     if (kind > 140)
                        kind = 140;
                     { jjCheckNAddTwoStates(34, 35); }
                  }
                  else if (curChar == 92)
                     { jjCheckNAdd(36); }
                  break;
               case 6:
                  if ((0xffffffffefffffffL & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 7:
                  if (curChar == 92)
                     { jjAddStates(369, 370); }
                  break;
               case 8:
                  if (curChar == 120)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 9:
                  if ((0x7e0000007eL & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 11:
                  if ((0x81450c610000000L & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 13:
                  if ((0xffffffffefffffffL & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 14:
                  if (curChar == 92)
                     { jjAddStates(371, 372); }
                  break;
               case 15:
                  if (curChar == 120)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 16:
                  if ((0x7e0000007eL & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 18:
                  if ((0x81450c610000000L & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 19:
                  if (curChar == 114)
                     { jjAddStates(367, 368); }
                  break;
               case 21:
                  { jjAddStates(373, 374); }
                  break;
               case 24:
                  { jjAddStates(375, 376); }
                  break;
               case 30:
               case 31:
                  if (curChar == 124 && kind > 126)
                     kind = 126;
                  break;
               case 32:
                  if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 33:
                  if ((0x7fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 34:
                  if ((0x7fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 35:
                  if (curChar == 92)
                     { jjCheckNAdd(36); }
                  break;
               case 37:
                  if (curChar == 92)
                     { jjCheckNAdd(36); }
                  break;
               case 38:
                  if (curChar == 123 && kind > 141)
                     kind = 141;
                  break;
               case 54:
                  if (curChar == 108)
                     { jjCheckNAddTwoStates(55, 57); }
                  break;
               case 55:
                  if (curChar == 116 && kind > 114)
                     kind = 114;
                  break;
               case 56:
                  if (curChar == 101 && kind > 115)
                     kind = 115;
                  break;
               case 57:
               case 60:
                  if (curChar == 116)
                     { jjCheckNAdd(56); }
                  break;
               case 58:
                  if (curChar == 92)
                     { jjAddStates(362, 366); }
                  break;
               case 59:
                  if (curChar == 108)
                     { jjCheckNAdd(55); }
                  break;
               case 61:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 60;
                  break;
               case 62:
                  if (curChar == 116 && kind > 116)
                     kind = 116;
                  break;
               case 63:
                  if (curChar == 103)
                     { jjCheckNAdd(62); }
                  break;
               case 64:
                  if (curChar == 101 && kind > 117)
                     kind = 117;
                  break;
               case 65:
               case 95:
                  if (curChar == 116)
                     { jjCheckNAdd(64); }
                  break;
               case 66:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 65;
                  break;
               case 67:
                  if (curChar == 100 && kind > 125)
                     kind = 125;
                  break;
               case 68:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 69:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 68;
                  break;
               case 72:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 71;
                  break;
               case 73:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 72;
                  break;
               case 75:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 74;
                  break;
               case 76:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 75;
                  break;
               case 78:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 77;
                  break;
               case 79:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 78;
                  break;
               case 82:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 81;
                  break;
               case 83:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 86:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 85;
                  break;
               case 87:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 86;
                  break;
               case 88:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 87;
                  break;
               case 91:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 90;
                  break;
               case 92:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 91;
                  break;
               case 93:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 92;
                  break;
               case 94:
                  if (curChar == 103)
                     { jjCheckNAddTwoStates(62, 95); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 1:
                  if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 96:
               case 34:
                  if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 6:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(359, 361); }
                  break;
               case 13:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(356, 358); }
                  break;
               case 21:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(373, 374); }
                  break;
               case 24:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(375, 376); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 96 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_3(int pos, long active0, long active1, long active2){
   switch (pos)
   {
      case 0:
         if ((active2 & 0x8L) != 0L)
            return 2;
         if ((active1 & 0x400002c00000000L) != 0L)
            return 43;
         if ((active1 & 0xc0000000L) != 0L || (active2 & 0xe00L) != 0L)
         {
            jjmatchedKind = 140;
            return 93;
         }
         return -1;
      case 1:
         if ((active2 & 0x600L) != 0L)
            return 93;
         if ((active1 & 0xc0000000L) != 0L || (active2 & 0x800L) != 0L)
         {
            if (jjmatchedPos != 1)
            {
               jjmatchedKind = 140;
               jjmatchedPos = 1;
            }
            return 93;
         }
         if ((active1 & 0x400002800000000L) != 0L)
            return 42;
         return -1;
      case 2:
         if ((active1 & 0xc0000000L) != 0L || (active2 & 0x800L) != 0L)
         {
            jjmatchedKind = 140;
            jjmatchedPos = 2;
            return 93;
         }
         return -1;
      case 3:
         if ((active1 & 0x80000000L) != 0L)
            return 93;
         if ((active1 & 0x40000000L) != 0L || (active2 & 0x800L) != 0L)
         {
            jjmatchedKind = 140;
            jjmatchedPos = 3;
            return 93;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_3(int pos, long active0, long active1, long active2){
   return jjMoveNfa_3(jjStopStringLiteralDfa_3(pos, active0, active1, active2), pos + 1);
}
private int jjMoveStringLiteralDfa0_3(){
   switch(curChar)
   {
      case 33:
         jjmatchedKind = 127;
         return jjMoveStringLiteralDfa1_3(0x40000000000L, 0x0L);
      case 37:
         jjmatchedKind = 124;
         return jjMoveStringLiteralDfa1_3(0x800000000000L, 0x0L);
      case 40:
         return jjStopAtPos(0, 133);
      case 41:
         return jjStopAtPos(0, 134);
      case 42:
         jjmatchedKind = 120;
         return jjMoveStringLiteralDfa1_3(0x200200000000000L, 0x0L);
      case 43:
         jjmatchedKind = 118;
         return jjMoveStringLiteralDfa1_3(0x1080000000000L, 0x0L);
      case 44:
         return jjStopAtPos(0, 128);
      case 45:
         jjmatchedKind = 119;
         return jjMoveStringLiteralDfa1_3(0x2100000000000L, 0x0L);
      case 46:
         jjmatchedKind = 98;
         return jjMoveStringLiteralDfa1_3(0x400002800000000L, 0x0L);
      case 47:
         jjmatchedKind = 123;
         return jjMoveStringLiteralDfa1_3(0x400000000000L, 0x0L);
      case 58:
         return jjStopAtPos(0, 130);
      case 59:
         return jjStopAtPos(0, 129);
      case 61:
         jjmatchedKind = 104;
         return jjMoveStringLiteralDfa1_3(0x20000000000L, 0x0L);
      case 62:
         jjmatchedKind = 148;
         return jjMoveStringLiteralDfa1_3(0x0L, 0x200000L);
      case 63:
         jjmatchedKind = 102;
         return jjMoveStringLiteralDfa1_3(0x8000000000L, 0x0L);
      case 91:
         return jjStartNfaWithStates_3(0, 131, 2);
      case 93:
         return jjStopAtPos(0, 132);
      case 97:
         return jjMoveStringLiteralDfa1_3(0x0L, 0x400L);
      case 102:
         return jjMoveStringLiteralDfa1_3(0x40000000L, 0x0L);
      case 105:
         return jjMoveStringLiteralDfa1_3(0x0L, 0x200L);
      case 116:
         return jjMoveStringLiteralDfa1_3(0x80000000L, 0x0L);
      case 117:
         return jjMoveStringLiteralDfa1_3(0x0L, 0x800L);
      case 123:
         return jjStopAtPos(0, 135);
      case 125:
         return jjStopAtPos(0, 136);
      default :
         return jjMoveNfa_3(1, 0);
   }
}
private int jjMoveStringLiteralDfa1_3(long active1, long active2){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(0, 0L, active1, active2);
      return 1;
   }
   switch(curChar)
   {
      case 42:
         if ((active1 & 0x200000000000000L) != 0L)
            return jjStopAtPos(1, 121);
         break;
      case 43:
         if ((active1 & 0x1000000000000L) != 0L)
            return jjStopAtPos(1, 112);
         break;
      case 45:
         if ((active1 & 0x2000000000000L) != 0L)
            return jjStopAtPos(1, 113);
         break;
      case 46:
         if ((active1 & 0x800000000L) != 0L)
         {
            jjmatchedKind = 99;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_3(active1, 0x400002000000000L, active2, 0L);
      case 61:
         if ((active1 & 0x20000000000L) != 0L)
            return jjStopAtPos(1, 105);
         else if ((active1 & 0x40000000000L) != 0L)
            return jjStopAtPos(1, 106);
         else if ((active1 & 0x80000000000L) != 0L)
            return jjStopAtPos(1, 107);
         else if ((active1 & 0x100000000000L) != 0L)
            return jjStopAtPos(1, 108);
         else if ((active1 & 0x200000000000L) != 0L)
            return jjStopAtPos(1, 109);
         else if ((active1 & 0x400000000000L) != 0L)
            return jjStopAtPos(1, 110);
         else if ((active1 & 0x800000000000L) != 0L)
            return jjStopAtPos(1, 111);
         else if ((active2 & 0x200000L) != 0L)
            return jjStopAtPos(1, 149);
         break;
      case 63:
         if ((active1 & 0x8000000000L) != 0L)
            return jjStopAtPos(1, 103);
         break;
      case 97:
         return jjMoveStringLiteralDfa2_3(active1, 0x40000000L, active2, 0L);
      case 110:
         if ((active2 & 0x200L) != 0L)
            return jjStartNfaWithStates_3(1, 137, 93);
         break;
      case 114:
         return jjMoveStringLiteralDfa2_3(active1, 0x80000000L, active2, 0L);
      case 115:
         if ((active2 & 0x400L) != 0L)
            return jjStartNfaWithStates_3(1, 138, 93);
         return jjMoveStringLiteralDfa2_3(active1, 0L, active2, 0x800L);
      default :
         break;
   }
   return jjStartNfa_3(0, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa2_3(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_3(0, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(1, 0L, active1, active2);
      return 2;
   }
   switch(curChar)
   {
      case 42:
         if ((active1 & 0x2000000000L) != 0L)
            return jjStopAtPos(2, 101);
         break;
      case 46:
         if ((active1 & 0x400000000000000L) != 0L)
            return jjStopAtPos(2, 122);
         break;
      case 105:
         return jjMoveStringLiteralDfa3_3(active1, 0L, active2, 0x800L);
      case 108:
         return jjMoveStringLiteralDfa3_3(active1, 0x40000000L, active2, 0L);
      case 117:
         return jjMoveStringLiteralDfa3_3(active1, 0x80000000L, active2, 0L);
      default :
         break;
   }
   return jjStartNfa_3(1, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa3_3(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_3(1, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(2, 0L, active1, active2);
      return 3;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x80000000L) != 0L)
            return jjStartNfaWithStates_3(3, 95, 93);
         break;
      case 110:
         return jjMoveStringLiteralDfa4_3(active1, 0L, active2, 0x800L);
      case 115:
         return jjMoveStringLiteralDfa4_3(active1, 0x40000000L, active2, 0L);
      default :
         break;
   }
   return jjStartNfa_3(2, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa4_3(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_3(2, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_3(3, 0L, active1, active2);
      return 4;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x40000000L) != 0L)
            return jjStartNfaWithStates_3(4, 94, 93);
         break;
      case 103:
         if ((active2 & 0x800L) != 0L)
            return jjStartNfaWithStates_3(4, 139, 93);
         break;
      default :
         break;
   }
   return jjStartNfa_3(3, 0L, active1, active2);
}
private int jjStartNfaWithStates_3(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_3(state, pos + 1);
}
private int jjMoveNfa_3(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 93;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 43:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 44;
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 42;
                  break;
               case 42:
                  if (curChar == 33)
                  {
                     if (kind > 100)
                        kind = 100;
                  }
                  else if (curChar == 60)
                  {
                     if (kind > 100)
                        kind = 100;
                  }
                  break;
               case 1:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 96)
                        kind = 96;
                     { jjCheckNAddStates(377, 379); }
                  }
                  else if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 84)
                        kind = 84;
                     { jjCheckNAdd(0); }
                  }
                  else if (curChar == 38)
                     { jjAddStates(380, 385); }
                  else if (curChar == 46)
                     { jjAddStates(386, 387); }
                  else if (curChar == 35)
                     { jjCheckNAdd(38); }
                  else if (curChar == 36)
                     { jjCheckNAdd(38); }
                  else if (curChar == 60)
                     { jjCheckNAdd(27); }
                  else if (curChar == 39)
                     { jjCheckNAddStates(356, 358); }
                  else if (curChar == 34)
                     { jjCheckNAddStates(359, 361); }
                  if (curChar == 36)
                  {
                     if (kind > 140)
                        kind = 140;
                     { jjCheckNAddTwoStates(34, 35); }
                  }
                  else if (curChar == 38)
                  {
                     if (kind > 125)
                        kind = 125;
                  }
                  else if (curChar == 60)
                  {
                     if (kind > 114)
                        kind = 114;
                  }
                  if (curChar == 60)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 93:
               case 34:
                  if ((0x3ff001000000000L & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 0:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 84)
                     kind = 84;
                  { jjCheckNAdd(0); }
                  break;
               case 2:
                  if ((0xa00000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 3:
                  if (curChar == 45 && kind > 85)
                     kind = 85;
                  break;
               case 4:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 3;
                  break;
               case 5:
                  if (curChar == 34)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 6:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 9:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 10:
                  if (curChar == 34 && kind > 92)
                     kind = 92;
                  break;
               case 11:
                  if ((0x9400000000L & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 12:
                  if (curChar == 39)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 13:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 16:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 17:
                  if (curChar == 39 && kind > 92)
                     kind = 92;
                  break;
               case 18:
                  if ((0x9400000000L & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 20:
                  if (curChar == 34)
                     { jjCheckNAddTwoStates(21, 22); }
                  break;
               case 21:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     { jjCheckNAddTwoStates(21, 22); }
                  break;
               case 22:
                  if (curChar == 34 && kind > 93)
                     kind = 93;
                  break;
               case 23:
                  if (curChar == 39)
                     { jjCheckNAddTwoStates(24, 25); }
                  break;
               case 24:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     { jjCheckNAddTwoStates(24, 25); }
                  break;
               case 25:
                  if (curChar == 39 && kind > 93)
                     kind = 93;
                  break;
               case 26:
                  if (curChar == 60 && kind > 114)
                     kind = 114;
                  break;
               case 27:
                  if (curChar == 61 && kind > 115)
                     kind = 115;
                  break;
               case 28:
                  if (curChar == 60)
                     { jjCheckNAdd(27); }
                  break;
               case 29:
               case 81:
                  if (curChar == 38 && kind > 125)
                     kind = 125;
                  break;
               case 33:
                  if (curChar != 36)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 36:
                  if ((0x400600000000000L & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 39:
                  if (curChar == 36)
                     { jjCheckNAdd(38); }
                  break;
               case 40:
                  if (curChar == 35)
                     { jjCheckNAdd(38); }
                  break;
               case 41:
                  if (curChar == 46)
                     { jjAddStates(386, 387); }
                  break;
               case 44:
                  if (curChar == 33 && kind > 100)
                     kind = 100;
                  break;
               case 45:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 44;
                  break;
               case 46:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 96)
                     kind = 96;
                  { jjCheckNAddStates(377, 379); }
                  break;
               case 47:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 96)
                     kind = 96;
                  { jjCheckNAdd(47); }
                  break;
               case 48:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(48, 49); }
                  break;
               case 49:
                  if (curChar == 46)
                     { jjCheckNAdd(50); }
                  break;
               case 50:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 97)
                     kind = 97;
                  { jjCheckNAdd(50); }
                  break;
               case 67:
                  if (curChar == 38)
                     { jjAddStates(380, 385); }
                  break;
               case 68:
                  if (curChar == 59 && kind > 114)
                     kind = 114;
                  break;
               case 71:
                  if (curChar == 59)
                     { jjCheckNAdd(27); }
                  break;
               case 74:
                  if (curChar == 59 && kind > 116)
                     kind = 116;
                  break;
               case 77:
                  if (curChar == 61 && kind > 117)
                     kind = 117;
                  break;
               case 78:
                  if (curChar == 59)
                     jjstateSet[jjnewStateCnt++] = 77;
                  break;
               case 82:
                  if (curChar == 59 && kind > 125)
                     kind = 125;
                  break;
               case 86:
                  if (curChar == 38)
                     jjstateSet[jjnewStateCnt++] = 85;
                  break;
               case 87:
                  if (curChar == 59)
                     jjstateSet[jjnewStateCnt++] = 86;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 1:
                  if ((0x7fffffe87ffffffL & l) != 0L)
                  {
                     if (kind > 140)
                        kind = 140;
                     { jjCheckNAddTwoStates(34, 35); }
                  }
                  else if (curChar == 92)
                     { jjAddStates(388, 392); }
                  else if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 31;
                  else if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 2;
                  if (curChar == 103)
                     { jjCheckNAddTwoStates(59, 92); }
                  else if (curChar == 108)
                     { jjCheckNAddTwoStates(52, 54); }
                  else if (curChar == 92)
                     { jjCheckNAdd(36); }
                  else if (curChar == 124)
                  {
                     if (kind > 126)
                        kind = 126;
                  }
                  else if (curChar == 114)
                     { jjAddStates(367, 368); }
                  break;
               case 93:
                  if ((0x7fffffe87ffffffL & l) != 0L)
                  {
                     if (kind > 140)
                        kind = 140;
                     { jjCheckNAddTwoStates(34, 35); }
                  }
                  else if (curChar == 92)
                     { jjCheckNAdd(36); }
                  break;
               case 6:
                  if ((0xffffffffefffffffL & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 7:
                  if (curChar == 92)
                     { jjAddStates(369, 370); }
                  break;
               case 8:
                  if (curChar == 120)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 9:
                  if ((0x7e0000007eL & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 11:
                  if ((0x81450c610000000L & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 13:
                  if ((0xffffffffefffffffL & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 14:
                  if (curChar == 92)
                     { jjAddStates(371, 372); }
                  break;
               case 15:
                  if (curChar == 120)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 16:
                  if ((0x7e0000007eL & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 18:
                  if ((0x81450c610000000L & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 19:
                  if (curChar == 114)
                     { jjAddStates(367, 368); }
                  break;
               case 21:
                  { jjAddStates(373, 374); }
                  break;
               case 24:
                  { jjAddStates(375, 376); }
                  break;
               case 30:
               case 31:
                  if (curChar == 124 && kind > 126)
                     kind = 126;
                  break;
               case 32:
                  if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 33:
                  if ((0x7fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 34:
                  if ((0x7fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 35:
                  if (curChar == 92)
                     { jjCheckNAdd(36); }
                  break;
               case 37:
                  if (curChar == 92)
                     { jjCheckNAdd(36); }
                  break;
               case 38:
                  if (curChar == 123 && kind > 141)
                     kind = 141;
                  break;
               case 51:
                  if (curChar == 108)
                     { jjCheckNAddTwoStates(52, 54); }
                  break;
               case 52:
                  if (curChar == 116 && kind > 114)
                     kind = 114;
                  break;
               case 53:
                  if (curChar == 101 && kind > 115)
                     kind = 115;
                  break;
               case 54:
               case 57:
                  if (curChar == 116)
                     { jjCheckNAdd(53); }
                  break;
               case 55:
                  if (curChar == 92)
                     { jjAddStates(388, 392); }
                  break;
               case 56:
                  if (curChar == 108)
                     { jjCheckNAdd(52); }
                  break;
               case 58:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 59:
                  if (curChar == 116 && kind > 116)
                     kind = 116;
                  break;
               case 60:
                  if (curChar == 103)
                     { jjCheckNAdd(59); }
                  break;
               case 61:
                  if (curChar == 101 && kind > 117)
                     kind = 117;
                  break;
               case 62:
               case 92:
                  if (curChar == 116)
                     { jjCheckNAdd(61); }
                  break;
               case 63:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 64:
                  if (curChar == 100 && kind > 125)
                     kind = 125;
                  break;
               case 65:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 64;
                  break;
               case 66:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 65;
                  break;
               case 69:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 68;
                  break;
               case 70:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 69;
                  break;
               case 72:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 71;
                  break;
               case 73:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 72;
                  break;
               case 75:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 74;
                  break;
               case 76:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 75;
                  break;
               case 79:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 78;
                  break;
               case 80:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 83:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 84:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 83;
                  break;
               case 85:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 84;
                  break;
               case 88:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 87;
                  break;
               case 89:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 88;
                  break;
               case 90:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 89;
                  break;
               case 91:
                  if (curChar == 103)
                     { jjCheckNAddTwoStates(59, 92); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 1:
                  if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 93:
               case 34:
                  if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 6:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(359, 361); }
                  break;
               case 13:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(356, 358); }
                  break;
               case 21:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(373, 374); }
                  break;
               case 24:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(375, 376); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 93 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_5(int pos, long active0, long active1){
   switch (pos)
   {
      default :
         return -1;
   }
}
private final int jjStartNfa_5(int pos, long active0, long active1){
   return jjMoveNfa_5(jjStopStringLiteralDfa_5(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_5(){
   switch(curChar)
   {
      case 45:
         return jjStartNfaWithStates_5(0, 89, 3);
      default :
         return jjMoveNfa_5(1, 0);
   }
}
private int jjStartNfaWithStates_5(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_5(state, pos + 1);
}
private int jjMoveNfa_5(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 6;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 3:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 4;
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 1:
                  if ((0xbfffdfffffffffffL & l) != 0L)
                  {
                     if (kind > 86)
                        kind = 86;
                     { jjCheckNAdd(0); }
                  }
                  else if (curChar == 45)
                     { jjAddStates(393, 394); }
                  break;
               case 0:
                  if ((0xbfffdfffffffffffL & l) == 0L)
                     break;
                  kind = 86;
                  { jjCheckNAdd(0); }
                  break;
               case 2:
                  if (curChar == 62)
                     kind = 90;
                  break;
               case 5:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 1:
               case 0:
                  if ((0xffffffffdfffffffL & l) == 0L)
                     break;
                  kind = 86;
                  { jjCheckNAdd(0); }
                  break;
               case 4:
                  if (curChar == 93)
                     kind = 90;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 1:
               case 0:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 86)
                     kind = 86;
                  { jjCheckNAdd(0); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 6 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_6(int pos, long active0, long active1, long active2){
   switch (pos)
   {
      case 0:
         if ((active1 & 0x800400000000000L) != 0L)
            return 38;
         if ((active1 & 0xc0000000L) != 0L || (active2 & 0xe00L) != 0L)
         {
            jjmatchedKind = 140;
            return 92;
         }
         if ((active1 & 0x400002c00000000L) != 0L)
            return 42;
         return -1;
      case 1:
         if ((active2 & 0x600L) != 0L)
            return 92;
         if ((active1 & 0x400002800000000L) != 0L)
            return 41;
         if ((active1 & 0xc0000000L) != 0L || (active2 & 0x800L) != 0L)
         {
            if (jjmatchedPos != 1)
            {
               jjmatchedKind = 140;
               jjmatchedPos = 1;
            }
            return 92;
         }
         return -1;
      case 2:
         if ((active1 & 0xc0000000L) != 0L || (active2 & 0x800L) != 0L)
         {
            jjmatchedKind = 140;
            jjmatchedPos = 2;
            return 92;
         }
         return -1;
      case 3:
         if ((active1 & 0x80000000L) != 0L)
            return 92;
         if ((active1 & 0x40000000L) != 0L || (active2 & 0x800L) != 0L)
         {
            jjmatchedKind = 140;
            jjmatchedPos = 3;
            return 92;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_6(int pos, long active0, long active1, long active2){
   return jjMoveNfa_6(jjStopStringLiteralDfa_6(pos, active0, active1, active2), pos + 1);
}
private int jjMoveStringLiteralDfa0_6(){
   switch(curChar)
   {
      case 33:
         jjmatchedKind = 127;
         return jjMoveStringLiteralDfa1_6(0x40000000000L, 0x0L);
      case 37:
         jjmatchedKind = 124;
         return jjMoveStringLiteralDfa1_6(0x800000000000L, 0x0L);
      case 40:
         return jjStopAtPos(0, 133);
      case 41:
         return jjStopAtPos(0, 134);
      case 42:
         jjmatchedKind = 120;
         return jjMoveStringLiteralDfa1_6(0x200200000000000L, 0x0L);
      case 43:
         jjmatchedKind = 118;
         return jjMoveStringLiteralDfa1_6(0x1080000000000L, 0x0L);
      case 44:
         return jjStopAtPos(0, 128);
      case 45:
         jjmatchedKind = 119;
         return jjMoveStringLiteralDfa1_6(0x2100000000000L, 0x0L);
      case 46:
         jjmatchedKind = 98;
         return jjMoveStringLiteralDfa1_6(0x400002800000000L, 0x0L);
      case 47:
         jjmatchedKind = 123;
         return jjMoveStringLiteralDfa1_6(0x400000000000L, 0x0L);
      case 58:
         return jjStopAtPos(0, 130);
      case 59:
         return jjStopAtPos(0, 129);
      case 61:
         jjmatchedKind = 104;
         return jjMoveStringLiteralDfa1_6(0x20000000000L, 0x0L);
      case 62:
         return jjStopAtPos(0, 146);
      case 63:
         jjmatchedKind = 102;
         return jjMoveStringLiteralDfa1_6(0x8000000000L, 0x0L);
      case 91:
         return jjStopAtPos(0, 131);
      case 93:
         return jjStopAtPos(0, 132);
      case 97:
         return jjMoveStringLiteralDfa1_6(0x0L, 0x400L);
      case 102:
         return jjMoveStringLiteralDfa1_6(0x40000000L, 0x0L);
      case 105:
         return jjMoveStringLiteralDfa1_6(0x0L, 0x200L);
      case 116:
         return jjMoveStringLiteralDfa1_6(0x80000000L, 0x0L);
      case 117:
         return jjMoveStringLiteralDfa1_6(0x0L, 0x800L);
      case 123:
         return jjStopAtPos(0, 135);
      case 125:
         return jjStopAtPos(0, 136);
      default :
         return jjMoveNfa_6(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_6(long active1, long active2){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(0, 0L, active1, active2);
      return 1;
   }
   switch(curChar)
   {
      case 42:
         if ((active1 & 0x200000000000000L) != 0L)
            return jjStopAtPos(1, 121);
         break;
      case 43:
         if ((active1 & 0x1000000000000L) != 0L)
            return jjStopAtPos(1, 112);
         break;
      case 45:
         if ((active1 & 0x2000000000000L) != 0L)
            return jjStopAtPos(1, 113);
         break;
      case 46:
         if ((active1 & 0x800000000L) != 0L)
         {
            jjmatchedKind = 99;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_6(active1, 0x400002000000000L, active2, 0L);
      case 61:
         if ((active1 & 0x20000000000L) != 0L)
            return jjStopAtPos(1, 105);
         else if ((active1 & 0x40000000000L) != 0L)
            return jjStopAtPos(1, 106);
         else if ((active1 & 0x80000000000L) != 0L)
            return jjStopAtPos(1, 107);
         else if ((active1 & 0x100000000000L) != 0L)
            return jjStopAtPos(1, 108);
         else if ((active1 & 0x200000000000L) != 0L)
            return jjStopAtPos(1, 109);
         else if ((active1 & 0x400000000000L) != 0L)
            return jjStopAtPos(1, 110);
         else if ((active1 & 0x800000000000L) != 0L)
            return jjStopAtPos(1, 111);
         break;
      case 63:
         if ((active1 & 0x8000000000L) != 0L)
            return jjStopAtPos(1, 103);
         break;
      case 97:
         return jjMoveStringLiteralDfa2_6(active1, 0x40000000L, active2, 0L);
      case 110:
         if ((active2 & 0x200L) != 0L)
            return jjStartNfaWithStates_6(1, 137, 92);
         break;
      case 114:
         return jjMoveStringLiteralDfa2_6(active1, 0x80000000L, active2, 0L);
      case 115:
         if ((active2 & 0x400L) != 0L)
            return jjStartNfaWithStates_6(1, 138, 92);
         return jjMoveStringLiteralDfa2_6(active1, 0L, active2, 0x800L);
      default :
         break;
   }
   return jjStartNfa_6(0, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa2_6(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_6(0, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(1, 0L, active1, active2);
      return 2;
   }
   switch(curChar)
   {
      case 42:
         if ((active1 & 0x2000000000L) != 0L)
            return jjStopAtPos(2, 101);
         break;
      case 46:
         if ((active1 & 0x400000000000000L) != 0L)
            return jjStopAtPos(2, 122);
         break;
      case 105:
         return jjMoveStringLiteralDfa3_6(active1, 0L, active2, 0x800L);
      case 108:
         return jjMoveStringLiteralDfa3_6(active1, 0x40000000L, active2, 0L);
      case 117:
         return jjMoveStringLiteralDfa3_6(active1, 0x80000000L, active2, 0L);
      default :
         break;
   }
   return jjStartNfa_6(1, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa3_6(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_6(1, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(2, 0L, active1, active2);
      return 3;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x80000000L) != 0L)
            return jjStartNfaWithStates_6(3, 95, 92);
         break;
      case 110:
         return jjMoveStringLiteralDfa4_6(active1, 0L, active2, 0x800L);
      case 115:
         return jjMoveStringLiteralDfa4_6(active1, 0x40000000L, active2, 0L);
      default :
         break;
   }
   return jjStartNfa_6(2, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa4_6(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_6(2, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(3, 0L, active1, active2);
      return 4;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x40000000L) != 0L)
            return jjStartNfaWithStates_6(4, 94, 92);
         break;
      case 103:
         if ((active2 & 0x800L) != 0L)
            return jjStartNfaWithStates_6(4, 139, 92);
         break;
      default :
         break;
   }
   return jjStartNfa_6(3, 0L, active1, active2);
}
private int jjStartNfaWithStates_6(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_6(state, pos + 1);
}
private int jjMoveNfa_6(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 92;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 41:
                  if (curChar == 33)
                  {
                     if (kind > 100)
                        kind = 100;
                  }
                  else if (curChar == 60)
                  {
                     if (kind > 100)
                        kind = 100;
                  }
                  break;
               case 42:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 43;
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 41;
                  break;
               case 0:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 96)
                        kind = 96;
                     { jjCheckNAddStates(395, 397); }
                  }
                  else if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 150)
                        kind = 150;
                     { jjCheckNAdd(36); }
                  }
                  else if (curChar == 38)
                     { jjAddStates(398, 403); }
                  else if (curChar == 46)
                     { jjAddStates(404, 405); }
                  else if (curChar == 47)
                     { jjAddStates(406, 407); }
                  else if (curChar == 35)
                     { jjCheckNAdd(33); }
                  else if (curChar == 36)
                     { jjCheckNAdd(33); }
                  else if (curChar == 60)
                     { jjCheckNAdd(22); }
                  else if (curChar == 39)
                     { jjCheckNAddStates(408, 410); }
                  else if (curChar == 34)
                     { jjCheckNAddStates(411, 413); }
                  if (curChar == 36)
                  {
                     if (kind > 140)
                        kind = 140;
                     { jjCheckNAddTwoStates(29, 30); }
                  }
                  else if (curChar == 38)
                  {
                     if (kind > 125)
                        kind = 125;
                  }
                  else if (curChar == 60)
                  {
                     if (kind > 114)
                        kind = 114;
                  }
                  break;
               case 92:
               case 29:
                  if ((0x3ff001000000000L & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(29, 30); }
                  break;
               case 38:
                  if (curChar == 62 && kind > 147)
                     kind = 147;
                  break;
               case 1:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     { jjCheckNAddStates(411, 413); }
                  break;
               case 4:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddStates(411, 413); }
                  break;
               case 5:
                  if (curChar == 34 && kind > 92)
                     kind = 92;
                  break;
               case 6:
                  if ((0x9400000000L & l) != 0L)
                     { jjCheckNAddStates(411, 413); }
                  break;
               case 7:
                  if (curChar == 39)
                     { jjCheckNAddStates(408, 410); }
                  break;
               case 8:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     { jjCheckNAddStates(408, 410); }
                  break;
               case 11:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddStates(408, 410); }
                  break;
               case 12:
                  if (curChar == 39 && kind > 92)
                     kind = 92;
                  break;
               case 13:
                  if ((0x9400000000L & l) != 0L)
                     { jjCheckNAddStates(408, 410); }
                  break;
               case 15:
                  if (curChar == 34)
                     { jjCheckNAddTwoStates(16, 17); }
                  break;
               case 16:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     { jjCheckNAddTwoStates(16, 17); }
                  break;
               case 17:
                  if (curChar == 34 && kind > 93)
                     kind = 93;
                  break;
               case 18:
                  if (curChar == 39)
                     { jjCheckNAddTwoStates(19, 20); }
                  break;
               case 19:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     { jjCheckNAddTwoStates(19, 20); }
                  break;
               case 20:
                  if (curChar == 39 && kind > 93)
                     kind = 93;
                  break;
               case 21:
                  if (curChar == 60 && kind > 114)
                     kind = 114;
                  break;
               case 22:
                  if (curChar == 61 && kind > 115)
                     kind = 115;
                  break;
               case 23:
                  if (curChar == 60)
                     { jjCheckNAdd(22); }
                  break;
               case 24:
               case 80:
                  if (curChar == 38 && kind > 125)
                     kind = 125;
                  break;
               case 28:
                  if (curChar != 36)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(29, 30); }
                  break;
               case 31:
                  if ((0x400600000000000L & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(29, 30); }
                  break;
               case 34:
                  if (curChar == 36)
                     { jjCheckNAdd(33); }
                  break;
               case 35:
                  if (curChar == 35)
                     { jjCheckNAdd(33); }
                  break;
               case 36:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 150)
                     kind = 150;
                  { jjCheckNAdd(36); }
                  break;
               case 37:
                  if (curChar == 47)
                     { jjAddStates(406, 407); }
                  break;
               case 40:
                  if (curChar == 46)
                     { jjAddStates(404, 405); }
                  break;
               case 43:
                  if (curChar == 33 && kind > 100)
                     kind = 100;
                  break;
               case 44:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 43;
                  break;
               case 45:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 96)
                     kind = 96;
                  { jjCheckNAddStates(395, 397); }
                  break;
               case 46:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 96)
                     kind = 96;
                  { jjCheckNAdd(46); }
                  break;
               case 47:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(47, 48); }
                  break;
               case 48:
                  if (curChar == 46)
                     { jjCheckNAdd(49); }
                  break;
               case 49:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 97)
                     kind = 97;
                  { jjCheckNAdd(49); }
                  break;
               case 66:
                  if (curChar == 38)
                     { jjAddStates(398, 403); }
                  break;
               case 67:
                  if (curChar == 59 && kind > 114)
                     kind = 114;
                  break;
               case 70:
                  if (curChar == 59)
                     { jjCheckNAdd(22); }
                  break;
               case 73:
                  if (curChar == 59 && kind > 116)
                     kind = 116;
                  break;
               case 76:
                  if (curChar == 61 && kind > 117)
                     kind = 117;
                  break;
               case 77:
                  if (curChar == 59)
                     jjstateSet[jjnewStateCnt++] = 76;
                  break;
               case 81:
                  if (curChar == 59 && kind > 125)
                     kind = 125;
                  break;
               case 85:
                  if (curChar == 38)
                     jjstateSet[jjnewStateCnt++] = 84;
                  break;
               case 86:
                  if (curChar == 59)
                     jjstateSet[jjnewStateCnt++] = 85;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x7fffffe87ffffffL & l) != 0L)
                  {
                     if (kind > 140)
                        kind = 140;
                     { jjCheckNAddTwoStates(29, 30); }
                  }
                  else if (curChar == 92)
                     { jjAddStates(414, 418); }
                  else if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 26;
                  if (curChar == 103)
                     { jjCheckNAddTwoStates(58, 91); }
                  else if (curChar == 108)
                     { jjCheckNAddTwoStates(51, 53); }
                  else if (curChar == 92)
                     { jjCheckNAdd(31); }
                  else if (curChar == 124)
                  {
                     if (kind > 126)
                        kind = 126;
                  }
                  else if (curChar == 114)
                     { jjAddStates(371, 372); }
                  break;
               case 92:
                  if ((0x7fffffe87ffffffL & l) != 0L)
                  {
                     if (kind > 140)
                        kind = 140;
                     { jjCheckNAddTwoStates(29, 30); }
                  }
                  else if (curChar == 92)
                     { jjCheckNAdd(31); }
                  break;
               case 38:
                  if (curChar == 93 && kind > 147)
                     kind = 147;
                  break;
               case 1:
                  if ((0xffffffffefffffffL & l) != 0L)
                     { jjCheckNAddStates(411, 413); }
                  break;
               case 2:
                  if (curChar == 92)
                     { jjAddStates(419, 420); }
                  break;
               case 3:
                  if (curChar == 120)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 4:
                  if ((0x7e0000007eL & l) != 0L)
                     { jjCheckNAddStates(411, 413); }
                  break;
               case 6:
                  if ((0x81450c610000000L & l) != 0L)
                     { jjCheckNAddStates(411, 413); }
                  break;
               case 8:
                  if ((0xffffffffefffffffL & l) != 0L)
                     { jjCheckNAddStates(408, 410); }
                  break;
               case 9:
                  if (curChar == 92)
                     { jjAddStates(421, 422); }
                  break;
               case 10:
                  if (curChar == 120)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 11:
                  if ((0x7e0000007eL & l) != 0L)
                     { jjCheckNAddStates(408, 410); }
                  break;
               case 13:
                  if ((0x81450c610000000L & l) != 0L)
                     { jjCheckNAddStates(408, 410); }
                  break;
               case 14:
                  if (curChar == 114)
                     { jjAddStates(371, 372); }
                  break;
               case 16:
                  { jjAddStates(423, 424); }
                  break;
               case 19:
                  { jjAddStates(425, 426); }
                  break;
               case 25:
               case 26:
                  if (curChar == 124 && kind > 126)
                     kind = 126;
                  break;
               case 27:
                  if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 26;
                  break;
               case 28:
                  if ((0x7fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(29, 30); }
                  break;
               case 29:
                  if ((0x7fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(29, 30); }
                  break;
               case 30:
                  if (curChar == 92)
                     { jjCheckNAdd(31); }
                  break;
               case 32:
                  if (curChar == 92)
                     { jjCheckNAdd(31); }
                  break;
               case 33:
                  if (curChar == 123 && kind > 141)
                     kind = 141;
                  break;
               case 50:
                  if (curChar == 108)
                     { jjCheckNAddTwoStates(51, 53); }
                  break;
               case 51:
                  if (curChar == 116 && kind > 114)
                     kind = 114;
                  break;
               case 52:
                  if (curChar == 101 && kind > 115)
                     kind = 115;
                  break;
               case 53:
               case 56:
                  if (curChar == 116)
                     { jjCheckNAdd(52); }
                  break;
               case 54:
                  if (curChar == 92)
                     { jjAddStates(414, 418); }
                  break;
               case 55:
                  if (curChar == 108)
                     { jjCheckNAdd(51); }
                  break;
               case 57:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 56;
                  break;
               case 58:
                  if (curChar == 116 && kind > 116)
                     kind = 116;
                  break;
               case 59:
                  if (curChar == 103)
                     { jjCheckNAdd(58); }
                  break;
               case 60:
                  if (curChar == 101 && kind > 117)
                     kind = 117;
                  break;
               case 61:
               case 91:
                  if (curChar == 116)
                     { jjCheckNAdd(60); }
                  break;
               case 62:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 61;
                  break;
               case 63:
                  if (curChar == 100 && kind > 125)
                     kind = 125;
                  break;
               case 64:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 63;
                  break;
               case 65:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 64;
                  break;
               case 68:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 69:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 68;
                  break;
               case 71:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 72:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 71;
                  break;
               case 74:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 75:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 74;
                  break;
               case 78:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 77;
                  break;
               case 79:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 78;
                  break;
               case 82:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 81;
                  break;
               case 83:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 84:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 83;
                  break;
               case 87:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 86;
                  break;
               case 88:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 87;
                  break;
               case 89:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 88;
                  break;
               case 90:
                  if (curChar == 103)
                     { jjCheckNAddTwoStates(58, 91); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(29, 30); }
                  break;
               case 92:
               case 29:
                  if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(29, 30); }
                  break;
               case 1:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(411, 413); }
                  break;
               case 8:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(408, 410); }
                  break;
               case 16:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(423, 424); }
                  break;
               case 19:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(425, 426); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 92 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_4(int pos, long active0, long active1, long active2){
   switch (pos)
   {
      case 0:
         if ((active2 & 0x8L) != 0L)
            return 2;
         if ((active1 & 0x800400000000000L) != 0L)
            return 44;
         if ((active1 & 0x400002c00000000L) != 0L)
            return 48;
         if ((active1 & 0x8000040000000000L) != 0L)
            return 42;
         if ((active1 & 0xc0000000L) != 0L || (active2 & 0xe00L) != 0L)
         {
            jjmatchedKind = 140;
            return 98;
         }
         return -1;
      case 1:
         if ((active2 & 0x600L) != 0L)
            return 98;
         if ((active1 & 0x400002800000000L) != 0L)
            return 47;
         if ((active1 & 0xc0000000L) != 0L || (active2 & 0x800L) != 0L)
         {
            if (jjmatchedPos != 1)
            {
               jjmatchedKind = 140;
               jjmatchedPos = 1;
            }
            return 98;
         }
         return -1;
      case 2:
         if ((active1 & 0xc0000000L) != 0L || (active2 & 0x800L) != 0L)
         {
            jjmatchedKind = 140;
            jjmatchedPos = 2;
            return 98;
         }
         return -1;
      case 3:
         if ((active1 & 0x80000000L) != 0L)
            return 98;
         if ((active1 & 0x40000000L) != 0L || (active2 & 0x800L) != 0L)
         {
            jjmatchedKind = 140;
            jjmatchedPos = 3;
            return 98;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_4(int pos, long active0, long active1, long active2){
   return jjMoveNfa_4(jjStopStringLiteralDfa_4(pos, active0, active1, active2), pos + 1);
}
private int jjMoveStringLiteralDfa0_4(){
   switch(curChar)
   {
      case 33:
         jjmatchedKind = 127;
         return jjMoveStringLiteralDfa1_4(0x40000000000L, 0x0L);
      case 37:
         jjmatchedKind = 124;
         return jjMoveStringLiteralDfa1_4(0x800000000000L, 0x0L);
      case 40:
         return jjStopAtPos(0, 133);
      case 41:
         return jjStopAtPos(0, 134);
      case 42:
         jjmatchedKind = 120;
         return jjMoveStringLiteralDfa1_4(0x200200000000000L, 0x0L);
      case 43:
         jjmatchedKind = 118;
         return jjMoveStringLiteralDfa1_4(0x1080000000000L, 0x0L);
      case 44:
         return jjStopAtPos(0, 128);
      case 45:
         jjmatchedKind = 119;
         return jjMoveStringLiteralDfa1_4(0x2100000000000L, 0x0L);
      case 46:
         jjmatchedKind = 98;
         return jjMoveStringLiteralDfa1_4(0x400002800000000L, 0x0L);
      case 47:
         jjmatchedKind = 123;
         return jjMoveStringLiteralDfa1_4(0x400000000000L, 0x0L);
      case 58:
         return jjStopAtPos(0, 130);
      case 59:
         return jjStopAtPos(0, 129);
      case 61:
         jjmatchedKind = 104;
         return jjMoveStringLiteralDfa1_4(0x20000000000L, 0x0L);
      case 62:
         return jjStopAtPos(0, 146);
      case 63:
         jjmatchedKind = 102;
         return jjMoveStringLiteralDfa1_4(0x8000000000L, 0x0L);
      case 91:
         return jjStartNfaWithStates_4(0, 131, 2);
      case 93:
         return jjStopAtPos(0, 132);
      case 97:
         return jjMoveStringLiteralDfa1_4(0x0L, 0x400L);
      case 102:
         return jjMoveStringLiteralDfa1_4(0x40000000L, 0x0L);
      case 105:
         return jjMoveStringLiteralDfa1_4(0x0L, 0x200L);
      case 116:
         return jjMoveStringLiteralDfa1_4(0x80000000L, 0x0L);
      case 117:
         return jjMoveStringLiteralDfa1_4(0x0L, 0x800L);
      case 123:
         return jjStopAtPos(0, 135);
      case 125:
         return jjStopAtPos(0, 136);
      default :
         return jjMoveNfa_4(1, 0);
   }
}
private int jjMoveStringLiteralDfa1_4(long active1, long active2){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_4(0, 0L, active1, active2);
      return 1;
   }
   switch(curChar)
   {
      case 42:
         if ((active1 & 0x200000000000000L) != 0L)
            return jjStopAtPos(1, 121);
         break;
      case 43:
         if ((active1 & 0x1000000000000L) != 0L)
            return jjStopAtPos(1, 112);
         break;
      case 45:
         if ((active1 & 0x2000000000000L) != 0L)
            return jjStopAtPos(1, 113);
         break;
      case 46:
         if ((active1 & 0x800000000L) != 0L)
         {
            jjmatchedKind = 99;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_4(active1, 0x400002000000000L, active2, 0L);
      case 61:
         if ((active1 & 0x20000000000L) != 0L)
            return jjStopAtPos(1, 105);
         else if ((active1 & 0x40000000000L) != 0L)
            return jjStopAtPos(1, 106);
         else if ((active1 & 0x80000000000L) != 0L)
            return jjStopAtPos(1, 107);
         else if ((active1 & 0x100000000000L) != 0L)
            return jjStopAtPos(1, 108);
         else if ((active1 & 0x200000000000L) != 0L)
            return jjStopAtPos(1, 109);
         else if ((active1 & 0x400000000000L) != 0L)
            return jjStopAtPos(1, 110);
         else if ((active1 & 0x800000000000L) != 0L)
            return jjStopAtPos(1, 111);
         break;
      case 63:
         if ((active1 & 0x8000000000L) != 0L)
            return jjStopAtPos(1, 103);
         break;
      case 97:
         return jjMoveStringLiteralDfa2_4(active1, 0x40000000L, active2, 0L);
      case 110:
         if ((active2 & 0x200L) != 0L)
            return jjStartNfaWithStates_4(1, 137, 98);
         break;
      case 114:
         return jjMoveStringLiteralDfa2_4(active1, 0x80000000L, active2, 0L);
      case 115:
         if ((active2 & 0x400L) != 0L)
            return jjStartNfaWithStates_4(1, 138, 98);
         return jjMoveStringLiteralDfa2_4(active1, 0L, active2, 0x800L);
      default :
         break;
   }
   return jjStartNfa_4(0, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa2_4(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_4(0, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_4(1, 0L, active1, active2);
      return 2;
   }
   switch(curChar)
   {
      case 42:
         if ((active1 & 0x2000000000L) != 0L)
            return jjStopAtPos(2, 101);
         break;
      case 46:
         if ((active1 & 0x400000000000000L) != 0L)
            return jjStopAtPos(2, 122);
         break;
      case 105:
         return jjMoveStringLiteralDfa3_4(active1, 0L, active2, 0x800L);
      case 108:
         return jjMoveStringLiteralDfa3_4(active1, 0x40000000L, active2, 0L);
      case 117:
         return jjMoveStringLiteralDfa3_4(active1, 0x80000000L, active2, 0L);
      default :
         break;
   }
   return jjStartNfa_4(1, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa3_4(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_4(1, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_4(2, 0L, active1, active2);
      return 3;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x80000000L) != 0L)
            return jjStartNfaWithStates_4(3, 95, 98);
         break;
      case 110:
         return jjMoveStringLiteralDfa4_4(active1, 0L, active2, 0x800L);
      case 115:
         return jjMoveStringLiteralDfa4_4(active1, 0x40000000L, active2, 0L);
      default :
         break;
   }
   return jjStartNfa_4(2, 0L, active1, active2);
}
private int jjMoveStringLiteralDfa4_4(long old1, long active1, long old2, long active2){
   if (((active1 &= old1) | (active2 &= old2)) == 0L)
      return jjStartNfa_4(2, 0L, old1, old2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_4(3, 0L, active1, active2);
      return 4;
   }
   switch(curChar)
   {
      case 101:
         if ((active1 & 0x40000000L) != 0L)
            return jjStartNfaWithStates_4(4, 94, 98);
         break;
      case 103:
         if ((active2 & 0x800L) != 0L)
            return jjStartNfaWithStates_4(4, 139, 98);
         break;
      default :
         break;
   }
   return jjStartNfa_4(3, 0L, active1, active2);
}
private int jjStartNfaWithStates_4(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_4(state, pos + 1);
}
private int jjMoveNfa_4(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 98;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 47:
                  if (curChar == 33)
                  {
                     if (kind > 100)
                        kind = 100;
                  }
                  else if (curChar == 60)
                  {
                     if (kind > 100)
                        kind = 100;
                  }
                  break;
               case 1:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 96)
                        kind = 96;
                     { jjCheckNAddStates(427, 429); }
                  }
                  else if ((0x100002600L & l) != 0L)
                  {
                     if (kind > 84)
                        kind = 84;
                     { jjCheckNAdd(0); }
                  }
                  else if (curChar == 38)
                     { jjAddStates(430, 435); }
                  else if (curChar == 46)
                     { jjAddStates(436, 437); }
                  else if (curChar == 47)
                     { jjAddStates(438, 439); }
                  else if (curChar == 33)
                     { jjCheckNAdd(42); }
                  else if (curChar == 35)
                     { jjCheckNAdd(38); }
                  else if (curChar == 36)
                     { jjCheckNAdd(38); }
                  else if (curChar == 60)
                     { jjCheckNAdd(27); }
                  else if (curChar == 39)
                     { jjCheckNAddStates(356, 358); }
                  else if (curChar == 34)
                     { jjCheckNAddStates(359, 361); }
                  if (curChar == 36)
                  {
                     if (kind > 140)
                        kind = 140;
                     { jjCheckNAddTwoStates(34, 35); }
                  }
                  else if (curChar == 38)
                  {
                     if (kind > 125)
                        kind = 125;
                  }
                  else if (curChar == 60)
                  {
                     if (kind > 114)
                        kind = 114;
                  }
                  if (curChar == 60)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 98:
               case 34:
                  if ((0x3ff001000000000L & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 48:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 49;
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 44:
                  if (curChar == 62 && kind > 147)
                     kind = 147;
                  break;
               case 0:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 84)
                     kind = 84;
                  { jjCheckNAdd(0); }
                  break;
               case 2:
                  if ((0xa00000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 3:
                  if (curChar == 45 && kind > 85)
                     kind = 85;
                  break;
               case 4:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 3;
                  break;
               case 5:
                  if (curChar == 34)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 6:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 9:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 10:
                  if (curChar == 34 && kind > 92)
                     kind = 92;
                  break;
               case 11:
                  if ((0x9400000000L & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 12:
                  if (curChar == 39)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 13:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 16:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 17:
                  if (curChar == 39 && kind > 92)
                     kind = 92;
                  break;
               case 18:
                  if ((0x9400000000L & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 20:
                  if (curChar == 34)
                     { jjCheckNAddTwoStates(21, 22); }
                  break;
               case 21:
                  if ((0xfffffffbffffffffL & l) != 0L)
                     { jjCheckNAddTwoStates(21, 22); }
                  break;
               case 22:
                  if (curChar == 34 && kind > 93)
                     kind = 93;
                  break;
               case 23:
                  if (curChar == 39)
                     { jjCheckNAddTwoStates(24, 25); }
                  break;
               case 24:
                  if ((0xffffff7fffffffffL & l) != 0L)
                     { jjCheckNAddTwoStates(24, 25); }
                  break;
               case 25:
                  if (curChar == 39 && kind > 93)
                     kind = 93;
                  break;
               case 26:
                  if (curChar == 60 && kind > 114)
                     kind = 114;
                  break;
               case 27:
                  if (curChar == 61 && kind > 115)
                     kind = 115;
                  break;
               case 28:
                  if (curChar == 60)
                     { jjCheckNAdd(27); }
                  break;
               case 29:
               case 86:
                  if (curChar == 38 && kind > 125)
                     kind = 125;
                  break;
               case 33:
                  if (curChar != 36)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 36:
                  if ((0x400600000000000L & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 39:
                  if (curChar == 36)
                     { jjCheckNAdd(38); }
                  break;
               case 40:
                  if (curChar == 35)
                     { jjCheckNAdd(38); }
                  break;
               case 41:
                  if (curChar == 33)
                     { jjCheckNAdd(42); }
                  break;
               case 42:
                  if ((0x100002600L & l) == 0L)
                     break;
                  if (kind > 151)
                     kind = 151;
                  { jjCheckNAdd(42); }
                  break;
               case 43:
                  if (curChar == 47)
                     { jjAddStates(438, 439); }
                  break;
               case 46:
                  if (curChar == 46)
                     { jjAddStates(436, 437); }
                  break;
               case 49:
                  if (curChar == 33 && kind > 100)
                     kind = 100;
                  break;
               case 50:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 49;
                  break;
               case 51:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 96)
                     kind = 96;
                  { jjCheckNAddStates(427, 429); }
                  break;
               case 52:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 96)
                     kind = 96;
                  { jjCheckNAdd(52); }
                  break;
               case 53:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(53, 54); }
                  break;
               case 54:
                  if (curChar == 46)
                     { jjCheckNAdd(55); }
                  break;
               case 55:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 97)
                     kind = 97;
                  { jjCheckNAdd(55); }
                  break;
               case 72:
                  if (curChar == 38)
                     { jjAddStates(430, 435); }
                  break;
               case 73:
                  if (curChar == 59 && kind > 114)
                     kind = 114;
                  break;
               case 76:
                  if (curChar == 59)
                     { jjCheckNAdd(27); }
                  break;
               case 79:
                  if (curChar == 59 && kind > 116)
                     kind = 116;
                  break;
               case 82:
                  if (curChar == 61 && kind > 117)
                     kind = 117;
                  break;
               case 83:
                  if (curChar == 59)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 87:
                  if (curChar == 59 && kind > 125)
                     kind = 125;
                  break;
               case 91:
                  if (curChar == 38)
                     jjstateSet[jjnewStateCnt++] = 90;
                  break;
               case 92:
                  if (curChar == 59)
                     jjstateSet[jjnewStateCnt++] = 91;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 1:
                  if ((0x7fffffe87ffffffL & l) != 0L)
                  {
                     if (kind > 140)
                        kind = 140;
                     { jjCheckNAddTwoStates(34, 35); }
                  }
                  else if (curChar == 92)
                     { jjAddStates(440, 444); }
                  else if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 31;
                  else if (curChar == 91)
                     jjstateSet[jjnewStateCnt++] = 2;
                  if (curChar == 103)
                     { jjCheckNAddTwoStates(64, 97); }
                  else if (curChar == 108)
                     { jjCheckNAddTwoStates(57, 59); }
                  else if (curChar == 92)
                     { jjCheckNAdd(36); }
                  else if (curChar == 124)
                  {
                     if (kind > 126)
                        kind = 126;
                  }
                  else if (curChar == 114)
                     { jjAddStates(367, 368); }
                  break;
               case 98:
                  if ((0x7fffffe87ffffffL & l) != 0L)
                  {
                     if (kind > 140)
                        kind = 140;
                     { jjCheckNAddTwoStates(34, 35); }
                  }
                  else if (curChar == 92)
                     { jjCheckNAdd(36); }
                  break;
               case 44:
                  if (curChar == 93 && kind > 147)
                     kind = 147;
                  break;
               case 6:
                  if ((0xffffffffefffffffL & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 7:
                  if (curChar == 92)
                     { jjAddStates(369, 370); }
                  break;
               case 8:
                  if (curChar == 120)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 9:
                  if ((0x7e0000007eL & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 11:
                  if ((0x81450c610000000L & l) != 0L)
                     { jjCheckNAddStates(359, 361); }
                  break;
               case 13:
                  if ((0xffffffffefffffffL & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 14:
                  if (curChar == 92)
                     { jjAddStates(371, 372); }
                  break;
               case 15:
                  if (curChar == 120)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 16:
                  if ((0x7e0000007eL & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 18:
                  if ((0x81450c610000000L & l) != 0L)
                     { jjCheckNAddStates(356, 358); }
                  break;
               case 19:
                  if (curChar == 114)
                     { jjAddStates(367, 368); }
                  break;
               case 21:
                  { jjAddStates(373, 374); }
                  break;
               case 24:
                  { jjAddStates(375, 376); }
                  break;
               case 30:
               case 31:
                  if (curChar == 124 && kind > 126)
                     kind = 126;
                  break;
               case 32:
                  if (curChar == 124)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 33:
                  if ((0x7fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 34:
                  if ((0x7fffffe87ffffffL & l) == 0L)
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 35:
                  if (curChar == 92)
                     { jjCheckNAdd(36); }
                  break;
               case 37:
                  if (curChar == 92)
                     { jjCheckNAdd(36); }
                  break;
               case 38:
                  if (curChar == 123 && kind > 141)
                     kind = 141;
                  break;
               case 56:
                  if (curChar == 108)
                     { jjCheckNAddTwoStates(57, 59); }
                  break;
               case 57:
                  if (curChar == 116 && kind > 114)
                     kind = 114;
                  break;
               case 58:
                  if (curChar == 101 && kind > 115)
                     kind = 115;
                  break;
               case 59:
               case 62:
                  if (curChar == 116)
                     { jjCheckNAdd(58); }
                  break;
               case 60:
                  if (curChar == 92)
                     { jjAddStates(440, 444); }
                  break;
               case 61:
                  if (curChar == 108)
                     { jjCheckNAdd(57); }
                  break;
               case 63:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 64:
                  if (curChar == 116 && kind > 116)
                     kind = 116;
                  break;
               case 65:
                  if (curChar == 103)
                     { jjCheckNAdd(64); }
                  break;
               case 66:
                  if (curChar == 101 && kind > 117)
                     kind = 117;
                  break;
               case 67:
               case 97:
                  if (curChar == 116)
                     { jjCheckNAdd(66); }
                  break;
               case 68:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 69:
                  if (curChar == 100 && kind > 125)
                     kind = 125;
                  break;
               case 70:
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 69;
                  break;
               case 71:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 74:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 75:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 74;
                  break;
               case 77:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 76;
                  break;
               case 78:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 77;
                  break;
               case 80:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 81:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 80;
                  break;
               case 84:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 83;
                  break;
               case 85:
                  if (curChar == 103)
                     jjstateSet[jjnewStateCnt++] = 84;
                  break;
               case 88:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 87;
                  break;
               case 89:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 88;
                  break;
               case 90:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 89;
                  break;
               case 93:
                  if (curChar == 112)
                     jjstateSet[jjnewStateCnt++] = 92;
                  break;
               case 94:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 93;
                  break;
               case 95:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 94;
                  break;
               case 96:
                  if (curChar == 103)
                     { jjCheckNAddTwoStates(64, 97); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 1:
                  if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 98:
               case 34:
                  if (!jjCanMove_1(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 140)
                     kind = 140;
                  { jjCheckNAddTwoStates(34, 35); }
                  break;
               case 6:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(359, 361); }
                  break;
               case 13:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(356, 358); }
                  break;
               case 21:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(373, 374); }
                  break;
               case 24:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjAddStates(375, 376); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 98 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
static final int[] jjnextStates = {
   10, 12, 4, 5, 3, 4, 5, 697, 712, 369, 370, 371, 372, 373, 374, 375, 
   376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 
   392, 393, 394, 395, 396, 397, 398, 404, 405, 413, 414, 423, 424, 431, 432, 443, 
   444, 455, 456, 467, 468, 477, 478, 488, 489, 499, 500, 512, 513, 522, 523, 539, 
   540, 551, 552, 570, 571, 583, 584, 597, 598, 608, 609, 610, 611, 612, 613, 614, 
   615, 616, 617, 618, 619, 620, 621, 622, 623, 624, 625, 626, 636, 637, 638, 650, 
   651, 656, 662, 663, 665, 12, 21, 24, 31, 36, 45, 50, 58, 65, 70, 77, 
   84, 90, 98, 105, 114, 120, 130, 136, 141, 148, 153, 161, 174, 183, 199, 209, 
   218, 227, 234, 242, 253, 262, 269, 277, 278, 286, 291, 296, 305, 314, 321, 331, 
   339, 350, 357, 367, 5, 6, 14, 15, 38, 41, 47, 48, 178, 179, 187, 188, 
   201, 202, 211, 212, 222, 223, 229, 230, 231, 236, 237, 238, 244, 245, 246, 255, 
   256, 257, 264, 265, 266, 271, 272, 273, 279, 280, 281, 283, 284, 285, 288, 289, 
   290, 293, 294, 295, 298, 299, 307, 308, 309, 323, 324, 325, 341, 342, 343, 361, 
   362, 400, 401, 407, 408, 416, 417, 426, 427, 434, 435, 446, 447, 460, 461, 470, 
   471, 480, 481, 491, 492, 502, 503, 515, 516, 527, 528, 544, 545, 556, 557, 573, 
   574, 586, 587, 600, 601, 628, 629, 642, 643, 700, 701, 703, 708, 709, 704, 710, 
   703, 705, 706, 708, 709, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 
   380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 
   396, 397, 667, 668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678, 679, 680, 
   681, 682, 683, 684, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 
   621, 622, 623, 624, 625, 685, 637, 686, 651, 689, 692, 663, 693, 193, 198, 562, 
   567, 658, 659, 699, 711, 708, 709, 50, 51, 52, 73, 76, 79, 83, 84, 93, 
   46, 48, 42, 43, 13, 14, 17, 6, 7, 10, 59, 61, 63, 66, 69, 20, 
   23, 8, 11, 15, 18, 21, 22, 24, 25, 47, 48, 49, 70, 73, 76, 80, 
   81, 90, 43, 45, 56, 58, 60, 63, 66, 3, 5, 46, 47, 48, 69, 72, 
   75, 79, 80, 89, 42, 44, 38, 39, 8, 9, 12, 1, 2, 5, 55, 57, 
   59, 62, 65, 3, 6, 10, 13, 16, 17, 19, 20, 52, 53, 54, 75, 78, 
   81, 85, 86, 95, 48, 50, 44, 45, 61, 63, 65, 68, 71, 
};
private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec2[i2] & l2) != 0L);
      default :
         if ((jjbitVec0[i1] & l1) != 0L)
            return true;
         return false;
   }
}
private static final boolean jjCanMove_1(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec4[i2] & l2) != 0L);
      case 32:
         return ((jjbitVec5[i2] & l2) != 0L);
      case 33:
         return ((jjbitVec6[i2] & l2) != 0L);
      case 44:
         return ((jjbitVec7[i2] & l2) != 0L);
      case 45:
         return ((jjbitVec8[i2] & l2) != 0L);
      case 46:
         return ((jjbitVec9[i2] & l2) != 0L);
      case 48:
         return ((jjbitVec10[i2] & l2) != 0L);
      case 49:
         return ((jjbitVec11[i2] & l2) != 0L);
      case 51:
         return ((jjbitVec12[i2] & l2) != 0L);
      case 77:
         return ((jjbitVec13[i2] & l2) != 0L);
      case 164:
         return ((jjbitVec14[i2] & l2) != 0L);
      case 166:
         return ((jjbitVec15[i2] & l2) != 0L);
      case 167:
         return ((jjbitVec16[i2] & l2) != 0L);
      case 168:
         return ((jjbitVec17[i2] & l2) != 0L);
      case 169:
         return ((jjbitVec18[i2] & l2) != 0L);
      case 170:
         return ((jjbitVec19[i2] & l2) != 0L);
      case 171:
         return ((jjbitVec20[i2] & l2) != 0L);
      case 215:
         return ((jjbitVec21[i2] & l2) != 0L);
      case 251:
         return ((jjbitVec22[i2] & l2) != 0L);
      case 253:
         return ((jjbitVec23[i2] & l2) != 0L);
      case 254:
         return ((jjbitVec24[i2] & l2) != 0L);
      case 255:
         return ((jjbitVec25[i2] & l2) != 0L);
      default :
         if ((jjbitVec3[i1] & l1) != 0L)
            return true;
         return false;
   }
}

/** Token literal values. */
public static final String[] jjstrLiteralImages = {
"", null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, 
"\44\173", "\43\173", null, null, null, null, null, null, null, null, null, null, 
"\146\141\154\163\145", "\164\162\165\145", null, null, "\56", "\56\56", null, "\56\56\52", "\77", 
"\77\77", "\75", "\75\75", "\41\75", "\53\75", "\55\75", "\52\75", "\57\75", "\45\75", 
"\53\53", "\55\55", null, null, null, null, "\53", "\55", "\52", "\52\52", "\56\56\56", 
"\57", "\45", null, null, "\41", "\54", "\73", "\72", "\133", "\135", "\50", "\51", 
"\173", "\175", "\151\156", "\141\163", "\165\163\151\156\147", null, null, null, null, 
null, null, "\76", null, "\76", "\76\75", null, null, null, null, null, null, };
protected Token jjFillToken()
{
   final Token t;
   final String curTokenImage;
   final int beginLine;
   final int endLine;
   final int beginColumn;
   final int endColumn;
   String im = jjstrLiteralImages[jjmatchedKind];
   curTokenImage = (im == null) ? input_stream.GetImage() : im;
   beginLine = input_stream.getBeginLine();
   beginColumn = input_stream.getBeginColumn();
   endLine = input_stream.getEndLine();
   endColumn = input_stream.getEndColumn();
   t = Token.newToken(jjmatchedKind, curTokenImage);

   t.beginLine = beginLine;
   t.endLine = endLine;
   t.beginColumn = beginColumn;
   t.endColumn = endColumn;

   return t;
}

int curLexState = 0;
int defaultLexState = 0;
int jjnewStateCnt;
int jjround;
int jjmatchedPos;
int jjmatchedKind;

/** Get the next Token. */
public Token getNextToken() 
{
  Token matchedToken;
  int curPos = 0;

  EOFLoop :
  for (;;)
  {
   try
   {
      curChar = input_stream.BeginToken();
   }
   catch(Exception e)
   {
      jjmatchedKind = 0;
      jjmatchedPos = -1;
      matchedToken = jjFillToken();
      return matchedToken;
   }
   image = jjimage;
   image.setLength(0);
   jjimageLen = 0;

   switch(curLexState)
   {
     case 0:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_0();
       break;
     case 1:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_1();
       break;
     case 2:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_2();
       break;
     case 3:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_3();
       break;
     case 4:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_4();
       break;
     case 5:
       try { input_stream.backup(0);
          while ((curChar < 64 && (0x4000000000000000L & (1L << curChar)) != 0L) || 
                 (curChar >> 6) == 1 && (0x20000000L & (1L << (curChar & 077))) != 0L)
             curChar = input_stream.BeginToken();
       }
       catch (java.io.IOException e1) { continue EOFLoop; }
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_5();
       break;
     case 6:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_6();
       break;
     case 7:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_7();
       break;
   }
     if (jjmatchedKind != 0x7fffffff)
     {
        if (jjmatchedPos + 1 < curPos)
           input_stream.backup(curPos - jjmatchedPos - 1);
        if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           matchedToken = jjFillToken();
           TokenLexicalActions(matchedToken);
       if (jjnewLexState[jjmatchedKind] != -1)
         curLexState = jjnewLexState[jjmatchedKind];
           return matchedToken;
        }
        else
        {
           SkipLexicalActions(null);
         if (jjnewLexState[jjmatchedKind] != -1)
           curLexState = jjnewLexState[jjmatchedKind];
           continue EOFLoop;
        }
     }
     int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try { input_stream.readChar(); input_stream.backup(1); }
     catch (java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
     }
     throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
  }
}

void SkipLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 90 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        if (parenthesisNesting > 0) SwitchTo(IN_PAREN);
        else if (inInvocation) SwitchTo(NAMED_PARAMETER_EXPRESSION);
        else SwitchTo(FM_EXPRESSION);
         break;
      default :
         break;
   }
}
void TokenLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 6 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                     strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 7 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                     strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 8 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                      strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 9 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        strictSyntaxCheck(matchedToken, getTagNamingConvention(matchedToken, 4), FM_EXPRESSION);
         break;
      case 10 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                          strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 11 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                            strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 13 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        strictSyntaxCheck(matchedToken, getTagNamingConvention(matchedToken, 3), FM_EXPRESSION);
         break;
      case 14 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                              strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 15 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                          strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 16 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                              strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 17 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                    strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 18 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                  strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 19 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                 strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 20 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                              strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 21 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                  strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 22 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                            strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 23 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                    strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 24 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                            strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 25 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                          strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 26 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                              strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 27 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                          strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 28 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 29 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        strictSyntaxCheck(matchedToken, getTagNamingConvention(matchedToken, 6), FM_EXPRESSION);
         break;
      case 30 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        strictSyntaxCheck(matchedToken, getTagNamingConvention(matchedToken, 4), DEFAULT);
         break;
      case 31 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        strictSyntaxCheck(matchedToken, getTagNamingConvention(matchedToken, 2), DEFAULT);
         break;
      case 32 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                       strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 33 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        strictSyntaxCheck(matchedToken, NO_PARSE); noparseTag = "comment";
         break;
      case 34 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                           noparseTag = "-->"; strictSyntaxCheck(matchedToken, NO_PARSE);
         break;
      case 35 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        int tagNamingConvention = getTagNamingConvention(matchedToken, 2);
        strictSyntaxCheck(matchedToken, tagNamingConvention, NO_PARSE);
        noparseTag = tagNamingConvention == Configuration.CAMEL_CASE_NAMING_CONVENTION ? "noParse" : "noparse";
         break;
      case 36 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                             strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 37 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                 strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 38 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                   strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 39 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                               strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 40 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                       strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 41 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                       strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 42 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        strictSyntaxCheck(matchedToken, getTagNamingConvention(matchedToken, 3), DEFAULT);
         break;
      case 43 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                   strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 44 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                     strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 45 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                     strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 46 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                         strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 47 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                   strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 48 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        strictSyntaxCheck(matchedToken, getTagNamingConvention(matchedToken, 6), DEFAULT);
         break;
      case 49 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        strictSyntaxCheck(matchedToken, getTagNamingConvention(matchedToken, 4), DEFAULT);
         break;
      case 50 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        strictSyntaxCheck(matchedToken, getTagNamingConvention(matchedToken, 2), DEFAULT);
         break;
      case 51 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                         strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 52 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                           strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 53 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                     strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 54 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                               strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 55 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                 strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 56 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                       strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 57 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                          strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 58 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                               strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 59 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                 strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 60 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                            strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 61 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                              strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 62 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                              strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 63 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                               strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 64 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                    strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 65 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                          strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 66 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                              strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 67 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                            strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 68 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 69 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                       strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 70 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                              strictSyntaxCheck(matchedToken, FM_EXPRESSION);
         break;
      case 71 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                     strictSyntaxCheck(matchedToken, DEFAULT);
         break;
      case 72 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        strictSyntaxCheck(matchedToken, getTagNamingConvention(matchedToken, 2), DEFAULT);
         break;
      case 73 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        strictSyntaxCheck(matchedToken, getTagNamingConvention(matchedToken, 2), DEFAULT);
         break;
      case 74 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                    unifiedCall(matchedToken);
         break;
      case 75 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                                              unifiedCallEnd(matchedToken);
         break;
      case 76 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                 ftlHeader(matchedToken);
         break;
      case 77 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                                    ftlHeader(matchedToken);
         break;
      case 78 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        if (!directiveSyntaxEstablished && incompatibleImprovements < _TemplateAPI.VERSION_INT_2_3_19) {
            matchedToken.kind = STATIC_TEXT_NON_WS;
        } else {
            char firstChar = matchedToken.image.charAt(0);

            if (!directiveSyntaxEstablished && autodetectTagSyntax) {
                squBracTagSyntax = (firstChar == '[');
                directiveSyntaxEstablished = true;
            }

            if (firstChar == '<' && squBracTagSyntax) {
                matchedToken.kind = STATIC_TEXT_NON_WS;
            } else if (firstChar == '[' && !squBracTagSyntax) {
                matchedToken.kind = STATIC_TEXT_NON_WS;
            } else if (strictEscapeSyntax) {
                String dn = matchedToken.image;
                int index = dn.indexOf('#');
                dn = dn.substring(index + 1);

                // Until the tokenizer/parser is reworked, we have this quirk where something like <#list>
                // doesn't match any directive starter tokens, because that token requires whitespace after the
                // name as it should be followed by parameters. For now we work this around so we don't report
                // unknown directive:
                if (_CoreAPI.ALL_BUILT_IN_DIRECTIVE_NAMES.contains(dn)) {
                    throw new TokenMgrError(
                            "#" + dn + " is an existing directive, but the tag is malformed. "
                            + " (See FreeMarker Manual / Directive Reference.)",
                            TokenMgrError.LEXICAL_ERROR,
                            matchedToken.beginLine, matchedToken.beginColumn + 1,
                            matchedToken.endLine, matchedToken.endColumn);
                }

                String tip = null;
                if (dn.equals("set") || dn.equals("var")) {
                    tip = "Use #assign or #local or #global, depending on the intented scope "
                          + "(#assign is template-scope). " + PLANNED_DIRECTIVE_HINT;
                } else if (dn.equals("else_if") || dn.equals("elif")) {
                        tip = "Use #elseif.";
                } else if (dn.equals("no_escape")) {
                        tip = "Use #noescape instead.";
                } else if (dn.equals("method")) {
                        tip = "Use #function instead.";
                } else if (dn.equals("head") || dn.equals("template") || dn.equals("fm")) {
                        tip = "You may meant #ftl.";
                } else if (dn.equals("try") || dn.equals("atempt")) {
                        tip = "You may meant #attempt.";
                } else if (dn.equals("for") || dn.equals("each") || dn.equals("iterate") || dn.equals("iterator")) {
                    tip = "You may meant #list (http://freemarker.org/docs/ref_directive_list.html).";
                } else if (dn.equals("prefix")) {
                    tip = "You may meant #import. " + PLANNED_DIRECTIVE_HINT;
                } else if (dn.equals("item") || dn.equals("row") || dn.equals("rows")) {
                    tip = "You may meant #items.";
                } else if (dn.equals("separator") || dn.equals("separate") || dn.equals("separ")) {
                    tip = "You may meant #sep.";
                } else {
                    tip = "Help (latest version): http://freemarker.org/docs/ref_directive_alphaidx.html; "
                            + "you're using FreeMarker " + Configuration.getVersion() + ".";
                }
                throw new TokenMgrError(
                        "Unknown directive: #" + dn + (tip != null ? ". " + tip : ""),
                        TokenMgrError.LEXICAL_ERROR,
                        matchedToken.beginLine, matchedToken.beginColumn + 1,
                        matchedToken.endLine, matchedToken.endColumn);
            }
        }
         break;
      case 82 :
        image.append(jjstrLiteralImages[82]);
        lengthOfMatch = jjstrLiteralImages[82].length();
                                            startInterpolation(matchedToken);
         break;
      case 83 :
        image.append(jjstrLiteralImages[83]);
        lengthOfMatch = jjstrLiteralImages[83].length();
                                          startInterpolation(matchedToken);
         break;
      case 131 :
        image.append(jjstrLiteralImages[131]);
        lengthOfMatch = jjstrLiteralImages[131].length();
        ++bracketNesting;
         break;
      case 132 :
        image.append(jjstrLiteralImages[132]);
        lengthOfMatch = jjstrLiteralImages[132].length();
        closeBracket(matchedToken);
         break;
      case 133 :
        image.append(jjstrLiteralImages[133]);
        lengthOfMatch = jjstrLiteralImages[133].length();
        ++parenthesisNesting;
        if (parenthesisNesting == 1) SwitchTo(IN_PAREN);
         break;
      case 134 :
        image.append(jjstrLiteralImages[134]);
        lengthOfMatch = jjstrLiteralImages[134].length();
        --parenthesisNesting;
        if (parenthesisNesting == 0) {
            if (inInvocation) SwitchTo(NAMED_PARAMETER_EXPRESSION);
            else SwitchTo(FM_EXPRESSION);
        }
         break;
      case 135 :
        image.append(jjstrLiteralImages[135]);
        lengthOfMatch = jjstrLiteralImages[135].length();
        ++hashLiteralNesting;
         break;
      case 136 :
        image.append(jjstrLiteralImages[136]);
        lengthOfMatch = jjstrLiteralImages[136].length();
        if (hashLiteralNesting == 0) endInterpolation(matchedToken);
        else --hashLiteralNesting;
         break;
      case 140 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        // Remove backslashes from Token.image:
        final String s = matchedToken.image;
        if (s.indexOf('\\') != -1) {
            final int srcLn = s.length();
            final char[] newS = new char[srcLn - 1];
            int dstIdx = 0;
            for (int srcIdx = 0; srcIdx < srcLn; srcIdx++) {
                final char c = s.charAt(srcIdx);
                if (c != '\\') {
                    newS[dstIdx++] = c;
                }
            }
            matchedToken.image = new String(newS, 0, dstIdx);
        }
         break;
      case 141 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        if ("".length() == 0) {  // prevents unreachabe "break" compilation error in generated Java
            char c = matchedToken.image.charAt(0);
            throw new TokenMgrError(
                    "You can't use \"" + c + "{\" here as you are already in FreeMarker-expression-mode. Thus, instead "
                    + "of " + c + "{myExpression}, just write myExpression. "
                    + "(" + c + "{...} is only needed where otherwise static text is expected, i.e, outside "
                    + "FreeMarker tags and ${...}-s.)",
                    TokenMgrError.LEXICAL_ERROR,
                    matchedToken.beginLine, matchedToken.beginColumn,
                    matchedToken.endLine, matchedToken.endColumn);
        }
         break;
      case 146 :
        image.append(jjstrLiteralImages[146]);
        lengthOfMatch = jjstrLiteralImages[146].length();
        if (inFTLHeader) eatNewline();
        inFTLHeader = false;
        if (squBracTagSyntax) {
            matchedToken.kind = NATURAL_GT;
        } else {
            SwitchTo(DEFAULT);
        }
         break;
      case 147 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        if (inFTLHeader) eatNewline();
        inFTLHeader = false;
        SwitchTo(DEFAULT);
         break;
      case 152 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        if (noparseTag.equals("-->")) {
            boolean squareBracket = matchedToken.image.endsWith("]");
            if ((squBracTagSyntax && squareBracket) || (!squBracTagSyntax && !squareBracket)) {
                matchedToken.image = matchedToken.image + ";";
                SwitchTo(DEFAULT);
            }
        }
         break;
      case 153 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        StringTokenizer st = new StringTokenizer(image.toString(), " \t\n\r<>[]/#", false);
        if (st.nextToken().equals(noparseTag)) {
            matchedToken.image = matchedToken.image + ";";
            SwitchTo(DEFAULT);
        }
         break;
      default :
         break;
   }
}
private void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
private void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
private void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}

private void jjCheckNAddStates(int start, int end)
{
   do {
      jjCheckNAdd(jjnextStates[start]);
   } while (start++ != end);
}

    /** Constructor. */
    public FMParserTokenManager(SimpleCharStream stream){

      if (SimpleCharStream.staticFlag)
            throw new Error("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");

    input_stream = stream;
  }

  /** Constructor. */
  public FMParserTokenManager (SimpleCharStream stream, int lexState){
    ReInit(stream);
    SwitchTo(lexState);
  }

  /** Reinitialise parser. */
  public void ReInit(SimpleCharStream stream)
  {
	
    jjmatchedPos = jjnewStateCnt = 0;
    curLexState = defaultLexState;
    input_stream = stream;
    ReInitRounds();
  }

  private void ReInitRounds()
  {
    int i;
    jjround = 0x80000001;
    for (i = 713; i-- > 0;)
      jjrounds[i] = 0x80000000;
  }

  /** Reinitialise parser. */
  public void ReInit( SimpleCharStream stream, int lexState)
  {
  
    ReInit( stream);
    SwitchTo(lexState);
  }

  /** Switch to specified lex state. */
  public void SwitchTo(int lexState)
  {
    if (lexState >= 8 || lexState < 0)
      throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
    else
      curLexState = lexState;
  }

/** Lexer state names. */
public static final String[] lexStateNames = {
   "DEFAULT",
   "NODIRECTIVE",
   "FM_EXPRESSION",
   "IN_PAREN",
   "NAMED_PARAMETER_EXPRESSION",
   "EXPRESSION_COMMENT",
   "NO_SPACE_EXPRESSION",
   "NO_PARSE",
};

/** Lex State array. */
public static final int[] jjnewLexState = {
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   2, 2, -1, -1, -1, -1, 
};
static final long[] jjtoToken = {
   0xffffffffffffffc1L, 0xfffffffff00fffffL, 0xffc3fffL, 
};
static final long[] jjtoSkip = {
   0x0L, 0x7f00000L, 0x0L, 
};
    protected SimpleCharStream  input_stream;

    private final int[] jjrounds = new int[713];
    private final int[] jjstateSet = new int[2 * 713];

    private final StringBuilder jjimage = new StringBuilder();
    private StringBuilder image = jjimage;
    private int jjimageLen;
    private int lengthOfMatch;
    
    protected int curChar;
}
