/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.bento.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.friendularity.bundle.bento.gui.BentoLauncher;
import org.friendularity.bundle.bento.gui.CameraViewer;
import org.friendularity.bundle.bento.gui.ItsBentoBoxesNotBentoTetrisException;
import org.friendularity.bundle.bento.gui.MergeGrid;

public class BentoFrame
extends JFrame {
    private static final String DEFAULT_TITLE = "Bento";
    private static int unusedTitleInt = 0;
    private MergeGrid myGrid;

    private static String getUnusedTitle() {
        if (unusedTitleInt == 0) {
            unusedTitleInt = 1;
            return DEFAULT_TITLE;
        }
        return DEFAULT_TITLE + unusedTitleInt++;
    }

    public BentoFrame() throws HeadlessException {
        this.initialize(BentoFrame.getUnusedTitle());
    }

    public BentoFrame(GraphicsConfiguration gc) {
        super(gc);
        this.initialize(BentoFrame.getUnusedTitle());
    }

    public BentoFrame(String title) throws HeadlessException {
        super(title);
        this.initialize(title);
    }

    public BentoFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.initialize(title);
    }

    private void initialize(String title) {
        this.setTitle(title);
        this.setMinimumSize(new Dimension(320, 240));
        this.myGrid = new MergeGrid();
        this.getContentPane().add((Component)this.myGrid, "Center");
        CameraViewer cv = new CameraViewer();
        this.myGrid.addColumn(0, cv.getPreferredSize().width);
        this.myGrid.addRow(0, cv.getPreferredSize().height);
        try {
            this.myGrid.setCell(cv, 0, 0, 1, 1);
        }
        catch (ItsBentoBoxesNotBentoTetrisException ex) {
            Logger.getLogger(BentoFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setupMenus();
        this.pack();
        this.setVisible(true);
        BentoLauncher.getDefaultLauncher().addWindow(this);
    }

    private void setupMenus() {
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menu.getAccessibleContext().setAccessibleDescription("file");
        bar.add(menu);
        JMenuItem item = new JMenuItem("New", 78);
        item.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        item.getAccessibleContext().setAccessibleDescription("New Bento Window");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BentoFrame bf = new BentoFrame(BentoFrame.getUnusedTitle());
            }
        });
        menu.add(item);
        item = new JMenuItem("Open", 79);
        item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        item.getAccessibleContext().setAccessibleDescription("New Bento Window");
        menu.add(item);
        this.setJMenuBar(bar);
    }
}

