/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.bento.gui;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import org.appdapter.core.log.BasicDebugger;
import org.friendularity.bundle.bento.engine.Quitter;
import org.friendularity.bundle.bento.gui.BentoFrame;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class BentoLauncher
extends BasicDebugger
implements Quitter,
WindowListener {
    private Boolean myFlag_QuittingNow = Boolean.FALSE;
    private boolean myFlag_StopOSGiAfterQuit = false;
    private static BentoLauncher defBentoLauncher = null;
    private ArrayList<BentoFrame> bframes = new ArrayList();

    public static BentoLauncher getDefaultLauncher() {
        if (defBentoLauncher == null) {
            defBentoLauncher = new BentoLauncher(false);
        }
        return defBentoLauncher;
    }

    public static void main(String[] args) {
        BentoLauncher.getDefaultLauncher().attemptInit();
    }

    public BentoLauncher(boolean flag_stopOSGiAfterQuit) {
        this.myFlag_StopOSGiAfterQuit = flag_stopOSGiAfterQuit;
    }

    public boolean attemptInit() {
        this.addWindow(new BentoFrame());
        return true;
    }

    void addWindow(BentoFrame bf) {
        this.bframes.add(bf);
        bf.addWindowListener(this);
    }

    public void requestStop(Boolean optionalFlag_stopOSGiAfterQuit) {
        if (optionalFlag_stopOSGiAfterQuit != null) {
            this.myFlag_StopOSGiAfterQuit = optionalFlag_stopOSGiAfterQuit;
        }
        this.setWantsToQuit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wantsToQuit() {
        Boolean bl = this.myFlag_QuittingNow;
        synchronized (bl) {
            return this.myFlag_QuittingNow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWantsToQuit(boolean x) {
        Boolean bl = this.myFlag_QuittingNow;
        synchronized (bl) {
            this.myFlag_QuittingNow = new Boolean(x);
        }
    }

    @Override
    public void notifyQuitCompleted() {
        if (this.myFlag_StopOSGiAfterQuit) {
            this.getLogger().info("Now that quit has completed, we will shutdown our OSGi container");
            this.shutdownOurOSGiContainer();
        }
    }

    private void shutdownOurOSGiContainer() {
        Bundle anyB = FrameworkUtil.getBundle(this.getClass());
        BundleContext anyBC = anyB.getBundleContext();
        this.stopOSGiContainer(anyBC);
    }

    private void stopOSGiContainer(BundleContext bc) {
        Bundle sysB = bc.getBundle(0L);
        this.getLogger().warn("Asking system bundle to stop(): {}", (Object)sysB);
        try {
            sysB.stop();
        }
        catch (Throwable t) {
            this.getLogger().error("Caught exception during sys-bundle.stop() request", t);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (this.bframes.indexOf(e.getComponent()) >= 0) {
            this.bframes.remove(e.getComponent());
        }
        if (this.bframes.size() == 0) {
            this.setWantsToQuit(true);
        }
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

