/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.bento.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.friendularity.bundle.bento.gui.BadPositionForAddedRowOrColumn;
import org.friendularity.bundle.bento.gui.BentoPlugin;
import org.friendularity.bundle.bento.gui.BentoSplitter;
import org.friendularity.bundle.bento.gui.HorBentoSplitter;
import org.friendularity.bundle.bento.gui.MergeGrid;
import org.friendularity.bundle.bento.gui.VertBentoSplitter;
import org.friendularity.bundle.bento.util.Bento_OSGi_ResourceLoader;

class MergeGridGlassPane
extends JPanel
implements MouseListener,
MouseMotionListener {
    private boolean iHandleEvents = false;
    private Component draggingComponent = null;
    private int splitCursorFromLeft;
    private int splitCursorFromTop;
    private int curHorSplitterWidgetX = 0;
    private int curVertSplitterWidgetY = 0;
    private boolean isHorSplitDragging = false;
    private boolean isVertSplitDragging = false;
    private static Cursor sideSideArrow = null;
    private static Cursor activeSideSideArrow = null;
    private static Cursor updownArrow = null;
    private static Cursor activeUpdownArrow = null;
    private static Cursor mergeCursor = null;
    public static final String HTWO_MENU = "H Two";
    public static final String HTHREE_MENU = "H Three";
    public static final String HFOUR_MENU = "H Four";
    public static final String VTWO_MENU = "V Two";
    public static final String VTHREE_MENU = "V Three";
    public static final String VFOUR_MENU = "V Four";
    public static final String REMOVE_MENU = "Remove";
    public static final String DELETE_COLUMN = "Delete Column";
    public static final String DELETE_ROW = "Delete Row";
    private JPopupMenu popup;
    private String debugStr = "";

    public MergeGridGlassPane() {
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.isHorSplitDragging) {
            g2.setColor(new Color(128, 128, 128, 128));
            g2.fillRect(this.curHorSplitterWidgetX, 0, 10, this.getHeight());
        }
        if (this.isVertSplitDragging) {
            g2.setColor(new Color(128, 128, 128, 128));
            g2.fillRect(0, this.curVertSplitterWidgetY, this.getWidth(), 10);
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.redispatchEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.redispatchEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.redispatchEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.redispatchEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.redispatchEvent(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.redispatchEvent(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.redispatchEvent(e);
    }

    private boolean handleEventLocally(MouseEvent e) {
        MergeGrid mg = (MergeGrid)this.getParent();
        if (e.isPopupTrigger()) {
            this.initPopup(mg.getNonGlassComponentAt(e.getPoint()), mg.getColumnAt(e.getPoint().x), mg.getRowAt(e.getPoint().y));
            this.popup.show(e.getComponent(), e.getX(), e.getY());
            this.draggingComponent = null;
            this.iHandleEvents = false;
            this.isHorSplitDragging = false;
            this.isVertSplitDragging = false;
            return true;
        }
        if (e.isControlDown() || this.iHandleEvents || mg.isLastRowOrColumnSplitter(mg.getNonGlassComponentAt(e.getPoint()))) {
            switch (e.getID()) {
                case 500: {
                    return true;
                }
                case 506: {
                    this.localDrag(e);
                    return true;
                }
                case 504: {
                    return true;
                }
                case 505: {
                    return true;
                }
                case 503: {
                    this.localMove(e);
                    return true;
                }
                case 501: {
                    this.localDown(e);
                    return true;
                }
                case 502: {
                    this.localUp(e);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void redispatchEvent(MouseEvent e) {
        if (this.debugEvent(e, this.handleEventLocally(e))) {
            return;
        }
        MergeGrid mg = (MergeGrid)this.getParent();
        Point epoint = SwingUtilities.convertPoint(this, e.getPoint(), mg);
        Component target = mg.getNonGlassComponentAt(epoint);
        if (e.getID() == 502) {
            this.draggingComponent = null;
        }
        if (this.draggingComponent != null) {
            target = this.draggingComponent;
        }
        if (e.getID() == 501) {
            this.draggingComponent = target;
        }
        if (target == null) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        Point tpoint = SwingUtilities.convertPoint(this, e.getPoint(), target);
        target.dispatchEvent(new MouseEvent(target, e.getID(), e.getWhen(), e.getModifiers(), tpoint.x, tpoint.y, e.getClickCount(), e.isPopupTrigger()));
    }

    private void localDown(MouseEvent e) {
        Point epoint;
        MergeGrid mg = (MergeGrid)this.getParent();
        Component target = mg.getNonGlassComponentAt(epoint = SwingUtilities.convertPoint(this, e.getPoint(), mg));
        if (target == null) {
            this.startRCDragSelect(e);
        } else if (target instanceof BentoPlugin) {
            this.startRCDragSelect(e);
        } else if (target instanceof HorBentoSplitter) {
            this.startHorSplit(e, (HorBentoSplitter)target);
        } else if (target instanceof VertBentoSplitter) {
            this.startVertSplit(e, (VertBentoSplitter)target);
        }
    }

    private void startRCDragSelect(MouseEvent e) {
    }

    private void startHorSplit(MouseEvent e, HorBentoSplitter target) {
        this.iHandleEvents = true;
        this.isHorSplitDragging = true;
        this.splitCursorFromLeft = e.getX() - target.getX();
        this.curHorSplitterWidgetX = target.getX();
        target.setDragCursor();
        this.repaint(50L);
    }

    private void startVertSplit(MouseEvent e, VertBentoSplitter target) {
        this.iHandleEvents = true;
        this.isVertSplitDragging = true;
        this.splitCursorFromTop = e.getY() - target.getY();
        this.curVertSplitterWidgetY = target.getY();
        target.setDragCursor();
        this.repaint(50L);
    }

    private void localDrag(MouseEvent e) {
        if (this.isHorSplitDragging) {
            this.curHorSplitterWidgetX = e.getX() - this.splitCursorFromLeft;
            this.setHorDragCursor();
            this.repaint(50L);
        }
        if (this.isVertSplitDragging) {
            this.curVertSplitterWidgetY = e.getY() - this.splitCursorFromTop;
            this.setVertDragCursor();
            this.repaint(50L);
        }
    }

    private void localMove(MouseEvent e) {
        Point epoint;
        MergeGrid mg = (MergeGrid)this.getParent();
        Component target = mg.getNonGlassComponentAt(epoint = SwingUtilities.convertPoint(this, e.getPoint(), mg));
        if (target == null) {
            this.setCursor(Cursor.getDefaultCursor());
        } else if (target instanceof BentoPlugin) {
            this.setMergeCursor();
        } else if (target instanceof HorBentoSplitter) {
            this.setHorMoveCursor();
        } else if (target instanceof VertBentoSplitter) {
            this.setVertMoveCursor();
        }
        this.iHandleEvents = false;
        this.isHorSplitDragging = false;
        this.isVertSplitDragging = false;
    }

    private void localUp(MouseEvent e) {
        MergeGrid mg;
        if (this.isHorSplitDragging) {
            mg = (MergeGrid)this.getParent();
            try {
                mg.insertColAt(this.curHorSplitterWidgetX);
                this.repaint(50L);
            }
            catch (BadPositionForAddedRowOrColumn ex) {
                Logger.getLogger(MergeGridGlassPane.class.getName()).log(Level.INFO, "Attempt to drop column in invalid location");
            }
        }
        if (this.isVertSplitDragging) {
            mg = (MergeGrid)this.getParent();
            try {
                mg.insertRowAt(this.curVertSplitterWidgetY);
                this.repaint(50L);
            }
            catch (BadPositionForAddedRowOrColumn ex) {
                Logger.getLogger(MergeGridGlassPane.class.getName()).log(Level.INFO, "Attempt to drop row in invalid location");
            }
        }
        this.iHandleEvents = false;
        this.isHorSplitDragging = false;
        this.isVertSplitDragging = false;
    }

    void setHorMoveCursor() {
        if (sideSideArrow == null) {
            sideSideArrow = Bento_OSGi_ResourceLoader.getDefaultImageLoader().getCursorResource("/img/sidesidearrow.png", 16, 16, "sidesidearrow");
        }
        ((MergeGrid)this.getParent()).getGlassPane().setCursor(sideSideArrow);
    }

    void setHorDragCursor() {
        if (activeSideSideArrow == null) {
            activeSideSideArrow = Bento_OSGi_ResourceLoader.getDefaultImageLoader().getCursorResource("/img/activesidesidearrow.png", 16, 16, "activesidesidearrow");
        }
        ((MergeGrid)this.getParent()).getGlassPane().setCursor(activeSideSideArrow);
    }

    void setVertMoveCursor() {
        if (updownArrow == null) {
            updownArrow = Bento_OSGi_ResourceLoader.getDefaultImageLoader().getCursorResource("/img/updownarrow.png", 16, 16, "updownarrow");
        }
        ((MergeGrid)this.getParent()).getGlassPane().setCursor(updownArrow);
    }

    void setVertDragCursor() {
        if (activeUpdownArrow == null) {
            activeUpdownArrow = Bento_OSGi_ResourceLoader.getDefaultImageLoader().getCursorResource("/img/activeupdownarrow.png", 16, 16, "activeupdownarrow");
        }
        ((MergeGrid)this.getParent()).getGlassPane().setCursor(activeUpdownArrow);
    }

    private void setMergeCursor() {
        if (mergeCursor == null) {
            mergeCursor = Bento_OSGi_ResourceLoader.getDefaultImageLoader().getCursorResource("/img/mergecursor.png", 16, 16, "mergecursor");
        }
        ((MergeGrid)this.getParent()).getGlassPane().setCursor(mergeCursor);
    }

    private boolean canSplit() {
        return true;
    }

    protected void initPopup(final Component c, final int col, final int row) {
        JMenuItem menuItem;
        this.popup = new JPopupMenu();
        if (c == null || !(c instanceof BentoSplitter)) {
            this.popup.add(new JSeparator());
            if (((MergeGrid)this.getParent()).getNumColumns() > 1) {
                menuItem = new JMenuItem(DELETE_COLUMN);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MergeGridGlassPane.this.draggingComponent = null;
                        ((MergeGrid)MergeGridGlassPane.this.getParent()).attemptDeleteColumn(col);
                    }
                });
                this.popup.add(menuItem);
            }
            if (((MergeGrid)this.getParent()).getNumRows() > 1) {
                menuItem = new JMenuItem(DELETE_ROW);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MergeGridGlassPane.this.draggingComponent = null;
                        ((MergeGrid)MergeGridGlassPane.this.getParent()).attemptDeleteRow(row);
                    }
                });
                this.popup.add(menuItem);
            }
        }
        if (c instanceof BentoPlugin) {
            this.popup.add(new JSeparator());
            menuItem = new JMenuItem(REMOVE_MENU);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MergeGridGlassPane.this.draggingComponent = null;
                    ((BentoPlugin)c).removeFromMergeGrid();
                }
            });
            this.popup.add(menuItem);
        }
        if (c == null) {
            this.popup.add(new JSeparator());
            menuItem = new JMenuItem("this will be the add");
            this.popup.add(menuItem);
        }
        if (c instanceof BentoPlugin) {
            ((BentoPlugin)c).addAdditionalMenuItems(this.popup);
        }
    }

    protected JPopupMenu getPopup() {
        return this.popup;
    }

    private boolean debugEvent(MouseEvent e, boolean handledLocally) {
        this.debugStr = e.toString() + ":";
        if (this.iHandleEvents) {
            this.debugStr = this.debugStr + "iHandleEvents:";
        }
        if (this.isHorSplitDragging) {
            this.debugStr = this.debugStr + "isHorSplitDragging:";
        }
        if (this.isVertSplitDragging) {
            this.debugStr = this.debugStr + "isVertSplitDragging:";
        }
        if (this.draggingComponent != null) {
            this.debugStr = this.debugStr + this.draggingComponent.getClass().getSimpleName();
        }
        this.repaint(50L);
        return handledLocally;
    }
}

