/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.bento;

import org.appdapter.osgi.core.BundleActivatorBase;
import org.friendularity.bundle.bento.gui.BentoLauncher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BentoBundleActivator
extends BundleActivatorBase {
    public static Logger theLogger = LoggerFactory.getLogger(BentoBundleActivator.class);
    private BentoLauncher myBento;

    public void start(BundleContext context) throws Exception {
        this.myBento = new BentoLauncher(false);
        context.addFrameworkListener((FrameworkListener)new GotFrameworkStartEvent());
    }

    public void stop(BundleContext context) throws Exception {
        this.getLogger().info("Activator sending requestStop() to myLauncher, in case some *other* bundle is stopping the container.");
        this.myBento.requestStop(Boolean.FALSE);
    }

    public Logger getLogger() {
        return theLogger;
    }

    protected void dispatchFrameworkStartedEvent(Bundle bundle, Throwable t) {
        this.getLogger().info("In OSGi framework-started callback, initialization of BentoLauncher");
        String args = this.getProperty(bundle, "", "bento.args", "application.args", "launcher.arguments");
        this.myBento.attemptInit();
        this.getLogger().debug("this is from debug");
        this.getLogger().error("this is from error");
        this.getLogger().info("this is from info");
        this.getLogger().warn("this is from warn");
        this.getLogger().info("BentoLauncher complete");
        System.err.println("It started");
    }

    private String getProperty(Bundle bundle, String defult, String ... tryFrom) {
        BundleContext context = bundle.getBundleContext();
        boolean blankString = false;
        for (String s : tryFrom) {
            String args = context.getProperty(s);
            if (args != null) {
                if (args.length() == 0) {
                    blankString = true;
                    continue;
                }
                return args;
            }
            args = System.getProperty(s, null);
            if (args == null) continue;
            return args;
        }
        if (blankString) {
            return "";
        }
        return defult;
    }

    final class GotFrameworkStartEvent
    implements FrameworkListener {
        GotFrameworkStartEvent() {
        }

        public void frameworkEvent(FrameworkEvent fe) {
            int eventType = fe.getType();
            BentoBundleActivator.this.getLogger().info("************************ Got frameworkEvent with eventType=" + eventType + ", bundle=" + fe.getBundle());
            if (eventType == 1) {
                BentoBundleActivator.this.getLogger().info("********  OSGi Framework has STARTED, calling dispatchFrameworkStartedEvent()");
                BentoBundleActivator.this.dispatchFrameworkStartedEvent(fe.getBundle(), fe.getThrowable());
            }
        }
    }
}

