/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.bento.gui;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.friendularity.bundle.bento.gui.BentoBox;
import org.friendularity.bundle.bento.gui.MergeGrid;
import org.friendularity.bundle.bento.util.Bento_OSGi_ResourceLoader;

public abstract class BentoPlugin
extends JPanel
implements ActionListener {
    private BentoBox myBentoController;
    public static final String HTWO_MENU = "H Two";
    public static final String HTHREE_MENU = "H Three";
    public static final String HFOUR_MENU = "H Four";
    public static final String VTWO_MENU = "V Two";
    public static final String VTHREE_MENU = "V Three";
    public static final String VFOUR_MENU = "V Four";
    public static final String REMOVE_MENU = "Remove";
    private JPopupMenu popup;

    public BentoPlugin() {
        this.setLayout(null);
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                super.mouseMoved(e);
                BentoPlugin.this.setMoveCursor();
            }
        });
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    protected void handleActions(ActionEvent e) {
        System.err.println(e.getActionCommand());
        this.containingBox().doCommand(this, e.getActionCommand());
    }

    void init(BentoBox aController) {
        this.myBentoController = aController;
        try {
            this.initPopup();
        }
        catch (IOException ex) {
            Logger.getLogger(BentoPlugin.class.getName()).log(Level.SEVERE, null, "missing resources probably wont come up");
        }
    }

    protected void addAdditionalMenuItems(JPopupMenu menu) {
    }

    protected BentoBox containingBox() {
        for (Container x = this; x != null; x = x.getParent()) {
            if (!(x instanceof BentoBox)) continue;
            return (BentoBox)x;
        }
        return null;
    }

    boolean canSplit() {
        return this.containingBox() != null;
    }

    protected void initPopup() throws IOException {
        this.popup = new JPopupMenu();
        if (this.canSplit()) {
            JMenu subMenu = new JMenu("Hor. Split");
            ImageIcon ii = new ImageIcon(Bento_OSGi_ResourceLoader.getDefaultImageLoader().getImageResource("/img/twohor.png"));
            JMenuItem menuItem = new JMenuItem(HTWO_MENU, ii);
            menuItem.addActionListener(this);
            subMenu.add(menuItem);
            ii = new ImageIcon(Bento_OSGi_ResourceLoader.getDefaultImageLoader().getImageResource("/img/threehor.png"));
            menuItem = new JMenuItem(HTHREE_MENU, ii);
            menuItem.addActionListener(this);
            subMenu.add(menuItem);
            ii = new ImageIcon(Bento_OSGi_ResourceLoader.getDefaultImageLoader().getImageResource("/img/fourhor.png"));
            menuItem = new JMenuItem(HFOUR_MENU, ii);
            menuItem.addActionListener(this);
            subMenu.add(menuItem);
            this.popup.add(subMenu);
            subMenu = new JMenu("Vert. Split");
            ii = new ImageIcon(Bento_OSGi_ResourceLoader.getDefaultImageLoader().getImageResource("/img/twovert.png"));
            menuItem = new JMenuItem(VTWO_MENU, ii);
            menuItem.addActionListener(this);
            subMenu.add(menuItem);
            ii = new ImageIcon(Bento_OSGi_ResourceLoader.getDefaultImageLoader().getImageResource("/img/threevert.png"));
            menuItem = new JMenuItem(VTHREE_MENU, ii);
            menuItem.addActionListener(this);
            subMenu.add(menuItem);
            ii = new ImageIcon(Bento_OSGi_ResourceLoader.getDefaultImageLoader().getImageResource("/img/fourvert.png"));
            menuItem = new JMenuItem(VFOUR_MENU, ii);
            menuItem.addActionListener(this);
            subMenu.add(menuItem);
            this.popup.add(subMenu);
            menuItem = new JMenuItem(REMOVE_MENU);
            menuItem.addActionListener(this);
            this.popup.add(menuItem);
        }
        this.addAdditionalMenuItems(this.popup);
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.handleActions(e);
    }

    protected JPopupMenu getPopup() {
        return this.popup;
    }

    public BentoBox getBentoBox() {
        return this.myBentoController;
    }

    private void setMoveCursor() {
        try {
            ((MergeGrid)this.getParent()).getGlassPane().setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception e) {
            System.err.println("vastly painful");
        }
    }

    void removeFromMergeGrid() {
        ((MergeGrid)this.getParent()).removeCell(this);
        this.pluginRemoved();
    }

    protected void pluginRemoved() {
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BentoPlugin.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

