/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.bento.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.friendularity.bundle.bento.gui.BentoPlugin;
import org.friendularity.bundle.bento.util.Bento_OSGi_ResourceLoader;
import org.friendularity.jvision.broker.ImageFlavorNotAvailable;
import org.friendularity.jvision.broker.ImageStreamBroker;
import org.friendularity.jvision.broker.ImageStreamConsumer;
import org.friendularity.jvision.broker.ImageStreamImage;

public class CameraViewer
extends BentoPlugin
implements ImageStreamConsumer {
    private BufferedImage mImage = null;
    private String mFrameMessage = "";
    private int noImage = 0;
    private static int nextImageNum = 1;
    private int thisImageNum = nextImageNum++;
    private static Font cameraViewerFont = new Font("Serif", 0, 18);

    public CameraViewer(String name) {
        this.setPreferredSize(new Dimension(640, 480));
        this.setMaximumSize(new Dimension(640, 480));
        this.setMinimumSize(new Dimension(160, 120));
        this.setLayout(null);
        this.setSize(new Dimension(640, 480));
        ImageStreamBroker.getDefaultImageStreamBroker().alwaysAddImageStreamConsumer(name, (ImageStreamConsumer)this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(Color.DARK_GRAY);
        Rectangle vis = this.getVisibleRect();
        g.fillRect(vis.x, vis.y, vis.width, vis.height);
        g.setFont(cameraViewerFont);
        if (this.mImage != null) {
            Rectangle destRect = new Rectangle();
            CameraViewer.bestAntiAliasedFit(this.getVisibleRect(), this.mImage.getWidth(), this.mImage.getHeight(), destRect);
            g.drawImage(this.mImage, destRect.x, destRect.y, destRect.width, destRect.height, this);
            this.drawLabel(g, this.getHeight() - 30, "(" + Integer.toString(this.thisImageNum) + ") " + this.mFrameMessage);
        } else {
            this.drawLabel(g, this.getHeight() - 30, "no image " + this.mFrameMessage);
        }
    }

    public void setConsumedImage(ImageStreamImage img) {
        try {
            this.mImage = img.getBufferedImage();
        }
        catch (ImageFlavorNotAvailable ex) {
            Logger.getLogger(CameraViewer.class.getName()).log(Level.SEVERE, "CameraViewer viewing wrong image type");
        }
        this.repaint();
    }

    public void setConsumedMessage(String string) {
        this.mFrameMessage = string;
    }

    private static void bestAntiAliasedFit(Rectangle layoutArea, int width, int height, Rectangle destRect) {
        int divisor;
        for (divisor = 1; divisor < 131072 && (layoutArea.width < 256 * width / divisor || layoutArea.height < 256 * height / divisor); divisor <<= 1) {
        }
        destRect.width = 256 * width / divisor;
        destRect.height = 256 * height / divisor;
        destRect.x = layoutArea.x + layoutArea.width / 2 - destRect.width / 2;
        destRect.y = layoutArea.y + layoutArea.height / 2 - destRect.height / 2;
    }

    public void sourceIsEnding() {
        try {
            this.mImage = Bento_OSGi_ResourceLoader.getDefaultImageLoader().getImageResource("/img/testpattern.png");
        }
        catch (IOException ex) {
            Logger.getLogger(CameraViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void drawLabel(Graphics g, int vertPos, String s) {
        g.setColor(Color.WHITE);
        g.setFont(cameraViewerFont);
        int x = this.getWidth() / 2 - g.getFontMetrics().stringWidth(s) / 2;
        g.drawString(s, x - 1, vertPos - 1);
        g.drawString(s, x + 1, vertPos + 1);
        g.drawString(s, x - 1, vertPos + 1);
        g.drawString(s, x + 1, vertPos - 1);
        g.setColor(Color.black);
        g.drawString(s, x, vertPos);
    }
}

