/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.bento.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.friendularity.bundle.bento.gui.MergeGrid;
import org.friendularity.bundle.bento.gui.MergeGridGlassPane;

class MergeGridLayout
implements LayoutManager2,
Serializable {
    Dimension oldSize = new Dimension(0, 0);

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        int i;
        Dimension d = new Dimension(0, 0);
        if (!(target instanceof MergeGrid)) {
            throw new IllegalArgumentException("MergeGridLayout requires a MergeGrid");
        }
        MergeGrid mg = (MergeGrid)target;
        for (i = 0; i < mg.getNumColumns(); ++i) {
            d.width += mg.getWidth(i);
        }
        d.width += mg.getNumColumns() * 10;
        for (i = 0; i < mg.getNumRows(); ++i) {
            d.height += mg.getHeight(i);
        }
        d.height += mg.getNumRows() * 10;
        return d;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.maximumLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.maximumLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        if (!(parent instanceof MergeGrid)) {
            throw new IllegalArgumentException("MergeGridLayout requires a MergeGrid");
        }
        MergeGrid mg = (MergeGrid)parent;
        int oldSumOfColSizes = mg.getSumOfColSizes();
        int oldSumOfRowSizes = mg.getSumOfRowSizes();
        if (this.oldSize.width != 0 && this.oldSize.height != 0 && !mg.getSize().equals(this.oldSize)) {
            int widthSum = parent.getWidth() - mg.getNumColumns() * 10;
            int heightSum = parent.getHeight() - mg.getNumRows() * 10;
            if (widthSum > 0 && heightSum > 0 && (widthSum != oldSumOfColSizes || heightSum != oldSumOfRowSizes)) {
                float widthRatio = (float)widthSum / (float)oldSumOfColSizes;
                float heightRatio = (float)heightSum / (float)oldSumOfRowSizes;
                mg.stretchWidth(widthRatio);
                mg.stretchHeight(heightRatio);
                this.oldSize = parent.getSize();
            }
        } else {
            this.oldSize = parent.getSize();
        }
        Point p = new Point(0, 0);
        int curZOrder = mg.getNumCells() + mg.getNumColumns() + mg.getNumRows() + 1 - 1;
        p.x = 0;
        for (int col = 0; col < mg.getNumColumns(); ++col) {
            p.y = 0;
            for (int row = 0; row < mg.getNumRows(); ++row) {
                JComponent c = mg.getCellAt(col, row);
                if (c != null) {
                    Dimension d = mg.sizeAt(col, row);
                    Dimension size = new Dimension(0, 0);
                    for (int cc = col; cc < col + d.width; ++cc) {
                        size.width += mg.getWidth(cc);
                    }
                    size.width += 10 * (d.width - 1);
                    for (int rr = row; rr < row + d.height; ++rr) {
                        size.height += mg.getHeight(rr);
                    }
                    size.height += 10 * (d.height - 1);
                    c.setLocation(p);
                    c.setSize(size);
                    mg.setComponentZOrder(c, curZOrder--);
                }
                p.y += mg.getHeight(row);
                p.y += 10;
            }
            p.x += mg.getWidth(col);
            p.x += 10;
        }
        int x = 0;
        for (int col = 0; col < mg.getNumColumns(); ++col) {
            mg.getColSplitter(col).setLocation(x += mg.getWidth(col), 0);
            x += 10;
            mg.setComponentZOrder(mg.getColSplitter(col), curZOrder--);
        }
        int y = 0;
        for (int row = 0; row < mg.getNumRows(); ++row) {
            mg.getRowSplitter(row).setLocation(0, y += mg.getHeight(row));
            y += 10;
            mg.setComponentZOrder(mg.getRowSplitter(row), curZOrder--);
        }
        MergeGridGlassPane g = mg.getGlassPane();
        if (curZOrder != 0) {
            Logger.getLogger(MergeGridLayout.class.getName()).log(Level.SEVERE, "curZOrder not at zero, something wrong");
        }
        mg.setComponentZOrder(g, 0);
        g.setBounds(mg.getBounds());
    }
}

