/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.bento.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.friendularity.bundle.bento.gui.BentoSplitter;
import org.friendularity.bundle.bento.gui.MergeGrid;
import org.friendularity.bundle.bento.util.Bento_OSGi_ResourceLoader;

public class VertBentoSplitter
extends BentoSplitter
implements MouseListener,
MouseMotionListener {
    private static final int REALLY_WIDE = 32768;
    private static BufferedImage texture = null;
    private static BufferedImage textop = null;
    private static final int IMAGE_TOP_WIDTH = 26;
    private static final int IMAGE_WIDTH = 168;
    private int prevYOnScreen;

    public VertBentoSplitter() {
        this.setLayout(null);
        this.setSize(this.getPreferredSize());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(32768, 10);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (texture == null) {
            try {
                texture = Bento_OSGi_ResourceLoader.getDefaultImageLoader().getImageResource("/img/vertsplittermain.png");
            }
            catch (IOException ex) {
                Logger.getLogger(VertBentoSplitter.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }
        if (textop == null) {
            try {
                textop = Bento_OSGi_ResourceLoader.getDefaultImageLoader().getImageResource("/img/vertsplittertop.png");
            }
            catch (IOException ex) {
                Logger.getLogger(VertBentoSplitter.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }
        for (int x = 26; x < g2.getClipBounds().x + g2.getClipBounds().width; x += 168) {
            g2.drawImage((Image)texture, x, 0, this);
        }
        g2.drawImage((Image)textop, 0, 0, this);
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    protected MergeGrid mg() {
        return (MergeGrid)this.getParent();
    }

    @Override
    protected void setMoveCursor() {
        this.mg().getGlassPane().setVertMoveCursor();
    }

    protected void setDragCursor() {
        this.mg().getGlassPane().setVertDragCursor();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setDragCursor();
        MergeGrid mg = this.mg();
        if (this.mg().isLastRowOrColumnSplitter(this)) {
            throw new IllegalArgumentException("I'm the last column don't try to move me");
        }
        this.prevYOnScreen = e.getYOnScreen();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setMoveCursor();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setDragCursor();
        int delta = e.getYOnScreen() - this.prevYOnScreen;
        int newdelta = this.mg().resizeRows(this.mg().indexOfVertSplitter(this), delta);
        this.prevYOnScreen += newdelta;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setMoveCursor();
    }
}

