/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.bento.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.friendularity.bundle.bento.gui.BadPositionForAddedRowOrColumn;
import org.friendularity.bundle.bento.gui.HorBentoSplitter;
import org.friendularity.bundle.bento.gui.ItsBentoBoxesNotBentoTetrisException;
import org.friendularity.bundle.bento.gui.MergeGridGlassPane;
import org.friendularity.bundle.bento.gui.MergeGridLayout;
import org.friendularity.bundle.bento.gui.VertBentoSplitter;

public class MergeGrid
extends JPanel {
    static final int SEPARATOR_WIDTH = 10;
    static final int SEPARATOR_HEIGHT = 10;
    static final int SOME_MINIMAL_CELL_DIM = 4;
    private HashMap<Point, MergeGridEntry> myCells = new HashMap();
    private ArrayList<Float> columns = new ArrayList();
    private ArrayList<Float> rows = new ArrayList();
    private ArrayList<HorBentoSplitter> colsplitters = new ArrayList();
    private ArrayList<VertBentoSplitter> rowsplitters = new ArrayList();
    private MergeGridGlassPane theGlass;
    private boolean createColumnMode = false;

    public MergeGrid() {
        this.setLayout(new MergeGridLayout());
        this.theGlass = new MergeGridGlassPane();
        this.add(this.theGlass);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    int getNumColumns() {
        return this.columns.size();
    }

    int getNumRows() {
        return this.rows.size();
    }

    int getWidth(int i) {
        return (int)this.columns.get(i).floatValue();
    }

    int getHeight(int i) {
        return (int)this.rows.get(i).floatValue();
    }

    int getColumnAt(int x) {
        float myx = 0.0f;
        for (int i = 0; i < this.columns.size(); ++i) {
            if (myx <= (float)x && (float)x < myx + this.columns.get(i).floatValue() + 10.0f) {
                return i;
            }
            myx += this.columns.get(i).floatValue() + 10.0f;
        }
        throw new IllegalArgumentException("pixel x=" + x + " is not in a column");
    }

    int getRowAt(int y) {
        float myy = 0.0f;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (myy <= (float)y && (float)y < myy + this.rows.get(i).floatValue() + 10.0f) {
                return i;
            }
            myy += this.rows.get(i).floatValue() + 10.0f;
        }
        throw new IllegalArgumentException("pixel y=" + y + " is not in a row");
    }

    void addColumn(int i, int width) {
        this.columns.add(i, new Float(width));
        HorBentoSplitter s = new HorBentoSplitter();
        this.add(s);
        this.colsplitters.add(i, s);
        this.revalidate();
    }

    void addRow(int i, int height) {
        this.rows.add(i, new Float(height));
        VertBentoSplitter s = new VertBentoSplitter();
        this.add(s);
        this.rowsplitters.add(i, s);
        this.revalidate();
    }

    void setCell(JComponent component, int col, int row, int colsize, int rowsize) throws ItsBentoBoxesNotBentoTetrisException {
        MergeGridEntry mge;
        if (col < 0 || col + colsize > this.columns.size()) {
            throw new IllegalArgumentException("attempt to set cell in columns " + col + " - " + (col + colsize) + " when there are only " + this.columns.size() + " columns");
        }
        if (row < 0 || row + rowsize > this.rows.size()) {
            throw new IllegalArgumentException("attempt to set cell in rows " + row + " - " + (row + rowsize) + " when there are only " + this.rows.size() + " rows");
        }
        for (Point p : this.myCells.keySet()) {
            mge = this.myCells.get(p);
            if (!mge.clashesWith(col, row, colsize, rowsize)) continue;
            throw new ItsBentoBoxesNotBentoTetrisException(mge.col, mge.row, mge.colsize, mge.rowsize);
        }
        for (Point p : this.myCells.keySet()) {
            mge = this.myCells.get(p);
            if (!mge.coveredBy(col, row, colsize, rowsize)) continue;
            this.removeMGE(mge);
        }
        this.add(component);
        MergeGridEntry mge2 = new MergeGridEntry(component, col, row, colsize, rowsize);
        this.myCells.put(mge2.getPoint(), mge2);
        this.revalidate();
    }

    private void removeMGE(MergeGridEntry mge) {
        this.myCells.remove(mge.getPoint());
        this.remove(mge.component);
        this.revalidate();
    }

    JComponent getCellAt(int col, int row) {
        MergeGridEntry mge = this.myCells.get(new Point(col, row));
        if (mge == null) {
            return null;
        }
        return mge.component;
    }

    HorBentoSplitter getColSplitter(int col) {
        return this.colsplitters.get(col);
    }

    VertBentoSplitter getRowSplitter(int row) {
        return this.rowsplitters.get(row);
    }

    void stretchWidth(float widthRatio) {
        for (int i = 0; i < this.columns.size(); ++i) {
            this.columns.set(i, new Float(this.columns.get(i).floatValue() * widthRatio));
        }
    }

    void stretchHeight(float heightRatio) {
        for (int i = 0; i < this.rows.size(); ++i) {
            this.rows.set(i, new Float(this.rows.get(i).floatValue() * heightRatio));
        }
    }

    Dimension sizeAt(int col, int row) {
        MergeGridEntry mge = this.myCells.get(new Point(col, row));
        return new Dimension(mge.colsize, mge.rowsize);
    }

    boolean isLastRowOrColumnSplitter(Object aThis) {
        if (aThis == null) {
            return false;
        }
        if (aThis instanceof HorBentoSplitter) {
            if (this.colsplitters.size() < 1) {
                return false;
            }
            return this.colsplitters.get(this.colsplitters.size() - 1) == aThis;
        }
        if (aThis instanceof VertBentoSplitter) {
            if (this.rowsplitters.size() < 1) {
                return false;
            }
            return this.rowsplitters.get(this.rowsplitters.size() - 1) == aThis;
        }
        return false;
    }

    int indexOfHorSplitter(HorBentoSplitter aThis) {
        int i = this.colsplitters.indexOf(aThis);
        if (i >= 0) {
            return i;
        }
        throw new IllegalArgumentException("Attempt to find index of HorBentoSplitter not in MergeGrid");
    }

    int indexOfVertSplitter(VertBentoSplitter aThis) {
        int i = this.rowsplitters.indexOf(aThis);
        if (i >= 0) {
            return i;
        }
        throw new IllegalArgumentException("Attempt to find index of VertBentoSplitter not in MergeGrid");
    }

    boolean okToDuplicateLeft(HorBentoSplitter aThis) {
        return this.columns.get(this.indexOfHorSplitter(aThis)).floatValue() > 18.0f;
    }

    boolean okToDuplicateRight(HorBentoSplitter aThis) {
        if (this.isLastRowOrColumnSplitter(aThis)) {
            return false;
        }
        return this.columns.get(1 + this.indexOfHorSplitter(aThis)).floatValue() > 18.0f;
    }

    HorBentoSplitter duplicateLeft(HorBentoSplitter aThis) {
        int i = this.indexOfHorSplitter(aThis);
        if (this.columns.get(i).floatValue() < 14.0f) {
            throw new IllegalArgumentException("Trying to make too narrow a column");
        }
        int width = (int)(this.columns.get(i).floatValue() - 4.0f - 10.0f);
        this.columns.set(i, new Float(4.0f));
        this.addColumn(i, width);
        return this.colsplitters.get(i);
    }

    int getNumCells() {
        return this.myCells.size();
    }

    MergeGridGlassPane getGlassPane() {
        return this.theGlass;
    }

    boolean interactWithGlassPane() {
        return this.createColumnMode;
    }

    Component getNonGlassComponentAt(Point epoint) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Point cpoint;
            Component c = this.getComponent(i);
            if (!c.contains(cpoint = SwingUtilities.convertPoint(this, epoint, c)) || c instanceof MergeGridGlassPane) continue;
            return c;
        }
        return null;
    }

    void insertColAt(int x) throws BadPositionForAddedRowOrColumn {
        if (x < 0) {
            throw new BadPositionForAddedRowOrColumn(x);
        }
        if (x > this.getWidth() - 20 - 4) {
            throw new BadPositionForAddedRowOrColumn(x);
        }
        float colx = 0.0f;
        for (int i = 0; i < this.columns.size(); ++i) {
            if (colx + 4.0f <= (float)x && colx + this.columns.get(i).floatValue() >= (float)(x + 10 + 4)) {
                float colwas = this.columns.get(i).floatValue();
                float leftside = (float)x - colx;
                float rightside = this.columns.get(i).floatValue() - leftside - 10.0f;
                this.columns.set(i, Float.valueOf(leftside));
                this.columns.add(i + 1, Float.valueOf(rightside));
                HorBentoSplitter h = new HorBentoSplitter();
                this.colsplitters.add(i + 1, h);
                this.add(h);
                this.revalidate();
                return;
            }
            colx += this.columns.get(i).floatValue();
            colx += 10.0f;
        }
        throw new BadPositionForAddedRowOrColumn(x);
    }

    void insertRowAt(int y) throws BadPositionForAddedRowOrColumn {
        if (y < 0) {
            throw new BadPositionForAddedRowOrColumn(y);
        }
        if (y > this.getHeight() - 20 - 4) {
            throw new BadPositionForAddedRowOrColumn(y);
        }
        float rowy = 0.0f;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (rowy + 4.0f <= (float)y && rowy + this.rows.get(i).floatValue() >= (float)(y + 10 + 4)) {
                float upperside = (float)y - rowy;
                float lowerside = this.rows.get(i).floatValue() - upperside - 10.0f;
                this.rows.set(i, Float.valueOf(upperside));
                this.rows.add(i + 1, Float.valueOf(lowerside));
                VertBentoSplitter v = new VertBentoSplitter();
                this.rowsplitters.add(i + 1, v);
                this.add(v);
                this.revalidate();
                return;
            }
            rowy += this.rows.get(i).floatValue();
            rowy += 10.0f;
        }
        throw new BadPositionForAddedRowOrColumn(y);
    }

    int resizeColumns(int index, int delta) {
        if (delta == 0) {
            return 0;
        }
        int newdelta = delta > 0 ? (int)Math.min((float)delta, this.columns.get(index + 1).floatValue() - 4.0f) : (int)Math.max((float)delta, 4.0f - this.columns.get(index).floatValue());
        this.columns.set(index, Float.valueOf(this.columns.get(index).floatValue() + (float)newdelta));
        this.columns.set(index + 1, Float.valueOf(this.columns.get(index + 1).floatValue() - (float)newdelta));
        this.revalidate();
        return newdelta;
    }

    int resizeRows(int index, int delta) {
        if (delta == 0) {
            return 0;
        }
        int newdelta = delta > 0 ? (int)Math.min((float)delta, this.rows.get(index + 1).floatValue() - 4.0f) : (int)Math.max((float)delta, 4.0f - this.rows.get(index).floatValue());
        this.rows.set(index, Float.valueOf(this.rows.get(index).floatValue() + (float)newdelta));
        this.rows.set(index + 1, Float.valueOf(this.rows.get(index + 1).floatValue() - (float)newdelta));
        this.revalidate();
        return newdelta;
    }

    int getSumOfColSizes() {
        int w = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            w = (int)((double)w + Math.floor(this.columns.get(i).floatValue()));
        }
        return w;
    }

    int getSumOfRowSizes() {
        int h = 0;
        for (int i = 0; i < this.rows.size(); ++i) {
            h = (int)((double)h + Math.floor(this.rows.get(i).floatValue()));
        }
        return h;
    }

    void removeCell(JComponent aThis) {
        for (Point p : this.myCells.keySet()) {
            MergeGridEntry mge = this.myCells.get(p);
            if (mge.component != aThis) continue;
            this.remove(aThis);
            this.myCells.remove(p);
            this.revalidate();
            this.repaint();
            return;
        }
    }

    void attemptDeleteColumn(int col) {
        if (this.columns.size() < 2) {
            return;
        }
        float amountToHandOut = (this.columns.get(col).floatValue() + 10.0f) / (float)(this.columns.size() - 1);
        HashMap<Point, MergeGridEntry> newCells = new HashMap<Point, MergeGridEntry>();
        for (Point p : this.myCells.keySet()) {
            MergeGridEntry mge = this.myCells.get(p);
            if (mge.col + mge.colsize - 1 < col) {
                newCells.put(p, mge);
                continue;
            }
            if (mge.col < col && mge.col + mge.colsize - 1 >= col) {
                --mge.colsize;
                newCells.put(p, mge);
                continue;
            }
            if (mge.col > col) {
                --mge.col;
                newCells.put(new Point(p.x - 1, p.y), mge);
                continue;
            }
            if (mge.col == col && mge.colsize == 1) {
                this.remove(mge.component);
                continue;
            }
            Logger.getLogger(MergeGrid.class.getName()).log(Level.SEVERE, "unhandled case deleting column " + col + " from mge.col = " + mge.col + " mge.colsize = " + mge.colsize);
        }
        this.myCells = newCells;
        HorBentoSplitter sp = this.getColSplitter(col);
        this.colsplitters.remove(sp);
        this.remove(sp);
        this.columns.remove(col);
        for (int i = 0; i < this.columns.size(); ++i) {
            this.columns.set(i, Float.valueOf(this.columns.get(i).floatValue() + amountToHandOut));
        }
        this.revalidate();
    }

    void attemptDeleteRow(int row) {
        if (this.rows.size() < 2) {
            return;
        }
        HashMap<Point, MergeGridEntry> newCells = new HashMap<Point, MergeGridEntry>();
        float amountToHandOut = (this.rows.get(row).floatValue() + 10.0f) / (float)(this.rows.size() - 1);
        for (Point p : this.myCells.keySet()) {
            MergeGridEntry mge = this.myCells.get(p);
            if (mge.row + mge.rowsize - 1 < row) {
                newCells.put(p, mge);
                continue;
            }
            if (mge.row < row && mge.row + mge.rowsize - 1 >= row) {
                --mge.rowsize;
                newCells.put(p, mge);
                continue;
            }
            if (mge.row > row) {
                --mge.row;
                newCells.put(new Point(p.x, p.y - 1), mge);
                continue;
            }
            if (mge.row == row && mge.rowsize == 1) {
                this.remove(mge.component);
                continue;
            }
            Logger.getLogger(MergeGrid.class.getName()).log(Level.SEVERE, "unhandled case deleting row " + row + " from mge.row = " + mge.row + " mge.rowsize = " + mge.rowsize);
        }
        this.myCells = newCells;
        VertBentoSplitter sp = this.getRowSplitter(row);
        this.rowsplitters.remove(sp);
        this.remove(sp);
        this.rows.remove(row);
        for (int i = 0; i < this.rows.size(); ++i) {
            this.rows.set(i, Float.valueOf(this.rows.get(i).floatValue() + amountToHandOut));
        }
        this.revalidate();
    }

    private static class MergeGridEntry {
        int col;
        int row;
        int colsize;
        int rowsize;
        JComponent component;

        public MergeGridEntry(JComponent component, int col, int row, int colsize, int rowsize) {
            this.col = col;
            this.row = row;
            this.colsize = colsize;
            this.rowsize = rowsize;
            this.component = component;
        }

        private boolean clashesWith(int acol, int arow, int acolsize, int arowsize) {
            return (this.col < acol && this.col + this.colsize > acol || this.col < acol + acolsize && this.col + this.colsize >= acol + acolsize) && (this.row < arow && this.row + this.rowsize > arow || this.row < arow + arowsize && this.row + this.rowsize >= arow + arowsize);
        }

        private boolean coveredBy(int acol, int arow, int acolsize, int arowsize) {
            return this.col >= acol && this.col + this.colsize <= acol + acolsize && this.row >= arow && this.row + this.rowsize <= arow + arowsize;
        }

        private Point getPoint() {
            return new Point(this.col, this.row);
        }
    }
}

