/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.filters;

import javax.swing.JFrame;
import org.friendularity.jvision.filters.ApplicativeBaseFilter;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;
import org.opencv.video.Video;

public class FarnebackBGx
extends ApplicativeBaseFilter {
    Mat mLastFrame = null;
    Mat mFlowImage = null;

    private static byte toIntRange(float f) {
        float ff = 128.0f + 8.0f * f;
        if (ff < 0.0f) {
            ff = 0.0f;
        }
        if (ff > 255.0f) {
            ff = 255.0f;
        }
        return (byte)ff;
    }

    @Override
    public void apply(Mat in, Mat out) {
        if (this.mFlowImage == null) {
            this.mFlowImage = new Mat(in.width(), in.height(), CvType.CV_32FC2);
        }
        Mat gray = new Mat();
        if (in.channels() > 1) {
            Imgproc.cvtColor(in, gray, 7);
        } else {
            in.copyTo(gray);
        }
        if (this.mLastFrame == null) {
            this.mLastFrame = new Mat();
            Imgproc.cvtColor(in, this.mLastFrame, 7);
            in.copyTo(out);
            return;
        }
        Video.calcOpticalFlowFarneback(this.mLastFrame, gray, this.mFlowImage, 0.5, 3, 15, 3, 5, 1.2, 0);
        in.copyTo(out);
        FarnebackBGx.drawFlowBGx(this.mFlowImage, out);
        gray.copyTo(this.mLastFrame);
    }

    static void drawFlowBGx(Mat float32image, Mat bgr8image) {
        int h = bgr8image.height();
        int w = bgr8image.width();
        float[] fbuf = new float[2];
        float scale = 1.0f;
        float total_x = 0.0f;
        float total_y = 0.0f;
        int inchannels = float32image.channels();
        float[] inbuf = new float[(int)float32image.total() * inchannels];
        float32image.get(0, 0, inbuf);
        int outchannels = bgr8image.channels();
        byte[] outbuf = new byte[(int)bgr8image.total() * outchannels];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                outbuf[(w * y + x) * outchannels] = FarnebackBGx.toIntRange(inbuf[(w * y + x) * inchannels]);
                outbuf[(w * y + x) * outchannels + 1] = FarnebackBGx.toIntRange(inbuf[(w * y + x) * inchannels + 1]);
                outbuf[(w * y + x) * outchannels + 2] = 0;
            }
        }
        bgr8image.put(0, 0, outbuf);
    }

    public String toString() {
        return "farneback_BGx";
    }

    @Override
    public void showParamUI(JFrame parent) {
    }

    @Override
    public String serialize() {
        return "";
    }

    @Override
    public void deserialize(String str) {
    }
}

