/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.filters;

import java.awt.Container;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.friendularity.jvision.filters.ParamChangedListener;

class FilterParams
extends JFrame {
    private ParamChangedListener pcl = null;

    static void showParamWidget(ParamChangedListener aFilter, String builderStr) {
        new FilterParams(aFilter, builderStr);
    }

    private FilterParams(ParamChangedListener aFilter, String builderStr) {
        this.pcl = aFilter;
        Container c = this.getContentPane();
        c.setLayout(new BoxLayout(c, 1));
        String[] s = builderStr.split(",");
        int index = 0;
        int i = 0;
        while (i < s.length) {
            c.add(new JLabel(s[i]));
            if (s[i + 1].equals("slider")) {
                JSlider sldr = new JSlider(0);
                sldr.setMinimum((int)Double.parseDouble(s[i + 2]));
                sldr.setMaximum((int)Double.parseDouble(s[i + 4]));
                sldr.setValue((int)Double.parseDouble(s[i + 3]));
                sldr.addChangeListener(new indexChangeListener(index, this.pcl));
                c.add(sldr);
                i += 5;
            } else {
                ++i;
            }
            ++index;
        }
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        c.invalidate();
        this.pack();
    }

    private static class indexChangeListener
    implements ChangeListener {
        private int index;
        private ParamChangedListener pcl;

        public indexChangeListener(int index, ParamChangedListener pcl) {
            this.index = index;
            this.pcl = pcl;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() instanceof JSlider) {
                this.pcl.paramChanged(this.index, Integer.toString(((JSlider)e.getSource()).getValue()));
            } else {
                this.pcl.paramChanged(this.index, e.getSource().toString());
            }
        }
    }
}

