/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.friendularity.jvision.broker.ImageFlavorNotAvailable;
import org.friendularity.jvision.broker.ImageStreamBroker;
import org.friendularity.jvision.broker.ImageStreamConsumer;
import org.friendularity.jvision.broker.ImageStreamImage;
import org.friendularity.jvision.engine.JVisionEngine;
import org.friendularity.jvision.engine.Quitter;
import org.friendularity.jvision.filters.FilterSequence;
import org.friendularity.jvision.gui.FilterBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVisionFrame
extends JFrame
implements WindowListener,
ImageStreamConsumer {
    static Logger theLogger = LoggerFactory.getLogger(JVisionFrame.class);
    private static final long serialVersionUID = -2429127330233038194L;
    private ImageIcon myImageOutIcon = new ImageIcon();
    private JButton myImageOutButton = new JButton();
    private Quitter myQuitter;
    private JPanel myControlsPanel = new JPanel();
    private JLabel myLabel_Framerate = new JLabel();
    private JMenuBar myMenuBar;
    private FilterSequence mytestfilters;

    public JVisionFrame() {
        this.setSize(640, 640);
        this.setTitle("JVision Bundle - OpenCV java demo");
        this.myImageOutButton.setIcon(this.myImageOutIcon);
        this.myImageOutButton.setMinimumSize(new Dimension(640, 480));
        this.myImageOutButton.setSize(new Dimension(640, 480));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.myImageOutButton, "Center");
        this.myControlsPanel.setMinimumSize(new Dimension(640, 160));
        this.myControlsPanel.setBackground(new Color(255, 200, 128));
        this.myControlsPanel.add(this.myLabel_Framerate);
        this.getContentPane().add((Component)this.myControlsPanel, "Last");
        this.setupMenus();
        this.registerWindowListeners();
        this.setVisible(true);
        ImageStreamBroker.getDefaultImageStreamBroker().alwaysAddImageStreamConsumer("jvision.camera", this);
        this.setDefaultCloseOperation(0);
    }

    public void setQuitter(Quitter q) {
        this.myQuitter = q;
    }

    public void showFilterBox() {
        FilterBox.showFilterBox();
    }

    @Override
    public void setConsumedImage(ImageStreamImage img) {
        try {
            this.myImageOutIcon.setImage(img.getBufferedImage());
        }
        catch (ImageFlavorNotAvailable ex) {
            java.util.logging.Logger.getLogger(JVisionFrame.class.getName()).log(Level.SEVERE, "Demoframe cant convert image");
        }
        this.repaint();
    }

    @Override
    public void setConsumedMessage(String string) {
        this.myLabel_Framerate.setText(string);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        theLogger.debug("Caught windowClosing() event");
        if (this.myQuitter != null) {
            theLogger.info("Setting wantsToQuit flag");
            this.myQuitter.setWantsToQuit(true);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    private void setupMenus() {
        this.myMenuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        this.myMenuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Quit", 81);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                theLogger.debug("Handling  explicit quit menu action");
                if (JVisionFrame.this.myQuitter != null) {
                    theLogger.info("Setting wantsToQuit flag");
                    JVisionFrame.this.myQuitter.setWantsToQuit(true);
                }
                JVisionFrame.this.setVisible(false);
                JVisionFrame.this.dispose();
            }
        });
        menu.add(menuItem);
        menu = new JMenu("Camera");
        this.myMenuBar.add(menu);
        menuItem = new JCheckBoxMenuItem("0");
        ((JCheckBoxMenuItem)menuItem).setSelected(true);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                theLogger.debug("Change to camera 0");
                JVisionEngine.getDefaultJVisionEngine().changeCamera(0);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(0)).setSelected(true);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(1)).setSelected(false);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(2)).setSelected(false);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(3)).setSelected(false);
            }
        });
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("1");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                theLogger.debug("Change to camera 1");
                JVisionEngine.getDefaultJVisionEngine().changeCamera(1);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(0)).setSelected(false);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(1)).setSelected(true);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(2)).setSelected(false);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(3)).setSelected(false);
            }
        });
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("2");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                theLogger.debug("Change to camera 2");
                JVisionEngine.getDefaultJVisionEngine().changeCamera(2);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(0)).setSelected(false);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(1)).setSelected(false);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(2)).setSelected(true);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(3)).setSelected(false);
            }
        });
        menu.add(menuItem);
        menuItem = new JCheckBoxMenuItem("3");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                theLogger.debug("Change to camera 3");
                JVisionEngine.getDefaultJVisionEngine().changeCamera(3);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(0)).setSelected(false);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(1)).setSelected(false);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(2)).setSelected(false);
                ((JCheckBoxMenuItem)JVisionFrame.this.myMenuBar.getMenu(2).getMenuComponent(3)).setSelected(true);
            }
        });
        menu.add(menuItem);
        this.setJMenuBar(this.myMenuBar);
    }

    private void registerWindowListeners() {
        this.addWindowListener(this);
    }

    @Override
    public void sourceIsEnding() {
    }
}

