/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.bundle.jvision;

import org.appdapter.osgi.core.BundleActivatorBase;
import org.friendularity.jvision.gui.JVisionLauncher;
import org.osgi.framework.BundleContext;
import org.slf4j.LoggerFactory;

public class JVisionBundleActivator
extends BundleActivatorBase {
    JVisionLauncher myLauncher;
    private static boolean LAUNCH_MYSELF = true;

    public void start(BundleContext context) throws Exception {
        this.forceLog4jConfig();
        super.start(context);
        this.scheduleFrameworkStartEventHandler(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.myLauncher != null) {
            this.getLogger().info("Activator sending requestStop() to myLauncher, in case some *other* bundle is stopping the container.");
            this.myLauncher.requestStop(Boolean.FALSE);
        }
        super.stop(context);
    }

    public static void setLaunchFlag(boolean launchFlag) {
        LoggerFactory.getLogger(JVisionBundleActivator.class).info("Setting launchFlag to {}", (Object)launchFlag);
        LAUNCH_MYSELF = launchFlag;
    }

    protected void handleFrameworkStartedEvent(BundleContext bundleCtx) {
        this.getLogger().info("In OSGi framework-started callback, JVision launchFlag is {}", (Object)LAUNCH_MYSELF);
        if (!LAUNCH_MYSELF) {
            this.getLogger().info("Aborting JVision Launch because LAUNCH_MYSELF is false");
            return;
        }
        this.launchJVisionDemo();
    }

    private void launchJVisionDemo() {
        String version = System.getProperty("java.version");
        if (version == null) {
            this.getLogger().error("Cannot determine java version, we need 1.6.0_32, will try to run anyway");
        } else if (!version.equals("1.6.0_32")) {
            this.getLogger().warn("Java version is not 1.6.0_32, Versions at u25 and earlier fail with a \"can't find native-library\" error.");
        }
        boolean flag_stopOSGiAfterQuitCompletes = true;
        this.myLauncher = new JVisionLauncher(flag_stopOSGiAfterQuitCompletes);
        boolean launchedOK = this.myLauncher.attemptInit();
        this.getLogger().info("myLauncher.attemptInit() returned: " + launchedOK);
    }
}

