/*
 * Decompiled with CFR 0.152.
 */
package org.friendularity.jvision.filters;

import javax.swing.JFrame;
import org.friendularity.jvision.filters.ApplicativeBaseFilter;
import org.friendularity.jvision.filters.FilterParams;
import org.friendularity.jvision.filters.ParamChangedListener;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class Erode
extends ApplicativeBaseFilter
implements ParamChangedListener {
    private Size kernal_size = new Size(13.0, 13.0);
    private int erodeIterations = 13;

    @Override
    public void apply(Mat in, Mat out) {
        Mat kernal = Imgproc.getStructuringElement(2, this.kernal_size);
        Imgproc.erode(in, out, kernal);
    }

    public String toString() {
        return "erode";
    }

    @Override
    public void showParamUI(JFrame parent) {
        FilterParams.showParamWidget(this, "erosion iterations,slider,1," + this.erodeIterations + ",24");
    }

    @Override
    public String serialize() {
        return Integer.toString(this.erodeIterations);
    }

    @Override
    public void deserialize(String str) {
        this.erodeIterations = Integer.parseInt(str);
        this.kernal_size = new Size(this.erodeIterations, this.erodeIterations);
    }

    @Override
    public void paramChanged(int index, String param) {
        this.erodeIterations = Integer.parseInt(param);
        if (this.erodeIterations < 1) {
            this.erodeIterations = 1;
        }
        this.kernal_size = new Size(this.erodeIterations, this.erodeIterations);
    }
}

